/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.transport;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.webservices.engine.transport.Connection;
import com.ibm.ws.webservices.engine.transport.channel.WSOutboundConnection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;

public final class OneWayConnectionMap {
    private static final TraceComponent _tc = Tr.register(OneWayConnectionMap.class, "WebServices", "com.ibm.ws.webservices.resources.webservicesMessages");
    private static ConcurrentHashMap hmap = null;
    private static OneWayConnectionMap onewayConnMap = null;

    private OneWayConnectionMap() {
        hmap = new ConcurrentHashMap(131, 0.75f);
    }

    public static final synchronized OneWayConnectionMap getInstance() {
        if (onewayConnMap == null) {
            onewayConnMap = new OneWayConnectionMap();
        }
        return onewayConnMap;
    }

    public synchronized void putConnection(String hashKey, Connection conn) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "OneWayConnectionMap.putConnection()...");
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Related objects: " + conn.getConnection());
        }
        if (!hmap.containsKey(hashKey)) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Puting " + conn + " in map with key: " + hashKey);
            }
            hmap.put(hashKey, conn);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...OneWayConnectionMap.putConnection()");
        }
    }

    public boolean containsKey(String hashKey) {
        boolean result = false;
        if (hmap.containsKey(hashKey)) {
            result = true;
        }
        return result;
    }

    public synchronized void cleanupConnections() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "OneWayConnectionMap.cleanupConnections()...");
        }
        if (hmap != null && !hmap.isEmpty()) {
            WSOutboundConnection co = null;
            Iterator iter = hmap.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                Connection ovc = (Connection)hmap.get(key);
                if (ovc == null) continue;
                co = ovc.getConnection();
                long oneWayRecycleTime = ovc.getRecycleTime();
                long sincelastAccess = co.timeFromLastAccess();
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Connection last access elapsed time in ms : " + sincelastAccess + " Recycle time in ms : " + oneWayRecycleTime);
                }
                if (sincelastAccess < oneWayRecycleTime) continue;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "One way connection time limit exceeded. Resetting the connection and removing key: " + key);
                }
                ovc.resetConnection();
                hmap.remove(key);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...OneWayConnectionMap.cleanupConnections()");
        }
    }
}

