/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.soap;

import com.ibm.websphere.webservices.soap.IBMSOAPConnection;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.client.Connection;
import com.ibm.ws.webservices.engine.client.Service;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.ClassUtils;
import com.ibm.ws.webservices.engine.utils.MCUtils;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPConstants;
import com.ibm.ws.webservices.engine.xmlsoap.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.commons.logging.Log;

public class SOAPConnectionImpl
extends IBMSOAPConnection {
    protected static Log log;
    boolean closed = false;
    public static boolean forceLegacyDispatch;
    private Class cache_JAXWSDispatchClass = null;
    private Method cache_callMethod = null;

    public SOAPMessage call(SOAPMessage request, Object endpoint) throws SOAPException {
        return this.call(request, endpoint, this.useMaelstromEngine(request));
    }

    public SOAPMessage call(SOAPMessage request, Object endpoint, boolean useLegacyClientEngine) throws SOAPException {
        if (this.closed) {
            throw new SOAPException(Messages.getMessage("connectionClosed00"));
        }
        try {
            MessageContext msgContext;
            block8: {
                if (!useLegacyClientEngine) {
                    return this.callJAXWSDispatch(request, endpoint);
                }
                Service service = new Service();
                msgContext = new MessageContext(service.getEngine());
                msgContext.setRequestMessage((Message)request);
                msgContext.setProperty("javax.xml.rpc.session.maintain", new Boolean(service.getMaintainSession()));
                msgContext.setProperty("SOAPConnection", new Boolean(true));
                URL address = new URL(endpoint.toString());
                Connection connection = service.getConnection(address);
                msgContext.protectProperties();
                String[] arrSOAPAction = request.getMimeHeaders().getHeader("SOAPAction");
                if (arrSOAPAction != null && arrSOAPAction[0] != null) {
                    String soapAction = arrSOAPAction[0];
                    msgContext.setUseSOAPAction(true);
                    msgContext.setSOAPActionURI(soapAction);
                }
                try {
                    connection.invoke(msgContext);
                }
                catch (WebServicesFault wsf) {
                    FFDCFilter.processException((Throwable)wsf, "com.ibm.ws.webservices.engine.soap.SOAPConnectionImpl.call", "145", (Object)this);
                    if (wsf.isSOAPPartFault()) break block8;
                    throw wsf;
                }
            }
            msgContext.resetProperties();
            return msgContext.getResponseMessage();
        }
        catch (MalformedURLException mue) {
            FFDCFilter.processException((Throwable)mue, "com.ibm.ws.webservices.engine.soap.SOAPConnectionImpl.call", "111", (Object)this);
            throw new SOAPException((Throwable)mue);
        }
        catch (WebServicesFault af) {
            FFDCFilter.processException((Throwable)af, "com.ibm.ws.webservices.engine.soap.SOAPConnectionImpl.call", "114", (Object)this);
            throw new SOAPException((Throwable)af);
        }
    }

    public void close() throws SOAPException {
        if (this.closed) {
            throw new SOAPException(Messages.getMessage("connectionClosed00"));
        }
        this.closed = true;
    }

    public SOAPMessage get(Object to) throws SOAPException {
        SOAPMessage soapMessage = null;
        try {
            String[] contentTypes;
            String contentType;
            URL url = this.getEndpointAsURL(to);
            URLConnection connection = url.openConnection();
            InputStream is = url.openStream();
            Map<String, List<String>> headers = connection.getHeaderFields();
            MimeHeaders mimeHeaders = new MimeHeaders();
            if (headers != null) {
                Iterator<Map.Entry<String, List<String>>> it = headers.entrySet().iterator();
                while (it != null && it.hasNext()) {
                    Map.Entry<String, List<String>> pair = it.next();
                    String keyStr = pair.getKey();
                    if (keyStr == null || keyStr.equals("")) continue;
                    List<String> valueList = pair.getValue();
                    Iterator<String> valueIt = valueList.iterator();
                    while (valueIt != null && valueIt.hasNext()) {
                        mimeHeaders.addHeader(keyStr, valueIt.next());
                    }
                }
            }
            String string = contentType = (contentTypes = mimeHeaders.getHeader("Content-Type")) != null ? contentTypes[0] : null;
            if (contentType == null) {
                mimeHeaders.addHeader("Content-Type", SOAPConstants.SOAP11_CONSTANTS.getContentTypeValue());
            }
            MessageFactory mf = MessageFactory.newInstance((String)"Dynamic Protocol");
            soapMessage = mf.createMessage(mimeHeaders, is);
        }
        catch (MalformedURLException mue) {
            FFDCFilter.processException((Throwable)mue, "com.ibm.ws.webservices.engine.soap.SOAPConnectionImpl.get", "203", (Object)this);
            throw new SOAPException((Throwable)mue);
        }
        catch (IOException ioe) {
            FFDCFilter.processException((Throwable)ioe, "com.ibm.ws.webservices.engine.soap.SOAPConnectionImpl.get", "203", (Object)this);
            throw new SOAPException((Throwable)ioe);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.soap.SOAPConnectionImpl.get", "332", (Object)this);
            throw new SOAPException((Throwable)e);
        }
        return soapMessage;
    }

    private boolean useMaelstromEngine(SOAPMessage request) {
        if (forceLegacyDispatch) {
            return true;
        }
        Class dispatchCls = null;
        try {
            dispatchCls = this.getJAXWSDispatchClass();
        }
        catch (SOAPException sOAPException) {
            // empty catch block
        }
        return dispatchCls == null || !Utils._isSAAJ13Enabled();
    }

    private SOAPMessage callJAXWSDispatch(SOAPMessage request, Object endpoint) throws SOAPException, MalformedURLException {
        SOAPMessage response = null;
        String endpointStr = this.getEndpointAsString(endpoint);
        String protocol = this.getSOAPProtocol(request);
        Object jaxwsDispatcher = this.getJAXWSDispatchInstance();
        Method callMethod = this.getJAXWSDispatchCallMethod();
        try {
            response = (SOAPMessage)callMethod.invoke(jaxwsDispatcher, request, endpointStr, protocol);
        }
        catch (Exception e) {
            if (e instanceof SOAPException) {
                throw (SOAPException)((Object)e);
            }
            throw new SOAPException((Throwable)e);
        }
        return response;
    }

    private URL getEndpointAsURL(Object to) throws MalformedURLException {
        URL url = null;
        url = to instanceof URL ? (URL)to : (to instanceof String ? new URL((String)to) : new URL(to.toString()));
        return url;
    }

    private String getEndpointAsString(Object to) throws MalformedURLException {
        return this.getEndpointAsURL(to).toString();
    }

    private String getSOAPProtocol(SOAPMessage soapMessage) {
        String[] values;
        MimeHeaders headers = soapMessage.getMimeHeaders();
        String[] stringArray = values = headers == null ? null : headers.getHeader("Content-Type");
        if (values == null || values.length == 0) {
            return "SOAP 1.1 Protocol";
        }
        String value = values[0];
        if (value.contains("application/soap+xml")) {
            return "SOAP 1.2 Protocol";
        }
        if (value.contains("text/xml")) {
            return "SOAP 1.1 Protocol";
        }
        return "SOAP 1.1 Protocol";
    }

    private Class getJAXWSDispatchClass() throws SOAPException {
        if (this.cache_JAXWSDispatchClass != null) {
            return this.cache_JAXWSDispatchClass;
        }
        try {
            this.cache_JAXWSDispatchClass = ClassUtils.forName("com.ibm.ws.webservices.engine.xmlsoap.saaj13only.SOAPConnectionJAXWS");
        }
        catch (Exception e) {
            throw new SOAPException((Throwable)e);
        }
        return this.cache_JAXWSDispatchClass;
    }

    private Method getJAXWSDispatchCallMethod() throws SOAPException {
        if (this.cache_callMethod != null) {
            return this.cache_callMethod;
        }
        try {
            Class cls = this.getJAXWSDispatchClass();
            this.cache_callMethod = cls.getDeclaredMethod("call", SOAPMessage.class, String.class, String.class);
        }
        catch (Exception e) {
            throw new SOAPException((Throwable)e);
        }
        return this.cache_callMethod;
    }

    private Object getJAXWSDispatchInstance() throws SOAPException {
        Class cls = this.getJAXWSDispatchClass();
        Object obj = null;
        try {
            obj = cls.newInstance();
        }
        catch (Exception e) {
            throw new SOAPException((Throwable)e);
        }
        return obj;
    }

    static {
        block3: {
            log = LogFactory.getLog(SOAPConnectionImpl.class.getName());
            forceLegacyDispatch = false;
            String propName = "com.ibm.ws.webservices.forceLegacyDispatchFromSOAPConnection";
            try {
                forceLegacyDispatch = MCUtils.isPropertyEnabled(propName);
                if (log.isDebugEnabled()) {
                    log.debug(MCUtils.getSettingMsg(propName, forceLegacyDispatch));
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block3;
                log.debug("Exception occurred obtaining and evaluating system property {" + propName + "}", e);
            }
        }
    }
}

