/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.security.servlet;

import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.security.AuthenticatedUser;
import com.ibm.ws.webservices.engine.security.SecurityProvider;
import com.ibm.ws.webservices.engine.security.servlet.ServletAuthenticatedUser;
import com.ibm.ws.webservices.engine.transport.http.HTTPConstants;
import java.security.Principal;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;

public class ServletSecurityProvider
implements SecurityProvider {
    protected static Log log = LogFactory.getLog(ServletSecurityProvider.class.getName());
    static HashMap users = null;

    public AuthenticatedUser authenticate(MessageContext msgContext) {
        HttpServletRequest req = (HttpServletRequest)msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        if (req == null) {
            return null;
        }
        log.debug(Messages.getMessage("got00", "HttpServletRequest"));
        Principal principal = req.getUserPrincipal();
        if (principal == null) {
            log.debug(Messages.getMessage("noPrincipal00"));
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("gotPrincipal00", principal.getName()));
        }
        return new ServletAuthenticatedUser(req);
    }

    public boolean userMatches(AuthenticatedUser user, String principal) {
        if (user == null) {
            return principal == null;
        }
        if (user instanceof ServletAuthenticatedUser) {
            ServletAuthenticatedUser servletUser = (ServletAuthenticatedUser)user;
            return servletUser.getRequest().isUserInRole(principal);
        }
        return false;
    }
}

