/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.lifecycle;

import com.ibm.ws.webservices.engine.lifecycle.LifeCycleException;
import com.ibm.ws.webservices.engine.lifecycle.LifeCycleObject;
import com.ibm.ws.webservices.engine.lifecycle.LifeCycleObjectImpl;
import com.ibm.ws.webservices.engine.lifecycle.LifeCycleOwner;
import com.ibm.ws.webservices.engine.lifecycle._LifeCycleObject;
import com.ibm.ws.webservices.engine.lifecycle._LifeCycleSet;
import com.ibm.ws.webservices.engine.orderedset.Operation;
import com.ibm.ws.webservices.engine.orderedset.OperationException;
import com.ibm.ws.webservices.engine.orderedset.OrderedSetImpl;
import com.ibm.ws.webservices.engine.resources.Messages;
import java.util.HashSet;
import java.util.Set;

public class LifeCycleSetImpl
extends LifeCycleObjectImpl
implements _LifeCycleSet {
    private final OrderedSetImpl _set = new OrderedSetImpl();
    private final Set _stickySet = new HashSet();
    private final LifeCycleOwner _containerOwner;
    private boolean _sticky = false;
    private boolean _lockIfActive = true;
    public static final boolean STICKY = true;
    public static final boolean NOSTICKY = false;
    public static final boolean LOCKIFACTIVE = true;
    public static final boolean NOLOCKIFACTIVE = false;

    public LifeCycleSetImpl() {
        this._containerOwner = null;
    }

    public LifeCycleSetImpl(_LifeCycleObject container) {
        this(container, false, true);
    }

    public LifeCycleSetImpl(_LifeCycleObject container, boolean sticky, boolean lockIfActive) {
        super(container);
        this._containerOwner = container instanceof LifeCycleOwner ? (LifeCycleOwner)((Object)container) : null;
        this._sticky = sticky;
        this._lockIfActive = lockIfActive;
    }

    public void setSticky(boolean sticky) {
        this._sticky = sticky;
    }

    public boolean getSticky() {
        return this._sticky;
    }

    public void setLockIfActive(boolean lockIfActive) {
        this._lockIfActive = lockIfActive;
    }

    public boolean getLockIfActive() {
        return this._lockIfActive;
    }

    public void _init() throws LifeCycleException {
        this._set.apply(new Operation(){

            public void op(Object o) {
                LifeCycleObject lco = (LifeCycleObject)o;
                if (!lco.isActive()) {
                    lco.init();
                }
            }
        });
        super._init();
    }

    public void _destroy() throws LifeCycleException {
        super._destroy();
        this._set.apply(new Operation(){

            public void op(Object o) {
                LifeCycleObject lco = (LifeCycleObject)o;
                if (lco.isActive()) {
                    lco.destroy();
                }
            }
        });
    }

    public boolean manageLifeCycleOf(LifeCycleObject object) {
        return this.manageLifeCycleOf(object, this.getSticky());
    }

    public boolean manageLifeCycleOf(LifeCycleObject object, boolean sticky) {
        boolean canManage;
        if (object == null) {
            throw new LifeCycleException(Messages.getMessage("null00", "object"));
        }
        if (!this.contains(object)) {
            if (this.getLockIfActive()) {
                this.verifyInactive();
            } else if (object.isActive()) {
                this.verifyActive();
            }
            canManage = object.getOwner() == null ? true : object.getOwner().releaseLifeCycleManagementOf(object);
            if (canManage) {
                object.setOwner(this._containerOwner != null ? this._containerOwner : this);
                if (this.isActive() && !object.isActive()) {
                    object.init();
                }
                this._set.add(object);
                if (sticky) {
                    this._stickySet.add(object);
                }
            }
        } else {
            canManage = false;
        }
        return canManage;
    }

    public boolean releaseLifeCycleManagementOf(LifeCycleObject object) throws LifeCycleException {
        if (this._stickySet.contains(object)) {
            return false;
        }
        return this._set.remove(object);
    }

    public boolean contains(LifeCycleObject object) {
        return this._set.contains(object);
    }

    public LifeCycleObject[] get() {
        return (LifeCycleObject[])this._set.get(LifeCycleObject.class);
    }

    public LifeCycleObject[] get(Class lifeCycleClass) {
        return (LifeCycleObject[])this._set.get(lifeCycleClass);
    }

    public void apply(Operation op) throws OperationException {
        this._set.apply(op);
    }

    public void applyReverse(Operation op) throws OperationException {
        this._set.applyReverse(op);
    }

    public void setIgnoreExceptions(boolean ignore) {
        this._set.setIgnoreExceptions(ignore);
    }

    public boolean getIgnoreExceptions() {
        return this._set.getIgnoreExceptions();
    }
}

