/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.handlers.soap;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.engine.GuardedMessageContext;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.description.OperationDesc;
import com.ibm.ws.webservices.engine.handlers.jaxrpc.JAXRPCHandlerChain;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPBody;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPElement;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPEnvelope;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPHeader;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.apache.commons.logging.Log;

public class SOAPHandlerChain
extends JAXRPCHandlerChain {
    protected static Log log = LogFactory.getLog(SOAPHandlerChain.class.getName());

    public SOAPHandlerChain(List handlerInfos, Collection roles) {
        super(handlerInfos, roles);
    }

    public boolean handleRequest(MessageContext msgContext) throws WebServicesFault {
        SOAPPart part;
        SOAPMessage msg;
        if (msgContext.isServer() && (msg = msgContext.getMessage()) != null && (part = msg.getSOAPPart()) != null) {
            try {
                OperationDesc opDesc;
                SOAPBody body = (SOAPBody)part.getEnvelope().getBody();
                if (body != null) {
                    body.setProtect(true);
                    body.getSOAPFactory().setProtectState(true);
                }
                if ((opDesc = msgContext.getOperation()) != null) {
                    Set set = opDesc.getHeaderParamQNames();
                    SOAPHeader header = (SOAPHeader)part.getEnvelope().getHeader();
                    if (set != null && !set.isEmpty()) {
                        Iterator it = set.iterator();
                        while (it.hasNext()) {
                            QName qName = (QName)it.next();
                            SOAPElement el = header.getChildElement(qName.getNamespaceURI(), qName.getLocalPart());
                            if (el == null) continue;
                            el.setProtect(true);
                        }
                    }
                }
            }
            catch (SOAPException se) {
                FFDCFilter.processException((Throwable)se, "com.ibm.ws.webservices.engine.handlers.soap.SOAPHandlerChain.handleRequest", "128", this);
                throw new WebServicesFault(Messages.getMessage("jaxRpcHandlerSetProtectState00"), se);
            }
        }
        return super.handleRequest(msgContext);
    }

    protected void checkProtectedStateViolation(MessageContext msgContext, String handlerName) throws SOAPFaultException {
        SOAPMessage msg = msgContext.getMessage();
        if (msg == null) {
            throw new SOAPFaultException(QNameTable.createQName(msgContext.getSOAPConstants().getEnvelopeURI(), "Server"), Messages.getMessage("jaxRpcHandlerProtectedStateViolation02", handlerName), handlerName, null);
        }
        SOAPPart part = msg.getSOAPPart();
        if (part == null) {
            throw new SOAPFaultException(QNameTable.createQName(msgContext.getSOAPConstants().getEnvelopeURI(), "Server"), Messages.getMessage("jaxRpcHandlerProtectedStateViolation01", handlerName), handlerName, null);
        }
        try {
            SOAPEnvelope env = (SOAPEnvelope)part.getEnvelope();
            if (env.getSOAPFactory().getProtectionViolation()) {
                throw new SOAPFaultException(QNameTable.createQName(msgContext.getSOAPConstants().getEnvelopeURI(), "Server"), Messages.getMessage("jaxRpcHandlerProtectedStateViolation00", handlerName), handlerName, null);
            }
        }
        catch (SOAPException se) {
            FFDCFilter.processException((Throwable)se, "com.ibm.ws.webservices.engine.handlers.soap.SOAPHandlerChain.checkProtectedStateViolation", "134", this);
            log.error(Messages.getMessage("jaxRpcHandlerProtectedStateViolation03", handlerName), se);
            throw new SOAPFaultException(QNameTable.createQName(msgContext.getSOAPConstants().getEnvelopeURI(), "Server"), Messages.getMessage("jaxRpcHandlerProtectedStateViolation03", handlerName), handlerName, null);
        }
    }

    public void preHandleIncoming(MessageContext context) {
        if (!context.isHighFidelity() && this.isSOAPBodyAccessRequired(this)) {
            context.setHighFidelity(true);
        }
        super.preHandleIncoming(context);
    }

    protected com.ibm.wsspi.webservices.rpc.handler.MessageContext getHandlerMC(MessageContext context) {
        return new GuardedMessageContext(context);
    }

    private boolean isSOAPBodyAccessRequired(SOAPHandlerChain hc) {
        Object ret = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return new Boolean(System.getProperty("com.ibm.websphere.webservices.saaj.accessSOAPBody", "false"));
                }
                catch (Throwable e) {
                    if (log.isDebugEnabled()) {
                        log.debug("Caught exception from System.getProperty.  Processing continues.  ", e);
                    }
                    return e;
                }
            }
        });
        Boolean baDefault = ret instanceof Boolean ? (Boolean)ret : Boolean.FALSE;
        boolean result = false;
        Iterator i = hc.iterator();
        while (i.hasNext() && !result) {
            HandlerInfo hi = (HandlerInfo)i.next();
            result = this.isSOAPBodyAccessRequiredForHandler(hi, baDefault);
        }
        return result;
    }

    private boolean isSOAPBodyAccessRequiredForHandler(HandlerInfo hi, Boolean bd) {
        String baprop;
        boolean result = bd;
        Map hcfg = hi.getHandlerConfig();
        if (hcfg != null && (baprop = (String)hcfg.get("saaj.accessSOAPBody")) != null) {
            result = JavaUtils.isTrueExplicitly(baprop);
        }
        return result;
    }
}

