/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.handlers.jaxrpc;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.HandlerInfo;

public class ExtendedHandlerInfo
extends HandlerInfo {
    public static final int DEFAULT_MIN_POOL_SIZE = 5;
    public static final int DEFAULT_MAX_POOL_SIZE = 25;
    public static final boolean DEFAULT_FAULT_LOCAL = false;
    public static final boolean DEFAULT_AUTO_RESPONSE = true;
    private int minPoolSize = 5;
    private int maxPoolSize = 25;
    private boolean faultLocal = false;
    private boolean autoResponse = true;
    private boolean configSet = false;
    private boolean headersSet = false;
    private String name;

    public ExtendedHandlerInfo(Class handlerClass, Map config2, QName[] headers) {
        super(handlerClass, config2, headers);
        this.configSet = true;
        this.headersSet = true;
    }

    public ExtendedHandlerInfo(HandlerInfo original) {
        super(original.getHandlerClass(), original.getHandlerConfig(), original.getHeaders());
        if (original instanceof ExtendedHandlerInfo) {
            ExtendedHandlerInfo eOriginal = (ExtendedHandlerInfo)original;
            this.minPoolSize = eOriginal.minPoolSize;
            this.maxPoolSize = eOriginal.maxPoolSize;
            this.faultLocal = eOriginal.faultLocal;
            this.autoResponse = eOriginal.autoResponse;
            this.name = eOriginal.name;
        }
    }

    public void setMinPoolSize(int _minPoolSize) {
        this.minPoolSize = _minPoolSize;
    }

    public int getMinPoolSize() {
        return this.minPoolSize;
    }

    public void setMaxPoolSize(int _maxPoolSize) {
        this.maxPoolSize = _maxPoolSize;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setFaultLocal(boolean _faultLocal) {
        this.faultLocal = _faultLocal;
    }

    public boolean isFaultLocal() {
        return this.faultLocal;
    }

    public static boolean isFaultLocal(HandlerInfo hi) {
        if (hi instanceof ExtendedHandlerInfo) {
            return ((ExtendedHandlerInfo)hi).isFaultLocal();
        }
        return false;
    }

    public void setAutoResponse(boolean _autoResponse) {
        this.autoResponse = _autoResponse;
    }

    public boolean isAutoResponse() {
        return this.autoResponse;
    }

    public static boolean isAutoResponse(HandlerInfo hi) {
        if (hi instanceof ExtendedHandlerInfo) {
            return ((ExtendedHandlerInfo)hi).isAutoResponse();
        }
        return true;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setHandlerConfig(Map config2) {
        this.configSet = true;
        super.setHandlerConfig(config2);
    }

    public Map getHandlerConfig() {
        HashMap m = super.getHandlerConfig();
        if (!this.configSet) {
            if (m != null) {
                m = new HashMap(m);
                super.setHandlerConfig(m);
            }
            this.configSet = true;
        }
        return m;
    }

    public void setHeaders(QName[] headers) {
        this.headersSet = true;
        super.setHeaders(headers);
    }

    public QName[] getHeaders() {
        QName[] headers = super.getHeaders();
        if (!this.headersSet) {
            if (headers != null) {
                headers = new QName[headers.length];
                System.arraycopy(super.getHeaders(), 0, headers, 0, headers.length);
                super.setHeaders(headers);
            }
            this.headersSet = true;
        }
        return headers;
    }
}

