/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.events;

import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesProperties;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.encoding.DeserializationContext;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.MappingScope;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPElement;
import org.apache.commons.logging.Log;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class DEventProcessor {
    protected static Log log = LogFactory.getLog(DEventProcessor.class.getName());
    protected boolean containsChild = false;
    protected boolean inUse = true;
    private static final String TOLERATE_INVALID_NAMESPACE_KEY = "com.ibm.ws.webservices.jaxrpc.parse.tolerate.invalid.namespace";
    private static boolean JVM_TOLERATE_INVALID_NAMESPACE = DEventProcessor.getTolerateInvalidNamespaceJVM();

    public boolean recycle() {
        if (!this.inUse) {
            this.inUse = true;
            return true;
        }
        return false;
    }

    public void relinquish() {
        this.inUse = false;
    }

    public void elementEvent(SOAPElement element) {
    }

    public void childElementEvent(SOAPElement element) {
    }

    public abstract void startElement(String var1, String var2, String var3, Attributes var4, MappingScope var5, DeserializationContext var6) throws SAXException;

    public abstract void endElement(String var1, String var2, DeserializationContext var3) throws SAXException;

    public void characters(String value) throws SAXException {
    }

    public void comment(char[] chars, int offset, int length) throws SAXException {
    }

    public abstract DEventProcessor onStartChild(String var1, String var2, String var3, Attributes var4, MappingScope var5, DeserializationContext var6) throws SAXException;

    public void onEndChild(String namespace, String localName, DeserializationContext context) throws SAXException {
        this.containsChild = true;
    }

    public void onSimpleChild(String namespace, String localName, String prefixedName, Attributes attributes, MappingScope mappingScope, DeserializationContext context, String strValue) throws SAXException {
        DEventProcessor processor = this.onStartChild(namespace, localName, prefixedName, attributes, mappingScope, context);
        context.getEventConverter().pushDEventProcessor(processor);
        processor.startElement(namespace, localName, prefixedName, attributes, mappingScope, context);
        if (strValue != null && strValue.length() > 0) {
            processor = context.getEventConverter().popDEventProcessor();
            context.getEventConverter().pushDEventProcessor(processor);
            processor.characters(strValue);
        }
        processor = context.getEventConverter().popDEventProcessor();
        processor.endElement(namespace, localName, context);
        this.onEndChild(namespace, localName, context);
    }

    public static boolean isTolerateIncorrectNamespace(MessageContext mc) {
        Object value = null;
        if (mc != null && (value = mc.getProperty(TOLERATE_INVALID_NAMESPACE_KEY)) != null && log.isDebugEnabled()) {
            log.debug("MessageContext used for isTolerateIncorrectNamespace setting: " + value);
        }
        if (value == null && (value = WebServicesProperties.getProperty(TOLERATE_INVALID_NAMESPACE_KEY)) != null && log.isDebugEnabled()) {
            log.debug("WebServicesProperties used for isTolerateIncorrectNamespace setting: " + value);
        }
        boolean tolerate = false;
        if (value != null) {
            tolerate = JavaUtils.isTrueExplicitly(value);
        } else {
            tolerate = JVM_TOLERATE_INVALID_NAMESPACE;
            if (value != null && log.isDebugEnabled()) {
                log.debug("System Property used for isTolerateIncorrectNamespace setting: " + value);
            }
        }
        return tolerate;
    }

    private static boolean getTolerateInvalidNamespaceJVM() {
        String value = System.getProperty(TOLERATE_INVALID_NAMESPACE_KEY);
        boolean rc = JavaUtils.isTrueExplicitly(value, false);
        if (log.isDebugEnabled()) {
            log.debug("System Property Key: com.ibm.ws.webservices.jaxrpc.parse.tolerate.invalid.namespace");
            log.debug("System Property Raw Value: " + value);
            log.debug("System Property Value: " + rc);
        }
        return rc;
    }
}

