/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding.ser;

import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.description.TypeDesc;
import com.ibm.ws.webservices.engine.encoding.SerializationContext;
import com.ibm.ws.webservices.engine.encoding.SimpleType;
import com.ibm.ws.webservices.engine.encoding.ser.SimpleValueSerializer;
import com.ibm.ws.webservices.engine.encoding.utils.BeanDesc;
import com.ibm.ws.webservices.engine.encoding.utils.FieldDesc;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.BeanPropertyDescriptor;
import com.ibm.ws.webservices.engine.utils.BeanUtils;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import java.io.IOException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class SimpleSerializer
implements SimpleValueSerializer {
    public QName xmlType;
    public Class javaType;
    protected BeanPropertyDescriptor[] propertyDescriptor = null;
    protected BeanDesc beanDesc = null;
    private static boolean hasToPlainStringMethodCache = false;
    private static Method toPlainStringMethodCache = null;
    protected static Log log = LogFactory.getLog(SimpleSerializer.class.getName());

    public SimpleSerializer(Class javaType, QName xmlType) {
        this.xmlType = xmlType;
        this.javaType = javaType;
        this.init();
    }

    public SimpleSerializer(Class javaType, QName xmlType, TypeDesc typeDesc) {
        this.xmlType = xmlType;
        this.javaType = javaType;
    }

    public SimpleSerializer(Class javaType, QName xmlType, BeanDesc beanDesc) {
        this.xmlType = xmlType;
        this.javaType = javaType;
        this.beanDesc = beanDesc;
        this.init();
    }

    protected void init() {
        if (SimpleType.class.isAssignableFrom(this.javaType)) {
            if (this.beanDesc == null) {
                this.beanDesc = BeanDesc.getBeanDescForClass(this.javaType);
            }
            this.propertyDescriptor = this.beanDesc != null ? this.beanDesc.getPropertyDescriptors() : BeanUtils.getPd(this.javaType, null);
        }
    }

    void setup(BeanDesc beanDesc, BeanPropertyDescriptor[] propertyDescriptor) {
        this.beanDesc = beanDesc;
        this.propertyDescriptor = propertyDescriptor;
    }

    public void serialize(QName name, Attributes attributes, Object value, SerializationContext context) throws IOException {
        if (value != null && value.getClass() == Object.class) {
            throw new IOException(Messages.getMessage("cantSerialize02"));
        }
        if (value instanceof SimpleType) {
            attributes = this.getObjectAttributes(value, attributes, context);
        }
        String strValue = null;
        if (value != null) {
            strValue = this.getValueAsString(value, context);
        }
        context.getSerializationWriter().simpleElement(name, attributes, strValue);
    }

    public String getValueAsString(Object value, SerializationContext context) {
        if (value instanceof Float || value instanceof Double) {
            double data = 0.0;
            data = value instanceof Float ? ((Float)value).doubleValue() : ((Double)value).doubleValue();
            if (Double.isNaN(data)) {
                return "NaN";
            }
            if (data == Double.POSITIVE_INFINITY) {
                return "INF";
            }
            if (data == Double.NEGATIVE_INFINITY) {
                return "-INF";
            }
        } else {
            if (value instanceof Boolean) {
                boolean isOne = (Boolean)value;
                return isOne ? "1" : "0";
            }
            if (value instanceof Character) {
                char ch = ((Character)value).charValue();
                if (ch == '\u0000') {
                    return "";
                }
                return value.toString();
            }
            if (value instanceof BigDecimal) {
                return this.getNonScientificValue((BigDecimal)value);
            }
        }
        return value.toString();
    }

    protected Attributes getObjectAttributes(Object value, Attributes attributes, SerializationContext context) {
        if (this.beanDesc == null || !this.beanDesc.hasAttributes()) {
            return attributes;
        }
        AttributesImpl attrs = attributes == null ? new AttributesImpl() : (attributes instanceof AttributesImpl ? (AttributesImpl)attributes : new AttributesImpl(attributes));
        try {
            for (int i = 0; i < this.propertyDescriptor.length; ++i) {
                Object propValue;
                FieldDesc field;
                String propName = this.propertyDescriptor[i].getName();
                if (propName.equals("class") || (field = this.beanDesc.getFieldByName(propName)) == null || field.isElement()) continue;
                QName qname = field.getXmlName();
                if (qname == null) {
                    qname = QNameTable.createQName("", propName);
                }
                if (!this.propertyDescriptor[i].isReadable() || this.propertyDescriptor[i].isIndexed() || (propValue = this.propertyDescriptor[i].get(value)) == null) continue;
                String propString = this.getValueAsString(propValue, context);
                String namespace = qname.getNamespaceURI();
                String localName = qname.getLocalPart();
                attrs.addAttribute(namespace, localName, context.getSerializationWriter().qName2String(qname), "CDATA", propString);
            }
        }
        catch (Exception e) {
            return attrs;
        }
        return attrs;
    }

    public String getMechanismType() {
        return "WebServices SAX Mechanism";
    }

    public String getBuildNumber() {
        return this.beanDesc == null ? null : this.beanDesc.getBuildNumber();
    }

    private String getNonScientificValue(BigDecimal value) {
        if (!hasToPlainStringMethodCache) {
            toPlainStringMethodCache = (Method)AccessController.doPrivileged(new getMethodPRIV(value.getClass(), "toPlainString"));
            hasToPlainStringMethodCache = true;
        }
        if (toPlainStringMethodCache != null) {
            if (log.isDebugEnabled()) {
                log.debug("Invoking toPlainString() method to convert BigDecimal to string.");
            }
            final BigDecimal finalValue = value;
            return (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return toPlainStringMethodCache.invoke((Object)finalValue, null);
                    }
                    catch (Throwable e) {
                        if (log.isDebugEnabled()) {
                            log.debug("The following exception encountered when trying to invoke method [" + toPlainStringMethodCache.getName() + "] on class [" + finalValue.getClass().getName() + "].");
                            log.debug(e.toString());
                        }
                        return null;
                    }
                }
            });
        }
        if (log.isDebugEnabled()) {
            log.debug("Invoking toString() method to convert BigDecimal to string.");
        }
        return value.toString();
    }

    private class getMethodPRIV
    implements PrivilegedAction {
        private Class clazz;
        private String methodName;

        getMethodPRIV(Class clazz, String methodName) {
            this.clazz = clazz;
            this.methodName = methodName;
        }

        public Object run() {
            try {
                return this.clazz.getMethod(this.methodName, null);
            }
            catch (Throwable e) {
                if (log.isDebugEnabled()) {
                    log.debug("The following exception encountered when trying to get method [" + this.methodName + "] from class [" + this.clazz.getName() + "].");
                    log.debug(e.toString());
                }
                return null;
            }
        }
    }
}

