/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding.ser;

import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.encoding.SerializationContext;
import com.ibm.ws.webservices.engine.encoding.ser.SimpleValueSerializer;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.xml.sax.Attributes;

public class CalendarSerializer
implements SimpleValueSerializer {
    protected static Log log = LogFactory.getLog(CalendarSerializer.class.getName());
    private static ThreadLocal tlZuluDateTime = new ThreadLocal(){

        protected synchronized Object initialValue() {
            if (log.isDebugEnabled()) {
                log.debug("Creating new zulu datetime SimpleDateFormat object");
            }
            SimpleDateFormat zuluDateTime = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            zuluDateTime.setTimeZone(TimeZone.getTimeZone("GMT"));
            return zuluDateTime;
        }
    };
    private static ThreadLocal tlZuluDate = new ThreadLocal(){

        protected synchronized Object initialValue() {
            if (log.isDebugEnabled()) {
                log.debug("Creating new zulu date SimpleDateFormat object");
            }
            SimpleDateFormat zuluDate = new SimpleDateFormat("yyyy-MM-dd");
            return zuluDate;
        }
    };
    private static ThreadLocal tlZuluTime = new ThreadLocal(){

        protected synchronized Object initialValue() {
            if (log.isDebugEnabled()) {
                log.debug("Creating new zulu time SimpleDateFormat object");
            }
            SimpleDateFormat zuluTime = new SimpleDateFormat("HH:mm:ss.SSS'Z'");
            zuluTime.setTimeZone(TimeZone.getTimeZone("GMT"));
            return zuluTime;
        }
    };
    protected QName xmlType;
    protected Class javaType;
    private QName componentTypeQName;

    public CalendarSerializer(Class javaType, QName xmlType, QName compQName, QName componentTypeQName) {
        this.xmlType = xmlType;
        this.javaType = javaType;
        this.componentTypeQName = componentTypeQName == null ? xmlType : componentTypeQName;
    }

    public void serialize(QName name, Attributes attributes, Object value, SerializationContext context) throws IOException {
        context.getSerializationWriter().simpleElement(name, attributes, this.getValueAsString(value, context));
    }

    public String getValueAsString(Object value, SerializationContext context) {
        if (Constants.equals(Constants.XSD_DATE, this.componentTypeQName)) {
            return CalendarSerializer.getDateValueAsString(value);
        }
        if (Constants.equals(Constants.XSD_TIME, this.componentTypeQName)) {
            return CalendarSerializer.getTimeValueAsString(value);
        }
        return CalendarSerializer.getDateTimeValueAsString(value);
    }

    public static String getDateValueAsString(Object value) {
        StringBuffer buf = new StringBuffer();
        if (((Calendar)value).get(0) == 0) {
            buf.append("-");
            ((Calendar)value).set(0, 1);
        }
        Date date = ((Calendar)value).getTime();
        SimpleDateFormat zuluDate = CalendarSerializer.getZuluDateFormatter();
        buf.append(zuluDate.format(date));
        return buf.toString();
    }

    public static String getTimeValueAsString(Object value) {
        SimpleDateFormat zuluTime = CalendarSerializer.getZuluTimeFormatter();
        return zuluTime.format(((Calendar)value).getTime());
    }

    public static String getDateTimeValueAsString(Object value) {
        Date date = value instanceof Date ? (Date)value : ((Calendar)value).getTime();
        SimpleDateFormat zuluDateTime = CalendarSerializer.getZuluDateTimeFormatter();
        return zuluDateTime.format(date);
    }

    public String getMechanismType() {
        return "WebServices SAX Mechanism";
    }

    public String getBuildNumber() {
        return null;
    }

    private static SimpleDateFormat getZuluDateTimeFormatter() {
        return (SimpleDateFormat)tlZuluDateTime.get();
    }

    private static SimpleDateFormat getZuluDateFormatter() {
        return (SimpleDateFormat)tlZuluDate.get();
    }

    private static SimpleDateFormat getZuluTimeFormatter() {
        return (SimpleDateFormat)tlZuluTime.get();
    }
}

