/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding.ser;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializer;
import com.ibm.ws.webservices.engine.resources.Messages;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.xml.namespace.QName;

public class CalendarDeserializer
extends SimpleDeserializer {
    private static final SimpleDateFormat zuluDateTime = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.000'Z'");
    private static final SimpleDateFormat zuluDateTime2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private static final SimpleDateFormat zuluDate = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat zuluTime = new SimpleDateFormat("HH:mm:ss.SSS'Z'");
    private static final SimpleDateFormat zuluTime2 = new SimpleDateFormat("HH:mm:ss");
    private QName componentTypeQName;

    public CalendarDeserializer(Class javaType, QName xmlType, QName compQName, QName componentTypeQName) {
        super(javaType, xmlType);
        this.componentTypeQName = componentTypeQName == null ? xmlType : componentTypeQName;
    }

    public Object makeValue(String source) {
        if (Constants.equals(Constants.XSD_DATE, this.componentTypeQName)) {
            return CalendarDeserializer.makeDateValue(source);
        }
        if (Constants.equals(Constants.XSD_TIME, this.componentTypeQName)) {
            return CalendarDeserializer.makeTimeValue(source);
        }
        return CalendarDeserializer.makeDateTimeValue(source);
    }

    public static Object makeDateTimeValue(String source) {
        boolean bc = false;
        if (source == "") {
            throw new NumberFormatException(Messages.getMessage("badDateTime01"));
        }
        if (source != null) {
            if (source.charAt(0) == '+') {
                source = source.substring(1);
            }
            if (source.charAt(0) == '-') {
                source = source.substring(1);
                bc = true;
            }
        }
        CalendarDeserializer.validateDateTime(source);
        Calendar cal = CalendarDeserializer.makeCalendar(source, 19, zuluDateTime, zuluDateTime2);
        if (bc) {
            cal.set(0, 0);
        }
        return cal;
    }

    public static Object makeTimeValue(String source) {
        CalendarDeserializer.validateTime(source);
        Calendar cal = CalendarDeserializer.makeCalendar(source, 8, zuluTime, zuluTime2);
        cal.set(0, 0, 0);
        return cal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object makeDateValue(String source) {
        Date date;
        Calendar cal = Calendar.getInstance();
        boolean bc = false;
        if (source == "") {
            throw new NumberFormatException(Messages.getMessage("badDate01"));
        }
        if (source != null) {
            if (source.charAt(0) == '+') {
                source = source.substring(1);
            }
            if (source.charAt(0) == '-') {
                source = source.substring(1);
                bc = true;
            }
            if (source.length() < 10) {
                throw new NumberFormatException(Messages.getMessage("badDate00", source));
            }
            if (source.charAt(4) != '-' || source.charAt(7) != '-') {
                throw new NumberFormatException(Messages.getMessage("badDate00", source));
            }
        }
        try {
            SimpleDateFormat simpleDateFormat = zuluDate;
            synchronized (simpleDateFormat) {
                date = zuluDate.parse(source == null ? null : source.substring(0, 10));
            }
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.webservices.engine.encoding.ser.CalendarDeserializer.makeDateValue", "214");
            throw new NumberFormatException(e.toString());
        }
        cal.setTime(date);
        if (bc) {
            cal.set(0, 0);
        }
        return cal;
    }

    private static void validateTime(String source) {
        if (source != null) {
            if (source == "") {
                throw new NumberFormatException(Messages.getMessage("badTime01"));
            }
            if (source.charAt(2) != ':' || source.charAt(5) != ':') {
                throw new NumberFormatException(Messages.getMessage("badTime00", source));
            }
            if (source.length() < 8) {
                throw new NumberFormatException(Messages.getMessage("badTime00", source));
            }
        }
    }

    private static void validateDateTime(String source) {
        if (source.length() < 19) {
            throw new NumberFormatException(Messages.getMessage("badDateTime00", source));
        }
        if (source.charAt(4) != '-' || source.charAt(7) != '-' || source.charAt(10) != 'T') {
            throw new NumberFormatException(Messages.getMessage("badDate00", source));
        }
        if (source.charAt(13) != ':' || source.charAt(16) != ':') {
            throw new NumberFormatException(Messages.getMessage("badTime00", source));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Calendar makeCalendar(String source, int pos1, SimpleDateFormat zulu1, SimpleDateFormat zulu2) {
        Calendar calendar = Calendar.getInstance();
        Date date = null;
        boolean timezone = false;
        boolean zflag = false;
        int milliseconds = 0;
        int timezonemilliseconds = 0;
        int pos = pos1;
        if (source != null) {
            block26: {
                if (pos < source.length() && source.charAt(pos) == '.') {
                    int start = ++pos;
                    while (pos < source.length() && Character.isDigit(source.charAt(pos))) {
                        ++pos;
                    }
                    String decimal = source.substring(start, pos);
                    if (decimal.length() == 3) {
                        milliseconds = Integer.parseInt(decimal);
                    } else if (decimal.length() < 3) {
                        milliseconds = Integer.parseInt((decimal + "000").substring(0, 3));
                    } else {
                        milliseconds = Integer.parseInt(decimal.substring(0, 3));
                        if (decimal.charAt(3) >= '5') {
                            ++milliseconds;
                        }
                    }
                }
                if (pos + 5 < source.length() && (source.charAt(pos) == '+' || source.charAt(pos) == '-')) {
                    if (!(Character.isDigit(source.charAt(pos + 1)) && Character.isDigit(source.charAt(pos + 2)) && source.charAt(pos + 3) == ':' && Character.isDigit(source.charAt(pos + 4)) && Character.isDigit(source.charAt(pos + 5)))) {
                        throw new NumberFormatException(Messages.getMessage("badTimezone00", source));
                    }
                    int hours = (source.charAt(pos + 1) - 48) * 10 + source.charAt(pos + 2) - 48;
                    int mins = (source.charAt(pos + 4) - 48) * 10 + source.charAt(pos + 5) - 48;
                    timezonemilliseconds = (hours * 60 + mins) * 60 * 1000;
                    if (source.charAt(pos) == '+') {
                        timezonemilliseconds = -timezonemilliseconds;
                    }
                    pos += 6;
                    timezone = true;
                }
                if (pos < source.length() && source.charAt(pos) == 'Z') {
                    ++pos;
                    calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
                    zflag = true;
                }
                if (timezone || zflag) {
                    try {
                        SimpleDateFormat hours = zulu1;
                        synchronized (hours) {
                            date = zulu1.parse(source == null ? null : source.substring(0, pos1) + ".000Z");
                            break block26;
                        }
                    }
                    catch (Exception e) {
                        FFDCFilter.processException(e, "com.ibm.ws.webservices.engine.encoding.ser.CalendarDeserializer.makeCalendar", "345");
                        throw new NumberFormatException(e.toString());
                    }
                }
                if (!timezone) {
                    try {
                        SimpleDateFormat e = zulu2;
                        synchronized (e) {
                            date = zulu2.parse(source == null ? null : source.substring(0, pos1));
                        }
                    }
                    catch (Exception e) {
                        FFDCFilter.processException(e, "com.ibm.ws.webservices.engine.encoding.ser.CalendarDeserializer.makeCalendar", "355");
                        throw new NumberFormatException(e.toString());
                    }
                }
            }
            if (date != null) {
                date.setTime(date.getTime() + (long)milliseconds);
                date.setTime(date.getTime() + (long)timezonemilliseconds);
            }
            if (pos < source.length()) {
                throw new NumberFormatException(Messages.getMessage("badChars00", source));
            }
        }
        calendar.setTime(date);
        return calendar;
    }

    static {
        zuluDateTime.setTimeZone(TimeZone.getTimeZone("GMT"));
        zuluDateTime2.setTimeZone(TimeZone.getDefault());
        zuluTime.setTimeZone(TimeZone.getTimeZone("GMT"));
        zuluTime2.setTimeZone(TimeZone.getDefault());
    }
}

