/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding.ser;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.description.TypeDesc;
import com.ibm.ws.webservices.engine.encoding.SerializationContext;
import com.ibm.ws.webservices.engine.encoding.SerializationContextImpl;
import com.ibm.ws.webservices.engine.encoding.Serializer;
import com.ibm.ws.webservices.engine.encoding.utils.BeanDesc;
import com.ibm.ws.webservices.engine.encoding.utils.FieldDesc;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.BeanPropertyDescriptor;
import com.ibm.ws.webservices.engine.utils.BeanUtils;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPElement;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.Calendar;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class BeanSerializer
implements Serializer {
    protected static Log log = LogFactory.getLog(BeanSerializer.class.getName());
    QName xmlType;
    Class javaType;
    protected BeanPropertyDescriptor[] propertyDescriptor = null;
    protected BeanDesc beanDesc = null;

    public BeanSerializer(Class javaType, QName xmlType) {
        this(javaType, xmlType, BeanDesc.getBeanDescForClass(javaType));
    }

    public BeanSerializer(Class javaType, QName xmlType, TypeDesc typeDesc) {
        this(javaType, xmlType, null, null);
    }

    public BeanSerializer(Class javaType, QName xmlType, BeanDesc beanDesc) {
        this(javaType, xmlType, beanDesc, null);
        this.propertyDescriptor = beanDesc != null ? beanDesc.getPropertyDescriptors() : BeanUtils.getPd(javaType, null);
    }

    public BeanSerializer(Class javaType, QName xmlType, BeanDesc beanDesc, BeanPropertyDescriptor[] propertyDescriptor) {
        this.xmlType = xmlType;
        this.javaType = javaType;
        this.beanDesc = beanDesc;
        this.propertyDescriptor = propertyDescriptor;
    }

    void setup(BeanDesc beanDesc, BeanPropertyDescriptor[] propertyDescriptor) {
        this.beanDesc = beanDesc;
        this.propertyDescriptor = propertyDescriptor;
    }

    public void serialize(QName name, Attributes attributes, Object value, SerializationContext context) throws IOException {
        boolean suppressElement;
        Attributes beanAttrs = this.getObjectAttributes(value, attributes, context);
        String encodingStyle = context.getEncodingStyle();
        boolean isEncoded = Constants.isSOAP_ENC(encodingStyle);
        boolean bl = suppressElement = !isEncoded && name.getNamespaceURI().equals("") && name.getLocalPart().equals("any");
        if (!suppressElement) {
            context.getSerializationWriter().startElement(name, beanAttrs);
        }
        try {
            Object anyVal;
            BeanPropertyDescriptor anyDesc;
            for (int i = 0; i < this.propertyDescriptor.length; ++i) {
                FieldDesc field;
                String propName = this.propertyDescriptor[i].getName();
                if (propName.equals("class")) continue;
                QName qname = null;
                QName xmlType = null;
                boolean isOmittable = false;
                if (this.beanDesc != null && (field = this.beanDesc.getFieldByName(propName)) != null) {
                    if (!field.isElement()) continue;
                    qname = field.getXmlName();
                    isOmittable = field.isMinOccursIs0();
                    xmlType = field.getXmlType();
                }
                if (qname == null) {
                    qname = QNameTable.createQName("", propName);
                }
                if (xmlType == null) {
                    xmlType = context.getTypeMapping().getTypeQName(this.propertyDescriptor[i].getType());
                }
                if (!this.propertyDescriptor[i].isReadable()) continue;
                if (!this.propertyDescriptor[i].isIndexed()) {
                    Object propValue = this.propertyDescriptor[i].get(value);
                    if (propValue == null && isOmittable && !isEncoded) continue;
                    context.serialize(qname, null, propValue, xmlType, true, null);
                    continue;
                }
                int j = 0;
                int length = 0;
                Object array = this.propertyDescriptor[i].get(value);
                if (array != null) {
                    length = Array.getLength(array);
                }
                while (j < length) {
                    Object propValue = null;
                    try {
                        propValue = this.propertyDescriptor[i].get(value, j);
                        ++j;
                    }
                    catch (Exception e) {
                        j = length;
                    }
                    if (j < 0) continue;
                    context.serialize(qname, null, propValue, xmlType, true, null);
                }
            }
            BeanPropertyDescriptor beanPropertyDescriptor = anyDesc = this.beanDesc == null ? null : this.beanDesc.getAnyDesc();
            if (anyDesc != null && (anyVal = anyDesc.get(value)) != null && anyVal instanceof javax.xml.soap.SOAPElement[]) {
                javax.xml.soap.SOAPElement[] anyContent = (javax.xml.soap.SOAPElement[])anyVal;
                for (int i = 0; i < anyContent.length; ++i) {
                    SOAPElement element = (SOAPElement)anyContent[i];
                    element.output(context);
                }
            }
        }
        catch (InvocationTargetException ite) {
            FFDCFilter.processException((Throwable)ite, "com.ibm.ws.webservices.engine.encoding.ser.BeanSerializer.serialize", "279", this);
            Throwable target = ite.getTargetException();
            if (log.isDebugEnabled()) {
                log.debug(Messages.getMessage("exception01", JavaUtils.stackToString(ite)));
            }
            log.error(Messages.getMessage("exception00"), target);
            throw new IOException(target.toString());
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.encoding.ser.BeanSerializer.serialize", "284", this);
            if (log.isDebugEnabled()) {
                log.debug(Messages.getMessage("exception01", JavaUtils.stackToString(e)));
            }
            log.error(Messages.getMessage("exception00"), e);
            throw new IOException(e.toString());
        }
        if (!suppressElement) {
            context.getSerializationWriter().endElement();
        }
    }

    public String getMechanismType() {
        return "WebServices SAX Mechanism";
    }

    private Attributes getObjectAttributes(Object value, Attributes attributes, SerializationContext context) {
        if (this.beanDesc == null || !this.beanDesc.hasAttributes()) {
            return attributes;
        }
        AttributesImpl attrs = attributes == null ? new AttributesImpl() : (attributes instanceof AttributesImpl ? (AttributesImpl)attributes : new AttributesImpl(attributes));
        try {
            for (int i = 0; i < this.propertyDescriptor.length; ++i) {
                Object propValue;
                FieldDesc field;
                String propName = this.propertyDescriptor[i].getName();
                if (propName.equals("class") || (field = this.beanDesc.getFieldByName(propName)) == null || field.isElement()) continue;
                QName qname = field.getXmlName();
                if (qname == null) {
                    qname = QNameTable.createQName("", propName);
                }
                if (!this.propertyDescriptor[i].isReadable() || this.propertyDescriptor[i].isIndexed() || (propValue = this.propertyDescriptor[i].get(value)) == null) continue;
                this.setAttributeProperty(propValue, qname, attrs, context);
            }
        }
        catch (Exception e) {
            return attrs;
        }
        return attrs;
    }

    private void setAttributeProperty(Object propValue, QName qname, AttributesImpl attrs, SerializationContext context) throws Exception {
        String propString = context.getValueAsString(propValue, null);
        String namespace = qname.getNamespaceURI();
        String localName = qname.getLocalPart();
        attrs.addAttribute(namespace, localName, context.getSerializationWriter().qName2String(qname, true), "CDATA", propString);
    }

    protected final void serializeChild(QName elemQName, Attributes attributes, Object value, QName xmlType, boolean sendNull, Boolean sendType, SerializationContext context) throws IOException {
        Class javaType;
        Serializer ser = null;
        Class clazz = javaType = value != null ? value.getClass() : null;
        if (this.beanDesc != null) {
            Class cls;
            FieldDesc fieldDesc = this.beanDesc.getFieldDesc(elemQName.getNamespaceURI(), elemQName.getLocalPart());
            if (fieldDesc != null && ((cls = fieldDesc.getJavaType()) != null && cls.isPrimitive() || javaType == null)) {
                javaType = cls;
            }
            if (fieldDesc != null && xmlType == fieldDesc.getXmlType() && (value == null || value.getClass() == fieldDesc.getJavaType() || fieldDesc.getJavaType().isPrimitive() || fieldDesc.getJavaType().equals(Calendar.class) && fieldDesc.getJavaType().isAssignableFrom(value.getClass())) && (ser = fieldDesc.getSerializer()) == null && (ser = context.getSerializer(fieldDesc.getJavaType(), fieldDesc.getXmlType())) != null) {
                fieldDesc.setSerializer(ser);
            }
        }
        ((SerializationContextImpl)context).serialize(elemQName, attributes, value, xmlType, javaType, sendNull, sendType, ser);
    }

    public String getBuildNumber() {
        return this.beanDesc == null ? null : this.beanDesc.getBuildNumber();
    }
}

