/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding.ser;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.configurable.Configurable;
import com.ibm.ws.webservices.engine.configurable.ConfigurableImpl;
import com.ibm.ws.webservices.engine.configurable.Configured;
import com.ibm.ws.webservices.engine.encoding.Deserializer;
import com.ibm.ws.webservices.engine.encoding.DeserializerFactory;
import com.ibm.ws.webservices.engine.encoding.ser.CustomDeserializerFactory;
import com.ibm.ws.webservices.engine.encoding.ser.DeserializerPool;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.ClassUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import org.apache.commons.logging.Log;

public abstract class BaseDeserializerFactory
implements DeserializerFactory {
    private static Log log = LogFactory.getLog(BaseDeserializerFactory.class.getName());
    static Vector mechanisms = null;
    protected Class deserClass = null;
    protected QName xmlType = null;
    protected Class javaType = null;
    protected boolean initialized = false;
    protected transient Constructor deserClassConstructor = null;
    protected transient Method getDeserializer = null;
    private transient DeserializerPool pool = null;
    private Configurable _configurable = null;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$javax$xml$namespace$QName;
    static /* synthetic */ Class class$java$lang$String;

    public BaseDeserializerFactory(Class deserClass, QName xmlType, Class javaType) {
        this.deserClass = deserClass;
        this.xmlType = xmlType;
        this.javaType = javaType;
    }

    protected void lazyInitialization() {
        this.deserClassConstructor = this.getConstructor(this.deserClass);
        this.getDeserializer = this.getDeserializerMethod(this.javaType);
        this.pool = new DeserializerPool();
        this.initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public javax.xml.rpc.encoding.Deserializer getDeserializerAs(String mechanismType) throws JAXRPCException {
        BaseDeserializerFactory baseDeserializerFactory = this;
        synchronized (baseDeserializerFactory) {
            Deserializer deser;
            if (!this.initialized) {
                this.lazyInitialization();
            }
            if ((deser = this.pool.getDeserializer()) != null) {
                return deser;
            }
            deser = this.getSpecialized(mechanismType);
            if (deser == null) {
                deser = this.getGeneralPurpose(mechanismType);
            }
            this.pool.addDeserializer(deser);
            return deser;
        }
    }

    protected Deserializer getGeneralPurpose(String mechanismType) {
        if (this.deserClassConstructor != null) {
            try {
                return (Deserializer)this.deserClassConstructor.newInstance(this.javaType, this.xmlType);
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return null;
    }

    protected Deserializer getSpecialized(String mechanismType) {
        if (this.getDeserializer != null) {
            try {
                return (Deserializer)this.getDeserializer.invoke(null, mechanismType, this.javaType, this.xmlType);
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return null;
    }

    private Constructor getConstructor(Class clazz) {
        return (Constructor)AccessController.doPrivileged(new getConstructorPRIV(clazz));
    }

    protected Method getDeserializerMethod(Class clazz) {
        return (Method)AccessController.doPrivileged(new getDeserializerMethodPRIV(clazz));
    }

    public Iterator getSupportedMechanismTypes() {
        return mechanisms.iterator();
    }

    public static DeserializerFactory createFactory(Class factory, Class javaType, QName xmlType) {
        return BaseDeserializerFactory.createFactory(factory, javaType, xmlType, null, null);
    }

    public static DeserializerFactory createFactory(Class factory, Class javaType, QName xmlType, String binderName) {
        return BaseDeserializerFactory.createFactory(factory, javaType, xmlType, binderName, null, null);
    }

    public static DeserializerFactory createFactory(Class factory, Class javaType, QName xmlType, QName compQName, QName compTypeQName) {
        return BaseDeserializerFactory.createFactory(factory, javaType, xmlType, null, compQName, compTypeQName);
    }

    public static DeserializerFactory createFactory(Class factory, Class javaType, QName xmlType, String binderName, QName compQName, QName compTypeQName) {
        return (DeserializerFactory)AccessController.doPrivileged(new CreateFactoryPRIV(factory, javaType, xmlType, binderName, compQName, compTypeQName));
    }

    private void makeConfigurable() {
        if (this._configurable == null) {
            this._configurable = new ConfigurableImpl();
        }
    }

    private String toStringConfigurable(String indent) {
        Iterator it;
        String text = "";
        if (this._configurable != null && (it = this.getOptions().entrySet().iterator()) != null) {
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                text = text + indent + "KEY(" + entry.getKey() + ")\n";
                text = text + indent + " VALUE(" + entry.getValue() + ")\n";
            }
        }
        return text;
    }

    public final void setOptionsDefault(Configured dephault) {
        this.makeConfigurable();
        this._configurable.setOptionsDefault(dephault);
    }

    public final void setOption(String name, Object value) {
        this.makeConfigurable();
        this._configurable.setOption(name, value);
    }

    public final void setOption(String name, Object value, boolean lock) {
        this.makeConfigurable();
        this._configurable.setOption(name, value, lock);
    }

    public final boolean setOptionDefault(String name, Object value) {
        this.makeConfigurable();
        return this._configurable.setOptionDefault(name, value);
    }

    public final boolean setOptionDefault(String name, Object value, boolean lock) {
        this.makeConfigurable();
        return this._configurable.setOptionDefault(name, value, lock);
    }

    public final void setOptions(Map opts) {
        this.makeConfigurable();
        this._configurable.setOptions(opts);
    }

    public final Object getOption(String name) {
        this.makeConfigurable();
        return this._configurable.getOption(name);
    }

    public final void removeOption(String name) {
        if (this._configurable != null) {
            this._configurable.removeOption(name);
        }
    }

    public final Map getOptions() {
        this.makeConfigurable();
        return this._configurable.getOptions();
    }

    public Set getOptionsBooleanNames() {
        this.makeConfigurable();
        return this._configurable.getOptionsBooleanNames();
    }

    public String toString() {
        return "BaseDeserializerFactory: DeserClass=" + (this.deserClass != null ? this.deserClass.toString() : "<null>") + ", XmlType=" + (this.xmlType != null ? this.xmlType.toString() : "<null>") + ", JavaType=" + (this.javaType != null ? this.javaType.toString() : "<null>");
    }

    private static class CreateFactoryPRIV
    implements PrivilegedAction {
        private Class factory;
        private Class javaType;
        private QName xmlType;
        private String binderName;
        private QName compQName;
        private QName compTypeQName;

        CreateFactoryPRIV(Class factory, Class javaType, QName xmlType, String binderName, QName compQName, QName compTypeQName) {
            this.factory = factory;
            this.javaType = javaType;
            this.xmlType = xmlType;
            this.binderName = binderName;
            this.compQName = compQName;
            this.compTypeQName = compTypeQName;
        }

        public Object run() {
            DeserializerFactory df;
            block44: {
                block43: {
                    Constructor constructor;
                    block42: {
                        Method method;
                        block41: {
                            block40: {
                                df = null;
                                try {
                                    if (this.binderName != null) {
                                        Class<?> binderClass = Class.forName(this.binderName, true, Thread.currentThread().getContextClassLoader());
                                        df = new CustomDeserializerFactory(this.javaType, this.xmlType, binderClass);
                                    }
                                }
                                catch (ClassNotFoundException e) {
                                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.encoding.ser.BaseDeserializerFactory", "395", this);
                                    log.error(Messages.getMessage("noBinderFound00", this.binderName), e);
                                }
                                if (df == null) {
                                    try {
                                        method = this.factory.getMethod("create", class$java$lang$Class == null ? (class$java$lang$Class = BaseDeserializerFactory.class$("java.lang.Class")) : class$java$lang$Class, class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = BaseDeserializerFactory.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName, class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = BaseDeserializerFactory.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName, class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = BaseDeserializerFactory.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName);
                                        df = (DeserializerFactory)method.invoke(null, this.javaType, this.xmlType, this.compQName, this.compTypeQName);
                                    }
                                    catch (NoSuchMethodException e) {
                                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.encoding.ser.BaseDeserializerFactory", "436", this);
                                        if (log.isDebugEnabled()) {
                                            log.debug("BaseDeserializerFactory$CreateFactoryPRIV.run() caught NoSuchMethodException: " + e);
                                        }
                                    }
                                    catch (IllegalAccessException e) {
                                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.encoding.ser.BaseDeserializerFactory", "439", this);
                                        if (log.isDebugEnabled()) {
                                            log.debug("BaseDeserializerFactory$CreateFactoryPRIV.run() caught IllegalAccessException: " + e);
                                        }
                                    }
                                    catch (InvocationTargetException e) {
                                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.encoding.ser.BaseDeserializerFactory", "439", this);
                                        if (!log.isDebugEnabled()) break block40;
                                        log.debug("BaseDeserializerFactory$CreateFactoryPRIV.run() caught InvocationTargetException: " + e);
                                    }
                                }
                            }
                            if (df == null) {
                                try {
                                    constructor = this.factory.getConstructor(class$java$lang$Class == null ? (class$java$lang$Class = BaseDeserializerFactory.class$("java.lang.Class")) : class$java$lang$Class, class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = BaseDeserializerFactory.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName, class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = BaseDeserializerFactory.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName, class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = BaseDeserializerFactory.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName);
                                    df = (DeserializerFactory)constructor.newInstance(this.javaType, this.xmlType, this.compQName, this.compTypeQName);
                                }
                                catch (NoSuchMethodException e) {
                                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.encoding.ser.BaseDeserializerFactory", "459", this);
                                    if (log.isDebugEnabled()) {
                                        log.debug("BaseDeserializerFactory$CreateFactoryPRIV.run() caught NoSuchMethodException: " + e);
                                    }
                                }
                                catch (InstantiationException e) {
                                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.encoding.ser.BaseDeserializerFactory", "461", this);
                                    if (log.isDebugEnabled()) {
                                        log.debug("BaseDeserializerFactory$CreateFactoryPRIV.run() caught InstantiationException: " + e);
                                    }
                                }
                                catch (IllegalAccessException e) {
                                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.encoding.ser.BaseDeserializerFactory", "461", this);
                                    if (log.isDebugEnabled()) {
                                        log.debug("BaseDeserializerFactory$CreateFactoryPRIV.run() caught IllegalAccessException: " + e);
                                    }
                                }
                                catch (InvocationTargetException e) {
                                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.encoding.ser.BaseDeserializerFactory", "461", this);
                                    if (!log.isDebugEnabled()) break block41;
                                    log.debug("BaseDeserializerFactory$CreateFactoryPRIV.run() caught InvocationTargetException: " + e);
                                }
                            }
                        }
                        if (df == null) {
                            try {
                                method = this.factory.getMethod("create", class$java$lang$Class == null ? (class$java$lang$Class = BaseDeserializerFactory.class$("java.lang.Class")) : class$java$lang$Class, class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = BaseDeserializerFactory.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName);
                                df = (DeserializerFactory)method.invoke(null, this.javaType, this.xmlType);
                            }
                            catch (NoSuchMethodException e) {
                                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.encoding.ser.BaseDeserializerFactory", "484", this);
                                if (log.isDebugEnabled()) {
                                    log.debug("BaseDeserializerFactory$CreateFactoryPRIV.run() caught NoSuchMethodException: " + e);
                                }
                            }
                            catch (IllegalAccessException e) {
                                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.encoding.ser.BaseDeserializerFactory", "487", this);
                                if (log.isDebugEnabled()) {
                                    log.debug("BaseDeserializerFactory$CreateFactoryPRIV.run() caught IllegalAccessException: " + e);
                                }
                            }
                            catch (InvocationTargetException e) {
                                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.encoding.ser.BaseDeserializerFactory", "487", this);
                                if (!log.isDebugEnabled()) break block42;
                                log.debug("BaseDeserializerFactory$CreateFactoryPRIV.run() caught InvocationTargetException: " + e);
                            }
                        }
                    }
                    if (df == null) {
                        try {
                            constructor = this.factory.getConstructor(class$java$lang$Class == null ? (class$java$lang$Class = BaseDeserializerFactory.class$("java.lang.Class")) : class$java$lang$Class, class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = BaseDeserializerFactory.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName);
                            df = (DeserializerFactory)constructor.newInstance(this.javaType, this.xmlType);
                        }
                        catch (NoSuchMethodException e) {
                            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.encoding.ser.BaseDeserializerFactory", "507", this);
                            if (log.isDebugEnabled()) {
                                log.debug("BaseDeserializerFactory$CreateFactoryPRIV.run() caught NoSuchMethodException: " + e);
                            }
                        }
                        catch (InstantiationException e) {
                            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.encoding.ser.BaseDeserializerFactory", "509", this);
                            if (log.isDebugEnabled()) {
                                log.debug("BaseDeserializerFactory$CreateFactoryPRIV.run() caught InstantiationException: " + e);
                            }
                        }
                        catch (IllegalAccessException e) {
                            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.encoding.ser.BaseDeserializerFactory", "509", this);
                            if (log.isDebugEnabled()) {
                                log.debug("BaseDeserializerFactory$CreateFactoryPRIV.run() caught IllegalAccessException: " + e);
                            }
                        }
                        catch (InvocationTargetException e) {
                            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.encoding.ser.BaseDeserializerFactory", "509", this);
                            if (!log.isDebugEnabled()) break block43;
                            log.debug("BaseDeserializerFactory$CreateFactoryPRIV.run() caught InvocationTargetException: " + e);
                        }
                    }
                }
                if (df == null) {
                    try {
                        df = (DeserializerFactory)this.factory.newInstance();
                    }
                    catch (InstantiationException e) {
                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.encoding.ser.BaseDeserializerFactory", "531", this);
                        if (log.isDebugEnabled()) {
                            log.debug("BaseDeserializerFactory$CreateFactoryPRIV.run() caught InstantiationException: " + e);
                        }
                    }
                    catch (IllegalAccessException e) {
                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.encoding.ser.BaseDeserializerFactory", "531", this);
                        if (!log.isDebugEnabled()) break block44;
                        log.debug("BaseDeserializerFactory$CreateFactoryPRIV.run() caught IllegalAccessException: " + e);
                    }
                }
            }
            return df;
        }
    }

    private class getDeserializerMethodPRIV
    implements PrivilegedAction {
        private Class clazz;

        getDeserializerMethodPRIV(Class clazz) {
            this.clazz = clazz;
        }

        public Object run() {
            Method method = null;
            Class helper = null;
            try {
                if (this.clazz.getClassLoader() == null) {
                    helper = ClassUtils.forName(this.clazz.getName() + "_Helper");
                } else {
                    try {
                        helper = ClassUtils.forName(this.clazz.getName() + "_Helper", true, this.clazz.getClassLoader());
                    }
                    catch (ClassNotFoundException e) {
                        helper = ClassUtils.forName(this.clazz.getName() + "_Helper");
                    }
                }
                method = helper.getMethod("getDeserializer", class$java$lang$String == null ? (class$java$lang$String = BaseDeserializerFactory.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Class == null ? (class$java$lang$Class = BaseDeserializerFactory.class$("java.lang.Class")) : class$java$lang$Class, class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = BaseDeserializerFactory.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName);
            }
            catch (NoSuchMethodException e) {
                if (log.isDebugEnabled()) {
                    log.debug("getDeserializerMethodPRIV caught exception - processing continues", e);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            return method;
        }
    }

    private class getConstructorPRIV
    implements PrivilegedAction {
        private Class clazz;

        getConstructorPRIV(Class clazz) {
            this.clazz = clazz;
        }

        public Object run() {
            try {
                return this.clazz.getConstructor(class$java$lang$Class == null ? (class$java$lang$Class = BaseDeserializerFactory.class$("java.lang.Class")) : class$java$lang$Class, class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = BaseDeserializerFactory.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return null;
            }
        }
    }
}

