/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.dispatchers.java;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesEngine;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.configurable.Configurable;
import com.ibm.ws.webservices.engine.dispatchers.java.JavaDispatcher;
import com.ibm.ws.webservices.engine.enumtype.Scope;
import com.ibm.ws.webservices.engine.handlers.soap.SOAPPort;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.session.Session;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.server.ServiceLifecycle;
import org.apache.commons.logging.Log;

public abstract class SessionDispatcher
extends JavaDispatcher {
    protected static Log log = LogFactory.getLog(SessionDispatcher.class.getName());
    private static final String D_OPTION_SCOPE = "scope";

    public static final void setScope(Configurable port, String scope) {
        SessionDispatcher.setScope(port, Scope.getScope(scope, Scope.DEFAULT));
    }

    public static final void setScope(Configurable port, Scope scope) {
        port.setOption(D_OPTION_SCOPE, scope);
    }

    public static final Scope getScope(Configurable port) {
        return (Scope)port.getOption(D_OPTION_SCOPE);
    }

    protected abstract Object createServiceObject(SOAPPort var1) throws WebServicesFault;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void invoke(MessageContext msgContext) throws WebServicesFault {
        block14: {
            if (log.isDebugEnabled()) {
                log.debug("Enter: SessionDispatcher::invoke (" + this + ")");
            }
            Object serviceObject = null;
            Session session = null;
            try {
                try {
                    session = this.getServiceSession(msgContext);
                    if (session != null) {
                        SOAPPort port = msgContext.getPort();
                        String portName = SessionDispatcher.getPortName(msgContext);
                        Session session2 = session;
                        synchronized (session2) {
                            serviceObject = session.get(portName);
                            if (serviceObject == null) {
                                serviceObject = this.createAndInitServiceObject(msgContext);
                                session.set(portName, serviceObject);
                            }
                        }
                    } else {
                        serviceObject = this.createAndInitServiceObject(msgContext);
                    }
                    this.processMessage(msgContext, serviceObject);
                }
                catch (WebServicesFault wsf) {
                    throw wsf;
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.dispatchers.java.Dispatcher.invoke", "246", this);
                    if (!log.isDebugEnabled()) throw WebServicesFault.makeFault(e);
                    log.debug(Messages.getMessage("toWebServicesFault00"), e);
                    throw WebServicesFault.makeFault(e);
                }
                Object var9_9 = null;
                if (serviceObject == null || session != null) break block14;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                if (serviceObject != null && session == null && serviceObject instanceof ServiceLifecycle) {
                    ((ServiceLifecycle)serviceObject).destroy();
                }
                if (!log.isDebugEnabled()) throw throwable;
                log.debug("Exit: SessionDispatcher::invoke (" + this + ")");
                throw throwable;
            }
            if (serviceObject instanceof ServiceLifecycle) {
                ((ServiceLifecycle)serviceObject).destroy();
            }
        }
        if (!log.isDebugEnabled()) return;
        log.debug("Exit: SessionDispatcher::invoke (" + this + ")");
    }

    private static String getPortName(MessageContext msgContext) {
        String portName = msgContext.getPort().getName();
        if (portName == null) {
            portName = msgContext.getTargetPortName();
        }
        return portName;
    }

    private Object createAndInitServiceObject(MessageContext msgContext) throws WebServicesFault, ServiceException {
        Object serviceObject = this.createServiceObject(msgContext.getPort());
        if (serviceObject != null && serviceObject instanceof ServiceLifecycle) {
            Object context = msgContext.getProperty("servletEndpointContext");
            ((ServiceLifecycle)serviceObject).init(context);
        }
        return serviceObject;
    }

    private Session getServiceSession(MessageContext msgContext) {
        Session session;
        SOAPPort port = msgContext.getPort();
        Scope scope = SessionDispatcher.getScope(port);
        if (scope == Scope.REQUEST) {
            session = null;
        } else if (scope == Scope.SESSION) {
            session = msgContext.getSession();
        } else if (scope == Scope.APPLICATION) {
            WebServicesEngine engine2 = msgContext.getEngine();
            session = engine2.getApplicationSession();
        } else {
            session = null;
        }
        return session;
    }
}

