/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.dispatchers.java;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.configurable.Configurable;
import com.ibm.ws.webservices.engine.dispatchers.java.SessionDispatcher;
import com.ibm.ws.webservices.engine.handlers.soap.SOAPPort;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.ClassUtils;
import com.ibm.wsspi.injectionengine.InjectionUtil;
import org.apache.commons.logging.Log;

public class JavaBeanDispatcher
extends SessionDispatcher {
    protected static Log log = LogFactory.getLog(JavaBeanDispatcher.class.getName());
    private static TraceComponent tc = Tr.register(JavaBeanDispatcher.class, "WebServices", "com.ibm.ws.webservices.resources.webservicesMessages");
    private static final String D_OPTION_CLASSNAME = "className";

    public static final void setClassName(Configurable port, String className) {
        port.setOption(D_OPTION_CLASSNAME, className);
    }

    public static final String getClassName(Configurable port) {
        return (String)port.getOption(D_OPTION_CLASSNAME);
    }

    protected ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    protected Class getServiceClass(SOAPPort port) throws WebServicesFault {
        String clsName = JavaBeanDispatcher.getClassName(port);
        if (clsName == null || clsName.length() == 0) {
            throw new WebServicesFault("Server.NoClassForService", Messages.getMessage("noServiceClass01"), null, null);
        }
        Class clazz = null;
        try {
            clazz = ClassUtils.forName(clsName, true, this.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.dispatchers.java.JavaBeanDispatcher.getServiceClass", "147", this);
            String translatedMessage = Messages.getMessage("noClassForService01", clsName, port.getName());
            log.error(translatedMessage, e);
            throw new WebServicesFault(translatedMessage, e);
        }
        return clazz;
    }

    protected Object createServiceObject(SOAPPort port) throws WebServicesFault {
        Object obj;
        Class clazz = this.getServiceClass(port);
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Attempting to create JavaBean webservice endpoint for class: " + clazz.getName());
            }
            obj = InjectionUtil.createInjectedInstance((Class)clazz, null);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.dispatchers.java.JavaBeanDispatcher.createServiceObject", "169", this);
            String translatedMessage = Messages.getMessage("cantInstantiateClass", clazz.getName());
            log.error(translatedMessage, e);
            throw new WebServicesFault(translatedMessage, e);
        }
        return obj;
    }
}

