/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.dispatchers.java;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.Handler;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.configurable.Configurable;
import com.ibm.ws.webservices.engine.dispatchers.java.JavaDispatcher;
import com.ibm.ws.webservices.engine.handlers.soap.SOAPPort;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.ClassUtils;
import java.lang.reflect.Method;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.apache.commons.logging.Log;

public class EJBDispatcher
extends JavaDispatcher {
    protected static Log log = LogFactory.getLog(EJBDispatcher.class.getName());
    private static final String D_OPTION_BEANJNDINAME = "beanJndiName".intern();
    private static final String D_OPTION_HOMEINTERFACENAME = "homeInterfaceName".intern();
    private static final String D_OPTION_REMOTEINTERFACENAME = "remoteInterfaceName".intern();
    private static final String D_OPTION_INITIALCONTEXT = "Internal.InitialContext".intern();
    private static final String D_OPTION_REMOTEINTERFACE = "Internal.RemoteInterface".intern();
    private static final String D_OPTION_EJBHOME = "Internal.EJBHome".intern();
    public static final String jndiContextClass = "jndiContextClass".intern();
    public static final String jndiURL = "jndiURL".intern();
    public static final String jndiUsername = "jndiUser".intern();
    public static final String jndiPassword = "jndiPassword".intern();
    protected static final Class[] empty_class_array = new Class[0];
    protected static final Object[] empty_object_array = new Object[0];

    public static final void setBeanJndiName(Configurable port, String beanName) {
        port.setOption(D_OPTION_BEANJNDINAME, beanName);
    }

    public static final String getBeanJndiName(Configurable port) {
        return (String)port.getOption(D_OPTION_BEANJNDINAME);
    }

    public static final void setHomeInterfaceName(Configurable port, String homeInterfaceName) {
        port.setOption(D_OPTION_HOMEINTERFACENAME, homeInterfaceName);
    }

    public static final String getHomeInterfaceName(Configurable port) {
        return (String)port.getOption(D_OPTION_HOMEINTERFACENAME);
    }

    public static final void setRemoteInterfaceName(Configurable port, String remoteInterfaceName) {
        port.setOption(D_OPTION_REMOTEINTERFACENAME, remoteInterfaceName);
    }

    public static final String getRemoteInterfaceName(Configurable port) {
        return (String)port.getOption(D_OPTION_REMOTEINTERFACENAME);
    }

    public static final void setInitialContext(Configurable port, InitialContext initialContext) {
        port.setOption(D_OPTION_INITIALCONTEXT, initialContext);
    }

    public static final InitialContext getInitialContext(Configurable port) {
        return (InitialContext)port.getOption(D_OPTION_INITIALCONTEXT);
    }

    public static final void setRemoteInterface(Configurable port, Class remoteInterface) {
        port.setOption(D_OPTION_REMOTEINTERFACE, remoteInterface);
    }

    public static final Class getRemoteInterface(Configurable port) {
        return (Class)port.getOption(D_OPTION_REMOTEINTERFACE);
    }

    protected ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public void invoke(MessageContext msgContext) throws WebServicesFault {
        if (log.isDebugEnabled()) {
            log.debug("Enter: EJBDispatcher::invoke (" + this + ")");
        }
        try {
            try {
                SOAPPort port = msgContext.getPort();
                Object serviceObject = this.createServiceObject(port);
                this.processMessage(msgContext, serviceObject);
            }
            catch (WebServicesFault wsf) {
                throw wsf;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.dispatchers.java.Dispatcher.invoke", "246", this);
                if (log.isDebugEnabled()) {
                    log.debug(Messages.getMessage("toWebServicesFault00"), e);
                }
                throw WebServicesFault.makeFault(e);
            }
            Object var5_6 = null;
            if (log.isDebugEnabled()) {
                log.debug("Exit: EJBDispatcher::invoke (" + this + ")");
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (log.isDebugEnabled()) {
                log.debug("Exit: EJBDispatcher::invoke (" + this + ")");
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class getServiceClass(SOAPPort port) throws WebServicesFault {
        Class interfaceClass;
        SOAPPort sOAPPort = port;
        synchronized (sOAPPort) {
            interfaceClass = EJBDispatcher.getRemoteInterface(port);
            if (interfaceClass == null) {
                try {
                    ClassLoader classLoader = this.getClassLoader();
                    String remoteName = EJBDispatcher.getRemoteInterfaceName(port);
                    if (remoteName != null) {
                        interfaceClass = ClassUtils.forName(remoteName, true, classLoader);
                    } else {
                        Object ejbHome = this.getEJBHome(port);
                        String homeName = EJBDispatcher.getHomeInterfaceName(port);
                        if (homeName == null) {
                            throw new WebServicesFault(Messages.getMessage("noOption00", D_OPTION_HOMEINTERFACENAME, port.getName()));
                        }
                        Class homeClass = ClassUtils.forName(homeName, true, classLoader);
                        Object ehome = PortableRemoteObject.narrow((Object)ejbHome, (Class)homeClass);
                        Method getEJBMetaData = homeClass.getMethod("getEJBMetaData", empty_class_array);
                        Object metaData = getEJBMetaData.invoke(ehome, empty_object_array);
                        Method getRemoteInterfaceClass = metaData.getClass().getMethod("getRemoteInterfaceClass", empty_class_array);
                        interfaceClass = (Class)getRemoteInterfaceClass.invoke(metaData, empty_object_array);
                    }
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.dispatchers.java.EJBDispatcher.getServiceClass", "252", this);
                    throw WebServicesFault.makeFault(e);
                }
                EJBDispatcher.setRemoteInterface(port, interfaceClass);
            }
        }
        return interfaceClass;
    }

    protected Object createServiceObject(SOAPPort port) throws Exception {
        Object ejbHome = this.getEJBHome(port);
        String homeName = EJBDispatcher.getHomeInterfaceName(port);
        if (homeName == null) {
            throw new WebServicesFault(Messages.getMessage("noOption00", D_OPTION_HOMEINTERFACENAME, port.getName()));
        }
        Class homeClass = ClassUtils.forName(homeName, true, this.getClassLoader());
        Object ehome = PortableRemoteObject.narrow((Object)ejbHome, (Class)homeClass);
        Method createMethod = homeClass.getMethod("create", empty_class_array);
        Object result = createMethod.invoke(ehome, empty_object_array);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getEJBHome(SOAPPort port) throws WebServicesFault {
        Object ejbHome;
        SOAPPort sOAPPort = port;
        synchronized (sOAPPort) {
            ejbHome = port.getOption(D_OPTION_EJBHOME);
            if (ejbHome == null) {
                try {
                    InitialContext context = this.getContext(port);
                    if (context == null) {
                        throw new WebServicesFault(Messages.getMessage("cannotCreateInitialContext00"));
                    }
                    String beanJndiName = EJBDispatcher.getBeanJndiName(port);
                    ejbHome = context.lookup(beanJndiName);
                    if (ejbHome == null) {
                        throw new WebServicesFault(Messages.getMessage("cannotFindJNDIHome00", beanJndiName));
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.dispatchers.java.EJBDispatcher.getEJBHome", "328", this);
                    throw WebServicesFault.makeFault(exception);
                }
                port.setOption(D_OPTION_EJBHOME, ejbHome);
            }
        }
        return ejbHome;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InitialContext getContext(SOAPPort port) throws WebServicesFault, NamingException {
        InitialContext context;
        SOAPPort sOAPPort = port;
        synchronized (sOAPPort) {
            context = EJBDispatcher.getInitialContext(port);
            if (context == null) {
                String contextUrl;
                String factoryClass;
                String password;
                Properties properties = null;
                String username = this.getStrOption(jndiUsername, port);
                if (username != null) {
                    if (properties == null) {
                        properties = new Properties();
                    }
                    properties.setProperty("java.naming.security.principal", username);
                }
                if ((password = this.getStrOption(jndiPassword, port)) != null) {
                    if (properties == null) {
                        properties = new Properties();
                    }
                    properties.setProperty("java.naming.security.credentials", password);
                }
                if ((factoryClass = this.getStrOption(jndiContextClass, port)) != null) {
                    if (properties == null) {
                        properties = new Properties();
                    }
                    properties.setProperty("java.naming.factory.initial", factoryClass);
                }
                if ((contextUrl = this.getStrOption(jndiURL, port)) != null) {
                    if (properties == null) {
                        properties = new Properties();
                    }
                    properties.setProperty("java.naming.provider.url", contextUrl);
                }
                context = new InitialContext(properties);
                EJBDispatcher.setInitialContext(port, context);
            }
        }
        return context;
    }

    private String getStrOption(String optionName, Handler service) {
        String value = null;
        if (service != null) {
            value = (String)service.getOption(optionName);
        }
        if (value == null) {
            value = (String)this.getOption(optionName);
        }
        return value;
    }
}

