/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.description;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.engine.InternalException;
import com.ibm.ws.webservices.engine.ServiceConfig;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.description.BaseDesc;
import com.ibm.ws.webservices.engine.description.OperationDesc;
import com.ibm.ws.webservices.engine.description.ParameterDesc;
import com.ibm.ws.webservices.engine.encoding.DefaultTypeMappingImpl;
import com.ibm.ws.webservices.engine.encoding.TypeMapping;
import com.ibm.ws.webservices.engine.encoding.TypeMappingRegistry;
import com.ibm.ws.webservices.engine.encoding.TypeMappingRegistryImpl;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.engine.utils.bytecode.ParamNameExtractor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;

public class PortDesc
extends BaseDesc {
    protected static Log log = LogFactory.getLog(PortDesc.class.getName());
    private String name = null;
    private List allowedMethods = null;
    private List disallowedMethods = null;
    private Class implClass = null;
    private ArrayList operations = new ArrayList();
    private List namespaceMappings = new ArrayList();
    private String wsdlFileName = null;
    private QName wsdlPort = null;
    private String endpointURL = null;
    private ArrayList stopClasses = null;
    private HashMap name2OperationsMap = null;
    private HashMap qname2OperationsMap = null;
    private HashMap method2OperationMap = new HashMap();
    private HashMap method2ParamsMap = new HashMap();
    private ArrayList completedNames = new ArrayList();
    private TypeMapping tm = DefaultTypeMappingImpl.getSingleton();
    private TypeMappingRegistry tmr = null;
    private boolean introspectionComplete = false;
    private boolean introspectionMode = true;
    private boolean highFidelityRecording = false;
    private int sendType = 1;
    private Set portOperationHeaders = null;
    static /* synthetic */ Class class$javax$xml$rpc$holders$Holder;
    static /* synthetic */ Class class$javax$xml$soap$SOAPElement;

    public void disableIntrospection() {
        this.introspectionMode = false;
    }

    public boolean needsHighFidelityRecording() {
        return this.highFidelityRecording;
    }

    public void setHighFidelityRecording(boolean highFidelityRecording) {
        this.highFidelityRecording = highFidelityRecording;
    }

    public int getSendType() {
        return this.sendType;
    }

    public void setSendType(int sendType) {
        this.sendType = sendType;
    }

    public String getWSDLFile() {
        return this.wsdlFileName;
    }

    public void setWSDLFile(String wsdlFileName) {
        this.wsdlFileName = wsdlFileName;
    }

    public List getAllowedMethods() {
        return this.allowedMethods;
    }

    public void setAllowedMethods(List allowedMethods) {
        this.allowedMethods = allowedMethods;
    }

    public Class getImplClass() {
        return this.implClass;
    }

    public synchronized void setImplClass(Class implClass) {
        if (this.implClass != null) {
            throw new IllegalArgumentException(Messages.getMessage("implAlreadySet"));
        }
        this.implClass = implClass;
    }

    public TypeMapping getTypeMapping() {
        return this.tm;
    }

    public void setTypeMapping(TypeMapping tm) {
        this.tm = tm;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ArrayList getStopClasses() {
        return this.stopClasses;
    }

    public void setStopClasses(ArrayList stopClasses) {
        this.stopClasses = stopClasses;
    }

    public List getDisallowedMethods() {
        return this.disallowedMethods;
    }

    public void setDisallowedMethods(List disallowedMethods) {
        this.disallowedMethods = disallowedMethods;
    }

    public synchronized void addOperationDesc(OperationDesc operation) {
        this.addOperationDesc(operation, true);
    }

    private synchronized void addOperationDesc(OperationDesc operation, boolean declarativeMode) {
        String name;
        ArrayList<OperationDesc> overloads;
        if (this.operations.contains(operation)) {
            return;
        }
        if (declarativeMode) {
            this.disableIntrospection();
        }
        this.operations.add(operation);
        operation.setParent(this);
        if (this.name2OperationsMap == null) {
            this.name2OperationsMap = new HashMap();
        }
        if ((overloads = (ArrayList<OperationDesc>)this.name2OperationsMap.get(name = operation.getName())) == null) {
            overloads = new ArrayList<OperationDesc>();
            this.name2OperationsMap.put(name, overloads);
        }
        overloads.add(operation);
    }

    public synchronized ArrayList getOperations() {
        if (!this.introspectionComplete) {
            this.loadPortDescByIntrospection();
        }
        if (this.implClass != null) {
            for (int i = 0; i < this.operations.size(); ++i) {
                OperationDesc oper = (OperationDesc)this.operations.get(i);
                if (oper.getMethod() != null) continue;
                this.syncOperationToClass(oper, this.implClass);
            }
        }
        return this.operations;
    }

    public synchronized OperationDesc[] getOperationsByName(String methodName) {
        this.getSyncedOperationsForName(this.implClass, methodName);
        if (this.name2OperationsMap == null) {
            return null;
        }
        ArrayList overloads = (ArrayList)this.name2OperationsMap.get(methodName);
        if (overloads == null) {
            return null;
        }
        OperationDesc[] array = new OperationDesc[overloads.size()];
        return overloads.toArray(array);
    }

    public synchronized OperationDesc getOperationByName(String methodName) {
        this.getSyncedOperationsForName(this.implClass, methodName);
        if (this.name2OperationsMap == null) {
            return null;
        }
        ArrayList overloads = (ArrayList)this.name2OperationsMap.get(methodName);
        if (overloads == null) {
            return null;
        }
        return (OperationDesc)overloads.get(0);
    }

    public synchronized OperationDesc getOperationByElementQName(QName qname) {
        OperationDesc[] overloads = this.getOperationsByQName(qname);
        if (overloads != null && overloads.length > 0) {
            return overloads[0];
        }
        return null;
    }

    public synchronized OperationDesc[] getOperationsByQName(QName qname) {
        this.initQNameMap();
        ArrayList overloads = (ArrayList)this.qname2OperationsMap.get(qname);
        if (overloads == null) {
            if (this.name2OperationsMap != null) {
                overloads = (ArrayList)this.name2OperationsMap.get(qname.getLocalPart());
            }
            if (overloads == null) {
                return null;
            }
        }
        this.getSyncedOperationsForName(this.implClass, ((OperationDesc)overloads.get(0)).getName());
        Collections.sort(overloads, new Comparator(){

            public int compare(Object o1, Object o2) {
                Method meth1 = ((OperationDesc)o1).getMethod();
                Method meth2 = ((OperationDesc)o2).getMethod();
                return meth1.getParameterTypes().length - meth2.getParameterTypes().length;
            }
        });
        OperationDesc[] array = new OperationDesc[overloads.size()];
        return overloads.toArray(array);
    }

    private synchronized void initQNameMap() {
        if (this.qname2OperationsMap == null) {
            this.loadPortDescByIntrospection();
            this.qname2OperationsMap = new HashMap();
            Iterator i = this.operations.iterator();
            while (i.hasNext()) {
                OperationDesc operationDesc = (OperationDesc)i.next();
                ArrayList<OperationDesc> list = (ArrayList<OperationDesc>)this.qname2OperationsMap.get(operationDesc.getElementQName());
                if (list == null) {
                    list = new ArrayList<OperationDesc>();
                    this.qname2OperationsMap.put(operationDesc.getElementQName(), list);
                }
                list.add(operationDesc);
            }
        }
    }

    private synchronized void syncOperationToClass(OperationDesc oper, Class implClass) {
        boolean isSCA = this.isSCA(implClass);
        if (log.isDebugEnabled()) {
            log.debug("SYNC! " + implClass + " " + oper);
            log.debug("The isSCA flag is set to :" + isSCA);
        }
        if (oper.getMethod() != null) {
            return;
        }
        Method[] methods = this.priviledgedGetDeclaredMethods(implClass);
        for (int i = 0; i < methods.length; ++i) {
            int j;
            Class<?>[] paramTypes;
            Method method = methods[i];
            if (log.isDebugEnabled()) {
                log.debug("Inspecting method: " + method);
            }
            if (!Modifier.isPublic(method.getModifiers()) || !method.getName().equals(oper.getName())) continue;
            if (log.isDebugEnabled()) {
                log.debug("  The method matches the operation name: " + oper.getName());
            }
            if ((paramTypes = method.getParameterTypes()).length != oper.getNumParams()) {
                if (!log.isDebugEnabled()) continue;
                log.debug("  The number of method parameters is " + paramTypes.length);
                log.debug("  The number of operation parameters is " + oper.getNumParams());
                log.debug("  Continue search");
                continue;
            }
            for (j = 0; j < paramTypes.length; ++j) {
                Class type;
                if (log.isDebugEnabled()) {
                    log.debug("  Inspecting parameter " + j);
                }
                Class heldType = type = paramTypes[j];
                if ((class$javax$xml$rpc$holders$Holder == null ? PortDesc.class$("javax.xml.rpc.holders.Holder") : class$javax$xml$rpc$holders$Holder).isAssignableFrom(type)) {
                    if (log.isDebugEnabled()) {
                        log.debug("    This method parameter is a Holder");
                    }
                    heldType = JavaUtils.getHolderValueType(type);
                }
                if (log.isDebugEnabled()) {
                    log.debug("    The method parameter actual class is " + heldType);
                }
                ParameterDesc param = oper.getParameter(j);
                QName typeQName = param.getTypeQName();
                if (log.isDebugEnabled()) {
                    log.debug("    The operation parameter's type qname is " + typeQName);
                }
                if (typeQName == null) {
                    typeQName = this.tm.getTypeQName(heldType);
                    param.setTypeQName(typeQName);
                    if (log.isDebugEnabled()) {
                        log.debug("    The method parameter class is used to set the type qname to " + typeQName);
                    }
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug("    Checking to see if the operation param's class is compatible with the method parameter class");
                    }
                    Class paramClass = null;
                    if (isSCA) {
                        ClassLoader cl = PortDesc.getClassLoader(heldType);
                        paramClass = param.getJavaType(cl);
                    }
                    if (paramClass == null) {
                        paramClass = param.getJavaType();
                    }
                    if (paramClass != null && JavaUtils.getHolderValueType(paramClass) != null) {
                        paramClass = JavaUtils.getHolderValueType(paramClass);
                        if (log.isDebugEnabled()) {
                            log.debug("    The operation param class is within a Holder.  The paramClass = " + paramClass);
                        }
                    }
                    if (paramClass == null) {
                        paramClass = this.tm.getClassForQName(param.getTypeQName());
                        if (log.isDebugEnabled()) {
                            log.debug("    The operation param class is not set. Using the type qname to find the param class. The paramClass = " + paramClass);
                        }
                    }
                    if (paramClass == null) {
                        Class clazz = paramClass = class$javax$xml$soap$SOAPElement == null ? PortDesc.class$("javax.xml.soap.SOAPElement") : class$javax$xml$soap$SOAPElement;
                        if (log.isDebugEnabled()) {
                            log.debug("    The operation param class is still not set. Defaulting to " + paramClass);
                        }
                    }
                    if (!JavaUtils.isConvertable(paramClass, heldType)) {
                        if (!log.isDebugEnabled()) break;
                        log.debug("    Method parameter " + heldType + " is not compatible with operation parameter " + paramClass + ". Continue searching for a method ");
                        log.debug("Classloader of method parameter = " + PortDesc.getClassLoader(heldType));
                        log.debug("Classloader of operation parameter = " + PortDesc.getClassLoader(paramClass));
                        break;
                    }
                }
                param.setJavaSigType(type);
            }
            if (j != paramTypes.length) continue;
            Class<?> returnClass = method.getReturnType();
            if (returnClass != Void.TYPE) {
                oper.setReturnClass(returnClass);
            }
            if (log.isDebugEnabled()) {
                log.debug("Method Found.  Setting operation's method to " + method);
            }
            oper.setMethod(method);
            this.method2OperationMap.put(method, oper);
            return;
        }
        Class superClass = implClass.getSuperclass();
        if (!(superClass == null || superClass.getName().startsWith("java.") || superClass.getName().startsWith("javax.") || this.stopClasses != null && this.stopClasses.contains(superClass.getName()))) {
            if (log.isDebugEnabled()) {
                log.debug("Did not find a compatible method.  Reattempting with the super class, " + superClass);
            }
            this.syncOperationToClass(oper, superClass);
        }
        if (oper.getMethod() == null) {
            InternalException ie = new InternalException(Messages.getMessage("methodSyncErr00", oper.getName(), implClass.getName(), this.toString()));
            throw ie;
        }
    }

    private boolean isSCA(Class cls) {
        return cls != null && cls.getName() != null && cls.getName().indexOf("sca.webservice") > 0;
    }

    public synchronized void loadPortDescByIntrospection() {
        this.loadPortDescByIntrospection(this.implClass);
        this.completedNames = null;
    }

    private synchronized Method priviledgedGetDeclaredMethod(final Class implClass, final String name, final Class[] parameterTypes) throws Exception {
        return (Method)AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                return implClass.getDeclaredMethod(name, parameterTypes);
            }
        });
    }

    private synchronized Method[] priviledgedGetDeclaredMethods(final Class implClass) {
        try {
            return (Method[])AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    return implClass.getDeclaredMethods();
                }
            });
        }
        catch (PrivilegedActionException e) {
            FFDCFilter.processException((Throwable)e.getException(), "com.ibm.ws.webservices.engine.description.PortDesc.priviledgedGetDeclaredMethods", "730", this);
            log.error(Messages.getMessage("exception00"), e);
            return new Method[0];
        }
    }

    public synchronized void loadPortDescByIntrospection(Class implClass) {
        String allowedMethodsStr;
        if (this.introspectionComplete || implClass == null) {
            return;
        }
        this.implClass = implClass;
        ServiceConfig webServicesConfig = null;
        try {
            Method method = this.priviledgedGetDeclaredMethod(implClass, "getServiceConfig", new Class[0]);
            if (method != null && Modifier.isStatic(method.getModifiers())) {
                webServicesConfig = (ServiceConfig)method.invoke(null, null);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (webServicesConfig != null && (allowedMethodsStr = webServicesConfig.getAllowedMethods()) != null && !"*".equals(allowedMethodsStr)) {
            ArrayList<String> methodList = new ArrayList<String>();
            StringTokenizer tokenizer = new StringTokenizer(allowedMethodsStr, " ,");
            while (tokenizer.hasMoreTokens()) {
                methodList.add(tokenizer.nextToken());
            }
            this.setAllowedMethods(methodList);
        }
        this.loadPortDescByIntrospectionRecursive(implClass);
        Iterator iterator = this.operations.iterator();
        while (iterator.hasNext()) {
            OperationDesc operation = (OperationDesc)iterator.next();
            if (operation.getMethod() != null) continue;
            throw new InternalException(Messages.getMessage("badWSDDOperation", operation.getName(), "Debug Info: " + this.toString()));
        }
        this.introspectionComplete = true;
    }

    private synchronized void loadPortDescByIntrospectionRecursive(Class implClass) {
        Method[] methods = this.priviledgedGetDeclaredMethods(implClass);
        for (int i = 0; i < methods.length; ++i) {
            if (!Modifier.isPublic(methods[i].getModifiers())) continue;
            this.getSyncedOperationsForName(implClass, methods[i].getName());
        }
        if (implClass.isInterface()) {
            Class<?>[] superClasses = implClass.getInterfaces();
            for (int i = 0; i < superClasses.length; ++i) {
                Class<?> superClass = superClasses[i];
                if (this.stopClasses != null && this.stopClasses.contains(superClass.getName())) continue;
                this.loadPortDescByIntrospectionRecursive(superClass);
            }
        } else {
            Class superClass = implClass.getSuperclass();
            if (!(superClass == null || superClass.getName().startsWith("java.") || superClass.getName().startsWith("javax.") || this.stopClasses != null && this.stopClasses.contains(superClass.getName()))) {
                this.loadPortDescByIntrospectionRecursive(superClass);
            }
        }
    }

    public synchronized void loadPortDescByIntrospection(Class cls, TypeMapping tm) {
        this.implClass = cls;
        this.tm = tm;
        this.loadPortDescByIntrospection();
    }

    private synchronized void getSyncedOperationsForName(Class implClass, String methodName) {
        ArrayList currentOverloads;
        if (implClass == null) {
            return;
        }
        if (this.completedNames == null || this.completedNames.contains(methodName)) {
            return;
        }
        if (this.allowedMethods != null && !this.allowedMethods.contains(methodName)) {
            return;
        }
        if (this.disallowedMethods != null && this.disallowedMethods.contains(methodName)) {
            return;
        }
        if (this.name2OperationsMap != null && (currentOverloads = (ArrayList)this.name2OperationsMap.get(methodName)) != null) {
            Iterator i = currentOverloads.iterator();
            while (i.hasNext()) {
                OperationDesc oper = (OperationDesc)i.next();
                if (oper.getMethod() != null) continue;
                this.syncOperationToClass(oper, implClass);
            }
        }
        if (this.introspectionMode) {
            this.createOperationsForName(implClass, methodName);
        }
        this.completedNames.add(methodName);
    }

    private synchronized void createOperationsForName(Class implClass, String methodName) {
        if (!this.introspectionMode) {
            return;
        }
        Method[] methods = this.priviledgedGetDeclaredMethods(implClass);
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!Modifier.isPublic(method.getModifiers()) || !method.getName().equals(methodName)) continue;
            this.createOperationForMethod(method);
        }
        Class superClass = implClass.getSuperclass();
        if (superClass != null && !superClass.getName().startsWith("java.") && !superClass.getName().startsWith("javax.")) {
            this.createOperationsForName(superClass, methodName);
        }
    }

    private synchronized void createOperationForMethod(Method method) {
        ArrayList overloads;
        if (!this.introspectionMode) {
            return;
        }
        if (this.method2OperationMap.get(method) != null) {
            return;
        }
        Class<?>[] paramTypes = method.getParameterTypes();
        ArrayList arrayList = overloads = this.name2OperationsMap == null ? null : (ArrayList)this.name2OperationsMap.get(method.getName());
        if (overloads != null && !overloads.isEmpty()) {
            for (int i = 0; i < overloads.size(); ++i) {
                int j;
                Class<?>[] others;
                OperationDesc op = (OperationDesc)overloads.get(i);
                Method checkMethod = op.getMethod();
                if (checkMethod == null || paramTypes.length != (others = checkMethod.getParameterTypes()).length) continue;
                for (j = 0; j < others.length && others[j].equals(paramTypes[j]); ++j) {
                }
                if (j != others.length) continue;
                return;
            }
        }
        OperationDesc operation = new OperationDesc();
        operation.setName(method.getName());
        String defaultNS = "";
        if (!this.namespaceMappings.isEmpty()) {
            defaultNS = (String)this.namespaceMappings.get(0);
        }
        operation.setElementQName(QNameTable.createQName(defaultNS, method.getName()));
        operation.setMethod(method);
        Class<?> retClass = method.getReturnType();
        operation.setReturnClass(retClass);
        operation.setReturnType(this.tm.getTypeQName(method.getReturnType()));
        String[] paramNames = this.getParamNames(method);
        for (int k = 0; k < paramTypes.length; ++k) {
            Class<?> type = paramTypes[k];
            ParameterDesc paramDesc = new ParameterDesc();
            if (paramNames != null && paramNames[k] != null && paramNames[k].length() > 0) {
                paramDesc.setName(paramNames[k]);
            } else {
                paramDesc.setName("in" + k);
            }
            Class heldClass = JavaUtils.getHolderValueType(type);
            if (heldClass != null) {
                paramDesc.setMode((byte)3);
                paramDesc.setTypeQName(this.tm.getTypeQName(heldClass));
            } else {
                paramDesc.setMode((byte)1);
                paramDesc.setTypeQName(this.tm.getTypeQName(type));
            }
            paramDesc.setJavaType(type);
            operation.addParameter(paramDesc);
        }
        this.addOperationDesc(operation, false);
        this.method2OperationMap.put(method, operation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getParamNames(Method method) {
        HashMap hashMap = this.method2ParamsMap;
        synchronized (hashMap) {
            String[] paramNames = (String[])this.method2ParamsMap.get(method);
            if (paramNames != null) {
                return paramNames;
            }
            paramNames = ParamNameExtractor.getParameterNamesFromDebugInfo(method);
            this.method2ParamsMap.put(method, paramNames);
            return paramNames;
        }
    }

    public void setNamespaceMappings(List namespaces) {
        this.namespaceMappings = namespaces == null ? new ArrayList() : namespaces;
    }

    public List getNamespaceMappings() {
        return this.namespaceMappings;
    }

    public String getDefaultNamespace() {
        if (this.namespaceMappings.isEmpty()) {
            return null;
        }
        return (String)this.namespaceMappings.get(0);
    }

    public void setDefaultNamespace(String namespace) {
        this.namespaceMappings.add(0, namespace);
    }

    public void setProperty(String name, Object value) {
        this.setOption(name, value);
    }

    public Object getProperty(String name) {
        return this.getOption(name);
    }

    public String getEndpointURL() {
        return this.endpointURL;
    }

    public void setEndpointURL(String endpointURL) {
        this.endpointURL = endpointURL;
    }

    public TypeMappingRegistry getTypeMappingRegistry() {
        if (this.tmr == null) {
            this.tmr = new TypeMappingRegistryImpl();
        }
        return this.tmr;
    }

    public void setTypeMappingRegistry(TypeMappingRegistry tmr) {
        this.tmr = tmr;
    }

    public QName getWSDLPort() {
        return this.wsdlPort;
    }

    public void setWSDLPort(QName qname) {
        this.wsdlPort = qname;
    }

    public Set getPortOperationHeaders() {
        return this.portOperationHeaders;
    }

    public void setPortOperationHeaders(Set pOH) {
        this.portOperationHeaders = pOH;
    }

    public QName getServiceQName() {
        if (this.operations.size() > 0) {
            OperationDesc operation = (OperationDesc)this.operations.get(0);
            return (QName)operation.getOption(OperationDesc.SERVICE_QNAME);
        }
        return null;
    }

    public String toString() {
        return this.toString("");
    }

    protected String toString(String indent) {
        String text = "";
        text = text + indent + "name:            " + this.getName() + "\n";
        text = text + indent + "implClass:       " + this.getImplClass() + "\n";
        if (this.getImplClass() != null) {
            text = text + indent + "implClassLoader: " + this.getImplClass().getClassLoader() + "\n";
        }
        text = text + indent + "defaultNS:       " + this.getDefaultNamespace() + "\n";
        text = text + indent + "endpointURL:     " + this.getEndpointURL() + "\n";
        if (this.operations != null) {
            for (int i = 0; i < this.operations.size(); ++i) {
                text = text + indent + " OperationDesc[" + i + "]:\n";
                text = text + indent + ((OperationDesc)this.operations.get(i)).toString("  ") + "\n";
            }
        }
        return text;
    }

    private static ClassLoader getClassLoader(final Class cls) {
        ClassLoader cl;
        block2: {
            cl = null;
            try {
                cl = (ClassLoader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws ClassNotFoundException {
                        return cls.getClassLoader();
                    }
                });
            }
            catch (PrivilegedActionException e) {
                if (!log.isDebugEnabled()) break block2;
                log.debug("Exception thrown from AccessController: " + e.getMessage());
            }
        }
        return cl;
    }
}

