/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.deployment.wsdd;

import com.ibm.ws.webservices.engine.ConfigurationException;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDConstants;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDDeployment;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDElement;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDException;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDTypeMapping;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDTypeMappingContainer;
import com.ibm.ws.webservices.engine.encoding.SerializationContext;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.xml.sax.helpers.AttributesImpl;

public class WSDDUndeployment
extends WSDDElement
implements WSDDTypeMappingContainer {
    private Vector services = new Vector();
    private Vector transports = new Vector();
    private Vector typeMappings = new Vector();

    public void addTransport(QName transport) {
        this.transports.add(transport);
    }

    public void addService(QName service) {
        this.services.add(service);
    }

    public void deployTypeMapping(WSDDTypeMapping typeMapping) throws WSDDException {
        this.typeMappings.add(typeMapping);
    }

    public WSDDUndeployment() {
    }

    private QName getQName(Element el) throws WSDDException {
        String attr = el.getAttribute("name");
        if (attr == null || "".equals(attr)) {
            throw new WSDDException(Messages.getMessage("badNameAttr00"));
        }
        return QNameTable.createQName("", attr);
    }

    public WSDDUndeployment(Element e) throws WSDDException {
        super(e);
        int i;
        Element[] elements = this.getChildElements(e, "transport");
        for (i = 0; i < elements.length; ++i) {
            this.addTransport(this.getQName(elements[i]));
        }
        elements = this.getChildElements(e, "port");
        for (i = 0; i < elements.length; ++i) {
            this.addService(this.getQName(elements[i]));
        }
    }

    protected QName getElementName() {
        return QNAME_UNDEPLOY;
    }

    public void undeployFromRegistry(WSDDDeployment registry) throws ConfigurationException {
        QName qname;
        int n;
        for (n = 0; n < this.transports.size(); ++n) {
            qname = (QName)this.transports.get(n);
            registry.undeployTransport(qname);
        }
        for (n = 0; n < this.services.size(); ++n) {
            qname = (QName)this.services.get(n);
            registry.undeployPort(qname);
        }
    }

    private void writeElement(SerializationContext context, QName elementQName, QName qname) throws IOException {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("", "name", "name", "CDATA", context.getSerializationWriter().qName2String(qname));
        context.getSerializationWriter().simpleElement(elementQName, attrs, null);
    }

    public void writeToContext(SerializationContext context) throws IOException {
        QName qname;
        context.getSerializationWriter().addMapping("", "http://websphere.ibm.com/webservices/wsdd/");
        context.getSerializationWriter().startElement(WSDDConstants.QNAME_UNDEPLOY, null);
        Iterator i = this.services.iterator();
        while (i.hasNext()) {
            qname = (QName)i.next();
            this.writeElement(context, QNAME_PORT, qname);
        }
        i = this.transports.iterator();
        while (i.hasNext()) {
            qname = (QName)i.next();
            this.writeElement(context, QNAME_TRANSPORT, qname);
        }
        i = this.typeMappings.iterator();
        while (i.hasNext()) {
            WSDDTypeMapping mapping = (WSDDTypeMapping)i.next();
            mapping.writeToContext(context);
        }
        context.getSerializationWriter().endElement();
    }

    public WSDDTypeMapping[] getTypeMappings() {
        WSDDTypeMapping[] t = new WSDDTypeMapping[this.typeMappings.size()];
        this.typeMappings.toArray(t);
        return t;
    }
}

