/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.deployment.wsdd;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.ConfigurationException;
import com.ibm.ws.webservices.engine.EngineConfiguration;
import com.ibm.ws.webservices.engine.Handler;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDChain;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDDeployableItem;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDException;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDJAXRPCHandlerInfo;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDJAXRPCHandlerInfoChain;
import com.ibm.ws.webservices.engine.encoding.SerializationContext;
import com.ibm.ws.webservices.engine.handlers.jaxrpc.HandlerChain;
import com.ibm.ws.webservices.engine.handlers.jaxrpc.JAXRPCHandler;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.ClassUtils;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import java.io.IOException;
import java.util.Collection;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;

public abstract class WSDDTargetedChain
extends WSDDDeployableItem {
    private WSDDChain requestFlow;
    private WSDDChain responseFlow;
    private QName pivotQName;
    private WSDDJAXRPCHandlerInfoChain jaxrpcChain;
    private JAXRPCHandler.ActorHeaderBindings actorsHeadersBindings;
    public static final int MODE_CS_CLIENT = 1;
    public static final int MODE_CS_SERVER = 2;
    private int _modeClientServer = 0;
    protected Handler _cachedPort = null;

    protected WSDDTargetedChain(int modeClientServer) {
        this._modeClientServer = modeClientServer;
    }

    protected WSDDTargetedChain(int modeClientServer, Element e) throws WSDDException {
        super(e);
        String pivotStr;
        Element respEl;
        this._modeClientServer = modeClientServer;
        Element reqEl = this.getChildElement(e, "requestFlow");
        if (reqEl != null && reqEl.getElementsByTagName("*").getLength() > 0) {
            this.setRequestFlow(new WSDDChain(modeClientServer == 1, reqEl));
        }
        if ((respEl = this.getChildElement(e, "responseFlow")) != null && respEl.getElementsByTagName("*").getLength() > 0) {
            this.setResponseFlow(new WSDDChain(modeClientServer == 1, respEl));
        }
        if ((pivotStr = e.getAttribute("pivot")) != null && !pivotStr.equals("")) {
            this.pivotQName = XMLUtils.getQNameFromString(pivotStr, e);
        }
    }

    protected WSDDChain getRequestFlow() {
        return this.requestFlow;
    }

    public void setRequestFlow(WSDDChain reqFlow) {
        if (this.requestFlow != null && this.releaseLifeCycleManagementOf(this.requestFlow) && this.requestFlow.isActive()) {
            this.requestFlow.destroy();
        }
        this.requestFlow = reqFlow;
        this._cachedPort = null;
        if (this.requestFlow != null) {
            this.manageLifeCycleOf(this.requestFlow);
        }
    }

    protected WSDDChain getResponseFlow() {
        return this.responseFlow;
    }

    public void setResponseFlow(WSDDChain respFlow) {
        if (this.responseFlow != null && this.releaseLifeCycleManagementOf(this.responseFlow) && this.responseFlow.isActive()) {
            this.responseFlow.destroy();
        }
        this.responseFlow = respFlow;
        this._cachedPort = null;
        if (this.responseFlow != null) {
            this.manageLifeCycleOf(this.responseFlow);
        }
    }

    public HandlerChain getHandlerChain() {
        return this.jaxrpcChain != null ? this.jaxrpcChain.getHandlerChain() : null;
    }

    public WSDDJAXRPCHandlerInfoChain getHandlerInfoChain() {
        return this.jaxrpcChain;
    }

    public void setHandlerInfoChain(WSDDJAXRPCHandlerInfoChain flow) {
        if (this.jaxrpcChain != null && this.releaseLifeCycleManagementOf(this.jaxrpcChain) && this.jaxrpcChain.isActive()) {
            this.jaxrpcChain.destroy();
        }
        this.jaxrpcChain = flow;
        this._cachedPort = null;
        if (this.jaxrpcChain != null) {
            this.manageLifeCycleOf(this.jaxrpcChain);
        }
    }

    public void addHandlerInfo(WSDDJAXRPCHandlerInfo hi) {
        if (this.jaxrpcChain == null) {
            this.jaxrpcChain = new WSDDJAXRPCHandlerInfoChain(this._modeClientServer == 1);
        }
        this.jaxrpcChain.addHandlerInfo(hi);
        this._cachedPort = null;
    }

    public void addHandlerInfo(WSDDJAXRPCHandlerInfoChain hichain) {
        if (this.jaxrpcChain == null) {
            this.jaxrpcChain = new WSDDJAXRPCHandlerInfoChain(this._modeClientServer == 1);
        }
        this.jaxrpcChain.addHandlerInfoList(hichain.getHandlerInfoList());
        this.jaxrpcChain.addGlobalHeaders(hichain.getGlobalHeaders());
        this._cachedPort = null;
    }

    public void addRoles(Collection roles) {
        if (roles != null) {
            if (this.jaxrpcChain == null) {
                this.jaxrpcChain = new WSDDJAXRPCHandlerInfoChain(this._modeClientServer == 1);
            }
            this.jaxrpcChain.addRoles(roles);
        }
    }

    public QName getPivotQName() {
        return this.pivotQName;
    }

    public void setPivotQName(QName pivotQName) {
        this.pivotQName = pivotQName;
        this._cachedPort = null;
    }

    public int getModeClientServer() {
        return this._modeClientServer;
    }

    public JAXRPCHandler.ActorHeaderBindings getActorHeaderBinding() {
        return this.actorsHeadersBindings;
    }

    public void addActorHeaderBinding(String actor, Collection headers) {
        if (this.actorsHeadersBindings == null) {
            this.actorsHeadersBindings = new JAXRPCHandler.ActorHeaderBindings();
        }
        this.actorsHeadersBindings.addBinding(actor, headers);
    }

    public void addActorHeaderBinding(String actor, QName header) {
        if (this.actorsHeadersBindings == null) {
            this.actorsHeadersBindings = new JAXRPCHandler.ActorHeaderBindings();
        }
        this.actorsHeadersBindings.addBinding(actor, header);
    }

    protected Handler makeNewInstance(EngineConfiguration registry) throws ConfigurationException {
        if (this._cachedPort == null) {
            Handler reqHandler = null;
            WSDDChain req = this.getRequestFlow();
            if (req != null) {
                reqHandler = req.getInstance(registry);
            }
            Handler pivot = null;
            if (this.pivotQName != null) {
                if ("http://websphere.ibm.com/webservices/wsdd/dispatchers/java".equals(this.pivotQName.getNamespaceURI())) {
                    try {
                        pivot = (Handler)ClassUtils.forName(this.pivotQName.getLocalPart()).newInstance();
                    }
                    catch (InstantiationException e) {
                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.deployment.wsdd.WSDDTargetedChain.makeNewInstance", "199", this);
                        throw WSDDException.makeWSDDException(e);
                    }
                    catch (IllegalAccessException e) {
                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.deployment.wsdd.WSDDTargetedChain.makeNewInstance", "202", this);
                        throw WSDDException.makeWSDDException(e);
                    }
                    catch (ClassNotFoundException e) {
                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.deployment.wsdd.WSDDTargetedChain.makeNewInstance", "205", this);
                        throw WSDDException.makeWSDDException(e);
                    }
                } else {
                    throw new WSDDException(Messages.getMessage("badTypeNamespace00", this.pivotQName.getNamespaceURI(), "http://websphere.ibm.com/webservices/wsdd/dispatchers/java"));
                }
            }
            Handler respHandler = null;
            WSDDChain resp = this.getResponseFlow();
            if (resp != null) {
                respHandler = resp.getInstance(registry);
            }
            this._cachedPort = JAXRPCHandler.factory(reqHandler, pivot, respHandler, this.getHandlerChain(), this.getActorHeaderBinding(), this.getModeClientServer());
        }
        return this._cachedPort;
    }

    public final void writeFlowsToContext(SerializationContext context) throws IOException {
        if (this.requestFlow != null) {
            this.requestFlow.writeToContext(context);
        }
        if (this.responseFlow != null) {
            this.responseFlow.writeToContext(context);
        }
    }
}

