/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.deployment.wsdd;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDConstants;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDElement;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDException;
import com.ibm.ws.webservices.engine.encoding.SerializationContext;
import com.ibm.ws.webservices.engine.handlers.jaxrpc.ExtendedHandlerInfo;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.ClassUtils;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import com.ibm.wsspi.webservices.rpc.handler.HandlerClassFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.Handler;
import org.apache.commons.logging.Log;
import org.w3c.dom.Element;
import org.xml.sax.helpers.AttributesImpl;

public class WSDDJAXRPCHandlerInfo
extends WSDDElement
implements Comparable {
    private static Log log = LogFactory.getLog(WSDDJAXRPCHandlerInfo.class.getName());
    public static final int INTERNAL_MIN_PRIORITY = Integer.MAX_VALUE;
    public static final int DEFAULT_PRIORITY = 50000000;
    public static final int PRIORITY_NOTSET = -1;
    private ClassLoader _classLoader;
    private int _priority = 50000000;
    private boolean _loadClassAttempted = false;
    private ExtendedHandlerInfo _handlerInfo;
    private String _name;
    private int _minPoolSize = 5;
    private int _maxPoolSize = 25;
    private boolean _faultLocal = false;
    private boolean _autoResponse = true;
    private String _classname;
    private Map _map;
    private QName[] _headers;
    private QName[] _protectedHeaders;

    public WSDDJAXRPCHandlerInfo() {
    }

    public WSDDJAXRPCHandlerInfo(Element e) throws WSDDException {
        super(e);
        String classnameStr = e.getAttribute("classname");
        if (classnameStr == null || classnameStr.equals("")) {
            throw new WSDDException(Messages.getMessage("noClassNameAttr00"));
        }
        this._classname = classnameStr;
        Element[] elements = this.getChildElements(e, "parameter");
        if (elements.length != 0) {
            this._map = new HashMap();
            for (int i = 0; i < elements.length; ++i) {
                Element param = elements[i];
                String pname = param.getAttribute("name");
                String value = param.getAttribute("value");
                this._map.put(pname, value);
            }
        }
        if ((elements = this.getChildElements(e, "header")).length != 0) {
            ArrayList<QName> headerList = new ArrayList<QName>();
            for (int i = 0; i < elements.length; ++i) {
                Element qElem = elements[i];
                String headerStr = qElem.getAttribute("qname");
                if (headerStr == null || headerStr.equals("")) {
                    throw new WSDDException(Messages.getMessage("noValidHeader"));
                }
                QName headerQName = XMLUtils.getQNameFromString(headerStr, qElem);
                if (headerQName == null) continue;
                headerList.add(headerQName);
            }
            QName[] headers = new QName[headerList.size()];
            this._headers = headerList.toArray(headers);
        }
    }

    protected QName getElementName() {
        return QNAME_JAXRPC_HANDLERINFO;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this._classLoader = classLoader;
        this.reset();
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public int getPriority() {
        return this._priority;
    }

    public void setPriority(int priority) {
        this._priority = priority;
    }

    public int getMinPoolSize() {
        return this._minPoolSize;
    }

    public void setMinPoolSize(int minPoolSize) {
        this._minPoolSize = minPoolSize;
    }

    public int getMaxPoolSize() {
        return this._maxPoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this._maxPoolSize = maxPoolSize;
    }

    public boolean getFaultLocal() {
        return this._faultLocal;
    }

    public void setFaultLocal(boolean faultLocal) {
        this._faultLocal = faultLocal;
    }

    public boolean getAutoResponse() {
        return this._autoResponse;
    }

    public void setAutoResponse(boolean autoResponse) {
        this._autoResponse = autoResponse;
    }

    public String getHandlerClassName() {
        return this._classname;
    }

    public void setHandlerClassName(String classname) {
        this._classname = classname;
        this.reset();
    }

    public Map getHandlerMap() {
        return this._map;
    }

    public void setHandlerMap(Map map) {
        this._map = map;
        this.reset();
    }

    public void putHandlerMap(String key, String value) {
        if (this._map == null) {
            this._map = new HashMap();
        }
        this._map.put(key, value);
    }

    public QName[] getHeaders() {
        return this._headers;
    }

    public void setHeaders(QName[] headers) {
        this._headers = headers;
        this.reset();
    }

    public QName[] getProtectedHeaders() {
        return this._protectedHeaders;
    }

    public void setProtectedHeaders(QName[] headers) {
        this._protectedHeaders = headers;
    }

    private void reset() {
        this._handlerInfo = null;
        this._loadClassAttempted = false;
    }

    public ExtendedHandlerInfo getHandlerInfo() throws ClassNotFoundException {
        if (this._handlerInfo == null && !this._loadClassAttempted) {
            Class handlerClass = this.getJavaClass();
            if (handlerClass != null) {
                this._handlerInfo = new ExtendedHandlerInfo(handlerClass, this.getHandlerMap(), this.getHeaders());
                this._handlerInfo.setName(this.getName());
                this._handlerInfo.setFaultLocal(this.getFaultLocal());
                this._handlerInfo.setAutoResponse(this.getAutoResponse());
                this._handlerInfo.setMinPoolSize(this.getMinPoolSize());
                this._handlerInfo.setMaxPoolSize(this.getMaxPoolSize());
            }
            this._loadClassAttempted = true;
        }
        return this._handlerInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class getJavaClass() throws ClassNotFoundException {
        Class javaClass = null;
        if (!this._loadClassAttempted) {
            try {
                javaClass = this._classLoader == null ? ClassUtils.forName(this.getHandlerClassName()) : ClassUtils.forName(this.getHandlerClassName(), true, this._classLoader);
                if (HandlerClassFactory.class.isAssignableFrom(javaClass)) {
                    try {
                        HandlerClassFactory factory = (HandlerClassFactory)javaClass.newInstance();
                        Class newClass = factory.getHandlerClass();
                        if (log.isDebugEnabled() && newClass != javaClass) {
                            if (newClass == null) {
                                log.debug("Factory returned null class.");
                            } else {
                                log.debug("Factory returned alternate class '" + newClass.getName() + "'");
                            }
                        }
                        javaClass = newClass;
                    }
                    catch (IllegalAccessException e) {
                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.axis.ext.deployment.wsdd.WSDDHandler.getJavaClass", "74", this);
                        log.error(Messages.getMessage("exception00"), e);
                        javaClass = null;
                    }
                    catch (InstantiationException e) {
                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.axis.ext.deployment.wsdd.WSDDHandler.getJavaClass", "78", this);
                        log.error(Messages.getMessage("exception00"), e);
                        javaClass = null;
                    }
                }
                if (javaClass != null && !Handler.class.isAssignableFrom(javaClass)) {
                    log.error(Messages.getMessage("warning.handler.not.Handler", javaClass.getName(), this.getName(), Handler.class.getName(), HandlerClassFactory.class.getName()));
                    javaClass = null;
                }
                Object var5_6 = null;
                if (javaClass == null && log.isDebugEnabled()) {
                    log.debug("handler \"" + (this.getName() == null ? "<noname>" : this.getName()) + "\" unable to load \"" + (this.getHandlerClassName() == null ? "<notype>" : this.getHandlerClassName()) + "\"");
                }
                this._loadClassAttempted = true;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                if (javaClass == null && log.isDebugEnabled()) {
                    log.debug("handler \"" + (this.getName() == null ? "<noname>" : this.getName()) + "\" unable to load \"" + (this.getHandlerClassName() == null ? "<notype>" : this.getHandlerClassName()) + "\"");
                }
                this._loadClassAttempted = true;
                throw throwable;
            }
        }
        return javaClass;
    }

    public void writeToContext(SerializationContext context) throws IOException {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("", "name", "name", "CDATA", this._name);
        attrs.addAttribute("", "classname", "classname", "CDATA", this._classname);
        attrs.addAttribute("", "priority", "priority", "CDATA", String.valueOf(this._priority));
        attrs.addAttribute("", "minPool", "minPool", "CDATA", String.valueOf(this._minPoolSize));
        attrs.addAttribute("", "maxPool", "maxPool", "CDATA", String.valueOf(this._maxPoolSize));
        attrs.addAttribute("", "faultLocal", "faultLocal", "CDATA", String.valueOf(this._faultLocal));
        attrs.addAttribute("", "autoResponse", "autoResponse", "CDATA", String.valueOf(this._autoResponse));
        attrs.addAttribute("", "classLoader", "classLoader", "CDATA", JavaUtils.getObjectIdentity(this._classLoader));
        context.getSerializationWriter().startElement(WSDDConstants.QNAME_JAXRPC_HANDLERINFO, attrs);
        Map ht = this._map;
        if (ht != null && ht.size() > 0) {
            Set keys = ht.keySet();
            Iterator iter = keys.iterator();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                String value = (String)ht.get(name);
                attrs = new AttributesImpl();
                attrs.addAttribute("", "name", "name", "CDATA", name);
                attrs.addAttribute("", "value", "value", "CDATA", value);
                context.getSerializationWriter().startElement(WSDDConstants.QNAME_PARAM, attrs);
                context.getSerializationWriter().endElement();
            }
        } else {
            context.getSerializationWriter().simpleElement(WSDDConstants.QNAME_PARAM, null, null);
        }
        if (this._headers != null && this._headers.length > 0) {
            for (int i = 0; i < this._headers.length; ++i) {
                QName qname = this._headers[i];
                attrs = new AttributesImpl();
                attrs.addAttribute("", "qname", "qname", "CDATA", context.getSerializationWriter().qName2String(qname));
                context.getSerializationWriter().simpleElement(WSDDConstants.QNAME_JAXRPC_HEADER, attrs, null);
            }
        } else {
            context.getSerializationWriter().simpleElement(WSDDConstants.QNAME_JAXRPC_HEADER, null, null);
        }
        context.getSerializationWriter().endElement();
    }

    public int compareTo(Object obj) {
        return obj instanceof WSDDJAXRPCHandlerInfo ? this.getPriority() - ((WSDDJAXRPCHandlerInfo)obj).getPriority() : -1;
    }
}

