/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.deployment.wsdd;

import com.ibm.ws.webservices.engine.ConfigurationException;
import com.ibm.ws.webservices.engine.EngineConfiguration;
import com.ibm.ws.webservices.engine.Handler;
import com.ibm.ws.webservices.engine.SimpleChain;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDConstants;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDException;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDHandler;
import com.ibm.ws.webservices.engine.encoding.SerializationContext;
import com.ibm.ws.webservices.engine.resources.Messages;
import java.io.IOException;
import java.util.Collections;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.xml.sax.helpers.AttributesImpl;

public class WSDDChain
extends WSDDHandler {
    private final boolean _reverse;
    private boolean _dirty = false;
    private Vector _handlers = new Vector();

    public WSDDChain(boolean reverse) {
        this._reverse = reverse;
    }

    public WSDDChain(boolean reverse, Element e) throws WSDDException {
        super(e);
        int i;
        this._reverse = reverse;
        if (this.getType() != null) {
            return;
        }
        Element[] elements = this.getChildElements(e, "handler");
        if (elements.length != 0) {
            for (i = 0; i < elements.length; ++i) {
                this.addHandler(new WSDDHandler(elements[i]));
            }
        }
        if ((elements = this.getChildElements(e, "chain")).length != 0) {
            for (i = 0; i < elements.length; ++i) {
                this.addHandler(new WSDDChain(reverse, elements[i]));
            }
        }
        if (this._handlers.isEmpty()) {
            throw new WSDDException(Messages.getMessage("noHandlersInChain00", this.getElementName().getLocalPart(), this.getQName() != null ? this.getQName().toString() : "null"));
        }
    }

    protected QName getElementName() {
        return WSDDConstants.QNAME_CHAIN;
    }

    public void addHandler(WSDDHandler handler) {
        this._handlers.add(handler);
        this._dirty = true;
        this.manageLifeCycleOf(handler);
    }

    public Vector getHandlers() {
        if (this._dirty) {
            this.sort();
        }
        return this._handlers;
    }

    public void removeHandler(WSDDHandler victim) {
        if (this._handlers.remove(victim)) {
            this._dirty = true;
            if (this.releaseLifeCycleManagementOf(victim) && victim.isActive()) {
                victim.destroy();
            }
        }
    }

    private void sort() {
        if (this._handlers != null) {
            if (this._reverse) {
                Collections.sort(this._handlers, Collections.reverseOrder());
                int max = this._handlers.size() - 1;
                for (int i = 0; i <= max; ++i) {
                    WSDDHandler handler = (WSDDHandler)this._handlers.get(i);
                    handler.setParameter("com.ibm.websphere.webservices.handler.position", String.valueOf(max - i));
                }
            } else {
                Collections.sort(this._handlers);
                for (int i = 0; i < this._handlers.size(); ++i) {
                    WSDDHandler handler = (WSDDHandler)this._handlers.get(i);
                    handler.setParameter("com.ibm.websphere.webservices.handler.position", String.valueOf(i));
                }
            }
            this._dirty = false;
        }
    }

    protected Handler makeNewHandler(EngineConfiguration registry) throws ConfigurationException {
        SimpleChain c = new SimpleChain();
        if (this._dirty) {
            this.sort();
        }
        for (int n = 0; n < this._handlers.size(); ++n) {
            WSDDHandler handler = (WSDDHandler)this._handlers.get(n);
            Handler h = handler.getInstance(registry);
            if (h == null) {
                throw new WSDDException("Can't find handler name:'" + handler.getQName() + "' type:'" + handler.getType() + "' in the registry");
            }
            c.addHandler(h);
        }
        return c;
    }

    public void writeToContext(SerializationContext context) throws IOException {
        AttributesImpl attrs = new AttributesImpl();
        QName name = this.getQName();
        if (name != null) {
            attrs.addAttribute("", "name", "name", "CDATA", context.getSerializationWriter().qName2String(name));
        }
        if (this.getType() != null) {
            attrs.addAttribute("", "type", "type", "CDATA", context.getSerializationWriter().qName2String(this.getType()));
        }
        context.getSerializationWriter().startElement(this.getElementName(), attrs);
        if (this._dirty) {
            this.sort();
        }
        for (int n = 0; n < this._handlers.size(); ++n) {
            WSDDHandler handler = (WSDDHandler)this._handlers.get(n);
            handler.writeToContext(context);
        }
        context.getSerializationWriter().endElement();
    }

    public void _destroy() {
        super._destroy();
        this._handlers.clear();
    }
}

