/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.configuration;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.ConfigurationException;
import com.ibm.ws.webservices.engine.Handler;
import com.ibm.ws.webservices.engine.SimpleTargetedChain;
import com.ibm.ws.webservices.engine.WSDDEngineConfiguration;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.configuration.NullEngineConfigurationProvider;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDDeployment;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDDocument;
import com.ibm.ws.webservices.engine.encoding.TypeMappingRegistry;
import com.ibm.ws.webservices.engine.handlers.soap.SOAPPort;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.ClassUtils;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.w3c.dom.Document;

public class FileEngineConfigurationProvider
extends NullEngineConfigurationProvider
implements WSDDEngineConfiguration {
    protected static Log log = LogFactory.getLog(FileEngineConfigurationProvider.class.getName());
    public static final int MODE_CS_CLIENT = 1;
    public static final int MODE_CS_SERVER = 2;
    private String _filename;
    private File _configFile;
    private InputStream _inputStream = null;
    private WSDDDeployment _deployment = null;
    private boolean _searchClasspath = true;
    private boolean _readOnly = true;
    private final int _modeClientServer;

    protected FileEngineConfigurationProvider(int modeClientServer) {
        this._modeClientServer = modeClientServer;
    }

    public FileEngineConfigurationProvider(int modeClientServer, String filename) {
        this._modeClientServer = modeClientServer;
        this._filename = filename;
        this._configFile = new File(filename);
        this.check();
    }

    public FileEngineConfigurationProvider(int modeClientServer, String basepath, String filename) throws ConfigurationException {
        this._modeClientServer = modeClientServer;
        this._filename = filename;
        File dir = new File(basepath);
        if (!dir.isDirectory() || !dir.canRead()) {
            throw new ConfigurationException(Messages.getMessage("invalidConfigFilePath", basepath));
        }
        this._configFile = new File(basepath, this._filename);
        this.check();
    }

    private void check() {
        this._readOnly = this._configFile.canRead() & !this._configFile.canWrite();
        if (this._readOnly) {
            log.info(Messages.getMessage("readOnlyConfigFile"));
        }
    }

    public FileEngineConfigurationProvider(int modeClientServer, InputStream is) {
        this._modeClientServer = modeClientServer;
        this.setInputStream(is);
    }

    public void setSearchClasspath(boolean searchClasspath) {
        this.verifyInactive();
        this._searchClasspath = searchClasspath;
    }

    protected void setInputStream(InputStream is) {
        this.verifyInactive();
        this._inputStream = is;
    }

    protected InputStream getInputStream() throws ConfigurationException {
        if (this._inputStream == null) {
            this._inputStream = this.createInputStream();
        }
        if (this._inputStream == null) {
            throw new ConfigurationException(Messages.getMessage("noConfigFile"));
        }
        return this._inputStream;
    }

    public static boolean canGetInputStream(String fileName) {
        File file = new File(fileName);
        if (file.canRead()) {
            return true;
        }
        return ClassUtils.getResource(FileEngineConfigurationProvider.class, fileName) != null;
    }

    protected InputStream createInputStream() {
        block3: {
            if (this._configFile != null) {
                try {
                    return new FileInputStream(this._configFile);
                }
                catch (Exception e) {
                    if (!this._searchClasspath || this.getClass() == null) break block3;
                    return ClassUtils.getResourceAsStream(this.getClass(), this._filename);
                }
            }
        }
        return null;
    }

    private WSDDDeployment getDeployment() throws ConfigurationException {
        if (this._deployment == null) {
            try {
                InputStream is = this.getInputStream();
                this.setInputStream(null);
                WSDDDocument doc = new WSDDDocument(this._modeClientServer, XMLUtils.newDocument(is));
                this._deployment = doc.getDeployment();
                this._deployment.setContainerManaged(this.isContainerManaged());
                is.close();
                this.manageLifeCycleOf(this._deployment);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.configuration.FileEngineConfigurationProvider.configureEngine", "220", this);
                throw ConfigurationException.makeConfigurationException(e);
            }
        }
        return this._deployment;
    }

    public Document getDocument() throws ConfigurationException {
        return this.getDeployment().getDocument();
    }

    public SOAPPort getPort(QName qname) throws ConfigurationException {
        return this.getDeployment().getPort(qname);
    }

    public SOAPPort getPortByNamespaceURI(String namespace) throws ConfigurationException {
        return this.getDeployment().getPortByNamespaceURI(namespace);
    }

    public Handler getTransport(QName qname) throws ConfigurationException {
        return this.getDeployment().getTransport(qname);
    }

    public TypeMappingRegistry getTypeMappingRegistry() throws ConfigurationException {
        return this.getDeployment().getTypeMappingRegistry();
    }

    public SimpleTargetedChain getGlobalHandler() throws ConfigurationException {
        return this.getDeployment().getGlobalHandler();
    }

    public Map getGlobalOptions() throws ConfigurationException {
        return this.getDeployment().getGlobalOptions();
    }

    public Iterator getDeployedPorts() throws ConfigurationException {
        return this.getDeployment().getDeployedPorts();
    }
}

