/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.configuration;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.engine.EngineConfigurationFactory;
import com.ibm.ws.webservices.engine.WebServicesProperties;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.PrivilegedAction;
import org.apache.commons.discovery.ResourceClassIterator;
import org.apache.commons.discovery.tools.ClassUtils;
import org.apache.commons.logging.Log;

public class EngineConfigurationFactoryFinder {
    protected static Log log = LogFactory.getLog(EngineConfigurationFactoryFinder.class.getName());
    private static final Class mySpi = EngineConfigurationFactory.class;
    private static final Class myFactory = EngineConfigurationFactoryFinder.class;
    private static final Class[] newFactoryParamTypes = new Class[]{Object.class};
    private static final String requiredMethod = "public static EngineConfigurationFactory newFactory(Object)";

    private EngineConfigurationFactoryFinder() {
    }

    public static EngineConfigurationFactory newFactory(Object obj) {
        final Object[] params = new Object[]{obj};
        return (EngineConfigurationFactory)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ResourceClassIterator services = WebServicesProperties.getResourceClassIterator(mySpi);
                Object factory = null;
                while (factory == null && services.hasNext()) {
                    Class service = services.nextResourceClass().loadClass();
                    if (service == null) continue;
                    factory = EngineConfigurationFactoryFinder.newFactory(service, newFactoryParamTypes, params);
                }
                if (factory != null) {
                    if (log.isDebugEnabled()) {
                        log.debug(Messages.getMessage("engineFactory", factory.getClass().getName()));
                    }
                } else {
                    log.error(Messages.getMessage("engineConfigFactoryMissing"));
                }
                return factory;
            }
        });
    }

    public static EngineConfigurationFactory newFactory() {
        return EngineConfigurationFactoryFinder.newFactory(null);
    }

    private static EngineConfigurationFactory newFactory(Class service, Class[] paramTypes, Object[] param) {
        block9: {
            try {
                Method method = ClassUtils.findPublicStaticMethod(service, EngineConfigurationFactory.class, "newFactory", paramTypes);
                if (method == null) {
                    log.warn(Messages.getMessage("engineConfigMissingNewFactory", service.getName(), requiredMethod));
                    break block9;
                }
                try {
                    return (EngineConfigurationFactory)method.invoke(null, param);
                }
                catch (InvocationTargetException e) {
                    FFDCFilter.processException(e, "com.ibm.ws.webservices.engine.configuration.EngineConfigurationFactoryFinder.newFactory", "223");
                    if (e.getTargetException() instanceof NoClassDefFoundError) {
                        if (log.isDebugEnabled()) {
                            log.debug(Messages.getMessage("engineConfigLoadFactory", service.getName()));
                        }
                    } else {
                        log.warn(Messages.getMessage("engineConfigInvokeNewFactory", service.getName(), requiredMethod), e);
                    }
                }
                catch (Exception e) {
                    FFDCFilter.processException(e, "com.ibm.ws.webservices.engine.configuration.EngineConfigurationFactoryFinder.newFactory", "255");
                    log.warn(Messages.getMessage("engineConfigInvokeNewFactory", service.getName(), requiredMethod), e);
                }
            }
            catch (NoClassDefFoundError e) {
                FFDCFilter.processException(e, "com.ibm.ws.webservices.engine.configuration.EngineConfigurationFactoryFinder.newFactory", "262");
                if (!log.isDebugEnabled()) break block9;
                log.debug(Messages.getMessage("engineConfigLoadFactory", service.getName()));
            }
        }
        return null;
    }

    static {
        WebServicesProperties.setClassOverrideProperty(EngineConfigurationFactory.class, "webservices.EngineConfigFactory");
        WebServicesProperties.setClassDefaults(EngineConfigurationFactory.class, new String[]{"com.ibm.ws.webservices.engine.configuration.DefaultEngineConfigurationFactory"});
    }
}

