/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.configuration;

import com.ibm.ws.webservices.configuration.WebServicesEngineConfigurationGenerator;
import com.ibm.ws.webservices.engine.EngineConfiguration;
import com.ibm.ws.webservices.engine.EngineConfigurationFactory;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.configuration.BasicClientConfig;
import com.ibm.ws.webservices.engine.configuration.BasicServerConfig;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDDeployment;
import java.util.Map;
import org.apache.commons.logging.Log;

public class DefaultEngineConfigurationFactory
implements EngineConfigurationFactory {
    private static String DISABLE_101_GLOBAL_HANDLERS_OPTION = "disable101GlobalHandlers";
    protected static Log log = LogFactory.getLog(DefaultEngineConfigurationFactory.class.getName());
    private String useGlobalHandlersFor101Client = null;

    public static EngineConfigurationFactory newFactory(Object param) {
        if (param != null && !(param instanceof String)) {
            return null;
        }
        return new DefaultEngineConfigurationFactory((String)param);
    }

    protected DefaultEngineConfigurationFactory(String useGlobalHandlersFor101Client) {
        this.useGlobalHandlersFor101Client = useGlobalHandlersFor101Client;
    }

    public EngineConfiguration getClientEngineConfig() {
        EngineConfiguration returnEngineConfiguration = null;
        if (this.useGlobalHandlersFor101Client == null) {
            if (log.isDebugEnabled()) {
                log.debug("DefaultEngineConfigurationFactory.getClientEngineConfig(): handler usage == null - default to global handlers");
            }
            returnEngineConfiguration = this.defaultBasicClientConfiguration();
        } else if ("DEFAULT".equals(this.useGlobalHandlersFor101Client)) {
            if (log.isDebugEnabled()) {
                log.debug("DefaultEngineConfigurationFactory.getClientEngineConfig(): using GLOBALHANDLERS_DEFAULT for handlers");
            }
            returnEngineConfiguration = this.defaultBasicClientConfiguration();
        } else if ("SYSTEM_ENGINE".equals(this.useGlobalHandlersFor101Client)) {
            if (log.isDebugEnabled()) {
                log.debug("DefaultEngineConfigurationFactory.getClientEngineConfig(): using GLOBALHANDLERS_FROM_SYSTEM_ENGINE for handlers");
            }
            WSDDDeployment wsddDeployment = WebServicesEngineConfigurationGenerator.createClientDeployment((int)1, null);
            returnEngineConfiguration = new BasicClientConfig(wsddDeployment);
        } else if ("APPLICATION_ENGINE".equals(this.useGlobalHandlersFor101Client)) {
            if (log.isDebugEnabled()) {
                log.debug("DefaultEngineConfigurationFactory.getClientEngineConfig(): using GLOBALHANDLERS_FROM_APPLICATION_ENGINE for handlers");
            }
            WSDDDeployment wsddDeployment = WebServicesEngineConfigurationGenerator.createClientDeployment((int)0, null);
            returnEngineConfiguration = new BasicClientConfig(wsddDeployment);
        } else if ("NONE".equals(this.useGlobalHandlersFor101Client)) {
            if (log.isDebugEnabled()) {
                log.debug("DefaultEngineConfigurationFactory.getClientEngineConfig(): using GLOBALHANDLERS_NONE for handlers");
            }
            returnEngineConfiguration = new BasicClientConfig();
        } else {
            if (log.isDebugEnabled()) {
                log.debug("DefaultEngineConfigurationFactory.getClientEngineConfig(): using invalid setting for handlers; no handlers used: " + this.useGlobalHandlersFor101Client);
            }
            returnEngineConfiguration = new BasicClientConfig();
        }
        return returnEngineConfiguration;
    }

    private EngineConfiguration defaultBasicClientConfiguration() {
        String disableHandlersValue;
        BasicClientConfig defaultBasicClientConfiguration = null;
        WSDDDeployment wsddDeployment = WebServicesEngineConfigurationGenerator.createClientDeployment((int)0, null);
        Map globalOptionsMap = wsddDeployment.getGlobalOptions();
        boolean enableGlobalHandlers = true;
        if (globalOptionsMap != null && (disableHandlersValue = (String)globalOptionsMap.get(DISABLE_101_GLOBAL_HANDLERS_OPTION)) != null && disableHandlersValue.equalsIgnoreCase("true")) {
            enableGlobalHandlers = false;
        }
        defaultBasicClientConfiguration = enableGlobalHandlers ? new BasicClientConfig(wsddDeployment) : new BasicClientConfig();
        return defaultBasicClientConfiguration;
    }

    public EngineConfiguration getServerEngineConfig() {
        return new BasicServerConfig();
    }
}

