/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.client;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.protocol.Protocols;
import com.ibm.ws.webservices.engine.EngineConfiguration;
import com.ibm.ws.webservices.engine.WebServicesEngine;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.client.Call;
import com.ibm.ws.webservices.engine.client.ClientEngine;
import com.ibm.ws.webservices.engine.client.ClientEngineFactory;
import com.ibm.ws.webservices.engine.client.ClientProxy;
import com.ibm.ws.webservices.engine.client.Connection;
import com.ibm.ws.webservices.engine.client.Stub;
import com.ibm.ws.webservices.engine.client.Transport;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.configuration.EngineConfigurationFactoryFinder;
import com.ibm.ws.webservices.engine.configuration.SimpleEngineConfigurationProvider;
import com.ibm.ws.webservices.engine.handlers.jaxrpc.HandlerChain;
import com.ibm.ws.webservices.engine.handlers.soap.ClientSOAPPort;
import com.ibm.ws.webservices.engine.handlers.soap.SOAPHandlerChain;
import com.ibm.ws.webservices.engine.handlers.soap.SOAPPort;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.ClassUtils;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.engine.utils.WSDLUtils;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import com.ibm.ws.webservices.metadata.ClientModuleMetaData;
import com.ibm.ws.webservices.multiprotocol.AgnosticService;
import com.ibm.ws.webservices.multiprotocol.utils.WSDLFactoryImpl;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.Remote;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import java.util.WeakHashMap;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.encoding.TypeMappingRegistry;
import javax.xml.rpc.handler.HandlerRegistry;
import org.apache.commons.logging.Log;
import org.w3c.dom.Document;

public class Service
implements javax.xml.rpc.Service,
Serializable,
Referenceable {
    private WebServicesEngine engine;
    private QName serviceName = null;
    private String serviceRefName = null;
    private Map portTypeToPortMapping = null;
    private Map seiToPortTypeMapping = null;
    private Map overriddingEndpointURIs = null;
    private String wsdlLoadStrategyPath = null;
    private URL wsdlLocation = null;
    private String wsdlFileName = null;
    private Definition wsdlDefinition = null;
    private javax.wsdl.Service wsdlService = null;
    private boolean maintainSession = false;
    private HandlerRegistryImpl registry = new HandlerRegistryImpl();
    private Map namespace2packageMapping = null;
    private static Map cachedWSDL = new HashMap();
    private static boolean cachingWSDL = true;
    protected static Log log = LogFactory.getLog(Service.class.getName());
    private Map connectionMap = Collections.synchronizedMap(new WeakHashMap());

    Definition getWSDLDefinition() {
        return this.wsdlDefinition;
    }

    javax.wsdl.Service getWSDLService() {
        return this.wsdlService;
    }

    public Service() {
        if (log.isDebugEnabled()) {
            log.debug("Entry Service()  ");
        }
        this.initService();
        if (log.isDebugEnabled()) {
            log.debug("Exit Service()  ");
        }
    }

    public Service(QName serviceName) {
        if (log.isDebugEnabled()) {
            log.debug("Entry Service(QName)  " + serviceName.toString());
        }
        this.initService();
        this.serviceName = serviceName;
        if (log.isDebugEnabled()) {
            log.debug("Exit Service(QName)  ");
        }
    }

    public Service(EngineConfiguration config2) {
        if (log.isDebugEnabled()) {
            log.debug("Entry Service(EngineConfiguration)  ");
        }
        this.engine = ClientEngineFactory.getEngine(config2);
        if (log.isDebugEnabled()) {
            log.debug("Exit Service(EngineConfiguration)  ");
        }
    }

    public Service(URL wsdlLocation, QName serviceName) throws ServiceException {
        Definition def;
        if (log.isDebugEnabled()) {
            log.debug("Entry Service(URL, QName)  " + serviceName.toString());
        }
        this.serviceName = serviceName;
        this.wsdlLocation = wsdlLocation;
        Definition definition = def = cachingWSDL ? (Definition)cachedWSDL.get(wsdlLocation.toString()) : null;
        if (def == null) {
            Document doc = null;
            try {
                doc = XMLUtils.newDocument(wsdlLocation.toString());
            }
            catch (Exception exp) {
                FFDCFilter.processException((Throwable)exp, "com.ibm.ws.webservices.engine.client.Service.initService", "199", this);
                throw new ServiceException(Messages.getMessage("wsdlError00", "", "\n" + exp));
            }
            try {
                WSDLFactoryImpl factory = new WSDLFactoryImpl();
                WSDLReader reader = factory.newWSDLReader();
                reader.setFeature("javax.wsdl.verbose", false);
                def = reader.readWSDL(wsdlLocation.toString(), doc);
                if (cachingWSDL) {
                    cachedWSDL.put(wsdlLocation.toString(), def);
                }
            }
            catch (Exception exp) {
                FFDCFilter.processException((Throwable)exp, "com.ibm.ws.webservices.engine.client.Service.initService", "293", this);
                throw new ServiceException(Messages.getMessage("wsdlError00", "", "\n" + exp));
            }
        }
        this.initService(def);
        if (log.isDebugEnabled()) {
            log.debug("Exit Service(URL, QName)  ");
        }
    }

    public Service(ClientEngine engine2, Definition wsdlDefinition, QName serviceName, Map namespace2packageMapping) throws ServiceException {
        if (log.isDebugEnabled()) {
            log.debug("Entry Service(ClientEngine, Definition, QName, Map)  ");
        }
        this.engine = engine2;
        this.serviceName = serviceName;
        cachingWSDL = false;
        this.wsdlLocation = null;
        this.namespace2packageMapping = namespace2packageMapping;
        this.initService(wsdlDefinition);
        if (log.isDebugEnabled()) {
            log.debug("Exit Service(ClientEngine, Definition, QName, Map)  ");
        }
    }

    protected void initService() {
        try {
            this.initService(null);
        }
        catch (ServiceException se) {
            FFDCFilter.processException((Throwable)se, "com.ibm.ws.webservices.engine.client.Service.initService", "277", this);
        }
    }

    protected void initService(Definition def) throws ServiceException {
        if (log.isDebugEnabled()) {
            log.debug("Entry Service.initService(Definition)  ");
        }
        if (def != null) {
            try {
                this.wsdlDefinition = def;
                this.wsdlService = def.getService(this.serviceName);
                if (this.wsdlService == null) {
                    throw new ServiceException(Messages.getMessage("noService00", "" + this.serviceName));
                }
            }
            catch (Exception exp) {
                FFDCFilter.processException((Throwable)exp, "com.ibm.ws.webservices.engine.client.Service.initService", "310", this);
                throw new ServiceException(Messages.getMessage("wsdlError00", "", "\n" + exp));
            }
        }
        if (this.engine == null) {
            EngineConfiguration defaultConfig = EngineConfigurationFactoryFinder.newFactory(AgnosticService.getWhichGlobalHandlersToUseOffThread()).getClientEngineConfig();
            SimpleEngineConfigurationProvider config2 = new SimpleEngineConfigurationProvider(defaultConfig);
            Iterator qNames = this.getPorts();
            if (qNames != null) {
                while (qNames.hasNext()) {
                    QName portName = (QName)qNames.next();
                    ClientSOAPPort soapPort = new ClientSOAPPort(null, null);
                    soapPort.setName(portName.getLocalPart());
                    soapPort.getPortDesc().setWSDLPort(portName);
                    config2.deployPort(soapPort.getName(), (SOAPPort)soapPort);
                }
            }
            this.engine = new ClientEngine(config2);
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit Service.initService(Definition)  ");
        }
    }

    public Remote getPort(QName portName, Class proxyInterface) throws ServiceException {
        this.assertValidPortName_getPort(portName);
        this.assertValidProxyInterface_getPort(proxyInterface);
        if (this.wsdlService == null) {
            throw new ServiceException(Messages.getMessage("wsdlMissing00"));
        }
        Port port = this.wsdlService.getPort(portName.getLocalPart());
        if (port == null) {
            throw new ServiceException(Messages.getMessage("noPort00", "" + portName));
        }
        return this.getPort(null, portName, proxyInterface);
    }

    public Remote getPort(Class proxyInterface) throws ServiceException {
        this.assertValidProxyInterface_getPort(proxyInterface);
        if (this.wsdlService == null) {
            throw new ServiceException(Messages.getMessage("wsdlMissing00"));
        }
        return this.getPort(null, null, proxyInterface);
    }

    private Port findPortForSEI(Class sei) {
        if (sei != null) {
            QName explicitPortTypeQName = null;
            if (this.seiToPortTypeMapping != null) {
                explicitPortTypeQName = (QName)this.seiToPortTypeMapping.get(sei.getName());
                if (log.isDebugEnabled()) {
                    log.debug("findPortForSEI(sei): setToPortTypeMapping not null.  After looking in table explicitPortTypeQName = " + explicitPortTypeQName);
                }
            }
            Iterator ports = this.wsdlService.getPorts().values().iterator();
            while (ports.hasNext()) {
                Port port = (Port)ports.next();
                QName portTypeQName = port.getBinding().getPortType().getQName();
                if ((explicitPortTypeQName == null || !explicitPortTypeQName.equals(portTypeQName)) && !sei.getName().equals(this.guessAtClassName(portTypeQName))) continue;
                QName defaultPort = null;
                if (this.portTypeToPortMapping != null) {
                    defaultPort = (QName)this.portTypeToPortMapping.get(portTypeQName);
                    if (log.isDebugEnabled()) {
                        log.debug("findPortForSEI(sei): PortTypeToPortMapping not null, found default port = " + defaultPort);
                    }
                }
                if (defaultPort != null && (!port.getName().equals(defaultPort.getLocalPart()) || !this.wsdlService.getQName().getNamespaceURI().equals(defaultPort.getNamespaceURI()))) continue;
                return port;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("findPortForSEI(sei): *** WARNING *** No port found.  Returning null!");
        }
        return null;
    }

    protected boolean isSOAPPort(Port port) {
        boolean soapPort = false;
        Binding binding = port.getBinding();
        List ees = binding.getExtensibilityElements();
        if (ees != null && ees.size() > 0) {
            soapPort = ees.get(0) instanceof SOAPBinding;
        }
        return soapPort;
    }

    private String guessAtClassName(QName qName) {
        if (log.isDebugEnabled()) {
            log.debug("guessAtClassName(qName): for Qname localPart = " + qName.getLocalPart() + " and namespaceURI = " + qName.getNamespaceURI());
        }
        String pkg = null;
        String name = JavaUtils.xmlNameToJavaClass(qName.getLocalPart());
        if (log.isDebugEnabled()) {
            log.debug("guessAtClassName(qName): Class name from JavaUtils = " + name);
        }
        if (this.namespace2packageMapping != null) {
            pkg = (String)this.namespace2packageMapping.get(qName.getNamespaceURI());
            if (log.isDebugEnabled()) {
                log.debug("guessAtClassName(qName): Using namespace2packageMapping found package = " + pkg);
            }
        }
        if (pkg == null) {
            pkg = JavaUtils.makePackageName(qName.getNamespaceURI());
            if (log.isDebugEnabled()) {
                log.debug("guessAtClassName(qName): Package not found in ns2pkg mapping so JavaUtils.makePackageName returned = " + pkg);
            }
        }
        if (pkg != null && pkg != "") {
            return pkg + '.' + name;
        }
        return name;
    }

    public Remote getPort(String endpoint, Class proxyInterface) throws ServiceException {
        this.assertValidEndpoint_getPort(endpoint);
        this.assertValidProxyInterface_getPort(proxyInterface);
        return this.getPort(endpoint, null, proxyInterface);
    }

    private Remote getPort(String endpoint, QName portName, Class proxyInterface) throws ServiceException {
        Remote remote;
        Port port = null;
        port = portName == null ? this.findPortForSEI(proxyInterface) : this.wsdlService.getPort(portName.getLocalPart());
        if (log.isDebugEnabled()) {
            log.debug("getPort(endpoint, portName, proxyInterface): After looking up port = " + port);
        }
        if (endpoint == null && port != null) {
            if (this.getOverriddingEndpointURIs() != null) {
                endpoint = (String)this.getOverriddingEndpointURIs().get(port.getName());
                if (log.isDebugEnabled()) {
                    log.debug("getPort(endpoint, portName, proxyInterface): overriddingEndpoingURI " + endpoint + " for port " + port.getName());
                }
            }
            if (endpoint == null) {
                endpoint = WSDLUtils.getAddressFromPort(port);
                if (log.isDebugEnabled()) {
                    log.debug("getPort(endpoint, portName, proxyInterface): endpoint was null.  After getting it from WSDL endpoint = " + endpoint);
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("getPort(endpoint, portName, proxyInterface): Looking for Stub with endpoint = " + endpoint + " port = " + port + " proxyInterface = " + proxyInterface);
        }
        if ((remote = this.getGeneratedStub(endpoint, port, proxyInterface, true)) == null) {
            if (log.isDebugEnabled()) {
                log.debug("getPort(endpoint, portName, proxyInterface): No generated JAX-RPC naming style stub found.  Look for non-JAX-RPC stub");
            }
            remote = this.getGeneratedStub(endpoint, port, proxyInterface, false);
        }
        if (remote == null) {
            if (log.isDebugEnabled()) {
                log.debug("getPort(endpoint, portName, proxyInterface): No generated stubs found.  Try dynamic proxy.");
            }
            remote = this.getDynamicProxy(endpoint, port, proxyInterface);
        }
        return remote;
    }

    private Remote getGeneratedStub(String endpoint, Port port, Class proxyInterface, boolean JAXRPCNameMappingScheme) {
        try {
            if (port == null) {
                return null;
            }
            String pkg = proxyInterface.getName();
            pkg = pkg.substring(0, pkg.lastIndexOf(46));
            String binding = port.getBinding().getQName().getLocalPart();
            Class stubClass = JAXRPCNameMappingScheme ? ClassUtils.forName(pkg + "." + JavaUtils.xmlNameToJavaClass(binding) + "Stub") : ClassUtils.forName(pkg + "." + JavaUtils.createNonJAXRPCName(binding) + "Stub");
            if (log.isDebugEnabled()) {
                log.debug("getGeneratedStub(endpoint, port, proxyInterface, JAXRPCNameMappingScheme): Generated StubClass name = " + stubClass.getName());
            }
            if (proxyInterface.isAssignableFrom(stubClass)) {
                Class[] formalArgs = new Class[]{URL.class, javax.xml.rpc.Service.class};
                URL targetURL = null;
                targetURL = endpoint != null ? new URL(endpoint) : new URL(WSDLUtils.getAddressFromPort(port));
                Object[] actualArgs = new Object[]{targetURL, this};
                Constructor ctor = stubClass.getConstructor(formalArgs);
                Stub stub = (Stub)ctor.newInstance(actualArgs);
                stub.setPortName(ClientModuleMetaData.clientConfigurationPortName((String)this.getServiceRefName(), (String)port.getName()));
                return (Remote)((Object)stub);
            }
            if (log.isDebugEnabled()) {
                log.debug("getGeneratedStub(endpoint, port, proxyInterface, JAXRPCNameMappingScheme): *** WARNING *** Stub not assignable from Proxy");
            }
            return null;
        }
        catch (Throwable t) {
            if (log.isDebugEnabled()) {
                log.debug("com.ibm.ws.webservices.engine.client.Service.getGeneratedStub(endpoint, port, proxyInterface, JAXRPCNameMappingScheme): *** WARNING *** Caught exception.", t);
            }
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Remote getDynamicProxy(String endpoint, Port port, Class proxyInterface) throws ServiceException {
        try {
            Call call = null;
            if (port == null) {
                call = (Call)this.createCall();
                if (endpoint == null) throw new ServiceException(Messages.getMessage("noEndpoint"));
                call.setTargetEndpointAddress(new URL(endpoint));
            } else {
                call = (Call)this.createCall(QNameTable.createQName("", port.getName()));
            }
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            return (Remote)Proxy.newProxyInstance(classLoader, new Class[]{proxyInterface, javax.xml.rpc.Stub.class}, (InvocationHandler)new ClientProxy(call));
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.client.Service.getPort", "441", this);
            throw new ServiceException(e.toString());
        }
    }

    public javax.xml.rpc.Call createCall(QName portName) throws ServiceException {
        if (log.isDebugEnabled()) {
            log.debug("Entry Service.createCall(QName)  ");
        }
        this.assertValidPortName_createCall(portName);
        Call call = (Call)this.createCall();
        String clientPortName = ClientModuleMetaData.clientConfigurationPortName((String)this.getServiceRefName(), (String)portName.getLocalPart());
        call.setPortName(new QName(clientPortName));
        if (this.wsdlDefinition == null) {
            return call;
        }
        Port port = this.wsdlService.getPort(portName.getLocalPart());
        if (port == null) {
            throw new ServiceException(Messages.getMessage("noPort00", "" + portName));
        }
        Binding binding = port.getBinding();
        PortType portType = binding.getPortType();
        if (portType == null) {
            throw new ServiceException(Messages.getMessage("noPortType00", "" + portName));
        }
        List list = port.getExtensibilityElements();
        for (int i = 0; list != null && i < list.size(); ++i) {
            Object obj = list.get(i);
            if (!(obj instanceof SOAPAddress)) continue;
            try {
                SOAPAddress addr = (SOAPAddress)obj;
                URL url = new URL(addr.getLocationURI());
                call.setTargetEndpointAddress(url);
                continue;
            }
            catch (Exception exp) {
                FFDCFilter.processException((Throwable)exp, "com.ibm.ws.webservices.engine.client.Service.createCall", "485", this);
                throw new ServiceException(Messages.getMessage("cantSetURI00", "" + exp));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit Service.createCall(QName)  ");
        }
        return call;
    }

    public javax.xml.rpc.Call createCall(QName portName, String operationName, String inputMessageName) throws ServiceException {
        if (log.isDebugEnabled()) {
            log.debug("Entry Service.createCall(QName, String, String)  ");
        }
        this.assertValidOperationName_createCall(operationName);
        Call call = null;
        try {
            block6: {
                try {
                    call = (Call)this.createCall();
                    call.setOperation(portName, operationName, inputMessageName);
                    if (portName == null) break block6;
                    String clientPortName = ClientModuleMetaData.clientConfigurationPortName((String)this.getServiceRefName(), (String)portName.getLocalPart());
                    call.setPortName(QNameTable.createQName(null, clientPortName));
                }
                catch (ServiceException e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.client.Service.createCall", "916", this);
                    throw e;
                }
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            throw throwable;
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit Service.createCall(QName, String, String)  ");
        }
        return call;
    }

    public javax.xml.rpc.Call createCall(QName portName, String operationName) throws ServiceException {
        if (log.isDebugEnabled()) {
            log.debug("Entry Service.createCall(QName, String)  ");
        }
        this.assertValidPortName_createCall(portName);
        this.assertValidOperationName_createCall(operationName);
        Call call = (Call)this.createCall();
        call.setOperation(portName, operationName);
        if (log.isDebugEnabled()) {
            log.debug("Exit Service.createCall(QName, String)  ");
        }
        return call;
    }

    public javax.xml.rpc.Call createCall(QName portName, QName operationName) throws ServiceException {
        if (log.isDebugEnabled()) {
            log.debug("Entry Service.createCall(QName, QName)  ");
        }
        this.assertValidPortName_createCall(portName);
        this.assertValidOperationName_createCall(operationName);
        Call call = (Call)this.createCall();
        call.setOperation(portName, operationName.getLocalPart());
        if (log.isDebugEnabled()) {
            log.debug("Exit Service.createCall(QName, QName)  ");
        }
        return call;
    }

    public javax.xml.rpc.Call createCall() throws ServiceException {
        if (log.isDebugEnabled()) {
            log.debug("Entry Service.createCall()  ");
        }
        Call call = new Call(this);
        if (log.isDebugEnabled()) {
            log.debug("Exit Service.createCall()  ");
        }
        return call;
    }

    public javax.xml.rpc.Call[] getCalls(QName portName) throws ServiceException {
        if (portName == null) {
            throw new ServiceException(Messages.getMessage("badPort00"));
        }
        if (this.wsdlService == null) {
            throw new ServiceException(Messages.getMessage("wsdlMissing00"));
        }
        Port port = this.wsdlService.getPort(portName.getLocalPart());
        if (port == null) {
            throw new ServiceException(Messages.getMessage("noPort00", "" + portName));
        }
        Binding binding = port.getBinding();
        List bindings = binding.getBindingOperations();
        Iterator i = bindings.iterator();
        javax.xml.rpc.Call[] calls = new javax.xml.rpc.Call[bindings.size()];
        int index = 0;
        while (i.hasNext()) {
            BindingOperation operation = (BindingOperation)i.next();
            QName operationQName = QNameTable.createQName("", operation.getName());
            calls[index++] = this.createCall(portName, operationQName);
        }
        return calls;
    }

    public HandlerRegistry getHandlerRegistry() {
        if (this.getEngine().isContainerManaged()) {
            throw new UnsupportedOperationException(Messages.getMessage("jaxRpcGetHandlerRegistry109"));
        }
        return this.registry;
    }

    public void setWSDLDocumentLocation(URL wsdlLocation) {
        this.wsdlLocation = wsdlLocation;
    }

    public URL getWSDLDocumentLocation() {
        URL returnURL = null;
        if (this.wsdlLocation != null) {
            returnURL = this.wsdlLocation;
        } else if (this.wsdlFileName != null) {
            String urlSpecification = null;
            urlSpecification = this.wsdlFileName.indexOf(":") == -1 ? "file://///./" + this.wsdlFileName : this.wsdlFileName;
            try {
                returnURL = new URL(urlSpecification);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return returnURL;
    }

    public QName getServiceName() {
        if (this.serviceName != null) {
            return this.serviceName;
        }
        if (this.wsdlService == null) {
            return null;
        }
        QName qn = this.wsdlService.getQName();
        return QNameTable.createQName(qn.getNamespaceURI(), qn.getLocalPart());
    }

    public Iterator getPorts() throws ServiceException {
        Vector<QName> vector = new Vector<QName>();
        if (this.wsdlService != null && this.wsdlService.getPorts() != null) {
            Iterator iter = this.wsdlService.getPorts().keySet().iterator();
            while (iter.hasNext()) {
                vector.add(QNameTable.createQName(null, (String)iter.next()));
            }
        }
        return vector.iterator();
    }

    public TypeMappingRegistry getTypeMappingRegistry() {
        if (this.getEngine().isContainerManaged()) {
            throw new UnsupportedOperationException(Messages.getMessage("jaxRpcGetTypeMappingRegistry109"));
        }
        return this.getEngine().getTypeMappingRegistry();
    }

    public Reference getReference() {
        String classname = this.getClass().getName();
        Reference reference = new Reference(classname, "com.ibm.ws.webservices.engine.client.ServiceFactory", null);
        StringRefAddr addr = null;
        if (!classname.equals("com.ibm.ws.webservices.engine.client.Service")) {
            addr = new StringRefAddr("service classname", classname);
            reference.add(addr);
        } else {
            QName serviceName;
            if (this.wsdlLocation != null) {
                addr = new StringRefAddr("WSDL location", this.wsdlLocation.toString());
                reference.add(addr);
            }
            if ((serviceName = this.getServiceName()) != null) {
                addr = new StringRefAddr("service namespace", serviceName.getNamespaceURI());
                reference.add(addr);
                addr = new StringRefAddr("service local part", serviceName.getLocalPart());
                reference.add(addr);
            }
        }
        if (this.maintainSession) {
            addr = new StringRefAddr("maintain session", "true");
            reference.add(addr);
        }
        return reference;
    }

    public WebServicesEngine getEngine() {
        return this.engine;
    }

    public void setEngine(WebServicesEngine engine2) {
        this.engine = engine2;
    }

    public void setMaintainSession(boolean yesno) {
        this.maintainSession = yesno;
    }

    public boolean getMaintainSession() {
        return this.maintainSession;
    }

    public boolean getCacheWSDL() {
        return cachingWSDL;
    }

    public void setCacheWSDL(boolean flag) {
        cachingWSDL = flag;
    }

    public synchronized Connection getConnection(URL address) {
        Connection connection = (Connection)this.connectionMap.get(address);
        if (connection == null) {
            if (this.connectionMap.size() >= 15) {
                this.connectionMap.clear();
            }
            connection = new Connection(this, address);
            this.connectionMap.put(address, connection);
        }
        return connection;
    }

    public synchronized Connection getConnection(Transport transport, URL address) {
        Connection connection = (Connection)this.connectionMap.get(transport);
        if (connection == null) {
            URL url = address;
            if (url == null) {
                try {
                    url = new URL(transport.getUrl());
                }
                catch (MalformedURLException mue) {
                    url = null;
                }
            }
            if (url != null) {
                connection = (Connection)this.connectionMap.get(url);
            }
            if (connection == null) {
                if (this.connectionMap.size() >= 25) {
                    this.connectionMap.clear();
                }
                connection = new Connection(this, transport, url);
                this.connectionMap.put(transport, connection);
                if (url != null) {
                    this.connectionMap.put(url, connection);
                }
            }
        }
        return connection;
    }

    public void setServiceRefName(String serviceRefName) {
        this.serviceRefName = serviceRefName;
    }

    public String getServiceRefName() {
        return this.serviceRefName;
    }

    public void setPortTypeToPortMapping(Map portTypeToPortMapping) {
        this.portTypeToPortMapping = portTypeToPortMapping;
    }

    public Map getPortTypeToPortMapping() {
        return this.portTypeToPortMapping;
    }

    public void setSEIToPortTypeMapping(Map seiToPortTypeMapping) {
        this.seiToPortTypeMapping = seiToPortTypeMapping;
    }

    public Map getSEIToPortTypeMapping() {
        return this.seiToPortTypeMapping;
    }

    public void setOverriddingEndpointURIs(Map overridingEndpointURIs) {
        this.overriddingEndpointURIs = overridingEndpointURIs;
    }

    public Map getOverriddingEndpointURIs() {
        return this.overriddingEndpointURIs;
    }

    public void setWSDLFileName(String wsdlFileName) {
        this.wsdlFileName = wsdlFileName;
    }

    public String getWSDLFileName() {
        return this.wsdlFileName;
    }

    private void assertValidPortName_getPort(QName portName) throws ServiceException {
        if (portName == null || portName.getLocalPart().length() == 0) {
            throw new ServiceException(Messages.getMessage("noPort00", "" + portName));
        }
    }

    private void assertValidProxyInterface_getPort(Class proxyInterface) throws ServiceException {
        if (proxyInterface == null || !proxyInterface.isInterface()) {
            throw new ServiceException(Messages.getMessage("mustBeIface00"));
        }
        if (!Remote.class.isAssignableFrom(proxyInterface)) {
            throw new ServiceException(Messages.getMessage("mustExtendRemote00"));
        }
    }

    private void assertValidEndpoint_getPort(String endpoint) throws ServiceException {
        if (endpoint == null || endpoint.length() == 0) {
            throw new ServiceException(Messages.getMessage("invEndpointCreateCall00", "" + endpoint));
        }
    }

    private void assertValidPortName_createCall(QName portName) throws ServiceException {
        if (portName == null || portName.getLocalPart().length() == 0) {
            throw new ServiceException(Messages.getMessage("invPortCreateCall00", "" + portName));
        }
    }

    private void assertValidOperationName_createCall(QName operation) throws ServiceException {
        if (operation == null || operation.getLocalPart().length() == 0) {
            throw new ServiceException(Messages.getMessage("invOperationCreateCall00", "" + operation));
        }
    }

    private void assertValidOperationName_createCall(String operation) throws ServiceException {
        if (operation == null || operation.length() == 0) {
            throw new ServiceException(Messages.getMessage("invOperationCreateCall00", "" + operation));
        }
    }

    public String getWsdlLoadStrategyPath() {
        return this.wsdlLoadStrategyPath;
    }

    public void setWsdlLoadStrategyPath(String wsdlLoadStrategyPath) {
        this.wsdlLoadStrategyPath = wsdlLoadStrategyPath;
    }

    static {
        Protocols.init();
    }

    protected class HandlerRegistryImpl
    implements HandlerRegistry {
        protected HandlerRegistryImpl() {
        }

        private SOAPPort getSOAPPort(QName portName) {
            SOAPPort soapPort;
            if (portName == null) {
                return null;
            }
            try {
                soapPort = Service.this.getEngine().getPort(portName.getLocalPart());
            }
            catch (WebServicesFault f) {
                soapPort = null;
            }
            if (soapPort == null) {
                soapPort = this.registerNewPort(portName);
            }
            if (soapPort == null) {
                if (log.isDebugEnabled()) {
                    log.debug("Error: Cannot find port: " + portName);
                }
                throw new JAXRPCException(Messages.getMessage("noService01"));
            }
            return soapPort;
        }

        private SOAPPort registerNewPort(QName portName) {
            EngineConfiguration config2 = Service.this.engine.getConfiguration();
            if (config2 instanceof SimpleEngineConfigurationProvider) {
                ClientSOAPPort soapPort = new ClientSOAPPort(null, null);
                soapPort.setName(portName.getLocalPart());
                ((SimpleEngineConfigurationProvider)config2).deployPort(soapPort.getName(), (SOAPPort)soapPort);
                return soapPort;
            }
            return null;
        }

        public List getHandlerChain(QName portName) {
            SOAPPort soapPort = this.getSOAPPort(portName);
            HandlerChain chain = soapPort.getHandlerChain();
            if (chain == null) {
                chain = new SOAPHandlerChain(null, null);
                soapPort.setHandlerChain(chain);
            }
            return chain;
        }

        public void setHandlerChain(QName portName, List chain) {
            TreeSet<String> roles = new TreeSet<String>();
            roles.add("");
            this.getSOAPPort(portName).setHandlerChain(new SOAPHandlerChain(chain, roles));
        }
    }
}

