/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.client;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.protocol.Protocols;
import com.ibm.ws.webservices.custom.CustomPropertyProviderFactory;
import com.ibm.ws.webservices.engine.InternalException;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.SOAPPart;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.attachments.Attachments;
import com.ibm.ws.webservices.engine.client.Service;
import com.ibm.ws.webservices.engine.client.Transport;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.description.OperationDesc;
import com.ibm.ws.webservices.engine.description.ParameterDesc;
import com.ibm.ws.webservices.engine.encoding.DeserializationContextImpl;
import com.ibm.ws.webservices.engine.enumtype.MessageType;
import com.ibm.ws.webservices.engine.handlers.soap.SOAPPort;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.transport.http.HTTPTransport;
import com.ibm.ws.webservices.engine.transport.java.JavaTransport;
import com.ibm.ws.webservices.engine.transport.jms.JMSTransport;
import com.ibm.ws.webservices.engine.transport.local.LocalTransport;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPBody;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPBodyElement;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPEnvelope;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPHeader;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPHeaderElement;
import com.ibm.ws.webservices.engine.xmlsoap.ext.ParamValue;
import com.ibm.ws.webservices.engine.xmlsoap.ext.RequestResponse;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import org.apache.commons.logging.Log;

public class Connection {
    protected static Log log = LogFactory.getLog(Connection.class.getName());
    protected static Log entLog = LogFactory.getLog("com.ibm.ws.webservices.engine.enterprise");
    public static final Integer writeTimeoutValue = (Integer)CustomPropertyProviderFactory.getProvider().getValue("com.ibm.ws.webservices.writeTimeout");
    public static final Integer readTimeoutValue = (Integer)CustomPropertyProviderFactory.getProvider().getValue("com.ibm.ws.webservices.readTimeout");
    private final Service service;
    private final Transport transport;
    private final URL url;
    public static final boolean FAULT_ON_NO_RESPONSE = false;
    private static final Hashtable transports = new Hashtable();
    private Vector myHeaderParams = null;

    public static void initProtocols() {
    }

    Connection(Service service, URL url) {
        this.service = service;
        this.transport = this.getTransportForURL(url);
        this.url = url;
    }

    Connection(Service service, Transport transport, URL url) {
        this.service = service;
        this.transport = transport;
        this.url = url;
    }

    private Transport getTransportForURL(URL url) {
        Transport transport = null;
        if (url != null) {
            String protocol = url.getProtocol();
            transport = this.getTransportForProtocol(protocol);
            if (transport == null) {
                String translatedMessage = Messages.getMessage("noTransport01", protocol);
                JAXRPCException e = new JAXRPCException(translatedMessage);
                log.error(translatedMessage);
                throw e;
            }
            transport.setUrl(url.toString());
        }
        return transport;
    }

    private Transport getTransportForProtocol(String protocol) {
        Class transportClass = (Class)transports.get(protocol);
        Transport ret = null;
        if (transportClass != null) {
            try {
                ret = (Transport)transportClass.newInstance();
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
        return ret;
    }

    public static void setTransportForProtocol(String protocol, Class transportClass) {
        if (!Transport.class.isAssignableFrom(transportClass)) {
            throw new InternalException(transportClass.toString());
        }
        transports.put(protocol, transportClass);
    }

    private Object[] getParamList(OperationDesc operation, Object[] params, Vector headers) {
        int numParams = 0;
        if (log.isDebugEnabled()) {
            log.debug("operation=" + operation);
            log.debug("operation.getNumParams()=" + operation.getNumParams());
        }
        if (operation.getNumParams() == 0) {
            return params;
        }
        numParams = operation.getNumInParams();
        if (params == null || numParams != params.length) {
            throw new JAXRPCException(Messages.getMessage("parmMismatch00", "" + (params != null ? params.length : 0), "" + numParams));
        }
        if (log.isDebugEnabled()) {
            log.debug("getParamList number of params: " + params.length);
        }
        Vector<ParamValue> result = new Vector<ParamValue>();
        int j = 0;
        ArrayList parameters = operation.getParameters();
        for (int i = 0; i < parameters.size(); ++i) {
            Object p;
            ParameterDesc param = (ParameterDesc)parameters.get(i);
            if (param.getMode() == 2) continue;
            QName paramQName = param.getQName();
            ParamValue paramValue = null;
            paramValue = (p = params[j++]) instanceof ParamValue ? (ParamValue)p : new ParamValue(paramQName.getNamespaceURI(), paramQName.getLocalPart(), p);
            paramValue.setParamDesc(param);
            if (param.isInHeader()) {
                headers.add(paramValue);
                continue;
            }
            result.add(paramValue);
        }
        return result.toArray();
    }

    public Vector invoke(MessageContext msgContext, Object[] args, Vector headers, Vector attachments) throws WebServicesFault {
        OperationDesc operation;
        if (headers == null) {
            headers = new Vector();
        }
        if ((operation = msgContext.getOperation()) == null) {
            throw new WebServicesFault(QNameTable.createQName(msgContext.getSOAPConstants().getEnvelopeURI(), "Client"), Messages.getMessage("mustSpecifyOperation"), null, null);
        }
        if (log.isDebugEnabled()) {
            log.debug("Enter: Connection::invoke(MessageContext, Object[] args, Vector, Vector)");
        }
        QName opQName = operation.getElementQName();
        SOAPFactory sf = new SOAPFactory(msgContext.getSOAPConstants());
        SOAPEnvelope reqEnv = null;
        SOAPBody body = null;
        SOAPHeader header = null;
        try {
            reqEnv = sf.createSOAPEnvelope(true);
            body = (SOAPBody)reqEnv.getBody();
            header = (SOAPHeader)reqEnv.getHeader();
        }
        catch (SOAPException se) {
            FFDCFilter.processException((Throwable)se, "com.ibm.ws.webservices.engine.client.Connection.invoke", "408", this);
            throw WebServicesFault.makeFault(se);
        }
        RequestResponse request = null;
        try {
            request = new RequestResponse(opQName.getNamespaceURI(), opQName.getLocalPart(), body, false);
        }
        catch (SOAPException se) {
            FFDCFilter.processException((Throwable)se, "com.ibm.ws.webservices.engine.client.Connection.invoke", "418", this);
            throw WebServicesFault.makeFault(se);
        }
        request.addParams(this.getParamList(operation, args, headers));
        SOAPEnvelope resEnv = null;
        Message reqMsg = new Message(reqEnv);
        Message resMsg = null;
        Vector resArgs = null;
        String charEncoding = msgContext.getCharacterEncoding();
        if (charEncoding != null && charEncoding.length() > 0) {
            reqMsg.setCharacterEncoding(charEncoding);
            reqMsg.setMessageContext(msgContext);
        }
        try {
            String encStyle = msgContext.getEncodingStyle();
            if (encStyle != null && encStyle.length() > 0) {
                body.setEncodingStyle(encStyle);
                header.setEncodingStyle(encStyle);
            }
            msgContext.setRequestMessage(reqMsg);
            reqEnv.getSOAPFactory().setMessageType(MessageType.REQUEST);
            this.invoke(msgContext, headers, attachments);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.client.Connection.invoke", "438", this);
            if (entLog.isDebugEnabled()) {
                entLog.debug(Messages.getMessage("toWebServicesFault00"), e);
            }
            throw WebServicesFault.makeFault(e);
        }
        resMsg = msgContext.getResponseMessage();
        if (!this.isRPCOneway(msgContext)) {
            if (resMsg == null) {
                return null;
            }
            resEnv = resMsg.getSOAPEnvelope();
            RequestResponse resp = null;
            try {
                if (resEnv.getBody() == null) {
                    if (log.isDebugEnabled()) {
                        log.debug("detected no body.  A body is created.");
                    }
                    SOAPBody sb = (SOAPBody)resEnv.addBody();
                    new RequestResponse("", "", sb, true, new OperationDesc[]{operation}, new DeserializationContextImpl(msgContext, null));
                }
                resp = ((SOAPBody)resEnv.getBody()).getRequestResponse();
            }
            catch (SOAPException se) {
                FFDCFilter.processException((Throwable)se, "com.ibm.ws.webservices.engine.client.Connection.invoke", "460", this);
                throw WebServicesFault.makeFault(se);
            }
            if (resp != null) {
                try {
                    resArgs = resp.getParams();
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.client.Connection.invoke", "468", this);
                    log.error(Messages.getMessage("exception00"), e);
                    throw WebServicesFault.makeFault(e);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("Exit: Connection::invoke(msgCtx, args)");
            }
        }
        if (msgContext != null) {
            msgContext.setRequestMessage(null);
        }
        return resArgs;
    }

    public void invoke(MessageContext msgContext, Vector headers, Vector attachments) throws WebServicesFault {
        SOAPEnvelope reqEnv;
        if (log.isDebugEnabled()) {
            log.debug("Enter: Connection::invoke(MessageContext, Vector headers, Vector attachments)");
        }
        Message reqMsg = msgContext.getRequestMessage();
        QName portName = msgContext.getPortName();
        if (portName != null) {
            msgContext.setTargetPort(portName.getLocalPart());
        } else if (reqMsg != null) {
            try {
                QName target;
                reqEnv = reqMsg.getSOAPEnvelope();
                RequestResponse rr = ((SOAPBody)reqEnv.getBody()).getRequestResponse();
                if (rr != null) {
                    target = rr.getQName();
                } else {
                    SOAPBodyElement sbe = (SOAPBodyElement)((SOAPBody)reqEnv.getBody()).getChildElement(0);
                    target = QNameTable.createQName(sbe.getNamespaceURI(), sbe.getLocalPart());
                }
                if (target.getNamespaceURI() == null) {
                    throw new WebServicesFault(QNameTable.createQName(msgContext.getSOAPConstants().getEnvelopeURI(), "Client"), Messages.getMessage("cantInvoke00", target.getLocalPart()), null, null);
                }
                msgContext.setTargetPort(target.getNamespaceURI());
            }
            catch (SOAPException se) {
                FFDCFilter.processException((Throwable)se, "com.ibm.ws.webservices.engine.client.Connection.invoke", "541", this);
                throw WebServicesFault.makeFault(se);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("targetService", msgContext.getTargetPortName()));
        }
        if (reqMsg != null) {
            reqEnv = reqMsg.getSOAPEnvelope();
            reqEnv.getSOAPFactory().setMessageContext(msgContext);
            try {
                for (int i = 0; headers != null && i < headers.size(); ++i) {
                    if (headers.get(i) instanceof ParamValue) {
                        ParamValue pv = (ParamValue)headers.get(i);
                        SOAPHeaderElement she = reqEnv.getSOAPFactory().createSOAPHeaderElement(pv.getQName().getNamespaceURI(), pv.getQName().getLocalPart());
                        she.setAlternateContent(pv);
                        reqEnv.getHeader().addChildElement((SOAPElement)she);
                        continue;
                    }
                    reqEnv.getHeader().addChildElement((SOAPElement)((SOAPHeaderElement)headers.get(i)));
                }
            }
            catch (SOAPException se) {
                FFDCFilter.processException((Throwable)se, "com.ibm.ws.webservices.engine.client.Connection.invoke", "575", this);
                throw WebServicesFault.makeFault(se);
            }
            if (log.isDebugEnabled()) {
                SOAPPart soapPart = (SOAPPart)reqMsg.getSOAPPart();
                try {
                    String msgStr = soapPart.getString();
                    log.debug(msgStr);
                }
                catch (Exception e) {
                    log.debug(Messages.getMessage("exceptionPrinting"), e);
                }
            }
        }
        Message requestMessage = msgContext.getRequestMessage();
        this.addAttachments(requestMessage, attachments);
        this.invoke(msgContext);
    }

    public void invoke(MessageContext msgContext) throws WebServicesFault {
        if (log.isDebugEnabled()) {
            log.debug("Enter: Connection::invoke(MessageContext)");
        }
        if (msgContext.getTargetEndpointAddress() == null && this.url != null) {
            msgContext.setTargetEndpointAddress(this.url);
        }
        if (this.transport != null) {
            this.transport.setupMessageContext(msgContext, this.service.getEngine());
        }
        msgContext.addImplicitSOAPHeadersToRequest();
        if (this.isRPCOneway(msgContext)) {
            this.invokeEngineOneWay(msgContext);
        } else {
            this.invokeEngine(msgContext);
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: Call::invoke()");
        }
    }

    private void addAttachments(Message msg, Vector attachmentParts) {
        if (attachmentParts != null && !attachmentParts.isEmpty()) {
            try {
                Attachments attachments = msg.getAttachmentsImpl();
                if (attachments == null) {
                    throw new RuntimeException(Messages.getMessage("noAttachments"));
                }
                attachments.setAttachmentParts(attachmentParts);
                attachmentParts.clear();
            }
            catch (WebServicesFault ex) {
                FFDCFilter.processException((Throwable)ex, "com.ibm.ws.webservices.engine.client.Connection.addAttachments", "1564", this);
                log.info(Messages.getMessage("webServicesFault00"), ex);
                throw new RuntimeException(ex.getMessage());
            }
        }
    }

    private boolean isRPCOneway(MessageContext msgContext) {
        return msgContext != null && msgContext.getOperation() != null ? msgContext.getOperation().isOneway() : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void setTimeout(MessageContext msgContext) {
        block27: {
            String timeout;
            QName portQName;
            block26: {
                block25: {
                    portQName = msgContext.getPortName();
                    timeout = null;
                    String propName = "com.ibm.ws.webservices.readTimeout";
                    SOAPPort soapPort = this.service.getEngine().getPort(portQName);
                    if (soapPort == null) break block25;
                    timeout = (String)soapPort.getOption(propName);
                    if (timeout == null) {
                        timeout = (String)soapPort.getOption("SyncTimeout");
                        if (log.isDebugEnabled()) {
                            log.debug("soapPort read timeout using sync_timeout");
                        }
                    }
                    if (!log.isDebugEnabled()) break block25;
                    log.debug("soapPort read timeout: " + timeout);
                }
                Object var7_7 = null;
                if (timeout != null) break block26;
                msgContext.setTimeout(readTimeoutValue * 1000);
                if (log.isDebugEnabled()) {
                    log.debug("readTimeoutValue: " + readTimeoutValue);
                }
            }
            try {
                msgContext.setTimeout(Integer.parseInt(timeout) * 1000);
                if (log.isDebugEnabled()) {
                    log.debug("PortComponent: " + portQName + "  Timeout: " + timeout);
                }
                break block27;
            }
            catch (Exception e2) {
                if (log.isDebugEnabled()) {
                    log.debug("Exception: " + e2);
                }
                msgContext.setTimeout(readTimeoutValue * 1000);
                if (log.isDebugEnabled()) {
                    log.debug("readTimeoutValue: " + readTimeoutValue);
                }
                break block27;
            }
            {
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.client.Connection.setTimeout", "660", this);
                    if (log.isDebugEnabled()) {
                        log.debug(Messages.getMessage("exceptionPrinting"), e);
                    }
                    Object var7_8 = null;
                    if (timeout == null) {
                        msgContext.setTimeout(readTimeoutValue * 1000);
                        if (log.isDebugEnabled()) {
                            log.debug("readTimeoutValue: " + readTimeoutValue);
                        }
                        break block27;
                    }
                    try {
                        msgContext.setTimeout(Integer.parseInt(timeout) * 1000);
                        if (log.isDebugEnabled()) {
                            log.debug("PortComponent: " + portQName + "  Timeout: " + timeout);
                        }
                        break block27;
                    }
                    catch (Exception e2) {
                        if (log.isDebugEnabled()) {
                            log.debug("Exception: " + e2);
                        }
                        msgContext.setTimeout(readTimeoutValue * 1000);
                        if (log.isDebugEnabled()) {
                            log.debug("readTimeoutValue: " + readTimeoutValue);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                block28: {
                    Object var7_9 = null;
                    if (timeout == null) {
                        msgContext.setTimeout(readTimeoutValue * 1000);
                        if (log.isDebugEnabled()) {
                            log.debug("readTimeoutValue: " + readTimeoutValue);
                        }
                    } else {
                        try {
                            msgContext.setTimeout(Integer.parseInt(timeout) * 1000);
                            if (log.isDebugEnabled()) {
                                log.debug("PortComponent: " + portQName + "  Timeout: " + timeout);
                            }
                        }
                        catch (Exception e2) {
                            if (log.isDebugEnabled()) {
                                log.debug("Exception: " + e2);
                            }
                            msgContext.setTimeout(readTimeoutValue * 1000);
                            if (!log.isDebugEnabled()) break block28;
                            log.debug("readTimeoutValue: " + readTimeoutValue);
                        }
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void setWriteTimeout(MessageContext msgContext) {
        block27: {
            String timeout;
            QName portQName;
            block26: {
                block25: {
                    portQName = msgContext.getPortName();
                    timeout = null;
                    String propName = "com.ibm.ws.webservices.writeTimeout";
                    SOAPPort soapPort = this.service.getEngine().getPort(portQName);
                    if (soapPort == null) break block25;
                    timeout = (String)soapPort.getOption(propName);
                    if (timeout == null) {
                        timeout = (String)soapPort.getOption("write_timeout");
                        if (log.isDebugEnabled()) {
                            log.debug("soapPort write timeout using OPTION_WRITE_TIMEOUT");
                        }
                    }
                    if (!log.isDebugEnabled()) break block25;
                    log.debug("soapPort write timeout: " + timeout);
                }
                Object var7_7 = null;
                if (timeout != null) break block26;
                msgContext.setWriteTimeout(writeTimeoutValue * 1000);
                if (log.isDebugEnabled()) {
                    log.debug("writeTimeoutValue: " + writeTimeoutValue);
                }
            }
            try {
                msgContext.setWriteTimeout(Integer.parseInt(timeout) * 1000);
                if (log.isDebugEnabled()) {
                    log.debug("PortComponent: " + portQName + "  writeTimeout: " + timeout);
                }
                break block27;
            }
            catch (Exception e2) {
                if (log.isDebugEnabled()) {
                    log.debug("Exception: " + e2);
                }
                msgContext.setWriteTimeout(writeTimeoutValue * 1000);
                if (log.isDebugEnabled()) {
                    log.debug("writeTimeoutValue: " + writeTimeoutValue);
                }
                break block27;
            }
            {
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.client.Connection.setWriteTimeout", "811", this);
                    if (log.isDebugEnabled()) {
                        log.debug(Messages.getMessage("exceptionPrinting"), e);
                    }
                    Object var7_8 = null;
                    if (timeout == null) {
                        msgContext.setWriteTimeout(writeTimeoutValue * 1000);
                        if (log.isDebugEnabled()) {
                            log.debug("writeTimeoutValue: " + writeTimeoutValue);
                        }
                        break block27;
                    }
                    try {
                        msgContext.setWriteTimeout(Integer.parseInt(timeout) * 1000);
                        if (log.isDebugEnabled()) {
                            log.debug("PortComponent: " + portQName + "  writeTimeout: " + timeout);
                        }
                        break block27;
                    }
                    catch (Exception e2) {
                        if (log.isDebugEnabled()) {
                            log.debug("Exception: " + e2);
                        }
                        msgContext.setWriteTimeout(writeTimeoutValue * 1000);
                        if (log.isDebugEnabled()) {
                            log.debug("writeTimeoutValue: " + writeTimeoutValue);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                block28: {
                    Object var7_9 = null;
                    if (timeout == null) {
                        msgContext.setWriteTimeout(writeTimeoutValue * 1000);
                        if (log.isDebugEnabled()) {
                            log.debug("writeTimeoutValue: " + writeTimeoutValue);
                        }
                    } else {
                        try {
                            msgContext.setWriteTimeout(Integer.parseInt(timeout) * 1000);
                            if (log.isDebugEnabled()) {
                                log.debug("PortComponent: " + portQName + "  writeTimeout: " + timeout);
                            }
                        }
                        catch (Exception e2) {
                            if (log.isDebugEnabled()) {
                                log.debug("Exception: " + e2);
                            }
                            msgContext.setWriteTimeout(writeTimeoutValue * 1000);
                            if (!log.isDebugEnabled()) break block28;
                            log.debug("writeTimeoutValue: " + writeTimeoutValue);
                        }
                    }
                }
                throw throwable;
            }
        }
    }

    private void invokeEngine(MessageContext msgContext) throws WebServicesFault {
        Message resMsg;
        if (msgContext.getTimeout() == 0) {
            this.setTimeout(msgContext);
        }
        if (msgContext.getWriteTimeout() == 0) {
            this.setWriteTimeout(msgContext);
        }
        this.service.getEngine().invoke(msgContext);
        if (this.transport != null) {
            this.transport.processReturnedMessageContext(msgContext);
        }
        if ((resMsg = msgContext.getResponseMessage()) == null) {
            return;
        }
        resMsg.setMessageType(MessageType.RESPONSE);
        resMsg.ifFaultThrowSelf();
        msgContext.getImplicitSOAPHeadersFromResponse();
    }

    private void invokeEngineOneWay(MessageContext msgContext) throws WebServicesFault {
        try {
            Message resMsg;
            this.service.getEngine().invoke(msgContext);
            if (this.transport != null) {
                this.transport.processReturnedMessageContext(msgContext);
            }
            if ((resMsg = msgContext.getResponseMessage()) != null) {
                resMsg.setMessageType(MessageType.RESPONSE);
                resMsg.ifFaultThrowSelf();
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.client.Connection.invokeEngineOneWay", "783", this);
            throw WebServicesFault.makeFault(e);
        }
    }

    public Service getService() {
        return this.service;
    }

    static {
        Protocols.init();
        Connection.setTransportForProtocol("java", JavaTransport.class);
        Connection.setTransportForProtocol("local", LocalTransport.class);
        Connection.setTransportForProtocol("http", HTTPTransport.class);
        Connection.setTransportForProtocol("https", HTTPTransport.class);
        Connection.setTransportForProtocol("jms", JMSTransport.class);
    }
}

