/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.attachments;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.Part;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.attachments.AttachmentPart;
import com.ibm.ws.webservices.engine.attachments.BoundaryDelimitedStream;
import com.ibm.ws.webservices.engine.attachments.ManagedMemoryDataSource;
import com.ibm.ws.webservices.engine.attachments.MultiPartInputStream;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import javax.activation.DataHandler;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.ParseException;
import org.apache.commons.logging.Log;

public class MultiPartRelatedInputStream
extends MultiPartInputStream {
    protected static Log log = LogFactory.getLog(MultiPartRelatedInputStream.class.getName());
    public static final String MIME_MULTIPART_RELATED = "multipart/related";
    protected HashMap parts = new HashMap();
    protected LinkedList orderedParts = new LinkedList();
    protected int rootPartLength = 0;
    protected BoundaryDelimitedStream boundaryDelimitedStream = null;
    protected InputStream soapStreamBDS = null;
    protected byte[] boundary = null;
    protected ByteArrayInputStream cachedSOAPEnvelope = null;
    protected String contentLocation = null;
    protected String contentId = null;
    protected static final String[] READ_ALL = new String[]{" * \u0000 ".intern()};

    public MultiPartRelatedInputStream(String contentType, InputStream is) throws WebServicesFault {
        super(null);
        if (log.isDebugEnabled()) {
            log.debug("Content-Type: " + contentType);
        }
        try {
            boolean found;
            String boundaryStr;
            String typeParam = "type=text/xml;";
            int i = contentType.indexOf(typeParam);
            if (i >= 0) {
                StringBuffer sb = new StringBuffer(contentType);
                sb = sb.delete(i, i + typeParam.length());
                sb = sb.append("; type=\"text/xml\"");
                contentType = sb.toString();
                if (log.isDebugEnabled()) {
                    log.debug("Content-Type edited to: " + contentType);
                }
            }
            if (contentType.indexOf("type=\"text/xml\"") == -1) {
                String MTOMType;
                int j;
                if (log.isDebugEnabled()) {
                    log.debug("Invalid Content-Type header: No parameter type=\"text/xml\" given");
                }
                if ((j = contentType.indexOf(MTOMType = " type=\"application/xop+xml\";")) >= 0) {
                    StringBuffer sb = new StringBuffer(contentType);
                    String cttrim = (sb = sb.delete(j, j + MTOMType.length())).toString().trim();
                    sb = cttrim.endsWith(";") ? sb.append(" type=\"text/xml\"") : sb.append("; type=\"text/xml\"");
                    contentType = sb.toString();
                    if (log.isDebugEnabled()) {
                        log.debug("Content-Type edited to: " + contentType);
                    }
                }
            }
            ContentType ct = new ContentType(contentType);
            DataInputStream dataIs = new DataInputStream(is);
            String rootPartContentId = ct.getParameter("start");
            if (ct.getParameter("boundary") != null) {
                boundaryStr = "--" + ct.getParameter("boundary");
                if (rootPartContentId != null) {
                    if ((rootPartContentId = rootPartContentId.trim()).startsWith("<")) {
                        rootPartContentId = rootPartContentId.substring(1);
                    }
                    if (rootPartContentId.endsWith(">")) {
                        rootPartContentId = rootPartContentId.substring(0, rootPartContentId.length() - 1);
                    }
                }
                byte[][] boundaryMarker = new byte[2][boundaryStr.length() + 2];
                dataIs.readFully(boundaryMarker[0]);
                this.boundary = (boundaryStr + "\r\n").getBytes("US-ASCII");
                int current = 0;
                found = false;
                while (!found) {
                    found = Arrays.equals(boundaryMarker[current & 1], this.boundary);
                    if (!found) {
                        System.arraycopy(boundaryMarker[current & 1], 1, boundaryMarker[current + 1 & 1], 0, boundaryMarker[0].length - 1);
                        if (dataIs.read(boundaryMarker[current + 1 & 1], boundaryMarker[0].length - 1, 1) < 1) {
                            throw new WebServicesFault(Messages.getMessage("mimeErrorNoBoundary", new String(this.boundary)));
                        }
                    }
                    ++current;
                }
                boundaryStr = "\r\n" + boundaryStr;
                this.boundary = boundaryStr.getBytes("US-ASCII");
                if (log.isDebugEnabled()) {
                    log.debug("[1] Boundary found: " + boundaryStr);
                }
            } else {
                boundaryStr = "--";
                byte[] boundaryBytes = boundaryStr.getBytes("US-ASCII");
                byte[] readBytes = new byte[boundaryBytes.length];
                dataIs.readFully(readBytes);
                found = false;
                while (!found) {
                    found = Arrays.equals(boundaryBytes, readBytes);
                    if (found || dataIs.read(readBytes) >= 1) continue;
                    throw new WebServicesFault(Messages.getMessage("mimeErrorNoBoundary", boundaryStr));
                }
                boundaryStr = "\r\n--" + this.readBoundary(dataIs);
                this.boundary = boundaryStr.getBytes("US-ASCII");
                if (log.isDebugEnabled()) {
                    log.debug("[2] Boundary found: " + boundaryStr);
                }
            }
            this.boundaryDelimitedStream = new BoundaryDelimitedStream(dataIs, this.boundary, 1024);
            String contentTransferEncoding = null;
            do {
                this.contentId = null;
                this.contentLocation = null;
                contentTransferEncoding = null;
                InternetHeaders headers = new InternetHeaders(this.boundaryDelimitedStream);
                this.contentId = headers.getHeader("Content-Id", null);
                if (this.contentId != null) {
                    this.contentId = this.contentId.trim();
                    if (this.contentId.startsWith("<")) {
                        this.contentId = this.contentId.substring(1);
                    }
                    if (this.contentId.endsWith(">")) {
                        this.contentId = this.contentId.substring(0, this.contentId.length() - 1);
                    }
                    this.contentId = this.contentId.trim();
                }
                this.contentLocation = headers.getHeader("Content-Location", null);
                if (this.contentLocation != null) {
                    this.contentLocation = this.contentLocation.trim();
                    if (this.contentLocation.startsWith("<")) {
                        this.contentLocation = this.contentLocation.substring(1);
                    }
                    if (this.contentLocation.endsWith(">")) {
                        this.contentLocation = this.contentLocation.substring(0, this.contentLocation.length() - 1);
                    }
                    this.contentLocation = this.contentLocation.trim();
                }
                if ((contentType = headers.getHeader("Content-Type", null)) != null) {
                    contentType = contentType.trim();
                }
                if ((contentTransferEncoding = headers.getHeader("Content-Transfer-Encoding", null)) != null) {
                    contentTransferEncoding = contentTransferEncoding.trim();
                }
                InputStream decodedStream = this.boundaryDelimitedStream;
                if (contentTransferEncoding != null && 0 != contentTransferEncoding.length()) {
                    decodedStream = MimeUtility.decode(decodedStream, contentTransferEncoding);
                }
                if (rootPartContentId == null || rootPartContentId.equals(this.contentId)) continue;
                DataHandler dh = new DataHandler(new ManagedMemoryDataSource(decodedStream, contentType));
                AttachmentPart ap = new AttachmentPart(dh);
                if (this.contentId != null) {
                    ap.setMimeHeader("Content-Id", this.contentId);
                }
                if (this.contentLocation != null) {
                    ap.setMimeHeader("Content-Location", this.contentLocation);
                }
                Enumeration en = headers.getNonMatchingHeaders(new String[]{"Content-Id", "Content-Location", "Content-Type"});
                while (en.hasMoreElements()) {
                    Header header = (Header)en.nextElement();
                    String name = header.getName();
                    String value = header.getValue();
                    if (name == null || value == null || (name = name.trim()).length() == 0) continue;
                    ap.addMimeHeader(name, value);
                }
                this.addPart(this.contentId, this.contentLocation, ap);
                this.boundaryDelimitedStream = this.boundaryDelimitedStream.getNextStream();
            } while (null != this.boundaryDelimitedStream && rootPartContentId != null && !rootPartContentId.equals(this.contentId));
            if (this.boundaryDelimitedStream == null) {
                throw new WebServicesFault(Messages.getMessage("noRoot", rootPartContentId));
            }
            this.soapStreamBDS = this.boundaryDelimitedStream;
            this.soapStream = contentTransferEncoding != null && 0 != contentTransferEncoding.length() ? MimeUtility.decode(this.boundaryDelimitedStream, contentTransferEncoding) : this.boundaryDelimitedStream;
        }
        catch (ParseException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.attachments.MultiPartRelatedInputStream.MultiPartRelatedInputStream", "447", this);
            throw new WebServicesFault(Messages.getMessage("mimeErrorParsing", e.getMessage()));
        }
        catch (IOException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.attachments.MultiPartRelatedInputStream.MultiPartRelatedInputStream", "451", this);
            throw new WebServicesFault(Messages.getMessage("readError", e.getMessage()));
        }
        catch (MessagingException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.attachments.MultiPartRelatedInputStream.MultiPartRelatedInputStream", "455", this);
            throw new WebServicesFault(Messages.getMessage("readError", e.getMessage()));
        }
    }

    private final String readBoundary(InputStream is) throws IOException {
        StringBuffer input = new StringBuffer();
        int c = -1;
        boolean eol = false;
        block4: while (!eol) {
            c = is.read();
            switch (c) {
                case -1: 
                case 10: {
                    eol = true;
                    continue block4;
                }
                case 13: {
                    eol = true;
                    is.read();
                    continue block4;
                }
            }
            input.append((char)c);
        }
        if (c == -1 && input.length() == 0) {
            return null;
        }
        return input.toString();
    }

    public Part getAttachmentByReference(String[] id) throws WebServicesFault {
        Part ret = null;
        for (int i = id.length - 1; ret == null && i > -1; --i) {
            ret = (AttachmentPart)this.parts.get(id[i]);
        }
        if (null == ret) {
            ret = this.readTillFound(id);
        }
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("return02", "getAttachmentByReference(\"" + id + "\"", ret == null ? "null" : ret.toString()));
        }
        return ret;
    }

    protected void addPart(String contentId, String locationId, AttachmentPart ap) {
        if (contentId != null && contentId.trim().length() != 0) {
            this.parts.put(contentId, ap);
        }
        if (locationId != null && locationId.trim().length() != 0) {
            this.parts.put(locationId, ap);
        }
        this.orderedParts.add(ap);
    }

    protected void readAll() throws WebServicesFault {
        this.readTillFound(READ_ALL);
    }

    public Collection getAttachments() throws WebServicesFault {
        this.readAll();
        return this.orderedParts;
    }

    protected Part readTillFound(String[] id) throws WebServicesFault {
        if (this.boundaryDelimitedStream == null) {
            return null;
        }
        AttachmentPart ret = null;
        try {
            if (this.soapStreamBDS == this.boundaryDelimitedStream) {
                if (!this.eos) {
                    ByteArrayOutputStream soapdata = new ByteArrayOutputStream(8192);
                    byte[] buf = new byte[16384];
                    int byteread = 0;
                    do {
                        if ((byteread = this.soapStream.read(buf)) <= 0) continue;
                        soapdata.write(buf, 0, byteread);
                    } while (byteread > -1);
                    soapdata.close();
                    this.soapStream = new ByteArrayInputStream(soapdata.toByteArray());
                }
                this.boundaryDelimitedStream = this.boundaryDelimitedStream.getNextStream();
            }
            if (null != this.boundaryDelimitedStream) {
                do {
                    String contentType = null;
                    String contentId = null;
                    String contentTransferEncoding = null;
                    String contentLocation = null;
                    InternetHeaders headers = new InternetHeaders(this.boundaryDelimitedStream);
                    contentId = headers.getHeader("Content-Id", null);
                    if (contentId != null) {
                        if ((contentId = contentId.trim()).startsWith("<")) {
                            contentId = contentId.substring(1);
                        }
                        if (contentId.endsWith(">")) {
                            contentId = contentId.substring(0, contentId.length() - 1);
                        }
                        contentId = contentId.trim();
                    }
                    if ((contentType = headers.getHeader("Content-Type", null)) != null) {
                        contentType = contentType.trim();
                    }
                    if ((contentLocation = headers.getHeader("Content-Location", null)) != null) {
                        contentLocation = contentLocation.trim();
                    }
                    if ((contentTransferEncoding = headers.getHeader("Content-Transfer-Encoding", null)) != null) {
                        contentTransferEncoding = contentTransferEncoding.trim();
                    }
                    InputStream decodedStream = this.boundaryDelimitedStream;
                    if (contentTransferEncoding != null && 0 != contentTransferEncoding.length()) {
                        decodedStream = MimeUtility.decode(decodedStream, contentTransferEncoding);
                    }
                    DataHandler dh = new DataHandler(new ManagedMemoryDataSource(decodedStream, contentType));
                    AttachmentPart ap = new AttachmentPart(dh);
                    if (contentId != null) {
                        ap.setMimeHeader("Content-Id", contentId);
                    }
                    if (contentLocation != null) {
                        ap.setMimeHeader("Content-Location", contentLocation);
                    }
                    Enumeration en = headers.getNonMatchingHeaders(new String[]{"Content-Id", "Content-Location", "Content-Type"});
                    while (en.hasMoreElements()) {
                        Header header = (Header)en.nextElement();
                        String name = header.getName();
                        String value = header.getValue();
                        if (name == null || value == null || (name = name.trim()).length() == 0) continue;
                        ap.addMimeHeader(name, value);
                    }
                    this.addPart(contentId, contentLocation, ap);
                    for (int i = id.length - 1; ret == null && i > -1; --i) {
                        if (contentId != null && id[i].equals(contentId)) {
                            ret = ap;
                            continue;
                        }
                        if (contentLocation == null || !id[i].equals(contentLocation)) continue;
                        ret = ap;
                    }
                    this.boundaryDelimitedStream = this.boundaryDelimitedStream.getNextStream();
                } while (null == ret && null != this.boundaryDelimitedStream);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.attachments.MultiPartRelatedInputStream.readTillFound", "664", this);
            throw WebServicesFault.makeFault(e);
        }
        return ret;
    }

    public String getContentLocation() {
        return this.contentLocation;
    }

    public String getContentId() {
        return this.contentId;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException(Messages.getMessage("streamClosed"));
        }
        if (this.eos) {
            return -1;
        }
        int read = this.soapStream.read(b, off, len);
        if (read < 0) {
            this.eos = true;
        }
        return read;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read() throws IOException {
        if (this.closed) {
            throw new IOException(Messages.getMessage("streamClosed"));
        }
        if (this.eos) {
            return -1;
        }
        int ret = this.soapStream.read();
        if (ret < 0) {
            this.eos = true;
        }
        return ret;
    }
}

