/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.attachments;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.Part;
import com.ibm.ws.webservices.engine.SOAPPart;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.attachments.AttachmentPart;
import com.ibm.ws.webservices.engine.attachments.AttachmentUtils;
import com.ibm.ws.webservices.engine.attachments.Attachments;
import com.ibm.ws.webservices.engine.attachments.DimeBodyPart;
import com.ibm.ws.webservices.engine.attachments.DimeMultiPart;
import com.ibm.ws.webservices.engine.attachments.DimeTypeNameFormat;
import com.ibm.ws.webservices.engine.attachments.ManagedMemoryDataSource;
import com.ibm.ws.webservices.engine.attachments.MimeUtils;
import com.ibm.ws.webservices.engine.attachments.MultiPartDimeInputStream;
import com.ibm.ws.webservices.engine.attachments.MultiPartInputStream;
import com.ibm.ws.webservices.engine.attachments.MultiPartRelatedInputStream;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.utils.WebServicesInputSource;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.internet.MimeMultipart;
import javax.xml.soap.MimeHeaders;
import org.apache.commons.logging.Log;

public class AttachmentsImpl
implements Attachments {
    protected static Log log = LogFactory.getLog(AttachmentsImpl.class.getName());
    private HashMap attachments = new HashMap();
    private LinkedList orderedAttachments = new LinkedList();
    protected SOAPPart soapPart = null;
    protected MultiPartInputStream mpartStream = null;
    protected int sendtype = 1;
    Message msgObj = null;
    Boolean base64Value = null;
    protected String contentLocation = null;
    private HashMap stackDataHandler = new HashMap();
    MimeMultipart multipart = null;
    DimeMultiPart dimemultipart = null;

    public AttachmentsImpl(Object initialContents, String contentType, String contentLocation) throws WebServicesFault {
        this(initialContents, contentType, contentLocation, null);
    }

    public AttachmentsImpl(Object initialContents, String contentType, String contentLocation, Message msg) throws WebServicesFault {
        StringTokenizer st;
        this.msgObj = msg;
        if (contentLocation != null && (contentLocation = contentLocation.trim()).length() == 0) {
            contentLocation = null;
        }
        InputStream is = null;
        if (initialContents instanceof InputStream) {
            is = (InputStream)initialContents;
        } else if (initialContents instanceof WebServicesInputSource) {
            is = ((WebServicesInputSource)initialContents).getByteStream();
        }
        this.contentLocation = contentLocation;
        if (contentType != null && !contentType.equals("  ") && (st = new StringTokenizer(contentType, " \t;")).hasMoreTokens()) {
            String mimetype = st.nextToken();
            if (mimetype.equalsIgnoreCase("multipart/related")) {
                this.sendtype = 2;
                this.mpartStream = new MultiPartRelatedInputStream(contentType, is);
                if (null == contentLocation && (contentLocation = this.mpartStream.getContentLocation()) != null && (contentLocation = contentLocation.trim()).length() == 0) {
                    contentLocation = null;
                }
                this.soapPart = new SOAPPart(this.mpartStream, msg);
            } else if (mimetype.equalsIgnoreCase("application/dime")) {
                try {
                    this.mpartStream = new MultiPartDimeInputStream(is);
                    this.soapPart = new SOAPPart(this.mpartStream, msg);
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.attachments.AttachmentsImpl.AttachmentsImpl", "243", this);
                    throw WebServicesFault.makeFault(e);
                }
                this.sendtype = 3;
            }
        }
    }

    private synchronized boolean isBase64Enabled() {
        boolean retValue;
        if (this.base64Value == null && this.msgObj != null) {
            try {
                Object obj = this.msgObj.getProperty("com.ibm.ws.webservices.useBase64EncodingForNonTextualAttachments");
                if (log.isDebugEnabled()) {
                    log.debug("Retrieved Message object's 'use base64' property: " + (obj != null ? obj.toString() : "<null>"));
                }
                if (obj != null && obj instanceof Boolean) {
                    this.base64Value = (Boolean)obj;
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        boolean bl = retValue = this.base64Value != null ? this.base64Value : false;
        if (log.isDebugEnabled()) {
            log.debug("isBase64Enabled() returning: " + retValue);
        }
        return retValue;
    }

    private void mergeinAttachments() throws WebServicesFault {
        if (this.mpartStream != null) {
            Collection atts = this.mpartStream.getAttachments();
            if (this.contentLocation == null) {
                this.contentLocation = this.mpartStream.getContentLocation();
            }
            this.mpartStream = null;
            this.setAttachmentParts(atts);
        }
    }

    public Part removeAttachmentPart(String reference) throws WebServicesFault {
        this.multipart = null;
        this.dimemultipart = null;
        this.mergeinAttachments();
        Part removedPart = this.getAttachmentByReference(reference);
        if (removedPart != null) {
            this.attachments.remove(removedPart.getContentId());
            this.attachments.remove(removedPart.getContentLocation());
            this.orderedAttachments.remove(removedPart);
        }
        return removedPart;
    }

    public Part addAttachmentPart(Part newPart) throws WebServicesFault {
        Part oldPart;
        this.multipart = null;
        this.dimemultipart = null;
        this.mergeinAttachments();
        String key = newPart.getContentId().trim();
        if (key != null && key.length() > 0 && key.startsWith("<") && key.endsWith(">")) {
            key = key.substring(1, key.length() - 1);
        }
        if ((oldPart = this.attachments.put(key, newPart)) != null) {
            this.orderedAttachments.remove(oldPart);
            this.attachments.remove(oldPart.getContentLocation());
        }
        this.orderedAttachments.add(newPart);
        if (newPart.getContentLocation() != null) {
            this.attachments.put(newPart.getContentLocation(), newPart);
        }
        return oldPart;
    }

    public Part createAttachmentPart(Object dataHandler) throws WebServicesFault {
        return this.createAttachmentPart(dataHandler, null);
    }

    public Part createAttachmentPart(Object datahandler, String contentIdSuffix) throws WebServicesFault {
        Integer key = new Integer(datahandler.hashCode());
        if (this.stackDataHandler.containsKey(key)) {
            return (Part)this.stackDataHandler.get(key);
        }
        this.multipart = null;
        this.dimemultipart = null;
        this.mergeinAttachments();
        if (!(datahandler instanceof DataHandler)) {
            throw new WebServicesFault(Messages.getMessage("unsupportedAttach", datahandler.getClass().getName(), DataHandler.class.getName()));
        }
        AttachmentPart ret = new AttachmentPart((DataHandler)datahandler, contentIdSuffix);
        this.addAttachmentPart(ret);
        this.stackDataHandler.put(key, ret);
        return ret;
    }

    public Part createAttachmentPart(Object datahandler, String contentIdSuffix, String cid) throws WebServicesFault {
        Integer key = new Integer(datahandler.hashCode());
        if (this.stackDataHandler.containsKey(key)) {
            return (Part)this.stackDataHandler.get(key);
        }
        this.multipart = null;
        this.dimemultipart = null;
        this.mergeinAttachments();
        if (!(datahandler instanceof DataHandler)) {
            throw new WebServicesFault(Messages.getMessage("unsupportedAttach", datahandler.getClass().getName(), DataHandler.class.getName()));
        }
        AttachmentPart ret = new AttachmentPart((DataHandler)datahandler, contentIdSuffix, cid);
        this.addAttachmentPart(ret);
        this.stackDataHandler.put(key, ret);
        return ret;
    }

    public void setAttachmentParts(Collection parts) throws WebServicesFault {
        this.removeAllAttachments();
        if (parts != null && !parts.isEmpty()) {
            Iterator i = parts.iterator();
            while (i.hasNext()) {
                Part part = (Part)i.next();
                if (null == part) continue;
                this.addAttachmentPart(part);
            }
        }
    }

    public Part getAttachmentByReference(String reference) throws WebServicesFault {
        if (null == reference) {
            return null;
        }
        if (0 == (reference = reference.trim()).length()) {
            return null;
        }
        this.mergeinAttachments();
        Part ret = (Part)this.attachments.get(reference);
        if (null != ret) {
            return ret;
        }
        if (!reference.startsWith("cid:") && null != this.contentLocation) {
            String fqreference = this.contentLocation;
            if (!fqreference.endsWith("/")) {
                fqreference = fqreference + "/";
            }
            fqreference = reference.startsWith("/") ? fqreference + reference.substring(1) : fqreference + reference;
            ret = (AttachmentPart)this.attachments.get(fqreference);
        }
        if (null == ret && reference.startsWith("cid:")) {
            ret = (Part)this.attachments.get(reference.substring(4));
        }
        return ret;
    }

    public Collection getAttachments() throws WebServicesFault {
        this.mergeinAttachments();
        return new LinkedList(this.orderedAttachments);
    }

    public Part getRootPart() {
        return this.soapPart;
    }

    public void setRootPart(Part newRoot) {
        try {
            this.soapPart = (SOAPPart)newRoot;
            this.multipart = null;
            this.dimemultipart = null;
        }
        catch (ClassCastException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.attachments.AttachmentsImpl.setRootPart", "568", this);
            throw new ClassCastException(Messages.getMessage("onlySOAPParts"));
        }
    }

    public long getContentLength() throws WebServicesFault {
        this.mergeinAttachments();
        int sendtype = this.sendtype == 1 ? 2 : this.sendtype;
        try {
            if (sendtype == 2) {
                if (this.multipart == null) {
                    this.multipart = MimeUtils.createMP(this.isBase64Enabled(), this.soapPart.getAsString(), this.orderedAttachments);
                }
                return MimeUtils.getContentLength(this.multipart);
            }
            if (sendtype == 3) {
                return this.createDimeMessage().getTransmissionSize();
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.attachments.AttachmentsImpl.getContentLength", "596", this);
            throw WebServicesFault.makeFault(e);
        }
        return 0L;
    }

    protected DimeMultiPart createDimeMessage() throws WebServicesFault {
        int sendtype;
        int n = sendtype = this.sendtype == 1 ? 2 : this.sendtype;
        if (sendtype == 3 && this.dimemultipart == null) {
            this.dimemultipart = new DimeMultiPart();
            this.dimemultipart.addBodyPart(new DimeBodyPart(this.soapPart.getAsBytes(), DimeTypeNameFormat.URI, "http://schemas.xmlsoap.org/soap/envelope/", "uuid:714C6C40-4531-442E-A498-3AC614200295"));
            Iterator i = this.orderedAttachments.iterator();
            while (i.hasNext()) {
                AttachmentPart part = (AttachmentPart)i.next();
                DataHandler dh = AttachmentUtils.getActivationDataHandler(part);
                this.dimemultipart.addBodyPart(new DimeBodyPart(dh, part.getContentId()));
            }
        }
        return this.dimemultipart;
    }

    public void writeContentToStream(OutputStream os) throws WebServicesFault {
        int sendtype = this.sendtype == 1 ? 2 : this.sendtype;
        try {
            this.mergeinAttachments();
            if (sendtype == 2) {
                if (this.multipart == null) {
                    this.multipart = MimeUtils.createMP(this.isBase64Enabled(), this.soapPart.getAsString(), this.orderedAttachments);
                }
                MimeUtils.writeToMultiPartStream(os, this.multipart);
            } else if (sendtype == 3) {
                this.createDimeMessage().write(os);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.attachments.AttachmentsImpl.writeContentToStream", "523", this);
            throw WebServicesFault.makeFault(e);
        }
    }

    public String getContentType() throws WebServicesFault {
        int sendtype;
        this.mergeinAttachments();
        int n = sendtype = this.sendtype == 1 ? 2 : this.sendtype;
        if (sendtype == 2) {
            if (this.multipart == null) {
                this.multipart = MimeUtils.createMP(this.isBase64Enabled(), this.soapPart.getAsString(), this.orderedAttachments);
            }
            return MimeUtils.getContentType(this.multipart);
        }
        return "application/dime";
    }

    public int getAttachmentCount() {
        try {
            this.mergeinAttachments();
            return this.orderedAttachments.size();
        }
        catch (WebServicesFault e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.attachments.AttachmentsImpl.getAttachmentCount", "563", this);
            return 0;
        }
    }

    public boolean isAttachment(Object value) {
        return AttachmentUtils.isAttachment(value);
    }

    public void removeAllAttachments() {
        try {
            this.multipart = null;
            this.dimemultipart = null;
            this.mergeinAttachments();
            Iterator i = this.orderedAttachments.iterator();
            while (i.hasNext()) {
                AttachmentPart part = (AttachmentPart)i.next();
                DataHandler dh = AttachmentUtils.getActivationDataHandler(part);
                DataSource ds2 = dh.getDataSource();
                if (ds2 == null || !(ds2 instanceof ManagedMemoryDataSource)) continue;
                ((ManagedMemoryDataSource)ds2).delete();
            }
            this.attachments.clear();
            this.orderedAttachments.clear();
        }
        catch (WebServicesFault af) {
            FFDCFilter.processException((Throwable)af, "com.ibm.ws.webservices.engine.attachments.AttachmentsImpl.removeAllAttachments", "595", this);
            log.warn(Messages.getMessage("exception00"), af);
        }
    }

    public Iterator getAttachments(MimeHeaders headers) {
        Vector<Part> vecParts = new Vector<Part>();
        Iterator iterator = this.attachments.values().iterator();
        while (iterator.hasNext()) {
            Part part = (Part)iterator.next();
            if (!(part instanceof AttachmentPart) || !((AttachmentPart)part).matches(headers)) continue;
            vecParts.add(part);
        }
        return vecParts.iterator();
    }

    public Part createAttachmentPart() throws WebServicesFault {
        return new AttachmentPart();
    }

    public void setSendType(int sendtype) {
        if (sendtype < 1) {
            throw new IllegalArgumentException("");
        }
        if (sendtype > 4) {
            throw new IllegalArgumentException("");
        }
        this.sendtype = sendtype;
    }

    public int getSendType() {
        return this.sendtype;
    }

    public static int getSendType(String value) {
        if (value.equalsIgnoreCase("MIME")) {
            return 2;
        }
        if (value.equalsIgnoreCase("DIME")) {
            return 3;
        }
        if (value.equalsIgnoreCase("NONE")) {
            return 4;
        }
        return 1;
    }

    public static String getSendTypeString(int value) {
        if (value == 2) {
            return "MIME";
        }
        if (value == 3) {
            return "DIME";
        }
        if (value == 4) {
            return "NONE";
        }
        return null;
    }
}

