/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.attachments;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.util.Base64;
import com.ibm.ws.webservices.engine.Part;
import com.ibm.ws.webservices.engine.attachments.ManagedMemoryDataSource;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.SessionUtils;
import com.ibm.ws.webservices.utils.WebServicesInputSource;
import java.awt.Image;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.UnsupportedDataTypeException;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;

public class AttachmentPart
extends javax.xml.soap.AttachmentPart
implements Part {
    protected static Log log = LogFactory.getLog(AttachmentPart.class.getName());
    DataHandler datahandler = null;
    private MimeHeaders mimeHeaders = new MimeHeaders();
    private Object contentObject;
    private String contentIdPartName;

    public AttachmentPart() {
        this.setMimeHeader("Content-Id", SessionUtils.generateSessionId());
    }

    public AttachmentPart(DataHandler dh) {
        this.setMimeHeader("Content-Id", SessionUtils.generateSessionId());
        this.datahandler = dh;
        if (dh != null) {
            this.setMimeHeader("Content-Type", dh.getContentType());
        }
    }

    public AttachmentPart(DataHandler dh, String contentIdPartName) {
        this.setMimeHeader("Content-Id", (contentIdPartName == null ? "" : contentIdPartName + "=") + SessionUtils.generateSessionId());
        this.contentIdPartName = contentIdPartName;
        this.datahandler = dh;
        if (dh != null) {
            this.setMimeHeader("Content-Type", dh.getContentType());
        }
    }

    public AttachmentPart(DataHandler dh, String contentIdPartName, String cid) {
        this.setMimeHeader("Content-Id", (contentIdPartName == null ? "" : contentIdPartName + "=") + (cid == null ? SessionUtils.generateSessionId() : cid));
        this.contentIdPartName = contentIdPartName;
        this.datahandler = dh;
        if (dh != null) {
            this.setMimeHeader("Content-Type", dh.getContentType());
        }
    }

    public DataHandler getActivationDataHandler() {
        return this.datahandler;
    }

    public String getContentType() {
        return this.getFirstMimeHeader("Content-Type");
    }

    public void addMimeHeader(String header, String value) {
        this.mimeHeaders.addHeader(header, value);
    }

    public String getFirstMimeHeader(String header) {
        String[] values = this.mimeHeaders.getHeader(header.toLowerCase());
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    public boolean matches(MimeHeaders headers) {
        Iterator i = headers.getAllHeaders();
        while (i.hasNext()) {
            MimeHeader hdr = (MimeHeader)i.next();
            String[] values = this.mimeHeaders.getHeader(hdr.getName());
            boolean found = false;
            if (values != null) {
                for (int j = 0; j < values.length; ++j) {
                    if (!hdr.getValue().equalsIgnoreCase(values[j])) continue;
                    found = true;
                    break;
                }
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public String getContentLocation() {
        return this.getFirstMimeHeader("Content-Location");
    }

    public void setContentLocation(String loc) {
        this.setMimeHeader("Content-Location", loc);
    }

    public void setContentId(String newCid) {
        this.setMimeHeader("Content-Id", newCid);
    }

    public String getContentId() {
        return this.getFirstMimeHeader("Content-Id");
    }

    public String getContentIdPartName() {
        String contentId;
        int equalsIndex;
        if (this.contentIdPartName == null && (equalsIndex = (contentId = this.getContentId()).indexOf("=")) >= 0) {
            this.contentIdPartName = contentId.substring(0, equalsIndex);
        }
        return this.contentIdPartName;
    }

    public Iterator getMatchingMimeHeaders(String[] match) {
        return this.mimeHeaders.getMatchingHeaders(match);
    }

    public Iterator getNonMatchingMimeHeaders(String[] match) {
        return this.mimeHeaders.getNonMatchingHeaders(match);
    }

    public Iterator getAllMimeHeaders() {
        return this.mimeHeaders.getAllHeaders();
    }

    public void setMimeHeader(String name, String value) {
        if (value != null && value.length() > 0 && value.startsWith("<") && value.endsWith(">")) {
            value = value.substring(1, value.length() - 1);
        }
        this.mimeHeaders.setHeader(name, value);
    }

    public void removeAllMimeHeaders() {
        this.mimeHeaders.removeAllHeaders();
    }

    public void removeMimeHeader(String header) {
        this.mimeHeaders.removeHeader(header);
    }

    public DataHandler getDataHandler() throws SOAPException {
        if (this.datahandler == null) {
            throw new SOAPException(Messages.getMessage("noContent"));
        }
        return this.datahandler;
    }

    public void setDataHandler(DataHandler datahandler) {
        if (datahandler == null) {
            throw new IllegalArgumentException(Messages.getMessage("illegalArgumentException00"));
        }
        this.datahandler = datahandler;
        this.setMimeHeader("Content-Type", datahandler.getContentType());
    }

    public Object getContent() throws SOAPException {
        if (this.contentObject != null) {
            if (log.isDebugEnabled()) {
                log.debug("Using cached content object = " + this.contentObject.getClass().getCanonicalName());
            }
            return this.contentObject;
        }
        if (this.datahandler == null) {
            throw new SOAPException(Messages.getMessage("noContent"));
        }
        try {
            DataSource ds2;
            if (log.isDebugEnabled()) {
                log.debug("Building content object from DataHandler");
            }
            if ((ds2 = this.datahandler.getDataSource()).getContentType().equals("text/plain") || ds2.getContentType().equals("text/html") || ds2.getContentType().equals("text/xml")) {
                InputStream is;
                String content = null;
                byte[] bytes = new byte[]{};
                try {
                    is = null;
                    final DataSource finalds = ds2;
                    is = (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws IOException {
                            return finalds.getInputStream();
                        }
                    });
                    DataInputStream dataIs = new DataInputStream(is);
                    bytes = new byte[dataIs.available()];
                    dataIs.read(bytes);
                    content = new String(bytes);
                }
                catch (PrivilegedActionException e) {
                    FFDCFilter.processException((Throwable)e.getException(), "com.ibm.ws.webservices.engine.attachments.AttachmentPart.getContent", "406", this);
                    log.error(Messages.getMessage("javaIOException00"), e.getException());
                }
                if (ds2.getContentType().equals("text/plain") || ds2.getContentType().equals("text/html")) {
                    if (log.isDebugEnabled()) {
                        log.debug("Content Type = " + ds2.getContentType());
                        log.debug("Content = " + content);
                    }
                    this.contentObject = content;
                    return this.contentObject;
                }
                if (log.isDebugEnabled()) {
                    log.debug("Content Type = " + ds2.getContentType());
                    log.debug("Content is a StreamSource containing= " + content);
                }
                is = new ByteArrayInputStream(bytes);
                StreamSource streamSource = new StreamSource(is);
                return streamSource;
            }
            try {
                if (log.isDebugEnabled()) {
                    log.debug("Content Type = " + ds2.getContentType());
                    log.debug("Using DataHandler.getContent() to get the content");
                }
                return this.datahandler.getContent();
            }
            catch (UnsupportedDataTypeException e) {
                if (log.isDebugEnabled()) {
                    log.debug("The DataHandler can't get the content.  Fallback to the DataHandler InputStream as indicated by the SAAJ specification.");
                }
                return ds2.getInputStream();
            }
        }
        catch (IOException io) {
            FFDCFilter.processException((Throwable)io, "com.ibm.ws.webservices.engine.attachments.AttachmentPart.getContent", "409", this);
            log.error(Messages.getMessage("javaIOException00"), io);
            return null;
        }
    }

    public void setContent(Object object, String contentType) {
        if (log.isDebugEnabled()) {
            String cls = object == null ? null : object.getClass().getCanonicalName();
            log.debug("content = " + cls);
            log.debug("contentType = " + contentType);
        }
        InputStream inStream = null;
        if (object instanceof String) {
            inStream = new ByteArrayInputStream(((String)object).getBytes());
        } else if (object instanceof byte[]) {
            inStream = new ByteArrayInputStream((byte[])object);
        } else if (object instanceof InputStream) {
            inStream = (InputStream)object;
        } else if (object instanceof StreamSource) {
            inStream = ((StreamSource)object).getInputStream();
        }
        try {
            if (inStream != null) {
                ManagedMemoryDataSource mmds = new ManagedMemoryDataSource(inStream, contentType);
                this.datahandler = new DataHandler(mmds);
            } else {
                this.datahandler = new DataHandler(object, contentType);
            }
            this.contentObject = contentType != null && (contentType.equals("text/plain") || contentType.equals("text/html")) ? (object instanceof String ? object : null) : (contentType != null && contentType.equals("text/xml") ? null : (contentType != null && (contentType.equals("image/jpeg") || contentType.equals("image/gif")) ? (object instanceof Image ? object : null) : null));
            this.removeMimeHeader("Content-Type");
            this.setMimeHeader("Content-Type", contentType);
        }
        catch (IOException io) {
            FFDCFilter.processException((Throwable)io, "com.ibm.ws.webservices.engine.attachments.AttachmentPart.setContent", "414", this);
            log.error(Messages.getMessage("javaIOException00"), io);
            throw new IllegalArgumentException(Messages.getMessage("illegalArgumentException00"));
        }
        if (this.contentObject == null && this.datahandler == null) {
            throw new IllegalArgumentException(Messages.getMessage("illegalArgumentException00"));
        }
    }

    public void clearContent() {
        this.datahandler = null;
        this.contentObject = null;
    }

    public int getSize() throws SOAPException {
        if (this.datahandler == null) {
            return 0;
        }
        ByteBuffer bout = new ByteBuffer();
        try {
            this.datahandler.writeTo(bout);
        }
        catch (IOException ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.webservices.engine.attachments.AttachmentPart.getSize", "463", this);
            log.error(Messages.getMessage("javaIOException00"), ex);
            throw new SOAPException(Messages.getMessage("javaIOException01", ex.getMessage()), (Throwable)ex);
        }
        byte[] bytes = bout.getBytes();
        if (bytes != null) {
            return bytes.length;
        }
        return -1;
    }

    public String[] getMimeHeader(String name) {
        return this.mimeHeaders.getHeader(name);
    }

    public String getContentIdRef() {
        return "cid:" + this.getContentId();
    }

    public InputStream getBase64Content() throws SOAPException {
        byte[] b = this.getRawContentBytes();
        String text = Base64.encode(b);
        ByteArrayInputStream is = new ByteArrayInputStream(text.getBytes());
        return is;
    }

    public void setBase64Content(InputStream content, String contentType) throws SOAPException {
        if (content == null) {
            throw new SOAPException(Messages.getMessage("null00", "content"));
        }
        try {
            WebServicesInputSource wsis = WebServicesInputSource.create(content);
            String text = wsis.getString();
            byte[] b = Base64.decode(text);
            this.setRawContentBytes(b, 0, b.length, contentType);
        }
        catch (IllegalArgumentException e) {
            throw new SOAPException((Throwable)e);
        }
    }

    public InputStream getRawContent() throws SOAPException {
        if (this.datahandler == null) {
            throw new SOAPException(Messages.getMessage("internalAttachErr", this.getContentId()));
        }
        try {
            InputStream is = this.datahandler.getInputStream();
            return is;
        }
        catch (Exception io) {
            throw new SOAPException((Throwable)io);
        }
    }

    public void setRawContent(InputStream content, String contentType) throws SOAPException {
        if (content == null) {
            throw new SOAPException(Messages.getMessage("null00", "content"));
        }
        this.setContent(content, contentType);
    }

    public byte[] getRawContentBytes() throws SOAPException {
        InputStream is = this.getRawContent();
        WebServicesInputSource wsis = WebServicesInputSource.create(is);
        return wsis.getBytes();
    }

    public void setRawContentBytes(byte[] content, int offset, int len, String contentType) throws SOAPException {
        ByteArrayInputStream bais = new ByteArrayInputStream(content, offset, len);
        this.setRawContent(bais, contentType);
    }

    private class ByteBuffer
    extends ByteArrayOutputStream {
        private ByteBuffer() {
        }

        byte[] getBytes() {
            return super.toByteArray();
        }
    }
}

