/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.attachments;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import java.io.File;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;

final class AttachmentCacheMonitor {
    static Log log = LogFactory.getLog(AttachmentCacheMonitor.class.getName());
    private int ATTACHMENT_TIMEOUT_SECONDS = 0;
    private int REFRESH_SECONDS = 0;
    public static final String ATTACHMENT_TIMEOUT_PROPERTY = "com.ibm.websphere.webservices.attachment.tempfile.expiration";
    private HashMap files = new HashMap();
    private Long priorDeleteMillis = this.getTime();
    private Timer timer = null;
    private static AttachmentCacheMonitor _singleton = null;

    public static synchronized AttachmentCacheMonitor getAttachmentCacheMonitor() {
        if (_singleton == null) {
            _singleton = new AttachmentCacheMonitor();
        }
        return _singleton;
    }

    private AttachmentCacheMonitor() {
        try {
            this.ATTACHMENT_TIMEOUT_SECONDS = Integer.valueOf(System.getProperty(ATTACHMENT_TIMEOUT_PROPERTY, "0"));
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, "com.ibm.ws.webservices.engine.attachments.AttachmentCacheMonitor", "128", this);
        }
        this.REFRESH_SECONDS = this.ATTACHMENT_TIMEOUT_SECONDS / 2;
        if (log.isDebugEnabled()) {
            log.debug("Custom Property Key=  com.ibm.websphere.webservices.attachment.tempfile.expiration");
            log.debug("   Value = " + this.ATTACHMENT_TIMEOUT_SECONDS);
        }
        if (this.REFRESH_SECONDS > 0) {
            this.timer = new Timer(true);
            this.timer.schedule((TimerTask)new CleanupFilesTask(), this.REFRESH_SECONDS * 1000, (long)(this.REFRESH_SECONDS * 1000));
        }
    }

    public void register(String fileName) {
        if (this.ATTACHMENT_TIMEOUT_SECONDS > 0) {
            this._register(fileName);
            this._checkForAgedFiles();
        }
    }

    public void access(String fileName) {
        if (this.ATTACHMENT_TIMEOUT_SECONDS > 0) {
            this._access(fileName);
            this._checkForAgedFiles();
        }
    }

    public void checkForAgedFiles() {
        if (this.ATTACHMENT_TIMEOUT_SECONDS > 0) {
            this._checkForAgedFiles();
        }
    }

    private synchronized void _register(String fileName) {
        Long currentTime = this.getTime();
        if (log.isDebugEnabled()) {
            log.debug("Register file " + fileName);
            log.debug("Time = " + currentTime);
        }
        this.files.put(fileName, currentTime);
    }

    private synchronized void _access(String fileName) {
        Long currentTime = this.getTime();
        Long priorTime = (Long)this.files.get(fileName);
        if (priorTime != null) {
            this.files.put(fileName, currentTime);
            if (log.isDebugEnabled()) {
                log.debug("Access file " + fileName);
                log.debug("Old Time = " + priorTime);
                log.debug("New Time = " + currentTime);
            }
        } else if (log.isDebugEnabled()) {
            log.debug("The following file was already deleted and is no longer available: " + fileName);
            log.debug("The value of com.ibm.websphere.webservices.attachment.tempfile.expiration is " + this.ATTACHMENT_TIMEOUT_SECONDS);
        }
    }

    private synchronized void _checkForAgedFiles() {
        Long currentTime = this.getTime();
        if (this.isExpired(this.priorDeleteMillis, currentTime, this.REFRESH_SECONDS)) {
            Iterator it = this.files.keySet().iterator();
            while (it.hasNext()) {
                String fileName = (String)it.next();
                Long lastAccess = (Long)this.files.get(fileName);
                if (!this.isExpired(lastAccess, currentTime, this.ATTACHMENT_TIMEOUT_SECONDS)) continue;
                if (log.isDebugEnabled()) {
                    log.debug("Expired file " + fileName);
                    log.debug("Old Time = " + lastAccess);
                    log.debug("New Time = " + currentTime);
                    log.debug("Elapsed Time (ms) = " + (currentTime - lastAccess));
                }
                this.deleteFile(fileName);
                it.remove();
            }
            this.priorDeleteMillis = currentTime;
        }
    }

    private boolean deleteFile(final String fileName) {
        Boolean privRet = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return AttachmentCacheMonitor.this._deleteFile(fileName);
            }
        });
        return privRet;
    }

    private Boolean _deleteFile(String fileName) {
        boolean ret = false;
        File file = new File(fileName);
        if (file.exists()) {
            ret = file.delete();
            if (log.isDebugEnabled()) {
                log.debug("Deletion Successful ? " + ret);
            }
        } else if (log.isDebugEnabled()) {
            log.debug("This file no longer exists = " + fileName);
        }
        return new Boolean(ret);
    }

    private Long getTime() {
        return new Long(System.currentTimeMillis());
    }

    private boolean isExpired(Long oldTimeMillis, Long newTimeMillis, int thresholdSecs) {
        long elapse = newTimeMillis - oldTimeMillis;
        return elapse > (long)(thresholdSecs * 1000);
    }

    public static void main(String[] arg) throws Exception {
        long INTERVAL = 15000L;
        if (log.isDebugEnabled()) {
            log.debug("AttachmentCacheMonitor Test ");
        }
        Thread t = Thread.currentThread();
        AttachmentCacheMonitor acm = AttachmentCacheMonitor.getAttachmentCacheMonitor();
        File aFile = new File("A");
        aFile.createNewFile();
        String aFileName = aFile.getCanonicalPath();
        acm.register(aFileName);
        Thread.sleep(INTERVAL);
        File bFile = new File("B");
        bFile.createNewFile();
        String bFileName = bFile.getCanonicalPath();
        acm.register(bFileName);
        Thread.sleep(INTERVAL);
        acm.access(aFileName);
        Thread.sleep(INTERVAL);
        acm.access(bFileName);
        Thread.sleep(INTERVAL);
        File cFile = new File("C");
        cFile.createNewFile();
        String cFileName = cFile.getCanonicalPath();
        acm.register(cFileName);
        acm.access(bFileName);
        Thread.sleep(INTERVAL);
        acm.checkForAgedFiles();
        Thread.sleep(10L * INTERVAL);
    }

    private class CleanupFilesTask
    extends TimerTask {
        private CleanupFilesTask() {
        }

        public void run() {
            AttachmentCacheMonitor.this.checkForAgedFiles();
        }
    }
}

