/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine;

import com.ibm.websphere.webservices.soap.IBMSOAPMessage;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.Part;
import com.ibm.ws.webservices.engine.SOAPPart;
import com.ibm.ws.webservices.engine.WebServicesEngine;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.attachments.Attachments;
import com.ibm.ws.webservices.engine.attachments.AttachmentsImpl;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.enum.MessageType;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.ClassUtils;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPConstants;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPEnvelope;
import com.ibm.ws.webservices.utils.WebServicesInputSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import org.apache.commons.logging.Log;

public class Message
extends IBMSOAPMessage
implements Serializable {
    protected static Log log = LogFactory.getLog(Message.class.getName());
    public static final String USE_BASE64_ENCODED_FOR_NON_TEXTUAL_ATTACHMENTS = "com.ibm.ws.webservices.useBase64EncodingForNonTextualAttachments";
    public static final String MIME_MULTIPART_RELATED = "multipart/related";
    public static final String MIME_APPLICATION_DIME = "application/dime";
    public static final String DEFAULT_ATTACHMENT_IMPL;
    public static final String DEFAULT_ATTACHMNET_IMPL;
    private static String mAttachmentsImplClassName;
    public static final String MIME_UNKNOWN = "  ";
    private com.ibm.ws.webservices.engine.enumtype.MessageType messageType = com.ibm.ws.webservices.engine.enumtype.MessageType.UNKNOWN;
    private SOAPPart mSOAPPart;
    SOAPConstants sc;
    private Attachments mAttachments = null;
    private MimeHeaders headers;
    private boolean saveRequired = true;
    private Properties properties = new Properties();
    private String charsetEncoding = "utf-8";
    private boolean writeXmlDeclaration = false;
    private MessageContext msgContext;
    private static Class attachImpl;
    private static Constructor attachImplConstr;
    private static boolean checkForAttchmentSupport;
    private static boolean attachmentSupportEnabled;

    public static String getAttachmentImplClassName() {
        return mAttachmentsImplClassName;
    }

    public com.ibm.ws.webservices.engine.enumtype.MessageType getMessageType() {
        return this.messageType;
    }

    public void setMessageType(com.ibm.ws.webservices.engine.enumtype.MessageType messageType) {
        this.messageType = messageType;
    }

    public void setMessageType(MessageType messageType) {
        if (messageType.getName().equals("unknown")) {
            this.messageType = com.ibm.ws.webservices.engine.enumtype.MessageType.UNKNOWN;
        }
        if (messageType.getName().equals("request")) {
            this.messageType = com.ibm.ws.webservices.engine.enumtype.MessageType.REQUEST;
        }
        if (messageType.getName().equals("response")) {
            this.messageType = com.ibm.ws.webservices.engine.enumtype.MessageType.RESPONSE;
        }
    }

    public MessageContext getMessageContext() {
        return this.msgContext;
    }

    public void setMessageContext(MessageContext msgContext) {
        this.msgContext = msgContext;
        msgContext.setCharacterEncoding(this.charsetEncoding);
    }

    public Message(Object initialContents) {
        this(initialContents, (SOAPConstants)null);
    }

    public Message(Object initialContents, SOAPConstants soapConstants) {
        this.sc = soapConstants;
        this.sc = this.sc == null ? SOAPConstants.SOAP11_CONSTANTS : this.sc;
        this.setup(initialContents, null, null, null);
    }

    public Message(Object initialContents, MimeHeaders headers) {
        this(initialContents, headers, null);
    }

    public Message(Object initialContents, MimeHeaders headers, SOAPConstants soapConstants) {
        this.sc = soapConstants;
        this.sc = this.sc == null ? SOAPConstants.SOAP11_CONSTANTS : this.sc;
        this.setup(initialContents, null, null, headers);
    }

    public Message(Object initialContents, String contentType, String contentLocation) {
        this(initialContents, contentType, contentLocation, null);
    }

    public Message(Object initialContents, String contentType, String contentLocation, SOAPConstants soapConstants) {
        this.sc = soapConstants;
        this.sc = this.sc == null ? SOAPConstants.SOAP11_CONSTANTS : this.sc;
        this.setup(initialContents, contentType, contentLocation, null);
    }

    private static synchronized boolean isAttachmentSupportEnabled(MessageContext mc) {
        if (checkForAttchmentSupport) {
            checkForAttchmentSupport = false;
            try {
                WebServicesEngine ae;
                String attachImpName = "com.ibm.ws.webservices.engine.attachments.AttachmentsImpl";
                if (null != mc && null != (ae = mc.getEngine())) {
                    attachImpName = (String)ae.getOption("attachments.implementation");
                }
                if (null == attachImpName) {
                    attachImpName = "com.ibm.ws.webservices.engine.attachments.AttachmentsImpl";
                }
                ClassUtils.forName("javax.activation.DataHandler");
                ClassUtils.forName("javax.mail.internet.MimeMultipart");
                attachImpl = ClassUtils.forName(attachImpName);
                mAttachmentsImplClassName = attachImpl.getName();
                attachImplConstr = attachImpl.getConstructors()[0];
                attachmentSupportEnabled = true;
            }
            catch (ClassNotFoundException ex) {
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
            log.debug(Messages.getMessage("attachEnabled") + MIME_UNKNOWN + attachmentSupportEnabled);
        }
        return attachmentSupportEnabled;
    }

    private void setup(Object initialContents, String contentType, String contentLocation, MimeHeaders mimeHeaders) {
        if (initialContents instanceof InputStream) {
            initialContents = WebServicesInputSource.create((InputStream)initialContents);
        } else if (initialContents instanceof byte[]) {
            initialContents = WebServicesInputSource.create((byte[])initialContents);
        } else if (initialContents instanceof String) {
            initialContents = WebServicesInputSource.create((String)initialContents);
        }
        if (contentType == null && mimeHeaders != null) {
            String[] contentTypes = mimeHeaders.getHeader("Content-Type");
            String string = contentType = contentTypes != null ? contentTypes[0] : null;
        }
        if (contentLocation == null && mimeHeaders != null) {
            String[] contentLocations = mimeHeaders.getHeader("Content-Location");
            String string = contentLocation = contentLocations != null ? contentLocations[0] : null;
        }
        if (contentType != null) {
            String low = contentType.toLowerCase();
            String marker = "charset=";
            int idx = low.indexOf("charset=");
            if (idx > 0) {
                if ((idx = (low = low.substring(idx + "charset=".length())).indexOf("utf-8")) == 0 || idx == 1) {
                    this.setCharacterEncoding("utf-8");
                }
                if ((idx = low.indexOf("utf-16")) == 0 || idx == 1) {
                    this.setCharacterEncoding("utf-16");
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Message.setup() CharacterEncoding=" + this.getCharacterEncoding());
            log.debug("Message.setup() contentType=" + contentType);
        }
        if (Message.isAttachmentSupportEnabled(this.getMessageContext())) {
            if (attachImpl.equals(AttachmentsImpl.class)) {
                try {
                    this.mAttachments = new AttachmentsImpl(initialContents, contentType, contentLocation, this);
                }
                catch (WebServicesFault wsf) {
                    FFDCFilter.processException((Throwable)wsf, "com.ibm.ws.webservices.engine.Message.setup", "369", this);
                    log.fatal(Messages.getMessage("invocationTargetException00"), wsf);
                    throw new RuntimeException(wsf.getMessage());
                }
                this.mSOAPPart = (SOAPPart)this.mAttachments.getRootPart();
            } else {
                try {
                    Object contentsForAttachments = initialContents;
                    if (initialContents instanceof WebServicesInputSource) {
                        contentsForAttachments = ((WebServicesInputSource)initialContents).getByteStream();
                    }
                    this.mAttachments = (Attachments)attachImplConstr.newInstance(initialContents, contentType, contentLocation);
                    this.mSOAPPart = (SOAPPart)this.mAttachments.getRootPart();
                }
                catch (InvocationTargetException ex) {
                    FFDCFilter.processException((Throwable)ex, "com.ibm.ws.webservices.engine.Message.setup", "360", this);
                    log.fatal(Messages.getMessage("invocationTargetException00"), ex);
                    throw new RuntimeException(ex.getMessage());
                }
                catch (InstantiationException ex) {
                    FFDCFilter.processException((Throwable)ex, "com.ibm.ws.webservices.engine.Message.setup", "365", this);
                    log.fatal(Messages.getMessage("instantiationException00"), ex);
                    throw new RuntimeException(ex.getMessage());
                }
                catch (IllegalAccessException ex) {
                    FFDCFilter.processException((Throwable)ex, "com.ibm.ws.webservices.engine.Message.setup", "370", this);
                    log.fatal(Messages.getMessage("illegalAccessException00"), ex);
                    throw new RuntimeException(ex.getMessage());
                }
            }
        }
        if (null == this.mSOAPPart) {
            this.mSOAPPart = new SOAPPart(initialContents, this);
        }
        this.mSOAPPart.setMessage(this);
        if (this.mAttachments != null) {
            this.mAttachments.setRootPart(this.mSOAPPart);
        }
        this.headers = mimeHeaders == null ? new MimeHeaders() : mimeHeaders;
    }

    public javax.xml.soap.SOAPPart getSOAPPart() {
        return this.mSOAPPart;
    }

    public String getSOAPPartAsString() throws WebServicesFault {
        return this.mSOAPPart.getAsString();
    }

    public byte[] getSOAPPartAsBytes() throws WebServicesFault {
        return this.mSOAPPart.getAsBytes();
    }

    public SOAPEnvelope getSOAPEnvelope() throws WebServicesFault {
        return this.mSOAPPart.getAsSOAPEnvelope();
    }

    public Attachments getAttachmentsImpl() {
        return this.mAttachments;
    }

    public String getContentType(SOAPConstants sc) throws WebServicesFault {
        int sendType = 1;
        if (this.msgContext != null && this.msgContext.getPortDesc() != null) {
            sendType = this.msgContext.getPortDesc().getSendType();
        }
        if (sendType != 4) {
            this.mSOAPPart.getAsWebServicesInputSource();
        }
        String ret = sc.getContentType();
        ret = ret + "charset=" + this.getCharacterEncoding();
        if (this.mAttachments != null && 0 != this.mAttachments.getAttachmentCount()) {
            ret = this.mAttachments.getContentType();
        }
        return ret;
    }

    public String getContentType() throws WebServicesFault {
        return this.getContentType(this.sc);
    }

    SOAPConstants getSOAPConstants() {
        return this.sc;
    }

    void setSOAPConstants(SOAPConstants sc) {
        this.sc = sc;
    }

    public long getContentLength() throws WebServicesFault {
        return this.mAttachments != null && 0 < this.mAttachments.getAttachmentCount() ? this.mAttachments.getContentLength() : (long)this.mSOAPPart.getContentLength();
    }

    public long getOriginalContentLength() throws WebServicesFault {
        return this.mAttachments != null && 0 < this.mAttachments.getAttachmentCount() ? this.mAttachments.getContentLength() : this.mSOAPPart.getOriginalContentLength();
    }

    public void writeTo(OutputStream os) throws SOAPException, IOException {
        if (this.mAttachments == null || 0 == this.mAttachments.getAttachmentCount()) {
            try {
                this.mSOAPPart.writeTo(os, this.getCharacterEncoding());
            }
            catch (IOException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.Message.writeTo", "481", this);
                log.error(Messages.getMessage("javaIOException00"), e);
            }
        } else {
            try {
                this.mAttachments.writeContentToStream(os);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.Message.writeTo", "488", this);
                log.error(Messages.getMessage("exception00"), e);
            }
        }
    }

    public void writeTo(OutputStream os, String contentType) throws SOAPException, IOException {
        if (contentType != null && contentType.length() > 0 && this.mAttachments != null && this.mAttachments.getAttachmentCount() > 0) {
            String ct = "Content-Type: " + contentType + "\n\n";
            try {
                OutputStreamWriter writer = new OutputStreamWriter(os, this.getCharacterEncoding());
                writer.write(ct, 0, ct.length());
                writer.flush();
            }
            catch (IOException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.Message.writeTo", "572", this);
                log.error(Messages.getMessage("javaIOException00"), e);
            }
        }
        this.writeTo(os);
    }

    public String getContentDescription() {
        String[] values = this.headers.getHeader("Content-Description");
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    public void setContentDescription(String description) {
        this.headers.setHeader("Content-Description", description);
    }

    public void saveChanges() throws SOAPException {
        if (this.mAttachments != null && 0 < this.mAttachments.getAttachmentCount()) {
            try {
                this.headers.setHeader("Content-Type", this.mAttachments.getContentType());
            }
            catch (WebServicesFault wsf) {
                FFDCFilter.processException((Throwable)wsf, "com.ibm.ws.webservices.engine.Message.saveChanges", "576", this);
                log.error(Messages.getMessage("exception00"), wsf);
            }
        }
        this.saveRequired = false;
    }

    public boolean saveRequired() {
        return this.saveRequired;
    }

    public MimeHeaders getMimeHeaders() {
        if (this.mAttachments != null && 0 != this.mAttachments.getAttachmentCount()) {
            try {
                this.headers.setHeader("Content-Type", this.mAttachments.getContentType());
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, "com.ibm.ws.webservices.engine.Message.getMimeHeaders", "608", this);
                log.debug("can not get the content type for the attachment", ex);
            }
        }
        return this.headers;
    }

    public void removeAllAttachments() {
        this.mAttachments.removeAllAttachments();
    }

    public int countAttachments() {
        return this.mAttachments == null ? 0 : this.mAttachments.getAttachmentCount();
    }

    public Iterator getAttachments() {
        try {
            return this.mAttachments.getAttachments().iterator();
        }
        catch (WebServicesFault af) {
            FFDCFilter.processException((Throwable)af, "com.ibm.ws.webservices.engine.Message.getAttachments", "601", this);
            log.error(Messages.getMessage("exception00"), af);
            return null;
        }
    }

    public Iterator getAttachments(MimeHeaders headers) {
        return this.mAttachments.getAttachments(headers);
    }

    public void addAttachmentPart(AttachmentPart attachmentpart) {
        try {
            this.mAttachments.addAttachmentPart((Part)attachmentpart);
        }
        catch (WebServicesFault af) {
            FFDCFilter.processException((Throwable)af, "com.ibm.ws.webservices.engine.Message.addAttachmentPart", "636", this);
            log.error(Messages.getMessage("exception00"), af);
        }
    }

    public AttachmentPart createAttachmentPart() {
        try {
            return (AttachmentPart)this.mAttachments.createAttachmentPart();
        }
        catch (WebServicesFault af) {
            FFDCFilter.processException((Throwable)af, "com.ibm.ws.webservices.engine.Message.createAttachmentPart", "655", this);
            log.error(Messages.getMessage("exception00"), af);
            return null;
        }
    }

    public String getCharacterEncoding() {
        String enc;
        if (this.msgContext != null && (enc = this.msgContext.getCharacterEncoding()) != null) {
            this.charsetEncoding = enc;
        }
        return this.charsetEncoding;
    }

    public void setCharacterEncoding(String value) {
        if (value != null) {
            char ch = value.charAt(0);
            if (ch == '\'' || ch == '\"') {
                if (value.length() > 2) {
                    value = value.substring(1, value.length() - 1);
                } else {
                    throw new IllegalArgumentException(Messages.getMessage("invalidCharacterEncoding"));
                }
            }
            this.charsetEncoding = value;
            if (this.msgContext != null) {
                this.msgContext.setCharacterEncoding(this.charsetEncoding);
            }
        }
    }

    public boolean shouldWriteXMLDecl() {
        return this.writeXmlDeclaration;
    }

    public void setShouldWriteXMLDecl(String value) {
        this.writeXmlDeclaration = Boolean.valueOf(value);
    }

    public Object getProperty(String property) throws SOAPException {
        if (property.equals("javax.xml.soap.character-set-encoding")) {
            return this.getCharacterEncoding();
        }
        if (property.equals("javax.xml.soap.write-xml-declaration")) {
            return this.shouldWriteXMLDecl() ? "true" : "false";
        }
        return this.properties.get(property);
    }

    public void setProperty(String property, Object value) throws SOAPException {
        if (property.equals("javax.xml.soap.write-xml-declaration")) {
            if (!value.equals("true") && !value.equals("false")) {
                throw new SOAPException(Messages.getMessage("invalidSOAPMessageProperty01"));
            }
            this.setShouldWriteXMLDecl((String)value);
        } else if (property.equals("javax.xml.soap.character-set-encoding")) {
            this.setCharacterEncoding((String)value);
        } else {
            this.properties.put(property, value);
        }
    }

    public void ifFaultThrowSelf() throws WebServicesFault {
        WebServicesFault fault = null;
        try {
            fault = this.getFault();
        }
        catch (SOAPException se) {
            FFDCFilter.processException((Throwable)se, "com.ibm.ws.webservices.engine.Message.ifFaultThrowSelf", "722", null);
            throw WebServicesFault.makeFault(se);
        }
        catch (IOException ioe) {
            FFDCFilter.processException((Throwable)ioe, "com.ibm.ws.webservices.engine.Message.ifFaultThrowSelf", "757", null);
            throw WebServicesFault.makeFault(ioe);
        }
        if (fault != null) {
            throw fault;
        }
    }

    public WebServicesFault getFault() throws SOAPException, IOException {
        return this.mSOAPPart.getFault();
    }

    public AttachmentPart getAttachment(SOAPElement element) throws SOAPException {
        String ref = element.getAttribute("href");
        System.out.println("href value=" + ref);
        if (ref == null || ref.length() == 0) {
            ref = element.getValue();
        }
        System.out.println("ref=" + ref);
        Part p = null;
        try {
            p = this.mAttachments.getAttachmentByReference(ref);
        }
        catch (WebServicesFault wsf) {
            FFDCFilter.processException((Throwable)wsf, "com.ibm.ws.webservices.engine.Message.getAttachment", "1041", this);
            throw new SOAPException(wsf.getMessage());
        }
        return (AttachmentPart)p;
    }

    public void removeAttachments(MimeHeaders headers) {
        Iterator it = this.getAttachments();
        while (it != null && it.hasNext()) {
            AttachmentPart ap = (AttachmentPart)it.next();
            boolean match = true;
            Iterator it2 = headers.getAllHeaders();
            while (it2 != null && it2.hasNext() && match) {
                MimeHeader header = (MimeHeader)it2.next();
                String[] values = ap.getMimeHeader(header.getName());
                if (values == null || values.length == 0) {
                    match = false;
                    continue;
                }
                boolean valueMatch = false;
                for (int i = 0; i < values.length && !valueMatch; ++i) {
                    valueMatch = header.getValue().equals(values[i]);
                }
                if (valueMatch) continue;
                match = false;
            }
            if (!match) continue;
            try {
                Part removeAp = this.mAttachments.removeAttachmentPart(ap.getContentId());
            }
            catch (WebServicesFault wsf) {
                FFDCFilter.processException((Throwable)wsf, "com.ibm.ws.webservices.engine.Message.removeAttachments", "1074", this);
                throw new RuntimeException(wsf.getMessage());
            }
        }
    }

    static {
        DEFAULT_ATTACHMNET_IMPL = DEFAULT_ATTACHMENT_IMPL = AttachmentsImpl.class.getName();
        mAttachmentsImplClassName = DEFAULT_ATTACHMENT_IMPL;
        attachImpl = null;
        attachImplConstr = null;
        checkForAttchmentSupport = true;
        attachmentSupportEnabled = false;
    }
}

