/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.enabler;

import com.ibm.etools.commonarchive.CommonarchiveFactory;
import com.ibm.etools.commonarchive.EJBJarFile;
import com.ibm.etools.commonarchive.impl.CommonarchiveFactoryImpl;
import com.ibm.etools.webservice.wsbnd.RouterModule;
import com.ibm.etools.webservice.wsbnd.WSBinding;
import com.ibm.etools.webservice.wsbnd.WsbndFactory;
import com.ibm.ws.webservices.enabler.resources.Messages;
import com.ibm.wsspi.webservices.models.WSModels;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServices;

public class Utils {
    private static WsbndFactory wsbndFactory = null;
    public static boolean verbose = false;

    public static File getFileFromName(String fileName) throws IOException {
        if (fileName == null) {
            return null;
        }
        File file = new File(fileName);
        if (!file.exists()) {
            file = null;
            InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName);
            if (in != null) {
                int tempByte;
                File tempFile = File.createTempFile(fileName, null);
                FileOutputStream fos = new FileOutputStream(tempFile);
                while ((tempByte = in.read()) != -1) {
                    fos.write(tempByte);
                }
                fos.close();
                in.close();
                file = tempFile;
            }
        }
        return file;
    }

    public static String getStringInputWithDefaults(BufferedReader bufIn, String prompt) throws IOException {
        String response = null;
        while (response == null) {
            System.out.print(prompt);
            response = bufIn.readLine();
        }
        return response;
    }

    public static File getReadFileInput(BufferedReader bufIn, String prompt) throws IOException {
        String responseStr = null;
        File response = null;
        while (response == null) {
            System.out.print(prompt);
            responseStr = bufIn.readLine();
            if (responseStr == null || (response = new File(responseStr)).exists() && response.isFile()) continue;
            System.err.println(Messages.getString((String)"enabler.enterexistingfile", (String)"Please enter the name of an existing file."));
            response = null;
        }
        return response;
    }

    public static String getSpaceSeparatedString(Collection collection) {
        StringBuffer strBuf = new StringBuffer();
        if (collection != null) {
            String[] tokens = collection.toArray(new String[0]);
            for (int i = 0; i < tokens.length; ++i) {
                strBuf.append((i > 0 ? " " : "") + tokens[i]);
            }
        }
        return strBuf.toString();
    }

    public static void backupEar(String earFileName) throws IOException {
        int amtToWrite;
        Object[] inserts = new String[]{earFileName};
        System.out.print("\n");
        System.out.println(Messages.getFormattedMessage((String)"enabler.utils.backingupear", (Object[])inserts, (String)"WSWS2003I: Backing up EAR file to: {0}~"));
        System.out.print("\n");
        File earInputFile = new File(earFileName);
        File earBackupFile = new File(earInputFile.getAbsolutePath() + "~");
        FileInputStream reader = new FileInputStream(earInputFile);
        FileOutputStream writer = new FileOutputStream(earBackupFile);
        BufferedInputStream bufReader = new BufferedInputStream(reader);
        BufferedOutputStream bufWriter = new BufferedOutputStream(writer);
        byte[] data = new byte[1024];
        while ((amtToWrite = bufReader.read(data, 0, 1024)) != -1) {
            bufWriter.write(data, 0, amtToWrite);
        }
        bufWriter.close();
        bufReader.close();
    }

    public static WSBinding getWSBinding(EJBJarFile ejbJar) throws Exception {
        return WSModels.getWSBinding(ejbJar.getLoadStrategy(), "META-INF/ibm-webservices-bnd.xmi");
    }

    public static WSBinding createWSBinding(EJBJarFile ejbJar) throws Exception {
        URI uri;
        WSBinding wsbnd = null;
        LoadStrategy loadStrategy = ejbJar.getLoadStrategy();
        String xmiFileName = "META-INF/ibm-webservices-bnd.xmi";
        ResourceSet rs = loadStrategy.getResourceSet();
        Resource res = rs.getResource(uri = URI.createURI(xmiFileName), false);
        if (res == null) {
            res = rs.createResource(uri);
        }
        wsbnd = wsbndFactory.createWSBinding();
        res.getContents().add(0, wsbnd);
        return wsbnd;
    }

    public static WebServices getWebServices(EJBJarFile ejbJar) throws Exception {
        return WSModels.getWebServices(ejbJar.getLoadStrategy(), "META-INF/webservices.xml");
    }

    public static void addRouterToWSBinding(WSBinding wsbnd, String routerName, String transport) {
        RouterModule rm = wsbndFactory.createRouterModule();
        rm.setName(routerName);
        rm.setTransport(transport);
        EList rmList = wsbnd.getRouterModules();
        rmList.add(rm);
    }

    public static CommonarchiveFactory getArchiveFactory() {
        return CommonarchiveFactoryImpl.getActiveFactory();
    }

    static {
        WSModels.init();
        wsbndFactory = WsbndFactory.eINSTANCE;
    }
}

