/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.enabler;

import com.ibm.ejs.models.base.bindings.applicationbnd.AllAuthenticatedUsers;
import com.ibm.ejs.models.base.bindings.applicationbnd.ApplicationBinding;
import com.ibm.ejs.models.base.bindings.applicationbnd.ApplicationbndFactory;
import com.ibm.ejs.models.base.bindings.applicationbnd.AuthorizationTable;
import com.ibm.ejs.models.base.bindings.applicationbnd.RoleAssignment;
import com.ibm.ejs.models.base.bindings.ejbbnd.EJBJarBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.EjbbndFactory;
import com.ibm.ejs.models.base.bindings.ejbbnd.MessageDrivenBeanBinding;
import com.ibm.ejs.models.base.bindings.webappbnd.WebAppBinding;
import com.ibm.ejs.models.base.extensions.webappext.WebAppExtension;
import com.ibm.etools.commonarchive.CommonarchiveFactory;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.EJBJarFile;
import com.ibm.etools.commonarchive.WARFile;
import com.ibm.etools.webservice.wsbnd.RouterModule;
import com.ibm.etools.webservice.wsbnd.WSBinding;
import com.ibm.ws.webservices.Version;
import com.ibm.ws.webservices.component.JAXRPCMetaDataHelper;
import com.ibm.ws.webservices.component.JAXRPCMetaDataWrapper;
import com.ibm.ws.webservices.enabler.ClientTraceEnabler;
import com.ibm.ws.webservices.enabler.HTTPRouterDescriptor;
import com.ibm.ws.webservices.enabler.JMSRouterDescriptor;
import com.ibm.ws.webservices.enabler.Utils;
import com.ibm.ws.webservices.enabler.resources.Messages;
import com.ibm.ws.webservices.tools.resource.DefaultToolEnv;
import com.ibm.ws.webservices.tools.resource.ToolEnv;
import com.ibm.wsspi.webservices.models.WSModels;
import com.ibm.wsspi.websvcs.desc.ServiceBeanInfo;
import com.ibm.wsspi.websvcs.desc.WSDescriptionBuilder;
import com.ibm.wsspi.websvcs.desc.WSDescriptionBuilderFactory;
import com.ibm.wsspi.websvcs.desc.WSEndpointDescriptor;
import com.ibm.wsspi.websvcs.desc.WSModuleDescriptor;
import com.ibm.wsspi.websvcs.desc.WSServiceDescriptor;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.internal.impl.JavaClassImpl;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.application.WebModule;
import org.eclipse.jst.j2ee.common.CommonFactory;
import org.eclipse.jst.j2ee.common.Description;
import org.eclipse.jst.j2ee.common.ResourceEnvRef;
import org.eclipse.jst.j2ee.common.SecurityRole;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifest;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveOptions;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;
import org.eclipse.jst.j2ee.ejb.ActivationConfig;
import org.eclipse.jst.j2ee.ejb.ActivationConfigProperty;
import org.eclipse.jst.j2ee.ejb.AssemblyDescriptor;
import org.eclipse.jst.j2ee.ejb.DestinationType;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EjbFactory;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.MessageDriven;
import org.eclipse.jst.j2ee.ejb.MessageDrivenDestination;
import org.eclipse.jst.j2ee.ejb.MethodPermission;
import org.eclipse.jst.j2ee.ejb.TransactionType;
import org.eclipse.jst.j2ee.webapplication.AuthConstraint;
import org.eclipse.jst.j2ee.webapplication.HTTPMethodTypeEnum;
import org.eclipse.jst.j2ee.webapplication.SecurityConstraint;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.ServletMapping;
import org.eclipse.jst.j2ee.webapplication.ServletType;
import org.eclipse.jst.j2ee.webapplication.TransportGuaranteeType;
import org.eclipse.jst.j2ee.webapplication.UserDataConstraint;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webapplication.WebResourceCollection;
import org.eclipse.jst.j2ee.webapplication.WebType;
import org.eclipse.jst.j2ee.webapplication.WebapplicationFactory;
import org.eclipse.jst.j2ee.webservice.wsdd.EJBLink;
import org.eclipse.jst.j2ee.webservice.wsdd.PortComponent;
import org.eclipse.jst.j2ee.webservice.wsdd.ServiceImplBean;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServiceDescription;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServices;

public class EndpointEnabler {
    private static String binaryCopyright = Version.getBinaryCopyright();
    private BufferedReader stdin = null;
    private String earFileName = null;
    private boolean verbose = false;
    private boolean quiet = false;
    private boolean interactive = false;
    private boolean enableHttpRouterSecurity = false;
    private ArrayList routerModuleTransportList = null;
    private Properties props = null;
    private CommonarchiveFactory archiveFactory = null;
    private int moduleCount = 0;
    private boolean forWSAD = false;
    private HashMap defaultModuleSuffixes = null;
    private Vector httpRouters = null;
    private Vector jmsRouters = null;
    private Hashtable wsBindings = null;
    private HashMap listenerPortModuleMap = new HashMap();
    private static EjbFactory ejbFactory = null;
    private static EjbbndFactory ejbbndFactory = null;
    private static CommonFactory commonFactory = null;
    private static WebapplicationFactory webappFactory = null;
    private static ApplicationbndFactory appBndFactory = null;
    private static ToolEnv env = null;
    public static final String PRP_VERBOSE = "verbose";
    public static final String PRP_QUIET = "quiet";
    public static final String PRP_DEFAULTTRANSPORTS = "defaultTransports";
    public static final String PRP_ROUTERNAME = ".routerModuleName";
    public static final String PRP_CONTEXTROOT = ".contextRoot";
    public static final String PRP_SKIP = ".skip";
    public static final String PRP_TRANSPORTS = ".transports";
    public static final String PRP_DESTINATIONTYPE = ".destinationType";
    public static final String PRP_DEFAULTDESTTYPE = ".defaultDestinationType";
    public static final String PRP_ROUTERNAMESUFFIX = ".routerModuleNameSuffix";
    public static final String PRP_ENABLEHTTPROUTERSECURITY = "http.enableRouterSecurity";
    public static final String PRP_LPNAME = ".listenerInputPortName";
    public static final String PRP_ASNAME = ".activationSpecJndiName";
    public static final String PRP_FILE_LOCATION = "propsFileLocation";
    public static final String WS_SERVERBND_XMLFILE = "ibm-webservices-bnd.xml";
    public static final String WAR_EXTENSION = ".war";
    public static final String JAR_EXTENSION = ".jar";
    public static final String TRANSPORT_HTTP = "http";
    public static final String TRANSPORT_JMS = "jms";
    public static final String HTTPROUTER_SUFFIX = "_HTTPRouter";
    public static final String JMSROUTER_SUFFIX = "_JMSRouter";
    public static final String DESTINATION_TYPE_QUEUE = "queue";
    public static final String DESTINATION_TYPE_TOPIC = "topic";
    public static final String DEFAULT_JMS_DESTINATION_TYPE = "queue";
    public static final String DESTINATION_TYPE_QUEUE_CLASS = "javax.jms.Queue";
    public static final String DESTINATION_TYPE_TOPIC_CLASS = "javax.jms.Topic";
    private static final String SERVLET_CLASS_NAME = "com.ibm.ws.webservices.engine.transport.http.WebServicesServlet";
    private static final String SERVLET_ULR_PATTERN_ROOT = "services";
    private static final String JMS_ROUTER_MDB_NAME = "WebServicesJMSRouter";
    private static final String JMS_ROUTER_MDB_CLASSNAME = "com.ibm.ws.webservices.engine.transport.jms.JMSListenerMDB";
    private static final String JAXWS_JMS_ROUTER_MDB_CLASSNAME = "com.ibm.ws.websvcs.transport.jms.JMSListenerMDB";
    public static final String JMS_MESSAGE_LISTENER_CLASS = "javax.jms.MessageListener";
    public static final String JMS_CONFIG_PROP_NAME = "destinationType";
    public static final String JMS_DESCRIPTION = "QueueConnectionFactory used by the MDB for replies";
    private static WSModuleDescriptor wsmDesc;
    private static final String HTTP_ROUTER_SECURITY_ROLE_NAME = "AuthenticatedWebServicesUsers";
    private static final String HTTP_ROUTER_AUTH_NAME = "AllAuthenticatedUsers";
    private static final String JAX_WS_SERVLET_CLASS_NAME = "com.ibm.ws.websvcs.transport.http.WASAxis2Servlet";

    public static void main(String[] argv) throws Exception {
        env = DefaultToolEnv.create();
        Properties props = new Properties();
        String earFileName = null;
        boolean verbose = false;
        BufferedReader stdin = null;
        System.out.println();
        System.out.println(Messages.getString((String)"enabler.ibmbanner", (String)"IBM WebSphere Application Server Release 6"));
        System.out.println(Messages.getString((String)"enabler.soapbanner", (String)"Web Services Enterprise Archive Endpoint Enabler Tool."));
        System.out.println(Messages.getString((String)"enabler.copyright", (String)"(C) COPYRIGHT International Business Machines Corp. 1997, 2004"));
        try {
            argv = ClientTraceEnabler.parseTraceOptions(argv);
        }
        catch (Exception e) {
            return;
        }
        try {
            for (int i = 0; i < argv.length; ++i) {
                if (argv[i].startsWith("-")) {
                    String option = argv[i].substring(1);
                    if (option.equals("?") || option.equalsIgnoreCase("h") || option.equalsIgnoreCase("help")) {
                        EndpointEnabler.printUsage();
                        return;
                    }
                    if (option.equalsIgnoreCase("v") || option.equalsIgnoreCase(PRP_VERBOSE)) {
                        props.setProperty(PRP_VERBOSE, "true");
                        verbose = true;
                        continue;
                    }
                    if (option.equalsIgnoreCase("q") || option.equalsIgnoreCase(PRP_QUIET)) {
                        props.setProperty(PRP_QUIET, "true");
                        continue;
                    }
                    if (option.equalsIgnoreCase("t") || option.equalsIgnoreCase("transport") || option.equalsIgnoreCase("transports")) {
                        if (++i >= argv.length) {
                            throw new Exception(Messages.getString((String)"enabler.missing_transport", (String)"Missing value for '-transport' parameter."));
                        }
                        props.setProperty(PRP_DEFAULTTRANSPORTS, argv[i]);
                        continue;
                    }
                    if (option.equalsIgnoreCase("p") || option.equalsIgnoreCase("properties")) {
                        if (++i >= argv.length) {
                            throw new Exception(Messages.getString((String)"enabler.missing_properties", (String)"Missing value for '-properties' parameter."));
                        }
                        FileInputStream f = new FileInputStream(argv[i]);
                        props.load(f);
                        f.close();
                        if (!verbose) continue;
                        Object[] inserts = new String[]{argv[i]};
                        System.out.println(Messages.getFormattedMessage((String)"enabler.read_properties", (Object[])inserts, (String)"Read properties from file: {0}"));
                        continue;
                    }
                    if (option.equalsIgnoreCase("enableHttpRouterSecurity")) {
                        props.setProperty(PRP_ENABLEHTTPROUTERSECURITY, "true");
                        continue;
                    }
                    Object[] inserts = new String[]{argv[i]};
                    throw new Exception(Messages.getFormattedMessage((String)"enabler.unrecognized_parameter", (Object[])inserts, (String)"ERROR: unrecognized command-line parameter found: {0}"));
                }
                earFileName = argv[i];
            }
            EndpointEnabler enabler = new EndpointEnabler();
            if (earFileName == null || earFileName.equals("")) {
                InputStreamReader in = new InputStreamReader(System.in);
                stdin = new BufferedReader(in);
                enabler.setInputSource(stdin);
                earFileName = Utils.getReadFileInput(stdin, Messages.getString((String)"enabler.earfilename", (String)"Please enter the name of your EAR file: ")).getPath();
            }
            Utils.backupEar(earFileName);
            enabler.enableEarFile(earFileName, props);
        }
        catch (Exception e) {
            System.out.println(Messages.getMessage((String)"enabler.failed.error", (String)e.getMessage()));
            return;
        }
    }

    public EndpointEnabler() {
        this.defaultModuleSuffixes = new HashMap();
        this.defaultModuleSuffixes.put(TRANSPORT_HTTP, HTTPROUTER_SUFFIX);
        this.defaultModuleSuffixes.put(TRANSPORT_JMS, JMSROUTER_SUFFIX);
    }

    public void setInputSource(BufferedReader stdin) {
        this.stdin = stdin;
        this.interactive = stdin != null;
    }

    private void processGlobalProperties(Properties props) throws Exception {
        String s;
        Properties additionalProps;
        if (this.props != null) {
            return;
        }
        this.props = props;
        String propsFileLocation = props.getProperty(PRP_FILE_LOCATION);
        if (propsFileLocation != null && !"".equals(propsFileLocation) && (additionalProps = this.loadPropertiesFromFile(propsFileLocation)) != null) {
            this.props.putAll((Map<?, ?>)additionalProps);
        }
        if ((s = this.props.getProperty(PRP_VERBOSE, "")).equalsIgnoreCase("true")) {
            this.verbose = true;
        }
        if ((s = this.props.getProperty(PRP_QUIET, "")).equalsIgnoreCase("true")) {
            this.quiet = true;
        }
        if ((s = this.props.getProperty(PRP_DEFAULTTRANSPORTS, "")).length() > 0) {
            this.routerModuleTransportList = this.getTransportsListFromString(s);
        }
        if ((s = this.props.getProperty(PRP_ENABLEHTTPROUTERSECURITY, "")).equalsIgnoreCase("true")) {
            this.enableHttpRouterSecurity = true;
        }
        if (this.quiet) {
            this.verbose = false;
        }
        if (this.verbose) {
            env.report(Messages.getString((String)"enabler.display_properties", (String)"The endpoint enabler is using the following properties:"));
            Enumeration<Object> keyList = this.props.keys();
            while (keyList.hasMoreElements()) {
                String key = (String)keyList.nextElement();
                env.report("\t" + key + ": " + this.props.getProperty(key));
            }
            env.report(null);
        }
    }

    private ArrayList getTransportsListFromString(String s) throws Exception {
        StringTokenizer st = new StringTokenizer(s, " ;,:");
        ArrayList<String> list = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (!token.equals(TRANSPORT_HTTP) && !token.equals(TRANSPORT_JMS)) {
                Object[] inserts = new String[]{token};
                throw new Exception(Messages.getFormattedMessage((String)"enabler.bad_transport", (Object[])inserts, (String)"Unrecognized transport: {0}"));
            }
            list.add(token);
        }
        return list;
    }

    public void enableEarFile(String earFileName, Properties props) throws Exception {
        Object[] inserts;
        this.checkEnv();
        if (earFileName == null || earFileName.equals("")) {
            throw new Exception(Messages.getString((String)"enabler.missing_ear", (String)"'EAR filename' parameter is missing or empty."));
        }
        if (props == null) {
            throw new Exception(Messages.getString((String)"enabler.missing_props", (String)"'props' parameter is missing."));
        }
        this.earFileName = earFileName;
        this.processGlobalProperties(props);
        this.archiveFactory = Utils.getArchiveFactory();
        LoadStrategy loadStrategy = this.archiveFactory.createLoadStrategy(this.earFileName);
        if (!this.quiet) {
            Object[] inserts2 = new String[]{this.earFileName};
            env.report(Messages.getFormattedMessage((String)"enabler.load_ear", (Object[])inserts2, (String)"Loading EAR file: {0}"));
        }
        ArchiveOptions options = new ArchiveOptions();
        options.setUseJavaReflection(true);
        options.setLoadStrategy(loadStrategy);
        EARFile earFile = this.archiveFactory.openEARFile(options, this.earFileName);
        this.enableEarFile(earFile, props);
        if (this.isModified()) {
            inserts = new String[]{this.earFileName};
            env.report(Messages.getFormattedMessage((String)"enabler.saving_ear", (Object[])inserts, (String)"Saving EAR file {0}..."));
            earFile.saveNoReopen();
            env.report(Messages.getFormattedMessage((String)"enabler.save_finished", null, (String)"Finished saving the EAR file."));
            this.clearModuleCount();
        }
        earFile.close();
        inserts = new String[]{this.earFileName};
        env.report(Messages.getFormattedMessage((String)"enabler.finished", (Object[])inserts, (String)"Finished processing EAR file {0}."));
    }

    Properties loadPropertiesFromFile(String file) {
        try {
            Properties props = new Properties();
            FileInputStream f = new FileInputStream(file);
            props.load(f);
            return props;
        }
        catch (Exception e) {
            env.reporterr(e.toString());
            return null;
        }
    }

    public void enableEarFile(EARFile earFile, Properties props) throws Exception {
        this.checkEnv();
        if (this.archiveFactory == null) {
            this.archiveFactory = Utils.getArchiveFactory();
        }
        this.clearModuleCount();
        this.processGlobalProperties(props);
        List ejbJars = earFile.getEJBJarFiles();
        for (EJBJarFile ejbJar : ejbJars) {
            Object[] inserts = new String[]{ejbJar.getName()};
            if (!this.quiet) {
                env.report(Messages.getFormattedMessage((String)"enabler.found_ejb", (Object[])inserts, (String)"Found EJB Module: {0}"));
            }
            this.enableEJBJar(earFile, ejbJar);
        }
    }

    private void clearModuleCount() {
        this.moduleCount = 0;
    }

    public boolean isModified() {
        return this.moduleCount > 0;
    }

    private boolean containsWebService(EJBJarFile ejbJar) throws Exception {
        WebServices ws = Utils.getWebServices(ejbJar);
        WSDescriptionBuilder builder = WSDescriptionBuilderFactory.getBuilder();
        wsmDesc = builder.getModuleDescriptor((ModuleFile)ejbJar);
        return ws != null || wsmDesc.containsWebServices();
    }

    public void enableEJBJar(EARFile earFile, EJBJarFile ejbJar, Properties props) throws Exception {
        this.checkEnv();
        if (this.archiveFactory == null) {
            this.archiveFactory = Utils.getArchiveFactory();
        }
        this.clearModuleCount();
        this.processGlobalProperties(props);
        this.enableEJBJar(earFile, ejbJar);
    }

    private void enableEJBJar(EARFile earFile, EJBJarFile ejbJar) throws Exception {
        if (this.containsWebService(ejbJar)) {
            if (this.verbose) {
                Object[] inserts = new String[]{ejbJar.getName()};
                env.report(Messages.getFormattedMessage((String)"enabler.enabling_ejb", (Object[])inserts, (String)"Enabling EJB Module {0}..."));
            }
            ArrayList routerList = this.routersNeeded(ejbJar);
            for (int i = 0; i < routerList.size(); ++i) {
                this.addRouterModule(earFile, ejbJar, (String)routerList.get(i));
            }
            if (this.verbose) {
                Object[] inserts = new String[]{ejbJar.getName()};
                env.report(Messages.getFormattedMessage((String)"enabler.finished_enabling_ejb", (Object[])inserts, (String)"Finished enabling EJB Module {0}."));
            }
        } else if (!this.quiet) {
            Object[] inserts = new String[]{ejbJar.getName()};
            env.report(Messages.getFormattedMessage((String)"enabler.skipping_ejb", (Object[])inserts, (String)"Skipping EJB Module {0} since it contains no web services."));
        }
    }

    private ArrayList routersNeeded(EJBJarFile ejbJar) throws Exception {
        ArrayList list = null;
        String baseName = this.getModuleBaseName(ejbJar);
        String propName = baseName + PRP_TRANSPORTS;
        String s = this.props.getProperty(propName, "");
        if (s.length() > 0) {
            list = this.getTransportsListFromString(s);
        } else if (this.routerModuleTransportList != null && this.routerModuleTransportList.size() > 0) {
            list = this.routerModuleTransportList;
        } else {
            list = new ArrayList();
            list.add(TRANSPORT_HTTP);
        }
        return list;
    }

    private void addRouterModule(EARFile earFile, EJBJarFile ejbJar, String routerTransport) throws Exception {
        WSBinding wsbnd = Utils.getWSBinding(ejbJar);
        if (this.containsRouterModule(earFile, ejbJar, wsbnd, routerTransport)) {
            if (!this.quiet) {
                Object[] inserts = new String[]{routerTransport, ejbJar.getName()};
                env.report(Messages.getFormattedMessage((String)"enabler.ejb_already_enabled", (Object[])inserts, (String)"Skipping {0} router module for EJB Module {1} since it already contains a router for this transport."));
            }
        } else {
            if (this.wsBindings == null) {
                this.wsBindings = new Hashtable();
            }
            if (wsbnd == null) {
                wsbnd = (WSBinding)this.wsBindings.get(ejbJar.getOriginalURI());
                if (wsbnd == null) {
                    wsbnd = Utils.createWSBinding(ejbJar);
                }
                this.wsBindings.put(ejbJar.getOriginalURI(), wsbnd);
            }
            if (routerTransport.equals(TRANSPORT_HTTP)) {
                this.addHTTPRouterModule(earFile, ejbJar, wsbnd);
            } else if (routerTransport.equals(TRANSPORT_JMS)) {
                this.addJMSRouterModule(earFile, ejbJar, wsbnd);
            }
        }
    }

    private boolean containsRouterModule(EARFile earFile, EJBJarFile ejbJar, WSBinding wsbnd, String transport) {
        if (wsbnd != null) {
            Iterator routerModules = wsbnd.getRouterModules().iterator();
            while (routerModules.hasNext()) {
                RouterModule rm = (RouterModule)routerModules.next();
                if (!this.forWSAD && !earFile.containsFile(rm.getName())) {
                    routerModules.remove();
                    continue;
                }
                if (!rm.getTransport().equals(transport)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean shouldSkipRouter(String baseName, String transport) {
        boolean shouldSkip = false;
        String propName = baseName + "." + transport + PRP_SKIP;
        String skipValue = this.props.getProperty(propName, "false");
        if (skipValue.equalsIgnoreCase("true")) {
            shouldSkip = true;
        }
        return shouldSkip;
    }

    private String getModuleBaseName(EJBJarFile ejbJar) {
        String jarName = ejbJar.getOriginalURI();
        if (!jarName.endsWith(JAR_EXTENSION)) {
            return jarName;
        }
        int index = jarName.indexOf(JAR_EXTENSION);
        String baseName = jarName.substring(0, index);
        return baseName;
    }

    private void addHTTPRouterModule(EARFile earFile, EJBJarFile ejbJar, WSBinding wsbnd) throws Exception {
        String ejbJarBaseName = this.getModuleBaseName(ejbJar);
        if (this.shouldSkipRouter(ejbJarBaseName, TRANSPORT_HTTP)) {
            if (!this.quiet) {
                Object[] inserts = new String[]{TRANSPORT_HTTP, ejbJar.getName()};
                env.report(Messages.getFormattedMessage((String)"enabler.skipping_router", (Object[])inserts, (String)"Skipping {0} router module for EJB Module {1} due to 'skip' property."));
            }
            return;
        }
        ++this.moduleCount;
        String routerName = this.getRouterName(ejbJarBaseName, TRANSPORT_HTTP, WAR_EXTENSION);
        String contextRoot = this.getHTTPContextRoot(ejbJarBaseName, TRANSPORT_HTTP);
        if (!this.quiet) {
            Object[] inserts = new String[]{TRANSPORT_HTTP, ejbJar.getName()};
            env.report(Messages.getFormattedMessage((String)"enabler.adding_router", (Object[])inserts, (String)"Adding {0} router module for EJB Module {1}."));
        }
        if (this.verbose) {
            Object[] inserts1 = new String[]{routerName};
            env.report(Messages.getFormattedMessage((String)"enabler.router_name", (Object[])inserts1, (String)"Router name: {0}"));
            Object[] inserts2 = new String[]{contextRoot};
            env.report(Messages.getFormattedMessage((String)"enabler.context_root", (Object[])inserts2, (String)"Context root: {0}"));
        }
        ArrayList portComponentNames = new ArrayList();
        ArrayList jaxwsServiceDescs = new ArrayList();
        this.getPortComponentNamesFromModule(ejbJar, portComponentNames, jaxwsServiceDescs);
        HTTPRouterDescriptor routerHolder = new HTTPRouterDescriptor(routerName, contextRoot, portComponentNames, jaxwsServiceDescs, ejbJar.getName());
        routerHolder.addClassPathEntry(ejbJar.getURI());
        Utils.addRouterToWSBinding(wsbnd, routerName, TRANSPORT_HTTP);
        WARFile warFile = this.createModule(routerHolder, earFile, ejbJar);
        if (this.forWSAD) {
            routerHolder.setRouterModule(warFile);
            this.httpRouters.add(routerHolder);
        } else {
            earFile.addCopy((ModuleFile)warFile);
            Application appDD = earFile.getDeploymentDescriptor();
            WebModule webModule = (WebModule)appDD.getFirstModule(routerHolder.getTargetURI());
            webModule.setContextRoot(routerHolder.getContextRoot());
        }
    }

    private void addJMSRouterModule(EARFile earFile, EJBJarFile ejbJar, WSBinding wsbnd) throws Exception {
        String ejbJarBaseName = this.getModuleBaseName(ejbJar);
        if (this.shouldSkipRouter(ejbJarBaseName, TRANSPORT_JMS)) {
            if (!this.quiet) {
                Object[] inserts = new String[]{TRANSPORT_JMS, ejbJar.getName()};
                env.report(Messages.getFormattedMessage((String)"enabler.skipping_router", (Object[])inserts, (String)"Skipping {0} router module for EJB Module {1} due to 'skip' property."));
            }
            return;
        }
        ++this.moduleCount;
        String routerName = this.getRouterName(ejbJarBaseName, TRANSPORT_JMS, JAR_EXTENSION);
        String activationSpecJNDIName = this.getActivationSpecJNDIName(ejbJarBaseName, TRANSPORT_JMS);
        String listenerPortName = this.getJMSListenerInputPortName(ejbJarBaseName, TRANSPORT_JMS);
        String destinationType = this.getJMSDestinationType(ejbJarBaseName, TRANSPORT_JMS);
        if (!this.quiet) {
            Object[] inserts = new String[]{TRANSPORT_JMS, ejbJar.getName()};
            env.report(Messages.getFormattedMessage((String)"enabler.adding_router", (Object[])inserts, (String)"Adding {0} router module for EJB Module {1}."));
        }
        if (this.verbose) {
            Object[] inserts1 = new String[]{routerName};
            env.report(Messages.getFormattedMessage((String)"enabler.router_name", (Object[])inserts1, (String)"Router name: {0}"));
            Object[] inserts2 = new String[]{activationSpecJNDIName};
            env.report(Messages.getFormattedMessage((String)"enabler.activation_spec", (Object[])inserts2, (String)"Activation Spec JNDI Name: {0}"));
            Object[] inserts3 = new String[]{listenerPortName};
            env.report(Messages.getFormattedMessage((String)"enabler.listener_port", (Object[])inserts3, (String)"Listener Input Port Name: {0}"));
            Object[] inserts4 = new String[]{destinationType};
            env.report(Messages.getFormattedMessage((String)"enabler.destination_type", (Object[])inserts4, (String)"Destination type: {0}"));
        }
        JMSRouterDescriptor routerHolder = new JMSRouterDescriptor(routerName, activationSpecJNDIName, listenerPortName, destinationType, ejbJar.getName());
        routerHolder.addClassPathEntry(ejbJar.getURI());
        Utils.addRouterToWSBinding(wsbnd, routerName, TRANSPORT_JMS);
        EJBJarFile jarFile = this.createModule(routerHolder, earFile, ejbJar);
        if (this.forWSAD) {
            routerHolder.setRouterModule(jarFile);
            this.jmsRouters.add(routerHolder);
        } else {
            earFile.addCopy((ModuleFile)jarFile);
        }
    }

    private String getRouterName(String moduleBaseName, String transport, String extension) throws Exception {
        String propName = moduleBaseName + "." + transport + PRP_ROUTERNAME;
        String routerName = this.props.getProperty(propName, null);
        if (routerName == null) {
            propName = transport + PRP_ROUTERNAMESUFFIX;
            String suffix = this.props.getProperty(propName, null);
            if (suffix == null) {
                suffix = (String)this.defaultModuleSuffixes.get(transport);
            }
            routerName = moduleBaseName + suffix + extension;
        }
        if (this.interactive) {
            env.report(null);
            Object[] inserts = new String[]{transport, moduleBaseName, routerName};
            String prompt = Messages.getFormattedMessage((String)"enabler.router_name_prompt", (Object[])inserts, (String)"Enter {0} router name for EJB Module {1} [{2}]: ");
            String override = Utils.getStringInputWithDefaults(this.stdin, prompt);
            if (!override.equals("")) {
                routerName = override;
            }
        }
        if (!routerName.endsWith(extension)) {
            routerName = routerName + extension;
        }
        return routerName;
    }

    private String getHTTPContextRoot(String moduleBaseName, String transport) throws Exception {
        String propName = moduleBaseName + "." + transport + PRP_CONTEXTROOT;
        String contextRoot = this.props.getProperty(propName, null);
        if (contextRoot == null) {
            contextRoot = "/" + moduleBaseName;
        }
        if (this.interactive) {
            env.report(null);
            Object[] inserts = new String[]{transport, moduleBaseName, contextRoot};
            String prompt = Messages.getFormattedMessage((String)"enabler.context_root_prompt", (Object[])inserts, (String)"Enter {0} context root for EJB Module {1} [{2}]: ");
            String override = Utils.getStringInputWithDefaults(this.stdin, prompt);
            if (!override.equals("")) {
                contextRoot = override;
            }
        }
        return contextRoot;
    }

    private String getActivationSpecJNDIName(String moduleBaseName, String transport) throws Exception {
        String propName = moduleBaseName + "." + transport + PRP_ASNAME;
        String asName = this.props.getProperty(propName, null);
        if (this.interactive) {
            env.report(null);
            Object[] inserts = new String[]{transport, moduleBaseName, asName};
            String prompt = Messages.getFormattedMessage((String)"enabler.asname_prompt", (Object[])inserts, (String)"Enter {0} Activation Spec Jndi name for EJB Module {1} [{2}]: ");
            String override = Utils.getStringInputWithDefaults(this.stdin, prompt);
            if (!override.equals("")) {
                asName = override;
            }
        }
        return asName;
    }

    private String getJMSListenerInputPortName(String moduleBaseName, String transport) throws Exception {
        String propName = moduleBaseName + "." + transport + PRP_LPNAME;
        String lpName = this.props.getProperty(propName, null);
        if (this.interactive) {
            env.report(null);
            Object[] inserts = new String[]{transport, moduleBaseName, lpName};
            String prompt = Messages.getFormattedMessage((String)"enabler.lpname_prompt", (Object[])inserts, (String)"Enter {0} listener input port name for EJB Module {1} [{2}]: ");
            String override = Utils.getStringInputWithDefaults(this.stdin, prompt);
            if (!override.equals("")) {
                lpName = override;
            }
        }
        return lpName;
    }

    private String getJMSDestinationType(String moduleBaseName, String transport) throws Exception {
        Object[] inserts;
        String propName = moduleBaseName + "." + transport + PRP_DESTINATIONTYPE;
        String destType = this.props.getProperty(propName, null);
        if (destType == null) {
            propName = transport + PRP_DEFAULTDESTTYPE;
            destType = this.props.getProperty(propName, null);
        }
        if (destType == null) {
            destType = "queue";
        }
        if (this.interactive) {
            env.report(null);
            inserts = new String[]{transport, moduleBaseName, destType};
            String prompt = Messages.getFormattedMessage((String)"enabler.destination_type_prompt", (Object[])inserts, (String)"Enter {0} destination type for EJB Module {1} [{2}]: ");
            String override = Utils.getStringInputWithDefaults(this.stdin, prompt);
            if (!override.equals("")) {
                destType = override;
            }
        }
        if (!destType.equals("queue") && !destType.equals(DESTINATION_TYPE_TOPIC)) {
            inserts = new String[]{destType};
            String msg = Messages.getFormattedMessage((String)"enabler.invalid_destination_type", (Object[])inserts, (String)"Invalid destination type specified: {0}");
            throw new Exception(msg);
        }
        return destType;
    }

    private void getPortComponentNamesFromModule(EJBJarFile mfile, List portComponentNames, List jaxwsEndpoints) throws Exception {
        JAXRPCMetaDataHelper metaDataHelper = new JAXRPCMetaDataHelper((Archive)mfile, mfile.getArchiveClassLoader());
        JAXRPCMetaDataWrapper metaDataWrapper = metaDataHelper.loadJAXRPCMetaData();
        if (metaDataWrapper != null && metaDataWrapper.getJaxrpcPortComponents() != null) {
            portComponentNames.addAll(metaDataWrapper.getJaxrpcPortComponents());
        }
        if (wsmDesc != null) {
            Iterator services = wsmDesc.getJAXWSServices();
            while (services.hasNext()) {
                WSServiceDescriptor wssDesc = (WSServiceDescriptor)services.next();
                if (!wssDesc.isJAXWSService()) continue;
                Iterator endpointIter = wssDesc.getEndpoints();
                while (endpointIter.hasNext()) {
                    jaxwsEndpoints.add(endpointIter.next());
                }
            }
        }
    }

    private boolean JAXWSEndpointPresent() {
        if (wsmDesc != null) {
            Iterator services = wsmDesc.getJAXWSServices();
            while (services.hasNext()) {
                Iterator endpointIter;
                WSServiceDescriptor wssDesc = (WSServiceDescriptor)services.next();
                if (!wssDesc.isJAXWSService() || !(endpointIter = wssDesc.getEndpoints()).hasNext()) continue;
                return true;
            }
        }
        return false;
    }

    public void setToolEnv(ToolEnv e) {
        env = e;
    }

    public void setArchiveFactory(CommonarchiveFactory archFactory) {
        this.archiveFactory = archFactory;
    }

    public ToolEnv getToolEnv() {
        return env;
    }

    private void checkEnv() {
        if (env == null) {
            env = DefaultToolEnv.create();
        }
    }

    private static void printUsage() {
        String traceOptions = Messages.getMessage((String)"clienttrace.trace_options", (String)"");
        String backupMsg = "Usage syntax:  endptEnabler [options] [trace options] [<ear-file-name>]";
        Object[] inserts = new String[]{traceOptions};
        env.report(null);
        env.report(Messages.getFormattedMessage((String)"enabler.usage_syntax", (Object[])inserts, (String)backupMsg));
    }

    private WARFile createModule(HTTPRouterDescriptor routerHolder, EARFile earFile, EJBJarFile ejbJar) throws Exception {
        WARFile warFile = this.archiveFactory.createWARFileInitialized(routerHolder.getTargetURI());
        warFile.setJ2EEVersion(ejbJar.getSpecVersionID());
        ArchiveManifest archiveManifest = warFile.getManifest();
        archiveManifest.setManifestVersion("1.0");
        archiveManifest.setClassPath(routerHolder.getClassPath());
        WebApp webDD = warFile.getDeploymentDescriptor();
        Object[] inserts = new String[]{"HTTP", routerHolder.getEjbJarName()};
        webDD.setDisplayName(Messages.getFormattedMessage((String)"enabler.routerDisplayName", (Object[])inserts, (String)"{0} router for {1}"));
        EList servlets = webDD.getServlets();
        EList servletMappings = webDD.getServletMappings();
        this.handleJAXRPCServlets(webDD, routerHolder.getPortComponentNames(), ejbJar, warFile.getName());
        this.handleJAXWSServlets(webDD, routerHolder.getJaxwsEndpoints(), ejbJar, warFile.getName());
        warFile.setDeploymentDescriptor(webDD);
        WebAppBinding webappBnd = warFile.getBindings();
        webappBnd.setVirtualHostName("default_host");
        warFile.setBindings(webappBnd);
        WebAppExtension webAppExt = warFile.getExtensions();
        webAppExt.setReloadInterval(3);
        webAppExt.setReloadingEnabled(false);
        webAppExt.setDirectoryBrowsingEnabled(false);
        webAppExt.setFileServingEnabled(false);
        webAppExt.setServeServletsByClassnameEnabled(false);
        webAppExt.setPreCompileJSPs(false);
        warFile.setExtensions(webAppExt);
        EJBJar ejbJarDD = ejbJar.getDeploymentDescriptor();
        ApplicationBinding appBnd = earFile.getBindings();
        boolean ejbJarProtected = this.ejbJarContainsProtectedEJB(ejbJarDD);
        if (ejbJarProtected && !this.enableHttpRouterSecurity) {
            String backupMsg = "EJB jar {0} contains protected EJBs, yet the -enableHttpRouterSecurity option was not specified, so the resulting HTTP router module, {1}, will not include security information.";
            Object[] modNames = new String[]{routerHolder.getEjbJarName(), routerHolder.getTargetURI()};
            env.report(Messages.getFormattedMessage((String)"enabler.security_warning_1", (Object[])modNames, (String)backupMsg));
        } else if (!ejbJarProtected && this.enableHttpRouterSecurity) {
            String backupMsg = "The -enableHttpRouterSecurity option was specified, yet the EJB jar {0} contains at least one unprotected EJB or the existing security information is incomplete.  Therefore, security information will not be added to the {1} HTTP router module.";
            Object[] modNames = new String[]{routerHolder.getEjbJarName(), routerHolder.getTargetURI()};
            env.report(Messages.getFormattedMessage((String)"enabler.security_warning_2", (Object[])modNames, (String)backupMsg));
        } else if (ejbJarProtected && this.enableHttpRouterSecurity) {
            AuthorizationTable authTable;
            Application appDD = earFile.getDeploymentDescriptor();
            SecurityRole secRole = appDD.getSecurityRoleNamed(HTTP_ROUTER_SECURITY_ROLE_NAME);
            if (secRole == null) {
                secRole = commonFactory.createSecurityRole();
                secRole.setRoleName(HTTP_ROUTER_SECURITY_ROLE_NAME);
                EList secRoleList = appDD.getSecurityRoles();
                secRoleList.add(secRole);
            }
            if ((authTable = appBnd.getAuthorizationTable()) == null) {
                authTable = appBndFactory.createAuthorizationTable();
                appBnd.setAuthorizationTable(authTable);
            }
            EList authList = authTable.getAuthorizations();
            RoleAssignment ra = null;
            boolean needRoleAssignment = true;
            Iterator authIter = authList.iterator();
            while (needRoleAssignment && authIter.hasNext()) {
                ra = (RoleAssignment)authIter.next();
                if (ra.getRole() != secRole) continue;
                needRoleAssignment = false;
            }
            if (needRoleAssignment) {
                ra = appBndFactory.createRoleAssignment();
                ra.setRole(secRole);
                AllAuthenticatedUsers aau = appBndFactory.createAllAuthenticatedUsers();
                aau.setName(HTTP_ROUTER_AUTH_NAME);
                EList subjectList = ra.getSpecialSubjects();
                subjectList.add(aau);
                authList.add(ra);
            }
            EList constraints = webDD.getConstraints();
            SecurityConstraint sc = webappFactory.createSecurityConstraint();
            AuthConstraint ac = webappFactory.createAuthConstraint();
            EList roleNames = ac.getRoles();
            roleNames.add(HTTP_ROUTER_SECURITY_ROLE_NAME);
            sc.setAuthConstraint(ac);
            UserDataConstraint udc = webappFactory.createUserDataConstraint();
            udc.setTransportGuarantee(TransportGuaranteeType.NONE_LITERAL);
            sc.setUserDataConstraint(udc);
            WebResourceCollection wrc = webappFactory.createWebResourceCollection();
            String wrcName = "WebResourceCollection_for_" + routerHolder.getTargetURI();
            wrc.setWebResourceName(wrcName);
            String webDDVersion = webDD.getVersion();
            if (webDDVersion.equals("2.4") || webDDVersion.equals("2.5")) {
                wrc.getHttpMethod().add(HTTPMethodTypeEnum.get((int)1));
            } else {
                wrc.addHTTP("POST");
            }
            WebServices ws = Utils.getWebServices(ejbJar);
            AssemblyDescriptor ad = ejbJarDD.getAssemblyDescriptor();
            for (String pcName : routerHolder.getPortComponentNames()) {
                EnterpriseBean ejb = this.getEjbForPortComponent(ejbJarDD, ws, pcName);
                if (ejb == null || !this.ejbIsProtected(ejb, ad)) continue;
                String urlPattern = "/services/" + pcName;
                if (webDDVersion.equals("2.4") || webDDVersion.equals("2.5")) {
                    wrc.getUrlPattern().add(urlPattern);
                    continue;
                }
                wrc.addURL(urlPattern);
            }
            for (WSEndpointDescriptor endpointDesc : routerHolder.getJaxwsEndpoints()) {
                String urlPattern;
                EnterpriseBean ejb;
                ServiceBeanInfo info = endpointDesc.getServiceBeanInfo();
                if (!ServiceBeanInfo.BeanType.EJB.equals((Object)info.getBeanType()) || (ejb = ejbJarDD.getEnterpriseBeanNamed(info.getLinkValue())) == null || !this.ejbIsProtected(ejb, ad)) continue;
                String portName = endpointDesc.getQName() != null ? endpointDesc.getQName().getLocalPart() : null;
                String urlPatternKey = this.constructURLPropKey(this.getModuleBaseName(ejbJar), portName);
                String string = urlPattern = this.props.get(urlPatternKey) != null ? (String)this.props.get(urlPatternKey) : endpointDesc.getURLPattern();
                if (webDDVersion.equals("2.4") || webDDVersion.equals("2.5")) {
                    wrc.getUrlPattern().add(urlPattern);
                    continue;
                }
                wrc.addURL(urlPattern);
            }
            EList wrcList = sc.getWebResourceCollections();
            wrcList.add(wrc);
            constraints.add(sc);
            SecurityRole sr = commonFactory.createSecurityRole();
            sr.setRoleName(HTTP_ROUTER_SECURITY_ROLE_NAME);
            EList srList = webDD.getSecurityRoles();
            srList.add(sr);
        }
        return warFile;
    }

    private void handleJAXRPCServlets(WebApp webDD, List portComponents, EJBJarFile ejbJar, String routerName) {
        EList servlets = webDD.getServlets();
        EList servletMappings = webDD.getServletMappings();
        Iterator pcIter = portComponents.iterator();
        LinkedList<String> urlPatterns = new LinkedList<String>();
        boolean duplicateURLPatterns = false;
        while (pcIter.hasNext()) {
            String portComponentName = (String)pcIter.next();
            String portName = this.getPortName(ejbJar, portComponentName);
            String urlPatternKey = this.constructURLPropKey(this.getModuleBaseName(ejbJar), portName);
            String urlPattern = (String)this.props.get(urlPatternKey);
            if (urlPattern == null || "".equals(urlPattern)) {
                urlPattern = "services/" + portComponentName;
            }
            this.createServletEntries(webDD, servlets, servletMappings, portComponentName, urlPattern, SERVLET_CLASS_NAME);
            if (this.verbose) {
                Object[] inserts = new String[]{portName, urlPattern};
                env.report(Messages.getFormattedMessage((String)"enabler.seturlpattern", (Object[])inserts, (String)"URL pattern for port {0}: {1}"));
            }
            if (urlPatterns.contains(urlPattern)) {
                duplicateURLPatterns = true;
                continue;
            }
            urlPatterns.add(urlPattern);
        }
        if (duplicateURLPatterns) {
            Object[] insert = new String[]{routerName};
            String msg = Messages.getFormattedMessage((String)"enabler.duplicate.url.patterns", (Object[])insert, (String)"The {0} WAR module generated by EndpointEnabler contains multiple servlets with the same URL pattern. This must be fixed before installing the application.");
            env.report(msg);
            duplicateURLPatterns = false;
        }
    }

    String constructURLPropKey(String ejbJarName, String portName) {
        String urlPropKey = null;
        String sep = ".";
        urlPropKey = ejbJarName + sep + portName + sep + TRANSPORT_HTTP + sep + "urlPattern";
        return urlPropKey;
    }

    String getPortName(EJBJarFile ejbJarFile, String portComponentName) {
        String portName = null;
        WebServices webServices = WSModels.getWebServices(ejbJarFile.getLoadStrategy(), "META-INF/webservices.xml");
        if (webServices != null) {
            for (WebServiceDescription wsDesc : webServices.getWebServiceDescriptions()) {
                for (PortComponent pc : wsDesc.getPortComponents()) {
                    if (!pc.getPortComponentName().equals(portComponentName)) continue;
                    portName = pc.getWsdlPort() != null ? pc.getWsdlPort().getLocalPart() : null;
                    break;
                }
                if (portName == null) continue;
                break;
            }
        }
        return portName;
    }

    private void handleJAXWSServlets(WebApp webDD, List jaxwsEndpoints, EJBJarFile ejbJar, String routerName) {
        EList servlets = webDD.getServlets();
        EList servletMappings = webDD.getServletMappings();
        Iterator endpointDescIter = jaxwsEndpoints.iterator();
        LinkedList<String> urlPatterns = new LinkedList<String>();
        boolean duplicateURLPatterns = false;
        while (endpointDescIter.hasNext()) {
            WSEndpointDescriptor endpointDesc = (WSEndpointDescriptor)endpointDescIter.next();
            String implClassName = endpointDesc.getServiceBeanInfo().getImplClassName();
            String portName = endpointDesc.getQName() != null ? endpointDesc.getQName().getLocalPart() : null;
            String urlPatternPropKey = this.constructURLPropKey(this.getModuleBaseName(ejbJar), portName);
            String urlPattern = (String)this.props.get(urlPatternPropKey);
            if (urlPattern == null || "".equals(urlPattern)) {
                urlPattern = endpointDesc.getURLPattern();
            }
            String servletName = null;
            servletName = endpointDesc.getServiceBeanInfo() != null && endpointDesc.getServiceBeanInfo().getLinkValue() != null && !"".equals(endpointDesc.getServiceBeanInfo().getLinkValue()) ? endpointDesc.getServiceBeanInfo().getLinkValue() : implClassName;
            this.createServletEntries(webDD, servlets, servletMappings, servletName, urlPattern, JAX_WS_SERVLET_CLASS_NAME);
            if (this.verbose) {
                Object[] inserts = new String[]{portName, urlPattern};
                env.report(Messages.getFormattedMessage((String)"enabler.seturlpattern", (Object[])inserts, (String)"URL pattern for port {0}: {1}"));
            }
            if (urlPatterns.contains(urlPattern)) {
                duplicateURLPatterns = true;
                continue;
            }
            urlPatterns.add(urlPattern);
        }
        if (duplicateURLPatterns) {
            Object[] insert = new String[]{routerName};
            String msg = Messages.getFormattedMessage((String)"enabler.duplicate.url.patterns", (Object[])insert, (String)"The {0} WAR module generated by EndpointEnabler contains multiple servlets with the same URL pattern. This must be fixed before installing the application.");
            env.report(msg);
            duplicateURLPatterns = false;
        }
    }

    private void createServletEntries(WebApp webDD, List servlets, List servletMappings, String servletName, String urlPattern, String servletClass) {
        Servlet servletToAdd = webappFactory.createServlet();
        servletToAdd.setWebApp(webDD);
        servletToAdd.setServletName(servletName);
        String displayName = Messages.getFormattedMessage((String)"enabler.servletDisplayNamePrefix", (Object[])new Object[]{servletName}, (String)"Web Services Router servlet for port-component {0}");
        servletToAdd.setDisplayName(displayName);
        ServletType servletType = webappFactory.createServletType();
        servletType.setClassName(servletClass);
        servletToAdd.setWebType((WebType)servletType);
        ServletMapping mappingToAdd = webappFactory.createServletMapping();
        mappingToAdd.setServlet(servletToAdd);
        mappingToAdd.setUrlPattern(urlPattern);
        servlets.add(servletToAdd);
        servletMappings.add(mappingToAdd);
    }

    private boolean ejbJarContainsProtectedEJB(EJBJar ejbJarDD) {
        AssemblyDescriptor ad = ejbJarDD.getAssemblyDescriptor();
        if (ad == null) {
            return false;
        }
        EList secroles = ad.getSecurityRoles();
        if (secroles.size() == 0) {
            return false;
        }
        for (EnterpriseBean ejb : ejbJarDD.getEnterpriseBeans()) {
            List mpList = ad.getMethodPermissionMethodElements(ejb);
            if (mpList.size() == 0) continue;
            return true;
        }
        return false;
    }

    private EnterpriseBean getEjbForPortComponent(EJBJar ejbJarDD, WebServices ws, String pcName) {
        String ejbName;
        EJBLink ejbLink;
        ServiceImplBean sib;
        EnterpriseBean theEjb = null;
        EList wsDescs = ws.getWebServiceDescriptions();
        PortComponent pc = null;
        for (int i = 0; i < wsDescs.size() && pc == null; ++i) {
            WebServiceDescription wsDesc = (WebServiceDescription)wsDescs.get(i);
            EList pcList = wsDesc.getPortComponents();
            for (int j = 0; j < pcList.size() && pc == null; ++j) {
                PortComponent thisPC = (PortComponent)pcList.get(j);
                if (!pcName.equals(thisPC.getPortComponentName())) continue;
                pc = thisPC;
            }
        }
        if (pc != null && (sib = pc.getServiceImplBean()) != null && (ejbLink = sib.getEEJBLink()) != null && (ejbName = ejbLink.getEjbLink()) != null) {
            theEjb = ejbJarDD.getEnterpriseBeanNamed(ejbName);
        }
        return theEjb;
    }

    private boolean ejbIsProtected(EnterpriseBean ejb, AssemblyDescriptor ad) {
        EList mpList = ad.getMethodPermissions();
        for (int i = 0; i < mpList.size(); ++i) {
            List mpeList;
            MethodPermission mp = (MethodPermission)mpList.get(i);
            if (mp.isUnchecked() || (mpeList = mp.getMethodElements(ejb)).size() <= 0) continue;
            return true;
        }
        return false;
    }

    private EJBJarFile createModule(JMSRouterDescriptor routerHolder, EARFile earFile, EJBJarFile ejbJarFile) throws Exception {
        int j2eeVersionID = ejbJarFile.getSpecVersionID();
        EJBJarFile jarFile = this.archiveFactory.createEJBJarFileInitialized(routerHolder.getTargetURI());
        jarFile.setJ2EEVersion(j2eeVersionID);
        ArchiveManifest archiveManifest = jarFile.getManifest();
        archiveManifest.setManifestVersion("1.0");
        archiveManifest.setClassPath(routerHolder.getClassPath());
        EJBJar ejbDD = jarFile.getDeploymentDescriptor(false);
        Object[] inserts = new String[]{"JMS", routerHolder.getEjbJarName()};
        ejbDD.setDisplayName(Messages.getFormattedMessage((String)"enabler.routerDisplayName", (Object[])inserts, (String)"{0} router for {1}"));
        MessageDriven mdb = ejbFactory.createMessageDriven();
        mdb.setName(JMS_ROUTER_MDB_NAME);
        if (this.JAXWSEndpointPresent()) {
            mdb.setEjbClassName(JAXWS_JMS_ROUTER_MDB_CLASSNAME);
        } else {
            mdb.setEjbClassName(JMS_ROUTER_MDB_CLASSNAME);
        }
        mdb.setTransactionType(TransactionType.CONTAINER_LITERAL);
        if (j2eeVersionID > 13) {
            mdb.setMessagingType(JavaClassImpl.createClassRef((String)JMS_MESSAGE_LISTENER_CLASS));
        }
        String destinationType = routerHolder.getDestinationType();
        if (j2eeVersionID > 13) {
            JavaClass jClass = null;
            jClass = destinationType.equalsIgnoreCase(DESTINATION_TYPE_TOPIC) ? JavaClassImpl.createClassRef((String)DESTINATION_TYPE_TOPIC_CLASS) : JavaClassImpl.createClassRef((String)DESTINATION_TYPE_QUEUE_CLASS);
            mdb.setMessageDestination(jClass);
            ActivationConfig activationConfig = ejbFactory.createActivationConfig();
            ActivationConfigProperty activationConfigProperty = ejbFactory.createActivationConfigProperty();
            activationConfigProperty.setName(JMS_CONFIG_PROP_NAME);
            activationConfigProperty.setValue(jClass.getQualifiedName());
            activationConfig.getConfigProperties().add(activationConfigProperty);
            mdb.setActivationConfig(activationConfig);
        } else {
            MessageDrivenDestination mdbDest = ejbFactory.createMessageDrivenDestination();
            if (destinationType.equalsIgnoreCase(DESTINATION_TYPE_TOPIC)) {
                mdbDest.setType(DestinationType.TOPIC_LITERAL);
            } else {
                mdbDest.setType(DestinationType.QUEUE_LITERAL);
            }
            mdb.setDestination(mdbDest);
        }
        ResourceEnvRef resRef = commonFactory.createResourceEnvRef();
        resRef.setName("jms/WebServicesReplyQCF");
        resRef.setTypeName("javax.jms.QueueConnectionFactory");
        Description description = commonFactory.createDescription();
        description.setValue(JMS_DESCRIPTION);
        resRef.getDescriptions().add(description);
        EList refList = mdb.getResourceEnvRefs();
        refList.add(resRef);
        EList beanList = ejbDD.getEnterpriseBeans();
        beanList.add(mdb);
        MessageDrivenBeanBinding mdbBinding = ejbbndFactory.createMessageDrivenBeanBinding();
        if (j2eeVersionID > 13 && routerHolder.getActivationSpec() != null) {
            mdbBinding.setActivationSpecJndiName(routerHolder.getActivationSpec());
        } else if (routerHolder.getListenerPort() != null) {
            mdbBinding.setListenerInputPortName(routerHolder.getListenerPort());
        }
        if (destinationType.equalsIgnoreCase("queue") && routerHolder.getActivationSpec() == null && routerHolder.getListenerPort() != null) {
            String routerName = (String)this.listenerPortModuleMap.get(routerHolder.getListenerPort());
            if (routerName != null) {
                if (routerName != routerHolder.getTargetURI()) {
                    String backupMsg = "Listener input port {0} has already been configured for JMS router module {1}.";
                    Object[] msgInserts = new String[]{routerHolder.getListenerPort(), routerName};
                    String msg = Messages.getFormattedMessage((String)"enabler.listenerPortWarn1", (Object[])msgInserts, (String)backupMsg);
                    throw new Exception(msg);
                }
            } else {
                this.listenerPortModuleMap.put(routerHolder.getListenerPort(), routerHolder.getTargetURI());
            }
        }
        mdbBinding.setEnterpriseBean((EnterpriseBean)mdb);
        EJBJarBinding ejbBinding = jarFile.getBindings();
        EList ejbBindings = ejbBinding.getEjbBindings();
        ejbBindings.add(mdbBinding);
        return jarFile;
    }

    public void setForWSAD(boolean value) {
        this.forWSAD = value;
        if (this.forWSAD) {
            this.httpRouters = new Vector();
            this.jmsRouters = new Vector();
            this.wsBindings = new Hashtable();
        }
    }

    public Vector getHTTPRouters() {
        return this.httpRouters;
    }

    public Vector getJMSRouters() {
        return this.jmsRouters;
    }

    public Hashtable getWsBindings() {
        return this.wsBindings;
    }

    static {
        WSModels.init();
        webappFactory = WebapplicationFactory.eINSTANCE;
        ejbFactory = EjbFactory.eINSTANCE;
        ejbbndFactory = EjbbndFactory.eINSTANCE;
        commonFactory = CommonFactory.eINSTANCE;
        appBndFactory = ApplicationbndFactory.eINSTANCE;
    }
}

