/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.combined.deploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.webservice.wsbnd.RouterModule;
import com.ibm.etools.webservice.wsbnd.WSBinding;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.application.client.AppDeploymentTaskHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.webservices.combined.deploy.URLPrefixHolder;
import com.ibm.ws.webservices.deploy.BindingChoices;
import com.ibm.ws.webservices.deploy.DeployUtils;
import com.ibm.ws.websvcs.deploy.URLPrefixMapHelper;
import com.ibm.ws.websvcs.desc.WSDescriptionBuilderFactory;
import com.ibm.wsspi.webservices.models.WSModels;
import com.ibm.wsspi.websvcs.desc.WSDescriptionBuilder;
import com.ibm.wsspi.websvcs.desc.WSEndpointDescriptor;
import com.ibm.wsspi.websvcs.desc.WSModuleDescriptor;
import com.ibm.wsspi.websvcs.desc.WSServiceDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingChoicesTaskHelper
implements AppDeploymentTaskHelper {
    private static TraceComponent _tc = Tr.register(BindingChoicesTaskHelper.class, "WebServices", "com.ibm.ws.webservices.deploy.resources.deployMessages");
    private WSDescriptionBuilder builder = WSDescriptionBuilderFactory.getBuilder();
    private boolean isForAppInstall;

    public BindingChoicesTaskHelper() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "BindingChoicesTaskHelper default ctor, this=" + this.toString());
        }
        this.isForAppInstall = false;
    }

    public BindingChoicesTaskHelper(boolean forAppInstall) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "BindingChoicesTaskHelper ctor, this=" + this.toString() + ", isForAppInstall=" + (forAppInstall ? "true" : "false"));
        }
        this.isForAppInstall = forAppInstall;
    }

    public AppDeploymentTask createTask(AppDeploymentController controller, String taskName) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "createTask, this=" + this.toString());
        }
        BindingChoices task = null;
        try {
            task = new BindingChoices(controller);
        }
        catch (Exception ex) {
            FFDCFilter.processException(ex, this.getClass().getName(), "109");
            Tr.error(_tc, "WSWS0020E", ex);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "createTask, returning BindingChoices:" + (task == null ? "<null>" : task));
        }
        return task;
    }

    public void prepareTask(AppDeploymentInfo info, AppDeploymentTask task) throws AppDeploymentException {
        String[][] taskData;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "prepareTask, this=" + this.toString());
        }
        if (task.getTaskData() != null) {
            return;
        }
        task.setIsSufficientlyDone(true);
        HashMap<String, URLPrefixHolder> holderMap = new HashMap<String, URLPrefixHolder>();
        URLPrefixHolder.setAppUrlHolderMap(info.getAppDisplayName(), holderMap);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Created holderMap for application " + info.getAppDisplayName());
        }
        if ((taskData = this.createTaskData(holderMap, info, task)) == null) {
            task.setIsTaskDisabled(true);
            ArrayList<String> data = new ArrayList<String>();
            String[] colNames = task.getColumnNames();
            for (int j = 0; j < colNames.length; ++j) {
                data.add(colNames[j]);
            }
            taskData = util.buildTaskData(new Vector(data), (int)task.getColumnNames().length);
            task.setTaskData(taskData);
        } else {
            task.setIsTaskDisabled(false);
            task.setTaskData(taskData);
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "taskData:\n" + DeployUtils.taskDataToString((String[][])taskData));
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "prepareTask");
        }
    }

    public void completeTask(AppDeploymentInfo info, AppDeploymentTask task) throws AppDeploymentException {
        String[][] taskData;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "completeTask, this=" + this.toString());
        }
        if ((taskData = task.getTaskData()) == null) {
            return;
        }
        HashMap<String, URLPrefixHolder> holderMap = URLPrefixHolder.getAppUrlHolderMap(info.getAppDisplayName());
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Retrieved holderMap for application " + info.getAppDisplayName() + ": " + (holderMap == null ? "<null>" : holderMap));
        }
        if (holderMap == null) {
            return;
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "taskData contains:\n" + DeployUtils.taskDataToString((String[][])task.getTaskData()));
        }
        for (int i = 1; i < taskData.length; ++i) {
            String moduleName = taskData[i][0];
            String protocol = taskData[i][1];
            String userInput = taskData[i][2];
            URLPrefixHolder holderObj = holderMap.get(moduleName);
            if (holderObj != null) {
                holderObj.getUrlPrefixMap().put(protocol, userInput);
                if (!_tc.isDebugEnabled()) continue;
                Tr.debug(_tc, "Applying task data to URL prefix map: " + protocol + "-->" + userInput);
                continue;
            }
            throw new AppDeploymentException("Internal error searching for URLPrefixHolder object for module " + moduleName, null);
        }
        if (!this.isForAppInstall) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Since this is NOT an app install, we'll save the URLPrefixMap info now.");
            }
            for (Map.Entry<String, URLPrefixHolder> entry : holderMap.entrySet()) {
                String moduleName = entry.getKey();
                URLPrefixHolder holder = entry.getValue();
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Saving URL prefix information for module " + moduleName + ": " + holder.getUrlPrefixMap().toString());
                }
                try {
                    holder.getUrlPrefixMapHelper().save(holder.getUrlPrefixMap());
                }
                catch (Throwable t) {
                    FFDCFilter.processException(t, this.getClass().getName(), "263");
                    throw new AppDeploymentException("Error saving URL prefix information for module: " + moduleName, t);
                }
            }
            URLPrefixHolder.setAppUrlHolderMap(info.getAppDisplayName(), null);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Cleared the holder map for application: " + info.getAppDisplayName());
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "completeTask");
        }
    }

    private String[][] createTaskData(HashMap<String, URLPrefixHolder> holderMap, AppDeploymentInfo info, AppDeploymentTask task) throws AppDeploymentException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "createTaskData");
        }
        Vector ejbJars = info.getModuleConfig("JAR_DD");
        WSModuleDescriptor moduleDesc = null;
        Iterator iter = ejbJars.iterator();
        while (iter.hasNext()) {
            HashMap<String, String> urlPrefixMap = null;
            URLPrefixMapHelper helper = null;
            EObject refObject = (EObject)iter.next();
            ModuleFile modFile = info.getModuleFileForDD(refObject);
            if (modFile.isEJBJarFile()) {
                block24: {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Processing EJB jar module " + modFile.getName());
                    }
                    WSBinding wsBinding = null;
                    try {
                        wsBinding = WSModels.getWSBinding(modFile.getLoadStrategy(), "META-INF/ibm-webservices-bnd.xmi");
                        if (wsBinding == null) break block24;
                        EList routers = wsBinding.getRouterModules();
                        for (RouterModule rm : routers) {
                            if (!rm.getTransport().equalsIgnoreCase("jms")) continue;
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Found a JMS router module: " + rm.getName());
                            }
                            helper = new URLPrefixMapHelper(info.getAppDisplayName(), modFile, task.getAppDeploymentController().getConfigSession());
                            try {
                                urlPrefixMap = helper.get();
                            }
                            catch (Throwable t) {
                                FFDCFilter.processException(t, this.getClass().getName(), "342");
                                urlPrefixMap = new HashMap();
                            }
                            String jmsPrefix = urlPrefixMap.get("jms");
                            if (jmsPrefix == null) {
                                urlPrefixMap.put("jms", "");
                            }
                            break;
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "CreateTaskData, call getModuleDescriptor to get the JAXRPC services");
                }
                moduleDesc = this.builder.getModuleDescriptor(modFile);
                Iterator serviceIt = moduleDesc.getJAXRPCServices();
                WSServiceDescriptor serviceDesc = null;
                WSEndpointDescriptor endpointDesc = null;
                Definition wsdlDef = null;
                QName bindingQName = null;
                Binding binding = null;
                boolean foundEJBEndpoint = false;
                while (!foundEJBEndpoint && serviceIt.hasNext()) {
                    serviceDesc = (WSServiceDescriptor)serviceIt.next();
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "CreateTaskData, find service " + serviceDesc.getName());
                    }
                    wsdlDef = serviceDesc.getWSDLDefinition();
                    Iterator endpointIt = serviceDesc.getEndpoints();
                    block9: while (!foundEJBEndpoint && endpointIt.hasNext()) {
                        endpointDesc = (WSEndpointDescriptor)endpointIt.next();
                        bindingQName = endpointDesc.getBindingQName();
                        binding = wsdlDef.getBinding(bindingQName);
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "find endpoint " + bindingQName);
                        }
                        List ees = binding.getExtensibilityElements();
                        String bindingNameSpace = null;
                        Iterator iter4 = ees.iterator();
                        while (!foundEJBEndpoint && iter4.hasNext()) {
                            String ejbPrefix;
                            ExtensibilityElement ee = (ExtensibilityElement)iter4.next();
                            QName qname = ee.getElementType();
                            if (!qname.getLocalPart().equals("binding") || !(bindingNameSpace = qname.getNamespaceURI()).equals("http://www.ibm.com/ns/2003/06/wsdl/mp/ejb")) continue;
                            foundEJBEndpoint = true;
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Found an EJB endpoint in module: " + modFile.getName());
                            }
                            if (helper == null) {
                                helper = new URLPrefixMapHelper(info.getAppDisplayName(), modFile, task.getAppDeploymentController().getConfigSession());
                                try {
                                    urlPrefixMap = helper.get();
                                }
                                catch (Throwable t) {
                                    FFDCFilter.processException(t, this.getClass().getName(), "463", this);
                                    urlPrefixMap = new HashMap();
                                }
                            }
                            if ((ejbPrefix = urlPrefixMap.get("ejb")) != null) continue block9;
                            urlPrefixMap.put("ejb", "");
                            if (!_tc.isDebugEnabled()) continue block9;
                            Tr.debug(_tc, "Added empty URL prefix for EJB protocol...");
                            continue block9;
                        }
                    }
                }
            }
            if (helper == null) continue;
            URLPrefixHolder holder = new URLPrefixHolder(urlPrefixMap, helper);
            holderMap.put(modFile.getName(), holder);
            if (!_tc.isDebugEnabled()) continue;
            Tr.debug(_tc, "Added URLPrefixHolder to map. Module=" + modFile.getName() + ", holder=" + holder.toString());
        }
        String[][] taskData = null;
        if (!holderMap.isEmpty()) {
            ArrayList<String> data = new ArrayList<String>();
            String[] colNames = task.getColumnNames();
            for (int j = 0; j < colNames.length; ++j) {
                data.add(colNames[j]);
            }
            Set<Map.Entry<String, URLPrefixHolder>> entrySet = holderMap.entrySet();
            this.addRowsForTransport(data, "jms", entrySet);
            this.addRowsForTransport(data, "ejb", entrySet);
            taskData = util.buildTaskData(new Vector(data), (int)task.getColumnNames().length);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "createTaskData, final taskData:\n" + (taskData == null ? "NULL" : DeployUtils.taskDataToString((String[][])taskData)));
        }
        return taskData;
    }

    private void addRowsForTransport(List data, String transport, Set entrySet) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "addRowsForTransport, transport=" + transport);
        }
        for (Map.Entry entry : entrySet) {
            URLPrefixHolder holder = (URLPrefixHolder)entry.getValue();
            String prefix = holder.getUrlPrefixMap().get(transport);
            if (prefix == null) continue;
            data.add(entry.getKey());
            data.add(transport);
            data.add(prefix);
            data.add("no");
            data.add("");
            data.add("");
        }
    }
}

