/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.admin.utils;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.WorkSpaceManagerFactory;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaData;
import com.ibm.ws.webservices.admin.serviceindex.ServiceIndexConstants;
import com.ibm.ws.webservices.admin.serviceindex.ServiceIndexWorkSpaceHelper;
import com.ibm.ws.webservices.admin.utils.ApplicationWorkSpaceHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class WSNClientWorkSpaceHelper
implements ServiceIndexWorkSpaceHelper,
ServiceIndexConstants {
    public static final String METADATA_TYPE = "buses";
    public static final String METADATA_DIR = "META-INF";
    private static TraceComponent tc = Tr.register(WSNClientWorkSpaceHelper.class, "webservices.admin", "com.ibm.ws.webservices.admin.resources.websvcsAdmin");

    public List listServiceIndexFiles(Session session, Properties props) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listServiceIndexFiles", new Object[]{props});
        }
        WorkSpace workspace = WorkSpaceManagerFactory.getManager().getWorkSpace(session.getUserName());
        String busName = null;
        String wsnName = null;
        if (props != null) {
            busName = props.getProperty("bus");
            wsnName = props.getProperty("WSNService");
        }
        List retList = null;
        retList = busName == null || busName.equals("*") ? this.listServiceIndexFilesInCell(workspace, wsnName) : (wsnName == null ? this.listServiceIndexFilesInBus(this.getBusRepositoryContext(workspace, busName), busName) : this.listServiceIndexFilesInWSNService(this.getBusRepositoryContext(workspace, busName), busName, wsnName));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listServiceIndexFiles");
        }
        return retList;
    }

    public List listServiceIndexFiles(Session session, String busName, String wsnServiceName) throws Exception {
        return new ArrayList();
    }

    private RepositoryContext getBusRepositoryContext(WorkSpace workspace, String busName) throws WorkSpaceException {
        Collection col = workspace.getRootContext().findContext(METADATA_TYPE, busName);
        Iterator contextIt = col.iterator();
        if (contextIt.hasNext()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getBusRepositoryContext, get deployment RepositoryContext for bus " + busName);
            }
            return (RepositoryContext)contextIt.next();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getBusRepositoryContext, cannot get deployment RepositoryContext for bus " + busName);
        }
        return null;
    }

    private List listServiceIndexFilesInCell(WorkSpace workspace, String specifiedWSNName) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listServiceIndexFilesInCell");
        }
        RepositoryMetaData metaData = workspace.getMetaData();
        RepositoryContextType contextType = metaData.getContextType(METADATA_TYPE);
        Collection col = workspace.findContext(contextType);
        Iterator contextIt = col.iterator();
        RepositoryContext repContext = null;
        List retList = new ArrayList();
        List oneList = null;
        while (contextIt.hasNext()) {
            repContext = (RepositoryContext)contextIt.next();
            String busName = this.getBusName(repContext);
            if (specifiedWSNName == null) {
                oneList = this.listServiceIndexFilesInBus(repContext, busName);
            } else {
                oneList = this.listServiceIndexFilesInWSNService(repContext, busName, specifiedWSNName);
                if (oneList.isEmpty()) {
                    Properties p = new Properties();
                    p.setProperty("WSNService", specifiedWSNName);
                    oneList.add(p);
                }
            }
            retList.addAll(oneList);
        }
        if (specifiedWSNName != null) {
            retList = ApplicationWorkSpaceHelper.processResult(retList, specifiedWSNName, "WSNService");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listServiceIndexFilesInCell");
        }
        return retList;
    }

    private List listServiceIndexFilesInBus(RepositoryContext repContext, String busName) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listServiceIndexFilesInBus", new Object[]{repContext, busName});
        }
        ArrayList<Properties> retList = new ArrayList<Properties>(1);
        if (repContext == null) {
            Properties p = new Properties();
            p.setProperty("bus", "PackageNotExist");
            retList.add(p);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "listServiceIndexFilesInBus - bus not found");
            }
            return retList;
        }
        List wsnWebserviceCtxs = repContext.getChildren();
        Iterator wsnWebserviceCtxsIt = wsnWebserviceCtxs.iterator();
        String fileName = null;
        while (wsnWebserviceCtxsIt.hasNext()) {
            RepositoryContext wsnWebserviceCtx = (RepositoryContext)wsnWebserviceCtxsIt.next();
            if (wsnWebserviceCtx == null) continue;
            String wsnServiceName = wsnWebserviceCtx.getName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "wsnServiceName : " + wsnServiceName);
            }
            Iterator filesIt = wsnWebserviceCtx.getFiles().iterator();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "wsnWebserviceCtx.getFiles().size() = " + wsnWebserviceCtx.getFiles().size());
            }
            while (filesIt.hasNext()) {
                fileName = (String)filesIt.next();
                if (!fileName.endsWith("servicesIndex.xml")) continue;
                if (!wsnWebserviceCtx.isExtracted(fileName)) {
                    wsnWebserviceCtx.extract(fileName, false);
                }
                StringBuffer strBuf = new StringBuffer(wsnWebserviceCtx.getPath());
                strBuf.append(File.separatorChar).append(fileName);
                Properties p = new Properties();
                p.setProperty("bus", busName);
                p.setProperty("WSNService", wsnServiceName);
                p.setProperty("file", strBuf.toString());
                retList.add(p);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "listServiceIndexFilesInBus : find file=" + strBuf.toString());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listServiceIndexFilesInBus - found bus");
        }
        return retList;
    }

    private List listServiceIndexFilesInWSNService(RepositoryContext repContext, String busName, String wsnServiceName) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listServiceIndexFilesInWSNService", new Object[]{repContext, busName, wsnServiceName});
        }
        ArrayList<Properties> retList = new ArrayList<Properties>(1);
        if (repContext == null) {
            Properties p = new Properties();
            p.setProperty("bus", "PackageNotExist");
            retList.add(p);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "listServiceIndexFilesInWSNService - bus not found");
            }
            return retList;
        }
        String fileName = null;
        boolean wsnFound = false;
        RepositoryContext wsnCtx = repContext.findContext("wsn/" + wsnServiceName);
        if (wsnCtx != null) {
            wsnFound = true;
            Iterator ctxIt = wsnCtx.getFiles().iterator();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "wsnCtx.getFiles().size() = " + wsnCtx.getFiles().size());
            }
            while (ctxIt.hasNext()) {
                fileName = (String)ctxIt.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "listServiceIndexFilesInWSNService, fileName is " + fileName);
                }
                if (!fileName.endsWith("servicesIndex.xml")) continue;
                if (!wsnCtx.isExtracted(fileName)) {
                    wsnCtx.extract(fileName, false);
                }
                StringBuffer strBuf = new StringBuffer(wsnCtx.getPath());
                strBuf.append(File.separatorChar).append(fileName);
                Properties p = new Properties();
                p.setProperty("bus", busName);
                p.setProperty("WSNService", wsnServiceName);
                p.setProperty("file", strBuf.toString());
                retList.add(p);
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "listServiceIndexFilesInWSNService, find the services index file " + strBuf.toString());
                break;
            }
        }
        if (!wsnFound) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "listServiceIndexFilesInWSNService, cannot found module: application=" + busName + "module=" + wsnServiceName);
            }
            Properties p = new Properties();
            p.setProperty("bus", busName);
            p.setProperty("WSNService", "PackageNotExist");
            retList.add(p);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "listServiceIndexFilesInWSNService, find module: application=" + busName + "module=" + wsnServiceName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listServiceIndexFilesInWSNService");
        }
        return retList;
    }

    private String getBusName(RepositoryContext repContext) {
        String path = repContext.getPath();
        int index = path.lastIndexOf(File.separatorChar);
        if (index < 0) {
            index = path.lastIndexOf(47);
        }
        String busName = path.substring(index + 1);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getBusName, path is " + path + ", busName=" + busName);
        }
        return busName;
    }
}

