/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.admin.utils;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.admin.exceptions.MultipleItemsFoundException;
import com.ibm.ws.webservices.admin.exceptions.NoItemFoundException;
import com.ibm.ws.webservices.admin.serviceindex.ServiceIndexConstants;
import com.ibm.ws.webservices.admin.utils.ServiceIndexMgrUtils;
import com.ibm.wsspi.extension.ExtensionRegistryFactory;
import com.ibm.wsspi.webservices.admin.extensions.ServiceProviderExtension;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceProviderUtils
implements ServiceIndexConstants {
    public static final String SERVICE_PROVIDER_EXT_ID = "com.ibm.wsfp.main.webservice-admin-provider-extension";
    private static final String FFDC_ID_1 = "FFDC-1";
    private static final String FFDC_ID_2 = "FFDC-2";
    private static final String SOURCE_FILE = "com.ibm.ws.webservices.admin.utils.ServiceProviderUtils";
    private static List providerExtensions = null;
    private static ResourceBundle resourceBundle = ResourceBundle.getBundle("com.ibm.ws.webservices.admin.resources.websvcsAdmin", Locale.getDefault());
    private static TraceComponent tc = Tr.register(ServiceProviderUtils.class, "webservices.admin", "com.ibm.ws.webservices.admin.resources.websvcsAdmin");

    public static ServiceProviderExtension getServiceProviderExtension(Properties props) throws Exception {
        List<ServiceProviderExtension> extList = ServiceProviderUtils.listServiceProviderExtensions(props);
        if (extList.size() == 1) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ServiceAdminExtensionUtil.getServiceProviderExtension, find one extension");
            }
            return extList.get(0);
        }
        if (extList.size() > 1) {
            throw new MultipleItemsFoundException(ServiceIndexMgrUtils.getFormattedMessage(resourceBundle, "CWSAD0083E", new Object[]{new Integer(extList.size()), "service provider"}, "Find multiple ServiceIndexManager extensions for properties " + props));
        }
        throw new NoItemFoundException(ServiceIndexMgrUtils.getFormattedMessage(resourceBundle, "CWSAD0083E", new Object[]{"0", "service provider"}, "Find 0 ServiceIndexManager extension for properties " + props));
    }

    public static List<String> getWSDLDocuments(Session session, Properties serviceProps) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ServiceProviderUtils.getWSDLDocuments", new Object[]{serviceProps});
        }
        ServiceProviderExtension extension = ServiceProviderUtils.getServiceProviderExtension(serviceProps);
        List<String> wsdlFiles = extension.getWSDLFiles(session, serviceProps);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ServiceProviderUtils.getWSDLDocuments", new Object[]{serviceProps, wsdlFiles});
        }
        return wsdlFiles;
    }

    private static List<ServiceProviderExtension> listServiceProviderExtensions(Properties props) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ServiceProviderUtils.listServiceProviderExtensions", new Object[]{props});
        }
        if (providerExtensions == null) {
            providerExtensions = ServiceProviderUtils.getExtensions(null);
        }
        ServiceProviderExtension extension = null;
        ArrayList<ServiceProviderExtension> retList = new ArrayList();
        if (props == null || props.isEmpty()) {
            retList = providerExtensions;
        } else {
            ArrayList packagePropList = new ArrayList();
            for (int i = 0; i < providerExtensions.size(); ++i) {
                extension = (ServiceProviderExtension)providerExtensions.get(i);
                if (!ServiceIndexMgrUtils.isPackageSupported(extension.getServiceIndexManager(), props, packagePropList)) continue;
                retList.add(extension);
            }
            if (packagePropList.size() > 1) {
                StringBuffer buf = new StringBuffer();
                for (int i = 0; i < packagePropList.size(); ++i) {
                    buf.append((String)packagePropList.get(i));
                    if (i >= packagePropList.size() - 1) continue;
                    buf.append(", ");
                }
                throw new IllegalArgumentException(ServiceIndexMgrUtils.getFormattedMessage(resourceBundle, "CWSAD0021E", new Object[]{buf.toString()}, "The command parameters contain the following conflicting properties: " + buf.toString()));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ServiceProviderUtils.listServiceProviderExtensions, retList size=" + retList.size());
        }
        return retList;
    }

    private static synchronized List getExtensions(List loadedExtensions) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ServiceProviderUtils.getExtensions", new Object[]{loadedExtensions});
        }
        String extPoint = SERVICE_PROVIDER_EXT_ID;
        if (loadedExtensions != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "ServiceProviderUtils.getExtensions, extensions already loaded for " + extPoint);
            }
            return loadedExtensions;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Loading extensions for " + extPoint);
        }
        ArrayList<ServiceProviderExtension> extensions = new ArrayList<ServiceProviderExtension>();
        try {
            IExtensionRegistry registry = ExtensionRegistryFactory.instance().getExtensionRegistry();
            IConfigurationElement[] elements = registry.getConfigurationElementsFor(extPoint);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found " + elements.length + " extensions for " + extPoint);
            }
            for (int i = 0; i < elements.length; ++i) {
                try {
                    ServiceProviderExtension extension;
                    Object o = elements[i].createExecutableExtension("classname");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Create ServiceProviderUtils extension for " + o.getClass().getName());
                    }
                    if (!ServiceProviderUtils.validateServiceProviderExtension(extension = (ServiceProviderExtension)o)) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "add extension: " + extension.getClass().getName());
                    }
                    extensions.add(extension);
                    continue;
                }
                catch (Exception ex1) {
                    FFDCFilter.processException(ex1, SOURCE_FILE, FFDC_ID_1);
                }
            }
        }
        catch (Exception ex) {
            FFDCFilter.processException(ex, SOURCE_FILE, FFDC_ID_2);
            throw ex;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ServiceProviderUtils.getExtensions");
        }
        return extensions;
    }

    private static boolean validateServiceProviderExtension(ServiceProviderExtension ext) {
        if (ext.getServiceIndexManager() == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ServiceProviderUtils.validateServiceProviderExtension, getServiceIndexManager returns null");
            }
            return false;
        }
        return ServiceIndexMgrUtils.validateServiceIndexManager(ext.getServiceIndexManager());
    }
}

