/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.admin.utils;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.admin.serviceindex.ServiceIndexConstants;
import com.ibm.ws.webservices.admin.status.AppTargetCache;
import com.ibm.ws.webservices.admin.utils.BLAUtils;
import com.ibm.ws.webservices.admin.utils.CommonUtils;
import com.ibm.ws.webservices.admin.utils.ServiceProviderUtils;
import com.ibm.wsspi.webservices.admin.ServicesAdminConstants;
import com.ibm.wsspi.webservices.admin.extensions.ServiceProviderExtension;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceProviderExtensionHelper
implements ServicesAdminConstants,
ServiceIndexConstants {
    private static final TraceComponent _tc = Tr.register(ServiceProviderExtensionHelper.class, "webservices.admin", "com.ibm.ws.webservices.admin.resources.websvcsAdmin");
    private static final String SOURCE_FILE = "com.ibm.ws.webservices.admin.utils.ServiceProviderExtensionHelper";
    private static ResourceBundle _resourceBundle = ResourceBundle.getBundle("com.ibm.ws.webservices.admin.resources.websvcsAdmin", Locale.getDefault());
    private static final String FFDC_ID_1 = "FFDC-1";
    private static final String FFDC_ID_2 = "FFDC-2";
    private static final String FFDC_ID_3 = "FFDC-3";
    private static final String FFDC_ID_4 = "FFDC-4";
    private static final String FFDC_ID_5 = "FFDC-5";
    private static final String FFDC_ID_6 = "FFDC-6";
    private static final String DUMMY_MODULE = "dummyModule";
    private static ServiceProviderExtensionHelper extensionHelper = new ServiceProviderExtensionHelper();

    public static ServiceProviderExtensionHelper getInstance() {
        return extensionHelper;
    }

    public ServiceProviderExtension getProviderExtension(Properties props) throws Exception {
        ServiceProviderExtension extension = ServiceProviderUtils.getServiceProviderExtension(props);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "ServiceProviderExtensionHelper.getProviderExtension returns extension for props=" + props);
        }
        return extension;
    }

    public boolean validateParameters(Properties queryProps, String target, String operation) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "ServiceProviderExtensionHelper.validateParameters", new Object[]{queryProps, operation});
        }
        ServiceProviderExtension provider = this.getProviderExtension(queryProps);
        String serviceName = queryProps.getProperty("service");
        String endpoint = queryProps.getProperty("logicalEndpoint");
        if (serviceName == null && !operation.equals("getServiceNames")) {
            throw new IllegalArgumentException(CommonUtils.getFormattedMessage(_resourceBundle, "CWSAD0026E", new Object[0], "The service name is missing in the parmeter"));
        }
        if (endpoint == null && operation.equals("getEndpointType")) {
            throw new IllegalArgumentException(CommonUtils.getFormattedMessage(_resourceBundle, "CWSAD0022E", new Object[0], "The logicalEndpoint name is missing in the parmeter"));
        }
        ObjectName oName = null;
        if (target != null && !target.equals("*")) {
            if (!target.startsWith("WebSphere:")) {
                target = "WebSphere:" + target;
            }
            oName = new ObjectName(target);
            String node = oName.getKeyProperty("node");
            String server = oName.getKeyProperty("server");
            String cluster = oName.getKeyProperty("cluster");
            if (server != null && cluster != null) {
                throw new IllegalArgumentException(CommonUtils.getFormattedMessage(_resourceBundle, "CWSAD0070E", new Object[0], "The target parameter contains both server name and cluster name."));
            }
            if (server == null && cluster == null) {
                throw new IllegalArgumentException(CommonUtils.getFormattedMessage(_resourceBundle, "CWSAD0035E", new Object[0], "The server or cluster name is missing in the parmeter"));
            }
            if (server != null && node == null) {
                throw new IllegalArgumentException(CommonUtils.getFormattedMessage(_resourceBundle, "CWSAD0034E", new Object[0], "The node name is missing in the parmeter"));
            }
            String key = null;
            Enumeration<String> e = oName.getKeyPropertyList().keys();
            while (e.hasMoreElements()) {
                key = e.nextElement();
                if (key.equals("cell") || key.equals("node") || key.equals("server") || key.equals("cluster")) continue;
                throw new IllegalArgumentException(CommonUtils.getFormattedMessage(_resourceBundle, "CWSAD0019E", new Object[]{key}, "Invalid property name: " + key));
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "ServiceProviderExtensionHelper.validateParameters, return true");
        }
        return true;
    }

    public Properties getJEEAppProperties(Properties props) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "ServiceProviderExtensionHelper.getJEEAppProperties", new Object[]{props});
        }
        ServiceProviderExtension provider = this.getProviderExtension(props);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "ServiceProviderExtensionHelper.getJEEAppProperties");
        }
        return this.getJEEAppProperties(provider, props);
    }

    public Properties getJEEAppProperties(ServiceProviderExtension provider, Properties props) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "ServiceProviderExtensionHelper.getJEEAppProperties", new Object[]{props});
        }
        try {
            Properties newProps = provider.getServiceIndexManager().getJEEAppProperties(props);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "ServiceProviderExtensionHelper.getJEEAppProperties, newProps=" + newProps);
            }
            return newProps;
        }
        catch (Exception ex) {
            FFDCFilter.processException(ex, SOURCE_FILE, FFDC_ID_1);
            if (_tc.isDebugEnabled()) {
                ex.printStackTrace();
            }
            throw ex;
        }
    }

    public String getAuthorizationResource(Properties props) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "ServiceProviderExtensionHelper.getAuthorizationResource", new Object[]{props});
        }
        try {
            ServiceProviderExtension provider = this.getProviderExtension(props);
            String resource = provider.getAuthorizationResource(props);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "ServiceProviderExtensionHelper.getAuthorizationResource, resource=" + resource);
            }
            return resource;
        }
        catch (Exception ex) {
            FFDCFilter.processException(ex, SOURCE_FILE, FFDC_ID_2);
            if (_tc.isDebugEnabled()) {
                ex.printStackTrace();
            }
            throw ex;
        }
    }

    public String getAssetStatusOnTarget(ServiceProviderExtension provider, Properties props, String target) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "ServiceProviderExtensionHelper.getAssetStatusOnTarget", new Object[]{props, target});
        }
        try {
            ObjectName targetOName = null;
            if (target != null && !target.equals("*")) {
                if (!target.startsWith("WebSphere:")) {
                    target = "WebSphere:" + target;
                }
                targetOName = new ObjectName(target);
            }
            String status = provider.getAssetStatus(props, targetOName);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "ServiceProviderExtensionHelper.getAssetStatusOnTarget", new Object[]{targetOName, status});
            }
            return status;
        }
        catch (Exception ex) {
            FFDCFilter.processException(ex, SOURCE_FILE, FFDC_ID_3);
            if (_tc.isDebugEnabled()) {
                ex.printStackTrace();
            }
            throw ex;
        }
    }

    public List<ObjectName> getMatchedTargets(ServiceProviderExtension provider, Properties queryProps, String requestedTarget) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "ServiceProviderExtensionHelper.getMatchedTargets", new Object[]{queryProps, requestedTarget});
        }
        List<ObjectName> matchedTargetList = null;
        try {
            List<ObjectName> targetList = provider.getDeploymentTargets(queryProps);
            if (targetList != null && targetList.size() != 0) {
                List<ObjectName> expandedTargetList = BLAUtils.getExpandedTargets(targetList, null);
                Properties appProps = provider.getServiceIndexManager().getJEEAppProperties(queryProps);
                AppTargetCache.ModuleTargetInfo targetInfo = new AppTargetCache.ModuleTargetInfo(DUMMY_MODULE);
                targetInfo.setTargetList(expandedTargetList);
                matchedTargetList = targetInfo.getMatchedTargets(requestedTarget);
                if (_tc.isDebugEnabled()) {
                    for (int i = 0; i < matchedTargetList.size(); ++i) {
                        Tr.debug(_tc, "ServiceProviderExtensionHelper.getMatchedTargets, matched target " + i + ": " + matchedTargetList.get(i));
                    }
                }
            } else if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "ServiceProviderExtensionHelper.getMatchedTargets, ServiceProviderExtension returns no target");
            }
        }
        catch (Exception ex) {
            FFDCFilter.processException(ex, SOURCE_FILE, FFDC_ID_4);
            if (_tc.isDebugEnabled()) {
                ex.printStackTrace();
            }
            throw ex;
        }
        if (matchedTargetList == null || matchedTargetList.isEmpty()) {
            throw new IllegalArgumentException(CommonUtils.getFormattedMessage(_resourceBundle, "CWSAD0084E", new Object[]{requestedTarget}, "The asset is not installed on the target: " + requestedTarget));
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "ServiceProviderExtensionHelper.getMatchedTargets", new Object[]{queryProps, requestedTarget});
        }
        return matchedTargetList;
    }

    public String getAssetStatusIfApplicable(Properties props) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "ServiceProviderExtensionHelper.getAssetStatusIfApplicable", new Object[]{props});
        }
        try {
            ServiceProviderExtension provider = this.getProviderExtension(props);
            if (!provider.isEndpointListenerSupported()) {
                String status = provider.getAssetStatus(props, null);
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "ServiceProviderExtensionHelper.getStatus, endpoint listener is not supported", new Object[]{props, status});
                }
                if (status == null) {
                    status = "Unavailable";
                }
                return status;
            }
            Properties appProps = provider.getServiceIndexManager().getJEEAppProperties(props);
            props.setProperty("application", appProps.getProperty("application"));
            props.setProperty("module", appProps.getProperty("module"));
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "ServiceProviderExtensionHelper.getAssetStatusIfApplicable, endpoint listener is supported", new Object[]{appProps, props});
            }
            return null;
        }
        catch (Exception ex) {
            FFDCFilter.processException(ex, SOURCE_FILE, FFDC_ID_5);
            if (_tc.isDebugEnabled()) {
                ex.printStackTrace();
            }
            throw ex;
        }
    }

    public String assetStatusToAppStatusMapping(String assetStatus) {
        String appStatus = "Unavailable";
        if ("Asset started".equals(assetStatus)) {
            appStatus = "ExecutionState.STARTED";
        } else if ("Asset stopped".equals(assetStatus)) {
            appStatus = "ExecutionState.STOPPED";
        } else if ("Asset partially started".equals(assetStatus)) {
            appStatus = "ExecutionState.PARTIAL_START";
        } else if ("Asset partially Stopped".equals(assetStatus)) {
            appStatus = "ExecutionState.PARTIAL_STOP";
        } else if ("Unavailable".equals(assetStatus)) {
            appStatus = "ExecutionState.UNAVAILABLE";
        } else if ("Unavailable".equals(assetStatus)) {
            appStatus = "ExecutionState.UNAVAILABLE";
        } else {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "assetStatusToAppStatusMapping: assetStatus is unrecognized: " + assetStatus);
            }
            appStatus = "ExecutionState.UNKNOWN";
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "assetStatusToAppStatusMapping, assetStatus=" + assetStatus + ", appStatus=" + appStatus);
        }
        return appStatus;
    }

    private String assetStatusToEndpointListenerStatus(String assetStatus) {
        String endpointStatus = "Unavailable";
        if ("Asset started".equals(assetStatus)) {
            endpointStatus = "Started";
        } else if ("Asset stopped".equals(assetStatus)) {
            endpointStatus = "Stopped and not startable";
        } else if ("Asset partially started".equals(assetStatus)) {
            endpointStatus = "Partially started";
        } else if ("Asset partially Stopped".equals(assetStatus)) {
            endpointStatus = "Stopped and not startable";
        } else if ("Unavailable".equals(assetStatus)) {
            endpointStatus = "Unavailable";
        } else if ("Unavailable".equals(assetStatus)) {
            endpointStatus = "Unavailable";
        } else {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "assetStatusToEndpointListenerStatus: assetStatus is unrecognized: " + assetStatus);
            }
            endpointStatus = "Unavailable";
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "assetStatusToEndpointListenerStatus, assetStatus=" + assetStatus + ", endpointStatus=" + endpointStatus);
        }
        return endpointStatus;
    }
}

