/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.admin.utils;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.admin.exceptions.MultipleItemsFoundException;
import com.ibm.ws.webservices.admin.exceptions.NoItemFoundException;
import com.ibm.ws.webservices.admin.serviceindex.ServiceIndexConstants;
import com.ibm.wsspi.extension.ExtensionRegistryFactory;
import com.ibm.wsspi.webservices.admin.extensions.ServiceIndexManager;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;

public class ServiceIndexMgrUtils
implements ServiceIndexConstants {
    private static final String FFDC_ID_1 = "FFDC-1";
    private static final String FFDC_ID_2 = "FFDC-2";
    private static final String FFDC_ID_3 = "FFDC-3";
    private static final String SOURCE_FILE = "com.ibm.ws.webservices.admin.utils.ServiceIndexMgrUtils";
    private static List siMgrExtensions = null;
    private static List propertyNames = new ArrayList();
    private static List assetTypes = new ArrayList();
    private static Map<String, String[]> providerTypeToPackageMap = null;
    private static Map<String, String[]> clientTypeToPackageMap = null;
    private static ResourceBundle resourceBundle = ResourceBundle.getBundle("com.ibm.ws.webservices.admin.resources.websvcsAdmin", Locale.getDefault());
    private static TraceComponent tc = Tr.register(ServiceIndexMgrUtils.class, "webservices.admin", "com.ibm.ws.webservices.admin.resources.websvcsAdmin");
    private static final String[] SERVICE_PROPERTY_NAMES = new String[]{"service", "serviceType", "client", "systemApp", "assetType"};

    public static StringBuffer validatePropertyNames(Properties props) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validatePropertyNames", new Object[]{props});
        }
        if (siMgrExtensions == null) {
            siMgrExtensions = ServiceIndexMgrUtils.getExtensions();
        }
        if (props == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "validatePropertyNames");
            }
            return new StringBuffer();
        }
        StringBuffer invalidProps = new StringBuffer();
        Enumeration<?> nameEnum = props.propertyNames();
        String name = null;
        while (nameEnum.hasMoreElements()) {
            name = (String)nameEnum.nextElement();
            if (ServiceIndexMgrUtils.isMatched(name, propertyNames)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "validationPropertyNames, find invalid property name " + name);
            }
            if (nameEnum.hasMoreElements()) {
                invalidProps.append(name).append(",");
                continue;
            }
            invalidProps.append(name);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validatePropertyNames");
        }
        return invalidProps;
    }

    public static StringBuffer validatePropertyValues(Properties props, String expandResource) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validatePropertyValues", new Object[]{props, expandResource});
        }
        if (siMgrExtensions == null) {
            siMgrExtensions = ServiceIndexMgrUtils.getExtensions();
        }
        StringBuffer invalidProps = new StringBuffer();
        if (props != null) {
            String serviceType;
            String packageType = props.getProperty("assetType");
            if (!ServiceIndexMgrUtils.isMatched(packageType, assetTypes)) {
                invalidProps.append("assetType").append("=").append(packageType);
            }
            if ((serviceType = props.getProperty("serviceType")) != null) {
                boolean valid = false;
                ServiceIndexManager mgr = null;
                for (int i = 0; i < siMgrExtensions.size() && !(valid = ServiceIndexMgrUtils.isServiceTypeSupported(mgr = (ServiceIndexManager)siMgrExtensions.get(i), props)); ++i) {
                }
                if (!valid) {
                    Boolean client = new Boolean(props.getProperty("client"));
                    if (invalidProps.length() > 0) {
                        invalidProps.append(", ");
                    }
                    if (client.booleanValue()) {
                        invalidProps.append("service client ").append("serviceType").append("=").append(serviceType);
                    } else {
                        invalidProps.append("service provider ").append("serviceType").append("=").append(serviceType);
                    }
                }
            }
        }
        if (expandResource != null && !expandResource.equals("logicalEndpoint") && !expandResource.equals("operation")) {
            if (invalidProps.length() > 0) {
                invalidProps.append(", ");
            }
            invalidProps.append("expandResource").append("=").append(expandResource);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validatePropertyValues");
        }
        return invalidProps;
    }

    public static ServiceIndexManager getServiceIndexManager(Properties props) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ServiceIndexMgrUtils.getServiceIndexManager", new Object[]{props});
        }
        if (props == null || props.isEmpty()) {
            throw new IllegalArgumentException(ServiceIndexMgrUtils.getFormattedMessage(resourceBundle, "CWSAD0023E", new Object[0], "The parameter is null or empty"));
        }
        ArrayList packagePropList = new ArrayList();
        ServiceIndexMgrUtils.validatePropertyNames(props);
        List extList = ServiceIndexMgrUtils.getServiceIndexManagers(props, packagePropList);
        if (extList.size() == 1) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "ServiceAdminExtensionUtil.getServiceIndexManager, find one extension");
            }
            return (ServiceIndexManager)extList.get(0);
        }
        if (packagePropList.size() > 1) {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < packagePropList.size(); ++i) {
                buf.append((String)packagePropList.get(i)).append(" ");
            }
            throw new IllegalArgumentException(ServiceIndexMgrUtils.getFormattedMessage(resourceBundle, "CWSAD0021E", new Object[]{buf.toString()}, "The command parameters contain the following conflicting properties: " + buf.toString()));
        }
        if (extList.size() > 1) {
            throw new MultipleItemsFoundException(ServiceIndexMgrUtils.getFormattedMessage(resourceBundle, "CWSAD0083E", new Object[]{new Integer(extList.size()), "service index"}, "Find multiple ServiceIndexManager extensions for properties " + props));
        }
        throw new NoItemFoundException(ServiceIndexMgrUtils.getFormattedMessage(resourceBundle, "CWSAD0083E", new Object[]{"0", "service index"}, "Find 0 ServiceIndexManager extension for properties " + props));
    }

    public static List getServiceIndexManagers(Properties props, List packagePropList) throws Throwable {
        int i;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServiceIndexManagers", new Object[]{props});
        }
        if (siMgrExtensions == null) {
            siMgrExtensions = ServiceIndexMgrUtils.getExtensions();
        }
        ArrayList<ServiceIndexManager> retList = new ArrayList<ServiceIndexManager>();
        ServiceIndexManager mgr = null;
        if (props != null) {
            for (i = 0; i < siMgrExtensions.size(); ++i) {
                mgr = (ServiceIndexManager)siMgrExtensions.get(i);
                if (!ServiceIndexMgrUtils.isPackageSupported(mgr, props, packagePropList)) continue;
                retList.add(mgr);
            }
            if (packagePropList.size() > 1) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getServiceIndexManagers, has conflict packages, return null");
                }
                return null;
            }
        }
        if (retList.isEmpty()) {
            for (i = 0; i < siMgrExtensions.size(); ++i) {
                if (!ServiceIndexMgrUtils.isServiceTypeSupported((ServiceIndexManager)siMgrExtensions.get(i), props)) continue;
                retList.add((ServiceIndexManager)siMgrExtensions.get(i));
            }
        } else {
            for (i = retList.size() - 1; i >= 0; --i) {
                if (ServiceIndexMgrUtils.isServiceTypeSupported((ServiceIndexManager)siMgrExtensions.get(i), props)) continue;
                retList.remove(i);
            }
        }
        if (retList.isEmpty()) {
            Tr.debug(tc, "No ServiceIndexManager is found to support the query property. It means that the combination of package, service type, and client information is not supported");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServiceIndexManagers, return num retList=" + retList.size());
        }
        return retList;
    }

    public static String[] getPackageNamesForServiceType(String serviceType, boolean client) throws Throwable {
        if (clientTypeToPackageMap == null) {
            Map[] maps = ServiceIndexMgrUtils.createServiceTypeToPackageMap();
            clientTypeToPackageMap = maps[0];
            providerTypeToPackageMap = maps[1];
        }
        if (client) {
            return clientTypeToPackageMap.get(serviceType);
        }
        return providerTypeToPackageMap.get(serviceType);
    }

    protected static String getFormattedMessage(ResourceBundle bundle, String key, Object[] args, String msg) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFormattedMessage()", new Object[]{key, msg});
        }
        String formattedMsg = null;
        try {
            String result = bundle.getString(key);
            formattedMsg = result == null ? msg : MessageFormat.format(result, args);
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, "com.ibm.ws.webservices.admin.utils.ServiceIndexMgrUtils.getFormattedMessage", FFDC_ID_1);
            formattedMsg = msg;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFormattedMessage()", new Object[]{formattedMsg});
        }
        return formattedMsg;
    }

    private static synchronized List getExtensions() throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getExtensions");
        }
        if (siMgrExtensions != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getExtensions, service index extensions already loaded");
            }
            return siMgrExtensions;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Loading service index manager extensions");
        }
        ArrayList<ServiceIndexManager> extensions = new ArrayList<ServiceIndexManager>();
        try {
            IExtensionRegistry registry = ExtensionRegistryFactory.instance().getExtensionRegistry();
            IConfigurationElement[] elements = registry.getConfigurationElementsFor("com.ibm.wsfp.main.webservice-admin-serviceindex-manager");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found " + elements.length + " extensions for " + "com.ibm.wsfp.main.webservice-admin-serviceindex-manager");
            }
            HashMap properties = new HashMap();
            for (int i = 0; i < elements.length; ++i) {
                try {
                    ServiceIndexManager mgr;
                    Object o = elements[i].createExecutableExtension("classname");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Create ServiceIndexManager extension for " + o.getClass().getName());
                    }
                    if (!ServiceIndexMgrUtils.validateServiceIndexManager(mgr = (ServiceIndexManager)o)) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "add extension: " + mgr.getClass().getName());
                    }
                    extensions.add(mgr);
                    continue;
                }
                catch (Throwable t) {
                    FFDCFilter.processException(t, SOURCE_FILE, FFDC_ID_2);
                }
            }
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, SOURCE_FILE, FFDC_ID_3);
            throw t;
        }
        ServiceIndexMgrUtils.createValidPropertyNames(extensions);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getExtensions, load extensions");
        }
        return extensions;
    }

    private static void createValidPropertyNames(List extensions) {
        int i;
        ServiceIndexManager mgr = null;
        String tmpObj = null;
        String[] tmpArray = null;
        for (i = 0; i < extensions.size(); ++i) {
            mgr = (ServiceIndexManager)extensions.get(i);
            tmpObj = mgr.getAssetType();
            assetTypes.add(tmpObj);
            tmpArray = mgr.getAssetPackageNames();
            for (int n = 0; n < tmpArray.length; ++n) {
                propertyNames.add(tmpArray[n]);
            }
        }
        for (i = 0; i < SERVICE_PROPERTY_NAMES.length; ++i) {
            propertyNames.add(SERVICE_PROPERTY_NAMES[i]);
        }
    }

    private static boolean isMatched(String value, List validValues) {
        if (value == null) {
            return true;
        }
        for (int i = 0; i < validValues.size(); ++i) {
            if (!value.equals((String)validValues.get(i))) continue;
            return true;
        }
        return false;
    }

    private static boolean isMatched(String value, String[] validValues) {
        if (value == null) {
            return true;
        }
        for (int i = 0; i < validValues.length; ++i) {
            if (!value.equals(validValues[i])) continue;
            return true;
        }
        return false;
    }

    private static boolean isServiceTypeSupported(ServiceIndexManager siMgr, Properties props) {
        if (props == null) {
            props = new Properties();
        }
        String serviceType = props.getProperty("serviceType");
        String[] supportedTypes = null;
        Boolean client = new Boolean(props.getProperty("client"));
        supportedTypes = client != false ? siMgr.getServiceClientTypes() : siMgr.getServiceProviderTypes();
        if (supportedTypes == null || supportedTypes.length == 0) {
            return false;
        }
        if (serviceType == null) {
            return true;
        }
        for (int i = 0; i < supportedTypes.length; ++i) {
            if (!serviceType.equals(supportedTypes[i])) continue;
            return true;
        }
        return false;
    }

    protected static boolean isPackageSupported(ServiceIndexManager mgr, Properties props, List packagePropList) {
        if (props == null) {
            return true;
        }
        String packageType = props.getProperty("assetType");
        if (packageType != null && packageType.equals(mgr.getAssetType())) {
            packagePropList.add("assetType=" + packageType);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isPackageSupported, find ServiceIndexManager based on package type " + packageType);
            }
            return true;
        }
        String[] packageNames = mgr.getAssetPackageNames();
        for (int i = 0; i < packageNames.length; ++i) {
            if (props.getProperty(packageNames[i]) == null) continue;
            packagePropList.add(packageNames[i] + "=" + props.getProperty(packageNames[i]));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isPackageSupported, find ServiceIndexManager based on package name " + packageNames[i]);
            }
            return true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isPackageSupported return false for ServiceIndexManager, asset type=" + mgr.getAssetType());
        }
        return false;
    }

    protected static boolean validateServiceIndexManager(ServiceIndexManager mgr) {
        boolean valid = true;
        if (mgr.getAssetType() == null) {
            valid = false;
        } else if (mgr.getAssetPackageNames() == null || mgr.getAssetPackageNames().length == 0) {
            valid = false;
        }
        if (tc.isDebugEnabled()) {
            int i;
            Tr.debug(tc, "validateServiceIndexManager assetType=" + mgr.getAssetType());
            StringBuffer buf = new StringBuffer();
            String[] packageNames = mgr.getAssetPackageNames();
            if (packageNames != null) {
                for (int i2 = 0; i2 < packageNames.length; ++i2) {
                    buf.append(packageNames[i2]).append(",");
                }
            }
            Tr.debug(tc, "package names=" + buf.toString());
            buf = new StringBuffer();
            String[] serviceTypes = mgr.getServiceProviderTypes();
            if (serviceTypes != null) {
                for (i = 0; i < serviceTypes.length; ++i) {
                    buf.append(serviceTypes[i]).append(",");
                }
            }
            Tr.debug(tc, "provider service types=" + buf.toString());
            buf = new StringBuffer();
            serviceTypes = mgr.getServiceClientTypes();
            if (serviceTypes != null) {
                for (i = 0; i < serviceTypes.length; ++i) {
                    buf.append(serviceTypes[i]).append(",");
                }
            }
            Tr.debug(tc, "client service types=" + buf.toString());
            Tr.debug(tc, "validateServiceIndexManager valid=" + valid);
        }
        return valid;
    }

    private static synchronized Map[] createServiceTypeToPackageMap() throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ServiceIndexMgrUtils.updateServiceTypeToPackageMap");
        }
        if (siMgrExtensions == null) {
            siMgrExtensions = ServiceIndexMgrUtils.getExtensions();
        }
        HashMap<String, String[]> providerMap = new HashMap<String, String[]>();
        HashMap<String, String[]> clientMap = new HashMap<String, String[]>();
        ServiceIndexManager mgr = null;
        for (int i = 0; i < siMgrExtensions.size(); ++i) {
            mgr = (ServiceIndexManager)siMgrExtensions.get(i);
            String[] providerTypes = mgr.getServiceProviderTypes();
            String[] clientTypes = mgr.getServiceClientTypes();
            String[] packageNames = mgr.getAssetPackageNames();
            if (providerTypes != null) {
                for (String type : providerTypes) {
                    providerMap.put(type, packageNames);
                }
            }
            if (clientTypes != null) {
                for (String type : clientTypes) {
                    clientMap.put(type, packageNames);
                }
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "ServiceIndexMgrUtils.updateServiceTypeToPackageMap, providerTypeToPackageMap=" + providerTypeToPackageMap + ", clientTypeToPackageMap" + clientTypeToPackageMap);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ServiceIndexMgrUtils.updateServiceTypeToPackageMap");
        }
        return new HashMap[]{clientMap, providerMap};
    }
}

