/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.admin.utils;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.client.ConfigRepositoryClientFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.service.Server;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.util.Properties;

public class ConfigRepositoryUtils {
    private static TraceComponent _tc = Tr.register(ConfigRepositoryUtils.class, "webservices.admin", "com.ibm.ws.webservices.admin.resources.websvcsAdmin");
    private static final String CLASS_NAME = "com.ibm.ws.webservices.admin.utils.ConfigRepositoryUtils";
    private static ProcessInfo _processInfo = null;

    private ConfigRepositoryUtils() {
    }

    public static String getThisCellName() throws Exception {
        ProcessInfo processInfo = ConfigRepositoryUtils.getProcessInfo();
        return processInfo.getCellName();
    }

    public static String getThisClusterName() throws Exception {
        ProcessInfo processInfo = ConfigRepositoryUtils.getProcessInfo();
        return processInfo.getClusterName();
    }

    public static String getThisNodeName() throws Exception {
        ProcessInfo processInfo = ConfigRepositoryUtils.getProcessInfo();
        return processInfo.getNodeName();
    }

    public static String getThisServerName() throws Exception {
        ProcessInfo processInfo = ConfigRepositoryUtils.getProcessInfo();
        return processInfo.getServerName();
    }

    private static synchronized ProcessInfo getProcessInfo() throws Exception {
        ProcessInfo processInfo;
        if (_processInfo != null) {
            return _processInfo;
        }
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getProcessInfo");
        }
        String processType = null;
        AdminService adminService = AdminServiceFactory.getAdminService();
        if (adminService != null) {
            processType = adminService.getProcessType();
            if (processType.equals("AdminAgent")) {
                processInfo = new ProcessInfo(adminService);
            } else {
                ConfigRepositoryUtils requestor = new ConfigRepositoryUtils();
                Server server = null;
                try {
                    server = WsServiceRegistry.getService(requestor, Server.class);
                    if (server == null) {
                        Exception oee = new Exception("getProcessInfo: Server service not found.");
                        if (_tc.isEntryEnabled()) {
                            Tr.exit(_tc, "getProcessInfo", oee);
                        }
                        throw oee;
                    }
                    processInfo = new ProcessInfo(server);
                }
                catch (Exception e) {
                    FFDCFilter.processException(e, "com.ibm.ws.webservices.admin.utils.ConfigRepositoryUtils.getProcessInfo", "788");
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "getProcessInfo", e);
                    }
                    throw e;
                }
            }
        } else {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "getProcessInfo: No AdminService.  Assuming process is not a server.");
            }
            processInfo = new ProcessInfo();
        }
        if (processType == null || !processType.equals("AdminAgent")) {
            _processInfo = processInfo;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getProcessInfo", processInfo);
        }
        return processInfo;
    }

    private static class ProcessInfo {
        private static TraceComponent _tc_pi = Tr.register(ProcessInfo.class, "webservices.admin", "com.ibm.ws.webservices.admin.resources.websvcsAdmin");
        private String _cellName;
        private String _nodeName;
        private String _serverName;
        private String _clusterName;

        public ProcessInfo(AdminService adminService) {
            if (_tc_pi.isEntryEnabled()) {
                Tr.entry(_tc_pi, "ProcessInfo(AdminService)", "adminService=" + adminService);
            }
            this._cellName = adminService.getCellName();
            this._nodeName = adminService.getNodeName();
            this._serverName = adminService.getProcessName();
            this._clusterName = null;
            if (_tc_pi.isEntryEnabled()) {
                Tr.exit(_tc_pi, "ProcessInfo(AdminService)", this.toString());
            }
        }

        public ProcessInfo(Server server) {
            if (_tc_pi.isEntryEnabled()) {
                Tr.entry(_tc_pi, "ProcessInfo(Server)", "server=" + server);
            }
            this._cellName = server.getCellName();
            this._nodeName = server.getNodeName();
            this._serverName = server.getName();
            this._clusterName = server.getClusterName();
            if (_tc_pi.isEntryEnabled()) {
                Tr.exit(_tc_pi, "ProcessInfo(Server)", this.toString());
            }
        }

        public ProcessInfo() {
            String cellName;
            if (_tc_pi.isEntryEnabled()) {
                Tr.entry(_tc_pi, "ProcessInfo()");
            }
            if ((cellName = System.getProperty("local.cell")) == null) {
                cellName = ProcessInfo.getCellNameFromConfig();
            }
            this._cellName = cellName;
            this._nodeName = System.getProperty("local.node");
            this._serverName = null;
            this._clusterName = null;
            if (_tc_pi.isEntryEnabled()) {
                Tr.exit(_tc_pi, "ProcessInfo()", this.toString());
            }
        }

        public String getCellName() {
            return this._cellName;
        }

        public String getNodeName() {
            return this._nodeName;
        }

        public String getServerName() {
            return this._serverName;
        }

        public String getClusterName() {
            return this._clusterName;
        }

        private static String getCellNameFromConfig() {
            ConfigRepository repo;
            if (_tc_pi.isEntryEnabled()) {
                Tr.entry(_tc_pi, "getCellNameFromConfig");
            }
            try {
                Properties rProps = new Properties();
                rProps.setProperty("location", "local");
                String configRoot = System.getProperty("user.install.root");
                if (configRoot != null) {
                    if (_tc_pi.isDebugEnabled()) {
                        Tr.debug(_tc_pi, "user.install.root defined as system property: " + configRoot);
                    }
                    rProps.setProperty("was.repository.root", configRoot);
                }
                repo = ConfigRepositoryClientFactory.getConfigRepositoryClient(rProps);
            }
            catch (AdminException e) {
                FFDCFilter.processException(e, "com.ibm.ws.webservices.admin.utils.ConfigRepositoryUtils.getCellNameFromConfig", "919");
                if (_tc_pi.isEventEnabled()) {
                    Tr.event(_tc_pi, "getCellNameFromConfig: Exception:", e);
                }
                if (_tc_pi.isEntryEnabled()) {
                    Tr.exit(_tc_pi, "getCellNameFromConfig", null);
                }
                return null;
            }
            String[] cells = repo.listResourceNames("cells", 2, 1);
            if (cells.length > 1) {
                if (_tc_pi.isEventEnabled()) {
                    Tr.event(_tc_pi, " Unexpected multiple config entries under cells/", cells);
                }
                if (_tc_pi.isEntryEnabled()) {
                    Tr.exit(_tc_pi, "getCellNameFromConfig", null);
                }
                return null;
            }
            if (cells.length == 0) {
                if (_tc_pi.isEventEnabled()) {
                    Tr.event(_tc_pi, "No config entries under cells/");
                }
                if (_tc_pi.isEntryEnabled()) {
                    Tr.exit(_tc_pi, "getCellNameFromConfig", null);
                }
                return null;
            }
            String cellName = cells[0];
            cellName = cellName.substring(cellName.lastIndexOf(47) + 1);
            if (_tc_pi.isEntryEnabled()) {
                Tr.exit(_tc_pi, "getCellNameFromConfig", cellName);
            }
            return cellName;
        }

        public String toString() {
            return "Process info: cellName=" + this._cellName + ", nodeName=" + this._nodeName + ", serverName=" + this._serverName + ", clusterName=" + this._clusterName;
        }
    }
}

