/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.admin.utils;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.WorkSpaceManagerFactory;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaData;
import com.ibm.ws.webservices.admin.serviceindex.ServiceIndexConstants;
import com.ibm.ws.webservices.admin.serviceindex.ServiceIndexWorkSpaceHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class CompUnitWorkSpaceHelper
implements ServiceIndexWorkSpaceHelper,
ServiceIndexConstants {
    public static final String METADATA_TYPE = "cus";
    public static final String MODULE_METADATA_DIR = "META-INF";
    private static TraceComponent tc = Tr.register(CompUnitWorkSpaceHelper.class, "webservices.admin", "com.ibm.ws.webservices.admin.resources.websvcsAdmin");

    public List listServiceIndexFiles(Session session, String cuName, String duName) throws Exception {
        return new ArrayList();
    }

    public List listServiceIndexFiles(Session session, Properties props) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listServiceIndexFiles", new Object[]{props});
        }
        WorkSpace workspace = WorkSpaceManagerFactory.getManager().getWorkSpace(session.getUserName());
        String cuName = null;
        if (props != null) {
            cuName = props.getProperty("cuName");
        }
        List retList = null;
        retList = cuName == null || cuName.equals("*") ? this.listServiceIndexFilesInCell(workspace) : this.listServiceIndexFilesInCU(this.getCURepositoryContext(workspace, cuName), cuName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listServiceIndexFiles");
        }
        return retList;
    }

    private RepositoryContext getCURepositoryContext(WorkSpace workspace, String cuName) throws WorkSpaceException {
        Collection col = workspace.getRootContext().findContext(METADATA_TYPE, cuName);
        Iterator contextIt = col.iterator();
        if (contextIt.hasNext()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getCURepositoryContext, get deployment RepositoryContext for CU " + cuName);
            }
            return (RepositoryContext)contextIt.next();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getCURepositoryContext, cannot get deployment RepositoryContext for CU " + cuName);
        }
        return null;
    }

    private List listServiceIndexFilesInCell(WorkSpace workspace) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listServiceIndexFilesInCell");
        }
        RepositoryMetaData metaData = workspace.getMetaData();
        RepositoryContextType contextType = metaData.getContextType(METADATA_TYPE);
        Collection col = workspace.findContext(contextType);
        Iterator contextIt = col.iterator();
        RepositoryContext repContext = null;
        ArrayList retList = new ArrayList();
        List oneList = null;
        while (contextIt.hasNext()) {
            repContext = (RepositoryContext)contextIt.next();
            String cuName = this.getCUName(repContext);
            oneList = this.listServiceIndexFilesInCU(repContext, cuName);
            retList.addAll(oneList);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listServiceIndexInCell");
        }
        return retList;
    }

    private List listServiceIndexFilesInCU(RepositoryContext repContext, String cuName) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listServiceIndexFilesInCU", new Object[]{repContext, cuName});
        }
        ArrayList<Properties> retList = new ArrayList<Properties>(1);
        if (repContext == null) {
            Properties p = new Properties();
            p.setProperty("cuName", "PackageNotExist");
            retList.add(p);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "listServiceIndexFilesInCU - app not found");
            }
            return retList;
        }
        Iterator it = repContext.getFiles().iterator();
        String fileName = null;
        while (it.hasNext()) {
            fileName = (String)it.next();
            if (!fileName.endsWith("servicesIndex.xml")) continue;
            if (!repContext.isExtracted(fileName)) {
                repContext.extract(fileName, false);
            }
            StringBuffer strBuf = new StringBuffer(repContext.getPath());
            strBuf.append(File.separatorChar).append(fileName);
            Properties p = new Properties();
            p.setProperty("cuName", cuName);
            p.setProperty("file", strBuf.toString());
            retList.add(p);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "listServiceIndexFilesInCU : find file=" + strBuf.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listServiceIndexFilesInCU");
        }
        return retList;
    }

    private String getCUName(RepositoryContext repContext) {
        String path = repContext.getPath();
        int index = path.lastIndexOf(File.separatorChar);
        if (index < 0) {
            index = path.lastIndexOf(47);
        }
        String cuName = path.substring(index + 1);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getCUName, path is " + path + ", cuName=" + cuName);
        }
        return cuName;
    }
}

