/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.admin.utils;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.admin.serviceindex.ServiceIndexConstants;
import com.ibm.ws.webservices.admin.utils.AppMgmtUtils;
import com.ibm.wsspi.management.bla.model.CompositionUnit;
import com.ibm.wsspi.management.bla.model.CompositionUnitFactory;
import com.ibm.wsspi.management.bla.model.CompositionUnitSpec;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BLAUtils
implements ServiceIndexConstants {
    private static TraceComponent tc = Tr.register(BLAUtils.class, "webservices.admin", "com.ibm.ws.webservices.admin.resources.websvcsAdmin");
    private static final String FFDC_ID_1 = "FFDC-1";
    private static final String SOURCE_FILE = "com.ibm.ws.webservices.admin.BLAUtils";
    private static final String COMP_UNIT = "cuName";

    public static List<ObjectName> getCUTargets(Properties queryProps, Session session) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "BLAUtils.getCUTargets", new Object[]{queryProps, session});
        }
        String cuName = queryProps.getProperty(COMP_UNIT);
        CompositionUnitFactory cuFact = CompositionUnitFactory.getSingleton();
        List cuSpecs = null;
        CompositionUnit cu = null;
        cuSpecs = session != null ? cuFact.listCompositionUnitSpecs(cuName, session.getUserName()) : cuFact.listCompositionUnitSpecs(cuName, (ConfigRepository)null);
        if (cuSpecs == null || cuSpecs.size() == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "BLAUtils.getCUTargets, no CU spec is found");
            }
            return new ArrayList<ObjectName>(0);
        }
        cu = session != null ? cuFact.readCompositionUnitFromCompositionUnitSpec((CompositionUnitSpec)cuSpecs.get(0), session.getUserName()) : cuFact.readCompositionUnitFromCompositionUnitSpec((CompositionUnitSpec)cuSpecs.get(0), (ConfigRepository)null);
        List targets = cu.listTargetsForCU();
        if (targets == null || targets.size() == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "BLAUtils.getCUTargets, find no target", new Object[]{queryProps, session});
            }
            return new ArrayList<ObjectName>(0);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getCUTargets, find targets.size() " + targets.size());
        }
        ArrayList<ObjectName> targetONs = new ArrayList<ObjectName>();
        ObjectName on = null;
        for (String target : targets) {
            String cellName;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "BLAUtils.getCUTargets(cuName, session), target=" + target);
            }
            if ((on = new ObjectName(target)).getKeyProperty("cell") == null && (cellName = BLAUtils.getCellName(session)) != null) {
                StringBuffer buf = new StringBuffer();
                buf.append(on.getDomain()).append(":cell=").append(cellName).append(",");
                buf.append(target.substring(target.indexOf(58) + 1));
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "BLAUtils.getCUTargets, updated target=" + buf.toString());
                }
                on = new ObjectName(buf.toString());
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "BLAUtils.getCUTargets(cuName, session), target on=" + on);
            }
            targetONs.add(on);
        }
        List<ObjectName> expandedTargetList = BLAUtils.getExpandedTargets(targetONs, session);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "BLAUtils.getCUTargets", new Object[]{queryProps, session});
        }
        return expandedTargetList;
    }

    public static List<ObjectName> getExpandedTargets(List<ObjectName> targetONs, Session session) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getExpandedTargets", new Object[]{targetONs});
        }
        ArrayList<ObjectName> expandedTargetONs = new ArrayList<ObjectName>();
        for (ObjectName oneTarget : targetONs) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "BLAUtils.getExpandedTargets, target: " + oneTarget);
            }
            if (oneTarget.getKeyProperty("cluster") == null) {
                expandedTargetONs.add(oneTarget);
                continue;
            }
            expandedTargetONs.addAll(AppMgmtUtils.getClusterMembers(oneTarget.toString(), session));
        }
        if (tc.isDebugEnabled()) {
            for (ObjectName target : expandedTargetONs) {
                Tr.debug(tc, "BLAUtils.getExpandedTargets, expanded target:" + target);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getExpandedTargets", new Object[]{targetONs});
        }
        return expandedTargetONs;
    }

    private static String getCellName(Session session) {
        String cell;
        block12: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "BLAUtils.getCellName, session=" + session);
            }
            cell = null;
            AdminService adminService = AdminServiceFactory.getAdminService();
            if (adminService != null) {
                cell = adminService.getCellName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "BLAUtils.getCellName, get cell name from AdminService: " + cell);
                }
            } else {
                cell = System.getProperty("local.cell");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "BLAUtils.getCellName, get cell name from local.cell: " + cell);
                }
                if (cell == null && session != null) {
                    try {
                        ConfigService configService = ConfigServiceFactory.getConfigService();
                        ObjectName[] cellObjs = configService.resolve(session, "Cell");
                        if (cellObjs == null || cellObjs.length == 0) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "BLAUtils.getCellName, ConfigService.resolve return 0 cell name");
                            }
                            return null;
                        }
                        String cellName = ConfigServiceHelper.getDisplayName(cellObjs[0]);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "BLAUtils.getCellName, get cell name from ConfigServiceHelper: ", cell);
                        }
                    }
                    catch (Exception ex) {
                        FFDCFilter.processException(ex, "com.ibm.ws.webservices.admin.BLAUtils.getCellName", FFDC_ID_1);
                        cell = null;
                        if (!tc.isDebugEnabled()) break block12;
                        Tr.debug(tc, "BLAUtils.getCellName, getCellName throws an exception" + ex.toString());
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "BLAUtils.getCellName, cell=" + cell);
        }
        return cell;
    }
}

