/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.admin.sysmgmt.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.resource.WASResourceSetImpl;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.webservices.admin.WebServiceAdminConstants;
import com.ibm.ws.webservices.admin.exceptions.NoItemFoundException;
import com.ibm.ws.webservices.admin.sysmgmt.SysMgmtHelper;
import com.ibm.wsspi.runtime.config.ConfigObject;
import com.ibm.wsspi.runtime.config.ConfigService;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseApplication;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseArchive;

public class SysMgmtRuntimeHelperImpl
implements SysMgmtHelper,
WebServiceAdminConstants {
    private static String WEB_APP_SUFFIX = ".war";
    private Repository repository = null;
    private ConfigService configService = null;
    protected String SOURCE_FILE = this.getClass().getName();
    private static TraceComponent tc = Tr.register(SysMgmtRuntimeHelperImpl.class, "webservices.admin", "com.ibm.ws.webservices.admin.resources.websvcsAdmin");
    private static ResourceBundle resourceBundle = ResourceBundle.getBundle("com.ibm.ws.webservices.admin.resources.websvcsAdmin", Locale.getDefault());
    private static final String FFDC_ID_1 = "FFDC-1";
    private static final String FFDC_ID_2 = "FFDC-2";
    private static final String FFDC_ID_3 = "FFDC-3";

    public SysMgmtRuntimeHelperImpl() {
        try {
            this.repository = WsServiceRegistry.getService(this, Repository.class);
        }
        catch (Exception e) {
            FFDCFilter.processException(e, this.SOURCE_FILE + ".SysMgmtRuntimeHelperImpl", FFDC_ID_1);
            Tr.error(tc, "Exception to get Repository: " + e.toString());
        }
        try {
            this.configService = WsServiceRegistry.getService(this, ConfigService.class);
        }
        catch (Exception e) {
            FFDCFilter.processException(e, this.SOURCE_FILE + ".SysMgmtRuntimeHelperImp", FFDC_ID_3);
            Tr.error(tc, "Exception to get ConfigService: " + e.toString());
        }
    }

    public String getFilePath(String appName, String moduleName, String fileName, boolean createIfNotFound) throws NoItemFoundException, WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SysMgmtRuntimeHelperImpl.getFilePath, app=" + appName + ", module=" + moduleName + ", file=" + fileName);
        }
        String fullPath = null;
        StringBuffer buf = new StringBuffer(this.repository.getRootURI());
        buf.append(File.separator).append("cells").append(File.separator);
        buf.append(this.repository.getCellName());
        buf.append(File.separator).append("applications").append(File.separator);
        buf.append(this.getAppPathFragment(buf.toString(), appName));
        String metadataPath = this.getMetaDataPath(buf.toString());
        fullPath = this.getFullPathForFileName(metadataPath, appName, moduleName, fileName);
        final File file = new File(fullPath);
        Boolean isFound = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                boolean exists = file.exists();
                return exists;
            }
        });
        if (isFound.booleanValue()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "SysMgmtRuntimeHelperImpl.getFilePath, file exists: app=" + appName + ", module=" + moduleName + ", file=" + fileName + ", return=" + fullPath);
            }
        } else {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "SysMgmtRuntimeHelperImpl.getFilePath, file does not exist: app=" + appName + ", module=" + moduleName + ", file=" + fileName + ", return=" + fullPath);
            }
            fullPath = null;
        }
        return fullPath;
    }

    public boolean updateFilePath(String appName, String moduleName, String fileName) throws NoItemFoundException, WorkSpaceException {
        throw new NoItemFoundException("Session object is null");
    }

    private String getAppPathFragment(String basePath, String appName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SysMgmtRuntimeHelperImpl.getAppPathFragment, base=" + basePath + "app=" + appName);
        }
        StringBuffer fragment = new StringBuffer();
        fragment.append(appName);
        fragment.append(".ear").append(File.separator).append("deployments");
        final File file = new File(basePath + File.separator + fragment.toString());
        StringBuffer buf = (StringBuffer)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                File[] files;
                StringBuffer strBuf = new StringBuffer();
                if (file.exists() && (files = file.listFiles()).length >= 1) {
                    strBuf.append(File.separator);
                    strBuf.append(files[0].getName());
                }
                return strBuf;
            }
        });
        fragment.append(buf);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SysMgmtRuntimeHelperImpl.getAppPathFragment, fragment=" + fragment.toString());
        }
        return fragment.toString();
    }

    private String getFullPathForFileName(String metadataPath, String appName, String modName, String fileName) {
        StringBuffer buf = new StringBuffer(metadataPath);
        buf.append(File.separator);
        if (modName.toLowerCase().endsWith(WEB_APP_SUFFIX)) {
            buf.append(modName).append(File.separator).append("WEB-INF").append(File.separator).append(fileName);
        } else {
            buf.append(modName).append(File.separator).append("META-INF").append(File.separator).append(fileName);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SysMgmtRuntimeHelperImpl.getFullPathForFileName, fullPath=" + buf.toString());
        }
        return buf.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getMetaDataPath(String basePath) {
        String metadataPath;
        block24: {
            EList archives;
            String resourcePath;
            String binariesURL;
            block25: {
                final String deploymentURI = basePath + "/deployment.xml";
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "application deployment.xml location is " + basePath + ", deploymentURI=" + deploymentURI);
                }
                metadataPath = null;
                String fileLoaded = deploymentURI;
                ConfigObject deployment = null;
                ConfigObject appDeploy = null;
                try {
                    List docs = null;
                    try {
                        docs = (List)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws IOException, ConfigurationError {
                                return SysMgmtRuntimeHelperImpl.this.configService.getDocumentObjects(null, deploymentURI);
                            }
                        });
                    }
                    catch (PrivilegedActionException e) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "SysMgmtRuntimeHelperImpl, exception thrown in getApplicationAttachment resource.load()");
                            Tr.debug(tc, "Cannot find deployments.xml, return basePath");
                        }
                        return basePath;
                    }
                    deployment = (ConfigObject)docs.get(0);
                    if (deployment == null) break block24;
                    appDeploy = deployment.getObject("deployedObject");
                    if (appDeploy.getBoolean("useMetadataFromBinaries", false)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "in deployment.xml, useMetadataFromBinaries = true");
                        }
                        binariesURL = appDeploy.getString("binariesURL", "__null__");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "application location is " + binariesURL);
                        }
                        if (binariesURL != null) {
                            metadataPath = binariesURL;
                            String looseConfigURI = null;
                            List list = appDeploy.getObjectList("properties");
                            for (ConfigObject prop : list) {
                                if (!"was.loose.config".equals(prop.getString("name", "__null__"))) continue;
                                looseConfigURI = prop.getString("value", "__null__");
                                if (!tc.isDebugEnabled()) break;
                                Tr.debug(tc, "loose config property is " + looseConfigURI);
                                break;
                            }
                            if (looseConfigURI != null) {
                                if (looseConfigURI.toLowerCase().startsWith("file:/")) {
                                    looseConfigURI = looseConfigURI.substring(6);
                                }
                                fileLoaded = looseConfigURI;
                                LooseApplication looseApplication = null;
                                WASResourceSetImpl resSet = new WASResourceSetImpl();
                                URI looseURI = URI.createFileURI(looseConfigURI);
                                final Resource looseResource = resSet.createResource(looseURI);
                                final InputStream instream = this.getInputStream(looseConfigURI);
                                if (looseResource == null || instream == null) break block24;
                                try {
                                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                                        public Object run() throws IOException {
                                            looseResource.load(instream, new HashMap());
                                            return null;
                                        }
                                    });
                                }
                                catch (PrivilegedActionException e) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Exception thrown in getApplicationAttachment looseResource.load()");
                                    }
                                    throw e.getException();
                                }
                                looseApplication = (LooseApplication)looseResource.getContents().get(0);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Read loose application object");
                                }
                                resourcePath = null;
                                if (looseApplication == null) break block24;
                                archives = looseApplication.getLooseArchives();
                                break block25;
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "No looseconfig.xmi found in deployment.xml so use standard attachment path");
                            }
                            metadataPath = basePath;
                            break block24;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "SysMgmtRuntimeHelperImpl.getMetadataPath, no binariesURL found in deployment.xml so use standard app path");
                        }
                        metadataPath = basePath;
                        break block24;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "SysMgmtRuntimeHelperImpl.getMetadataPath, deployment.xml useMetadataFromBinaries = false");
                    }
                    metadataPath = basePath;
                }
                catch (Throwable t) {
                    FFDCFilter.processException(t, this.SOURCE_FILE + ".getMetadataPath", FFDC_ID_2);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "SysMgmtRuntimeHelperImpl.getMetadataPath, exception loading file " + fileLoaded);
                    }
                    break block24;
                }
            }
            for (int j = 0; j < archives.size(); ++j) {
                LooseArchive archive = (LooseArchive)archives.get(j);
                if (!archive.getBinariesPath().equals(binariesURL)) continue;
                resourcePath = archive.getResourcesPath();
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "Found matching path in looseConfig.xml: " + resourcePath);
                break;
            }
            if (resourcePath != null) {
                metadataPath = resourcePath;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SysMgmtRuntimeHelperImpl.getMetadataPath, metadataPath=" + metadataPath);
        }
        return metadataPath;
    }

    private InputStream getInputStream(String pathname) {
        FileInputStream stream;
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "SysMgmtRuntimeHelperImpl.getInputStream", pathname);
            }
            stream = null;
            if (pathname != null) {
                try {
                    FileInputStream fis;
                    final File file = new File(pathname);
                    stream = fis = (FileInputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws FileNotFoundException {
                            return new FileInputStream(file);
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    if (!tc.isDebugEnabled()) break block5;
                    Tr.debug(tc, "FileNotFound: " + pathname);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SysMgmtRuntimeHelperImpl.getInputStream", pathname);
        }
        return stream;
    }
}

