/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.admin.sysmgmt.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.WorkSpaceFile;
import com.ibm.ws.sm.workspace.WorkSpaceManagerFactory;
import com.ibm.ws.webservices.admin.WebServiceAdminConstants;
import com.ibm.ws.webservices.admin.exceptions.NoItemFoundException;
import com.ibm.ws.webservices.admin.sysmgmt.SysMgmtHelper;
import com.ibm.ws.webservices.admin.utils.CommonUtils;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;

public class SysMgmtHelperImpl
implements SysMgmtHelper,
WebServiceAdminConstants {
    private static String APP_REPOSITORY_TYPE = "deployments";
    private static String WEB_APP_SUFFIX = ".war";
    private Session session;
    private static TraceComponent tc = Tr.register(SysMgmtHelperImpl.class, "webservices.admin", "com.ibm.ws.webservices.admin.resources.websvcsAdmin");
    private static ResourceBundle resourceBundle = ResourceBundle.getBundle("com.ibm.ws.webservices.admin.resources.websvcsAdmin", Locale.getDefault());

    public SysMgmtHelperImpl(Session session) {
        this.session = session;
    }

    public String getFilePath(String appName, String moduleName, String fileName, boolean createIfNotFound) throws NoItemFoundException, WorkSpaceException {
        String fullPath = null;
        boolean fileFound = false;
        boolean moduleFound = false;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFilePath, appName=" + appName + " , moduleName=" + moduleName + " , fileName=" + fileName + " , createIfNotFound=" + createIfNotFound);
        }
        SysMgmtHelperImpl.validateFileName(fileName);
        Collection repColl = SysMgmtHelperImpl.getAppRepositoryCollection(this.session, appName);
        Iterator repCollIt = repColl.iterator();
        RepositoryContext repContextDep = null;
        WorkSpaceFile workspaceFile = null;
        String expectedFileName = SysMgmtHelperImpl.getPathToFileName(moduleName, fileName);
        while (repCollIt.hasNext() && !fileFound) {
            repContextDep = (RepositoryContext)repCollIt.next();
            List fileList = repContextDep.getAllList(true);
            for (int k = 0; k < fileList.size(); ++k) {
                workspaceFile = (WorkSpaceFile)fileList.get(k);
                String wkFile = workspaceFile.getFileName();
                if (wkFile.contains(moduleName + File.separator)) {
                    moduleFound = true;
                }
                if (!wkFile.endsWith(expectedFileName)) continue;
                fileFound = true;
                k = fileList.size();
                if (!repContextDep.isAvailable(expectedFileName)) continue;
                if (!repContextDep.isExtracted(expectedFileName)) {
                    repContextDep.extract(expectedFileName, false);
                }
                fullPath = SysMgmtHelperImpl.getFullPath(repContextDep, expectedFileName);
            }
        }
        if (!moduleFound) {
            throw new NoItemFoundException(CommonUtils.getFormattedMessage(resourceBundle, "CWSAD0004E", new Object[]{moduleName}, "No module is found: " + moduleName));
        }
        if (!fileFound && createIfNotFound) {
            repContextDep.getOutputStream(expectedFileName);
            repContextDep.notifyChanged(0, expectedFileName);
            fullPath = SysMgmtHelperImpl.getFullPath(repContextDep, expectedFileName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFilePath, fullPath=" + fullPath);
        }
        return fullPath;
    }

    public boolean updateFilePath(String appName, String moduleName, String fileName) throws NoItemFoundException, WorkSpaceException {
        boolean updated = false;
        boolean fileFound = false;
        boolean moduleFound = false;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateFilePath, appName=" + appName + " , moduleName=" + moduleName + " , fileName=" + fileName);
        }
        SysMgmtHelperImpl.validateFileName(fileName);
        Collection repColl = SysMgmtHelperImpl.getAppRepositoryCollection(this.session, appName);
        Iterator repCollIt = repColl.iterator();
        RepositoryContext repContextDep = null;
        WorkSpaceFile workspaceFile = null;
        String expectedFileName = SysMgmtHelperImpl.getPathToFileName(moduleName, fileName);
        while (repCollIt.hasNext() && !fileFound) {
            repContextDep = (RepositoryContext)repCollIt.next();
            List fileList = repContextDep.getAllList(true);
            for (int k = 0; k < fileList.size(); ++k) {
                workspaceFile = (WorkSpaceFile)fileList.get(k);
                String wkFile = workspaceFile.getFileName();
                if (wkFile.contains(moduleName + File.separator)) {
                    moduleFound = true;
                }
                if (!wkFile.endsWith(expectedFileName)) continue;
                fileFound = true;
                k = fileList.size();
                if (!repContextDep.isAvailable(expectedFileName)) {
                    throw new NoItemFoundException(CommonUtils.getFormattedMessage(resourceBundle, "CWSAD0013E", new Object[]{expectedFileName}, "The file name was not found: " + expectedFileName));
                }
                repContextDep.notifyChanged(1, expectedFileName);
                updated = true;
            }
        }
        if (!moduleFound) {
            throw new NoItemFoundException(CommonUtils.getFormattedMessage(resourceBundle, "CWSAD0004E", new Object[]{moduleName}, "No module is found: " + moduleName));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateFilePath, expectedFileName=" + expectedFileName);
        }
        return updated;
    }

    public static Collection getAppRepositoryCollection(Session session, String appName) throws WorkSpaceException, NoItemFoundException {
        WorkSpace workspace = WorkSpaceManagerFactory.getManager().getWorkSpace(session.getUserName());
        Collection col = workspace.getRootContext().findContext(APP_REPOSITORY_TYPE, appName);
        Iterator contextIt = col.iterator();
        if (contextIt.hasNext()) {
            return col;
        }
        throw new NoItemFoundException(CommonUtils.getFormattedMessage(resourceBundle, "CWSAD0003E", new Object[]{appName}, "No application is found: " + appName));
    }

    private static String getPathToFileName(String moduleName, String fileName) {
        StringBuffer buf = new StringBuffer();
        if (moduleName.toLowerCase().endsWith(WEB_APP_SUFFIX)) {
            buf.append(moduleName).append(File.separator).append("WEB-INF").append(File.separator).append(fileName);
        } else {
            buf.append(moduleName).append(File.separator).append("META-INF").append(File.separator).append(fileName);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getPathToFileName, buf=" + buf.toString());
        }
        return buf.toString();
    }

    private static String getFullPath(RepositoryContext repContext, String fileURI) {
        StringBuffer buf = new StringBuffer(repContext.getPath());
        buf.append(File.separator).append(fileURI);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getFullPath, buf=" + buf.toString());
        }
        return buf.toString();
    }

    private static void validateFileName(String fileName) throws NoItemFoundException {
        if (fileName.contains("/") || fileName.contains("\\")) {
            throw new NoItemFoundException(CommonUtils.getFormattedMessage(resourceBundle, "CWSAD0012E", new Object[]{fileName}, "The file name provided is not allowed to have embedded slashes: " + fileName));
        }
    }
}

