/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.admin.serviceindex;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.webservices.admin.serviceindex.Endpoint;
import com.ibm.ws.webservices.admin.serviceindex.ServiceIndexConstants;
import com.ibm.ws.webservices.admin.serviceindex.ServiceIndexHelper;
import com.ibm.ws.webservices.admin.serviceindex.ServiceIndexWorkSpaceHelper;
import com.ibm.ws.webservices.admin.serviceindex.WebService;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;

public class ServiceIndexHelperFactory
implements ServiceIndexConstants {
    private static final String helperImplClass = "com.ibm.ws.webservices.admin.serviceindex.impl.ServiceIndexHelperImpl";
    private static final String webserviceImplClass = "com.ibm.ws.webservices.admin.serviceindex.impl.WebServiceBean";
    private static final String endpointImplClass = "com.ibm.ws.webservices.admin.serviceindex.impl.EndpointBean";
    private static final String APP_HELPER_Class = "com.ibm.ws.webservices.admin.utils.ApplicationWorkSpaceHelper";
    private static final String CU_HELPER_Class = "com.ibm.ws.webservices.admin.utils.CompUnitWorkSpaceHelper";
    private static final String WSN_HELPER_Class = "com.ibm.ws.webservices.admin.utils.WSNClientWorkSpaceHelper";
    private static TraceComponent tc = Tr.register(ServiceIndexHelperFactory.class, "webservices.admin", "com.ibm.ws.webservices.admin.resources.websvcsAdmin");

    public static ServiceIndexHelper createHelper(String appName, String moduleName, InputStream istream) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "createHelper, appName=" + appName + "moduleName=" + moduleName + ", istream=" + istream);
        }
        Properties p = new Properties();
        if (appName != null) {
            p.setProperty("application", appName);
        }
        if (moduleName != null) {
            p.setProperty("module", moduleName);
        }
        return ServiceIndexHelperFactory.createHelper(p, istream);
    }

    public static ServiceIndexHelper createHelper(String appName, String moduleName, String filePath) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "createHelper, appName=" + appName + "moduleName=" + moduleName + ", filePath=" + filePath);
        }
        Properties p = new Properties();
        if (appName != null) {
            p.setProperty("application", appName);
        }
        if (moduleName != null) {
            p.setProperty("module", moduleName);
        }
        p.setProperty("file", filePath);
        return ServiceIndexHelperFactory.createHelper(p);
    }

    public static ServiceIndexHelper createHelper(InputStream istream) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "createHelper, istream=" + istream);
        }
        return ServiceIndexHelperFactory.createHelper(new Properties(), istream);
    }

    public static ServiceIndexHelper createHelper(Properties packageProps, InputStream istream) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "createHelper, istream=" + istream);
        }
        if (packageProps == null) {
            packageProps = new Properties();
        }
        Class<?> helperClass = Class.forName(helperImplClass);
        Class[] signature = new Class[]{Properties.class, InputStream.class};
        Constructor<?> constructor = helperClass.getConstructor(signature);
        Object[] params = new Object[]{packageProps, istream};
        return (ServiceIndexHelper)constructor.newInstance(params);
    }

    public static ServiceIndexHelper createHelper(Properties p) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "createHelper, properties=" + p);
        }
        if (p == null) {
            p = new Properties();
        }
        Class<?> helperClass = Class.forName(helperImplClass);
        Class[] signature = new Class[]{Properties.class};
        Constructor<?> constructor = helperClass.getConstructor(signature);
        Object[] params = new Object[]{p};
        return (ServiceIndexHelper)constructor.newInstance(params);
    }

    public static WebService createWebService(String serviceName) throws IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "createWebService, serviceName=" + serviceName);
        }
        if (serviceName == null) {
            throw new IllegalArgumentException("createWebService: serviceName is null");
        }
        Class<?> helperClass = Class.forName(webserviceImplClass);
        Class[] signature = new Class[]{String.class};
        Constructor<?> constructor = helperClass.getConstructor(signature);
        Object[] params = new Object[]{serviceName};
        return (WebService)constructor.newInstance(params);
    }

    public static Endpoint createEndpoint(String endpointName) throws IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "createEndpoint, endpointName=" + endpointName);
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("createEndpoint: endpointName is null");
        }
        Class<?> helperClass = Class.forName(endpointImplClass);
        Class[] signature = new Class[]{String.class};
        Constructor<?> constructor = helperClass.getConstructor(signature);
        Object[] params = new Object[]{endpointName};
        return (Endpoint)constructor.newInstance(params);
    }

    public static ServiceIndexWorkSpaceHelper createWorkSpaceHelper(String packageType) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "createWorkSpaceHelper, packageType=" + packageType);
        }
        if (packageType == null || packageType.equals("application")) {
            Class<?> helperClass = Class.forName(APP_HELPER_Class);
            return (ServiceIndexWorkSpaceHelper)helperClass.newInstance();
        }
        if (packageType.equals("cuName")) {
            Class<?> helperClass = Class.forName(CU_HELPER_Class);
            return (ServiceIndexWorkSpaceHelper)helperClass.newInstance();
        }
        if (packageType.equals("WSNService")) {
            Class<?> helperClass = Class.forName(WSN_HELPER_Class);
            return (ServiceIndexWorkSpaceHelper)helperClass.newInstance();
        }
        throw new ClassNotFoundException("Do not have a ServiceIndexWorkSpaceHelper class to support package type " + packageType);
    }

    public static ServiceIndexWorkSpaceHelper createWorkSpaceHelper() throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "createWorkSpaceHelper");
        }
        return ServiceIndexHelperFactory.createWorkSpaceHelper("application");
    }
}

