/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.admin.management;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.management.authorizer.AdminAuthorizer;
import com.ibm.websphere.management.authorizer.AdminAuthorizerFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.status.StatusCacheClient;
import com.ibm.ws.management.status.StatusCacheFactory;
import com.ibm.ws.management.status.StatusReport;
import com.ibm.ws.management.util.Utils;
import com.ibm.ws.webservices.admin.serviceindex.ServiceIndexConstants;
import com.ibm.ws.webservices.admin.status.AppTargetCache;
import com.ibm.ws.webservices.admin.utils.AppMgmtUtils;
import com.ibm.ws.webservices.admin.utils.CommonUtils;
import com.ibm.ws.webservices.admin.utils.EndpointStatusUtils;
import com.ibm.ws.webservices.admin.utils.ServiceProviderExtensionHelper;
import com.ibm.wsspi.webservices.admin.ServicesAdminConstants;
import com.ibm.wsspi.webservices.admin.extensions.ServiceProviderExtension;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.ObjectName;

public class EndpointCentralManager
extends RuntimeCollaborator
implements ServicesAdminConstants,
ServiceIndexConstants {
    private static final TraceComponent _tc = Tr.register(EndpointCentralManager.class, "webservices.admin", "com.ibm.ws.webservices.admin.resources.websvcsAdmin");
    private static final String FFDC_ID_1 = "FFDC-1";
    private static final String FFDC_ID_2 = "FFDC-2";
    private AdminService as = null;
    private ResourceBundle _resourceBundle = ResourceBundle.getBundle("com.ibm.ws.webservices.admin.resources.websvcsAdmin", Locale.getDefault());
    private String className = this.getClass().getName();
    public static final String SERVICE_LISTENER_STARTED_STRING = "started";
    public static final String ENDPOINT_LISTENER_STARTED_STRING = "started";
    public static final String START_OP = "startListener";
    public static final String STOP_OP = "stopListener";
    public static final String GET_STATE_OP = "getListenerState";
    public static final String GET_SERVICES_OP = "getServiceNames";
    public static final String GET_ENDPOINTS_OP = "getEndpointNames";
    public static final String GET_ENDPOINT_TYPE_OP = "getEndpointType";

    public EndpointCentralManager() throws Exception {
        this.as = AdminServiceFactory.getAdminService();
    }

    public List startListener(Properties queryProps, String target) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, START_OP, new Object[]{"queryProps=" + queryProps, "target=" + target});
        }
        List retList = this.operateListener(queryProps, target, START_OP);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "startListener query properties", new Object[]{"retList(0)=" + retList.get(0), "retList size=" + retList.size()});
        }
        return retList;
    }

    public List startListener(String queryString, String target) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, START_OP, new Object[]{"queryString=" + queryString, "target=" + target});
        }
        Properties queryProps = this.stringToProperties(queryString);
        List retList = this.operateListener(queryProps, target, START_OP);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, START_OP, new Object[]{"retList(0)=" + retList.get(0), "retList size=" + retList.size(), "queryString=" + queryProps.toString()});
        }
        return retList;
    }

    public List stopListener(Properties queryProps, String target) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, STOP_OP, new Object[]{"queryProps=" + queryProps, "target=" + target});
        }
        List retList = this.operateListener(queryProps, target, STOP_OP);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "stopListener query properties", new Object[]{"retList(0)=" + retList.get(0), "retList size=" + retList.size()});
        }
        return retList;
    }

    public List stopListener(String queryString, String target) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, STOP_OP, new Object[]{"queryString=" + queryString, "target=" + target});
        }
        Properties queryProps = this.stringToProperties(queryString);
        List retList = this.operateListener(queryProps, target, STOP_OP);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, STOP_OP, new Object[]{"retList(0)=" + retList.get(0), "retList size=" + retList.size(), "queryString=" + queryProps.toString()});
        }
        return retList;
    }

    public List getListenerState(Properties queryProps, String target) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, GET_STATE_OP, new Object[]{"queryProps=" + queryProps, "target=" + target});
        }
        List retList = this.operateListener(queryProps, target, GET_STATE_OP);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, GET_STATE_OP, new Object[]{"retList(0)=" + retList.get(0), "retList size=" + retList.size()});
        }
        return retList;
    }

    public List getListenerState(String queryString, String target) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, GET_STATE_OP, new Object[]{"queryString=" + queryString, "target=" + target});
        }
        Properties queryProps = this.stringToProperties(queryString);
        List retList = this.operateListener(queryProps, target, GET_STATE_OP);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, GET_STATE_OP, new Object[]{"retList(0)=" + retList.get(0), "retList size=" + retList.size(), "queryString=" + queryProps.toString()});
        }
        return retList;
    }

    public List getServiceNames(Properties queryProps) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, GET_SERVICES_OP, new Object[]{"queryProps=" + queryProps});
        }
        List retList = (List)this.getServiceInfo(queryProps, GET_SERVICES_OP);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getServiceNames query properties");
        }
        return retList;
    }

    public List getServiceNames(String queryString) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, GET_SERVICES_OP, new Object[]{"queryStr=" + queryString});
        }
        Properties queryProps = this.stringToProperties(queryString);
        List retList = (List)this.getServiceInfo(queryProps, GET_SERVICES_OP);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, GET_SERVICES_OP);
        }
        return retList;
    }

    public List getEndpointNames(Properties queryProps) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, GET_ENDPOINTS_OP, new Object[]{"queryProps=" + queryProps});
        }
        List retList = (List)this.getServiceInfo(queryProps, GET_ENDPOINTS_OP);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getEndpointNames query properties");
        }
        return retList;
    }

    public List getEndpointNames(String queryString) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, GET_ENDPOINTS_OP, new Object[]{"queryStr=" + queryString});
        }
        Properties queryProps = this.stringToProperties(queryString);
        List retList = (List)this.getServiceInfo(queryProps, GET_ENDPOINTS_OP);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, GET_ENDPOINTS_OP);
        }
        return retList;
    }

    public String getEndpointType(Properties queryProps) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, GET_ENDPOINT_TYPE_OP, new Object[]{"queryProps=" + queryProps});
        }
        String type = (String)this.getServiceInfo(queryProps, GET_ENDPOINT_TYPE_OP);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getEndpointType query properties");
        }
        return type;
    }

    public String getEndpointType(String queryString) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, GET_ENDPOINT_TYPE_OP, new Object[]{"queryStr=" + queryString});
        }
        Properties queryProps = this.stringToProperties(queryString);
        String type = (String)this.getServiceInfo(queryProps, GET_ENDPOINT_TYPE_OP);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, GET_ENDPOINT_TYPE_OP);
        }
        return type;
    }

    private Object getServiceInfo(Properties queryProps, String operation) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getServiceInfo", new Object[]{queryProps});
        }
        ArrayList retList = new ArrayList();
        EndpointStatusUtils.validateParameters(queryProps, "*", operation);
        this.validateAuthorizationForApp(queryProps.getProperty("application"), operation, queryProps);
        if (queryProps.getProperty("application") == null) {
            this.prepareOperationOnExtension(queryProps, operation);
        } else {
            EndpointStatusUtils.verifyModuleExists(queryProps);
        }
        ObjectName oName = this.getEndpointManager(null, queryProps.getProperty("application"), queryProps.getProperty("module"));
        if (oName != null) {
            Object[] params = null;
            String[] sigs = null;
            this.validateServiceAndEndpointExist(oName, queryProps.getProperty("service"), queryProps.getProperty("logicalEndpoint"));
            if (operation.equals(GET_ENDPOINTS_OP)) {
                params = new String[]{queryProps.getProperty("service")};
                sigs = new String[]{"java.lang.String"};
            } else if (operation.equals(GET_ENDPOINT_TYPE_OP)) {
                params = new String[]{queryProps.getProperty("service"), queryProps.getProperty("logicalEndpoint")};
                sigs = new String[]{"java.lang.String", "java.lang.String"};
            }
            return this.as.invoke(oName, operation, params, sigs);
        }
        throw new IllegalStateException(CommonUtils.getFormattedMessage(this._resourceBundle, "CWSAD0037E", new Object[]{operation}, "The operation requires the application is installed on a 7.0 server and is running: " + operation));
    }

    private List operateListener(Properties queryProps, String target, String operation) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "operateListener", new Object[]{queryProps, target, operation});
        }
        ArrayList<String> retList = new ArrayList<String>();
        ArrayList statusList = new ArrayList();
        EndpointStatusUtils.validateParameters(queryProps, target, operation);
        String appName = queryProps.getProperty("application");
        this.validateAuthorizationForApp(appName, operation, queryProps);
        if (appName == null) {
            return this.operateListenerOnExtension(queryProps, target, operation);
        }
        AppTargetCache.ModuleTargetInfo targetInfo = AppTargetCache.getModuleTargetInfo(queryProps);
        if (targetInfo == null) {
            AppTargetCache.setModuleTargetInfo(queryProps);
            targetInfo = AppTargetCache.getModuleTargetInfo(queryProps);
        }
        List<ObjectName> targetList = targetInfo.getMatchedTargets(target);
        StatusCacheClient _statusCacheClient = StatusCacheFactory.getStatusCacheClient((boolean)false);
        StatusReport statusReport = _statusCacheClient.getReport();
        ObjectName thisTarget = null;
        String baseVersion = null;
        boolean allWSFEPTargets = true;
        for (int i = 0; i < targetList.size(); ++i) {
            thisTarget = targetList.get(i);
            baseVersion = AppMgmtUtils.getModuleTargetVersion(thisTarget);
            if (Utils.compareVersions((String)baseVersion, (String)"7.0.0.0") < 0) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "operateListener, thisTarget " + thisTarget + " is pre 7.0 version");
                }
                this.setApplicationStatusOnWSFEPTarget(statusReport, thisTarget, appName, operation, statusList, retList);
                continue;
            }
            allWSFEPTargets = false;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "operateListener, thisTarget " + thisTarget + " is 7.0 version");
            }
            this.operateListenerOnTarget(statusReport, thisTarget, queryProps, statusList, retList, operation);
        }
        String aggregatedState = EndpointStatusUtils.getAggregatedStatus(statusList, allWSFEPTargets);
        retList.add(0, aggregatedState);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "operateListener");
        }
        return retList;
    }

    private void setApplicationStatusOnWSFEPTarget(StatusReport statusReport, ObjectName thisTarget, String appName, String operation, List statusList, List msgList) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "setApplicationStatusOnWSFEPTarget");
        }
        String appStatus = statusReport.getApplicationState(appName, thisTarget.getKeyProperty("node"), thisTarget.getKeyProperty("server"));
        statusList.add(EndpointStatusUtils.appStatusToEndpointListenerStatus(appStatus));
        if (operation.equals(START_OP)) {
            msgList.add(CommonUtils.getFormattedMessage(this._resourceBundle, "CWSAD0029E", new Object[]{thisTarget}, "Cannot start the service or endpoint listener on a pre-7.0 server " + thisTarget));
        } else if (operation.equals(STOP_OP)) {
            msgList.add(CommonUtils.getFormattedMessage(this._resourceBundle, "CWSAD0030E", new Object[]{thisTarget}, "Cannot stop the service or endpoint listener on a pre-7.0 server " + thisTarget));
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "setApplicationStatusOnWSFEPTarget, appStatus=" + appStatus);
        }
    }

    private void operateListenerOnTarget(StatusReport statusReport, ObjectName target, Properties queryProps, List statusList, List msgList, String operation) throws Exception {
        String moduleName;
        String appName;
        ObjectName oName;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "operateListenerOnTarget", new Object[]{target, queryProps, operation});
        }
        if ((oName = this.getEndpointManager(target, appName = queryProps.getProperty("application"), moduleName = queryProps.getProperty("module"))) != null) {
            this.validateServiceAndEndpointExist(oName, queryProps.getProperty("service"), queryProps.getProperty("logicalEndpoint"));
            this.operateListenerOnEndpointManager(target, oName, queryProps, statusList, msgList, operation);
        } else {
            String appStatus = statusReport.getApplicationState(appName, target.getKeyProperty("node"), target.getKeyProperty("server"));
            String serverStatus = statusReport.getServerState(target.getKeyProperty("node"), target.getKeyProperty("server"));
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "operateListenerOnTarget, appStatus=" + appStatus + ", serverStatus=" + serverStatus);
            }
            if ("ExecutionState.STARTED".equals(appStatus)) {
                statusList.add("Unavailable");
                msgList.add(CommonUtils.getFormattedMessage(this._resourceBundle, "CWSAD0032E", new Object[0], "The specified application module does not contain any web service"));
            } else if ("ExecutionState.STOPPED".equals(appStatus)) {
                statusList.add("Stopped and not startable");
                if (operation.equals(START_OP) && "ExecutionState.STARTED".equals(serverStatus)) {
                    msgList.add(CommonUtils.getFormattedMessage(this._resourceBundle, "CWSAD0031E", new Object[]{target}, "Cannot start the service or endpoint listener because the asset is not started on server " + target));
                } else if (operation.equals(START_OP)) {
                    msgList.add(CommonUtils.getFormattedMessage(this._resourceBundle, "CWSAD0033E", new Object[]{target}, "Cannot start the service or endpoint listener because the server is not started"));
                } else if (operation.equals(STOP_OP)) {
                    msgList.add(CommonUtils.getFormattedMessage(this._resourceBundle, "CWSAD0028E", new Object[]{target}, "The service or endpoint listener is already stopped on server " + target));
                }
            } else {
                statusList.add(EndpointStatusUtils.appStatusToEndpointListenerStatus(appStatus));
                if (operation.equals(START_OP)) {
                    msgList.add(CommonUtils.getFormattedMessage(this._resourceBundle, "CWSAD0080E", new Object[]{target, appStatus}, "Cannot start the service listener because the application is in status " + appStatus + " on server " + target));
                } else if (operation.equals(STOP_OP)) {
                    msgList.add(CommonUtils.getFormattedMessage(this._resourceBundle, "CWSAD0081E", new Object[]{target, appStatus}, "Cannot stop the service listener because the application is in status " + appStatus + " on server " + target));
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "operateListenerOnTarget");
        }
    }

    private void operateListenerOnEndpointManager(ObjectName target, ObjectName emOName, Properties queryProps, List statusList, List msgList, String operation) throws Exception {
        String serviceName = queryProps.getProperty("service");
        String endpointName = queryProps.getProperty("logicalEndpoint");
        Object[] params = null;
        String[] sigs = null;
        Integer statusObj = null;
        String startOpName = null;
        String stopOpName = null;
        String opName = null;
        try {
            if (endpointName == null) {
                opName = "getServiceState";
                params = new String[]{serviceName};
                sigs = new String[]{"java.lang.String"};
                statusObj = (Integer)this.as.invoke(emOName, opName, params, sigs);
                startOpName = "startServiceListener";
                stopOpName = "stopServiceListener";
            } else {
                opName = "getEndpointState";
                params = new String[]{serviceName, endpointName};
                sigs = new String[]{"java.lang.String", "java.lang.String"};
                statusObj = (Integer)this.as.invoke(emOName, opName, params, sigs);
                startOpName = "startEndpointListener";
                stopOpName = "stopEndpointListener";
            }
            int status = statusObj;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "operateListenerOnEndpointManager, endpointManager=" + emOName + ", old status=" + status);
            }
            if (operation.equals(GET_STATE_OP)) {
                statusList.add(EndpointStatusUtils.getStatusInString(status));
                return;
            }
            if (status == 3) {
                if (operation.equals(START_OP)) {
                    opName = startOpName;
                    this.as.invoke(emOName, startOpName, params, sigs);
                    statusList.add("Started");
                } else {
                    statusList.add("Stopped");
                    msgList.add(CommonUtils.getFormattedMessage(this._resourceBundle, "CWSAD0028E", new Object[]{target}, "The service or endpoint listener is already stopped on server " + target));
                }
            } else if (status == 2) {
                if (operation.equals(START_OP)) {
                    statusList.add("Started");
                    msgList.add(CommonUtils.getFormattedMessage(this._resourceBundle, "CWSAD0027E", new Object[]{target}, "The service listener is already started on server " + target));
                } else {
                    opName = stopOpName;
                    this.as.invoke(emOName, stopOpName, params, sigs);
                    statusList.add("Stopped");
                }
            } else if (status == 0) {
                statusList.add("Partially started");
                msgList.add(CommonUtils.getFormattedMessage(this._resourceBundle, "CWSAD0027E", new Object[]{target}, "Cannot invoke the operation before the application is partially started"));
            } else if (status == 1) {
                if (operation == START_OP) {
                    opName = startOpName;
                    this.as.invoke(emOName, startOpName, params, sigs);
                    statusList.add("Started");
                } else {
                    opName = stopOpName;
                    this.as.invoke(emOName, stopOpName, params, sigs);
                    statusList.add("Stopped");
                }
            } else if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "operateListenerOnEndpointManager, unknown endpoint status " + statusObj);
            }
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, this.className + ".operateListenerOnEndpointManager", FFDC_ID_1, this);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Encounter exception while invoking EndpointManager MBean operation " + opName + " on server " + target + ":" + CommonUtils.getExceptionStack(ex));
            }
            statusList.add("Unavailable");
            msgList.add(CommonUtils.getFormattedMessage(this._resourceBundle, "CWSAD0069E", new Object[]{opName, target, ex.toString()}, "Failed to invoke operation " + opName + " on target " + target + " due to exception " + ex.toString()));
        }
    }

    private ObjectName getEndpointManager(ObjectName srvOName, String appName, String moduleName) throws Exception {
        String queryString = null;
        if (srvOName != null) {
            String cellName = srvOName.getKeyProperty("cell");
            String nodeName = srvOName.getKeyProperty("node");
            String serverName = srvOName.getKeyProperty("server");
            queryString = EndpointStatusUtils.createEndpointManagerQueryString(cellName, nodeName, serverName, appName, moduleName);
        } else {
            queryString = EndpointStatusUtils.createEndpointManagerQueryString(null, null, null, appName, moduleName);
        }
        ObjectName endpointMgrOName = new ObjectName(queryString);
        Set onameSet = this.as.queryNames(endpointMgrOName, null);
        if (onameSet.isEmpty()) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "getEndpointManager cannot find EndpointManager MBean", new Object[]{queryString, endpointMgrOName, appName, moduleName});
            }
            return null;
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "getEndpointManager find EndpointManager MBean", new Object[]{queryString, endpointMgrOName, appName, moduleName});
        }
        return (ObjectName)onameSet.iterator().next();
    }

    private Properties stringToProperties(String queryString) throws IllegalArgumentException {
        Properties queryProps = new Properties();
        queryString = queryString.replaceAll(", ", ",");
        StringTokenizer tokens = new StringTokenizer(queryString, ",");
        String token = null;
        StringTokenizer subtokens = null;
        while (tokens.hasMoreTokens()) {
            token = tokens.nextToken();
            if (token.indexOf("=") < 0 || token.startsWith("=") || token.endsWith("=")) {
                throw new IllegalArgumentException(CommonUtils.getFormattedMessage(this._resourceBundle, "CWSAD0088E", new Object[]{"queryString", token}, "A sub-string in the input parameter is not in the format of name=value."));
            }
            subtokens = new StringTokenizer(token, "=");
            String key = subtokens.nextToken();
            String value = subtokens.nextToken();
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "stringToProperties: key=" + key + "value=" + value);
            }
            queryProps.setProperty(key, value);
        }
        return queryProps;
    }

    private boolean isApplicationStarted(ObjectName srvOName, String appName) throws Exception {
        ObjectName appOName;
        Set onameSet;
        StringBuffer buf = new StringBuffer();
        buf.append("WebSphere:type=Application");
        buf.append(",cell=").append(srvOName.getKeyProperty("cell"));
        buf.append(",node=").append(srvOName.getKeyProperty("node"));
        buf.append(",process=").append(srvOName.getKeyProperty("server"));
        buf.append(",name=").append(appName);
        buf.append(",*");
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "isApplicationStarted, application mbean: " + buf.toString());
        }
        if ((onameSet = this.as.queryNames(appOName = new ObjectName(buf.toString()), null)).isEmpty()) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "isApplicationStarted, application " + appName + " is not started");
            }
            return false;
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "isApplicationStarted, application " + appName + " is started");
        }
        return true;
    }

    private boolean isServerStarted(ObjectName srvOName) throws Exception {
        StringBuffer buf = new StringBuffer();
        buf.append("WebSphere:type=Server");
        buf.append(",cell=").append(srvOName.getKeyProperty("cell"));
        buf.append(",node=").append(srvOName.getKeyProperty("node"));
        buf.append(",process=").append(srvOName.getKeyProperty("server"));
        buf.append(",*");
        Set onameSet = this.as.queryNames(new ObjectName(buf.toString()), null);
        if (onameSet.isEmpty()) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "isServerStarted, server is not started: " + buf.toString());
            }
            return false;
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "isServerStarted, server is started: " + buf.toString());
        }
        return true;
    }

    private void validateServiceExists(ObjectName oName, String serviceName) throws Exception {
        List serviceList = (List)this.as.invoke(oName, GET_SERVICES_OP, null, null);
        Iterator it = serviceList.iterator();
        while (it.hasNext()) {
            if (!serviceName.equals((String)it.next())) continue;
            return;
        }
        throw new IllegalArgumentException(CommonUtils.getFormattedMessage(this._resourceBundle, "CWSAD0067E", new Object[]{serviceName}, "Cannot find service " + serviceName));
    }

    private void validateServiceAndEndpointExist(ObjectName oName, String serviceName, String endpointName) throws Exception {
        if (serviceName == null) {
            return;
        }
        this.validateServiceExists(oName, serviceName);
        if (endpointName == null) {
            return;
        }
        Object[] params = new String[]{serviceName};
        String[] sigs = new String[]{"java.lang.String"};
        List endpointList = (List)this.as.invoke(oName, GET_ENDPOINTS_OP, params, sigs);
        Iterator it = endpointList.iterator();
        while (it.hasNext()) {
            if (!endpointName.equals((String)it.next())) continue;
            return;
        }
        throw new IllegalArgumentException(CommonUtils.getFormattedMessage(this._resourceBundle, "CWSAD0068E", new Object[]{endpointName, serviceName}, "Cannot find endpoint " + endpointName + " in service " + serviceName));
    }

    private void validateAuthorizationForApp(String appName, String operation, Properties queryProps) throws Exception {
        AdminAuthorizer myAdminAuthorizer;
        String resource = null;
        resource = queryProps.getProperty("application") == null ? ServiceProviderExtensionHelper.getInstance().getAuthorizationResource(queryProps) : "applications/" + appName;
        boolean monitorIsSufficient = true;
        if (operation.equals(START_OP) || operation.equals(STOP_OP)) {
            monitorIsSufficient = false;
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "EndpointCentralManager.validateAuthorizationForApp, resource=" + resource + ", operation=" + operation + ", monitorIsSufficient=" + monitorIsSufficient);
        }
        if ((myAdminAuthorizer = AdminAuthorizerFactory.getAdminAuthorizer()) != null) {
            if (monitorIsSufficient && !myAdminAuthorizer.checkAccess(resource, "monitor")) {
                throw new AccessControlException(CommonUtils.getFormattedMessage(this._resourceBundle, "CWSAD0078E", new Object[]{resource, "monitor"}, "Access denied for resource" + resource + ", monitor authority required."));
            }
            if (!(monitorIsSufficient || myAdminAuthorizer.checkAccess(resource, "operator") || myAdminAuthorizer.checkAccess(resource, "deployer"))) {
                throw new AccessControlException(CommonUtils.getFormattedMessage(this._resourceBundle, "CWSAD0078E", new Object[]{resource, "operator|deployer"}, "Access denied for resource" + resource + ", operator or deployer authority required."));
            }
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "EndpointCentralManager.validateAuthorizationForApp, app=" + appName + ", user has authorization to perform the operation " + operation);
        }
    }

    private void prepareOperationOnExtension(Properties queryProps, String operation) throws Exception {
        ServiceProviderExtensionHelper extensionHelper;
        ServiceProviderExtension provider;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "EndpointCentralManager.prepareOperationOnExtension", new Object[]{queryProps, operation});
        }
        if (!(provider = (extensionHelper = ServiceProviderExtensionHelper.getInstance()).getProviderExtension(queryProps)).isEndpointListenerSupported()) {
            throw new Exception(CommonUtils.getFormattedMessage(this._resourceBundle, "CWSAD0087E", new Object[]{operation, queryProps}, "The MBean operation is not supported for the service " + queryProps));
        }
        Properties appProps = extensionHelper.getJEEAppProperties(provider, queryProps);
        queryProps.putAll((Map<?, ?>)appProps);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "EndpointCentralManager.prepareOperationOnExtension, queryProps=" + queryProps);
        }
    }

    private List operateListenerOnExtension(Properties queryProps, String target, String operation) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "EndpointCentralManager.operateListenerOnExtension", new Object[]{queryProps, target, operation});
        }
        ArrayList<String> retList = new ArrayList<String>();
        ArrayList statusList = new ArrayList();
        ServiceProviderExtensionHelper extensionHelper = ServiceProviderExtensionHelper.getInstance();
        try {
            ServiceProviderExtension provider = extensionHelper.getProviderExtension(queryProps);
            if (provider.isEndpointListenerSupported()) {
                List<ObjectName> targetList = extensionHelper.getMatchedTargets(provider, queryProps, target);
                Properties appProps = extensionHelper.getJEEAppProperties(provider, queryProps);
                queryProps.putAll((Map<?, ?>)appProps);
                StatusCacheClient _statusCacheClient = StatusCacheFactory.getStatusCacheClient((boolean)false);
                StatusReport statusReport = _statusCacheClient.getReport();
                for (int i = 0; i < targetList.size(); ++i) {
                    this.operateListenerOnTarget(statusReport, targetList.get(i), queryProps, statusList, retList, operation);
                }
                String aggregatedState = EndpointStatusUtils.getAggregatedStatus(statusList, false);
                retList.add(0, aggregatedState);
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "EndpointCentralManager.operateListenerOnExtension, endpoint listener supported");
                }
                return retList;
            }
            String status = extensionHelper.getAssetStatusOnTarget(provider, queryProps, target);
            retList.add(status);
            if (operation.equals(START_OP)) {
                retList.add(CommonUtils.getFormattedMessage(this._resourceBundle, "CWSAD0085E", new Object[]{queryProps.getProperty("service")}, "Cannot start the service or endpoint listener for this service. You must start the containing asset."));
            } else if (operation.equals(STOP_OP)) {
                retList.add(CommonUtils.getFormattedMessage(this._resourceBundle, "CWSAD0086E", new Object[]{queryProps.getProperty("service")}, "Cannot stop the service or endpoint listener for this service. You must stop the containing asset."));
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "EndpointCentralManager.operateListenerOnExtension, endpoint listener not supported, asset status=" + status);
            }
            return retList;
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, this.className + ".operateListenerOnExtension", FFDC_ID_2, this);
            if (_tc.isDebugEnabled()) {
                ex.printStackTrace();
            }
            throw ex;
        }
    }
}

