/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.admin.deploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.application.InstallScheduler;
import com.ibm.websphere.management.application.UpdateScheduler;
import com.ibm.websphere.management.application.task.AbstractTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.webservices.admin.deploy.DeploymentValidation;
import com.ibm.ws.webservices.admin.deploy.ServiceIndexServerTaskImpl;
import com.ibm.ws.webservices.admin.deploy.VerifyEJBandItsRoutersTaskImpl;
import com.ibm.ws.webservices.admin.utils.CommonUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;

public class ServiceIndexServerTask
extends AbstractTask {
    private static TraceComponent tc = Tr.register(ServiceIndexServerTask.class, "webservices.admin", "com.ibm.ws.webservices.admin.resources.websvcsAdmin");

    public boolean performTask() throws AdminException {
        int i2;
        Exception e22;
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ServiceIndexServerTask.performTask()");
        }
        String[] tempDirToBeRemoved = new String[1];
        String[] updateDirToBeRemoved = new String[1];
        ArrayList targetValidationErrors = new ArrayList();
        EARFile ear = null;
        boolean serviceIndexPassed = false;
        VerifyEJBandItsRoutersTaskImpl verifyEJBTaskImpl = null;
        ResourceBundle newBundle = null;
        try {
            RepositoryContext deployContext = AppUtils.findAppContextFromConfig((String)this.scheduler.getAppName(), (WorkSpace)this.scheduler.getWorkSpace(), (Hashtable)this.scheduler.getProperties());
            ServiceIndexServerTaskImpl taskImpl = new ServiceIndexServerTaskImpl();
            taskImpl.setResourceBundle(this.getResourceBundle());
            taskImpl.setDeployContext(deployContext);
            taskImpl.setOperation(this.scheduler instanceof InstallScheduler ? 0 : 1);
            taskImpl.setExistingIndex((Map)this.scheduler.getProperties().get("ServiceIndexTask.ServiceIndexMap"));
            verifyEJBTaskImpl = new VerifyEJBandItsRoutersTaskImpl();
            Locale locale = (Locale)this.scheduler.getProperties().get("app.client.locale");
            if (locale == null) {
                locale = Locale.getDefault();
            }
            newBundle = ResourceBundle.getBundle("com.ibm.ws.webservices.admin.resources.websvcsAdmin", locale);
            verifyEJBTaskImpl.setResourceBundle(newBundle);
            verifyEJBTaskImpl.setDeployContext(deployContext);
            verifyEJBTaskImpl.setOperation(this.scheduler instanceof InstallScheduler ? 0 : 1);
            if (this.scheduler instanceof InstallScheduler) {
                ear = ((InstallScheduler)this.scheduler).getEarFile(true, true);
                if (ear != null) {
                    serviceIndexPassed = false;
                    taskImpl.listWebServices(ear, this.scheduler);
                    serviceIndexPassed = true;
                    ear.getOptions().setUseJavaReflection(true);
                    verifyEJBTaskImpl.verifyInstallOrEdit(this.scheduler, ear, locale, this.appTaskName);
                }
            } else if (this.scheduler instanceof UpdateScheduler) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ServiceIndexServerTask.performTask, UpdateScheduler");
                }
                ear = CommonUtils.getEar(this.scheduler, this.getResourceBundle());
                UpdateScheduler ush = (UpdateScheduler)this.scheduler;
                if (("add".equals(ush.getOperation()) || "update".equals(ush.getOperation())) && ush.getContentType().equals("modulefile")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ServiceIndexServerTask module update");
                    }
                    ModuleFile mf = (ModuleFile)ush.getContentAsArchive(true, true);
                    serviceIndexPassed = false;
                    taskImpl.listWebServices(mf, this.scheduler);
                    serviceIndexPassed = true;
                    ear.getOptions().setUseJavaReflection(true);
                    verifyEJBTaskImpl.verifyModuleUpdate(mf, this.scheduler, ear, locale, this.appTaskName);
                } else if (!"delete".equals(ush.getOperation())) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ServiceIndexServerTask.performTask, partial app update or single file update");
                    }
                    if (ear != null) {
                        String contentType = ush.getContentType();
                        String operationType = ush.getOperation();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "ServiceIndexServerTask partial update, don't call getMergeEar");
                        }
                        ear.getOptions().setUseJavaReflection(true);
                        DeploymentValidation deployValidation = new DeploymentValidation();
                        deployValidation.validateTargetForPartialUpdate(this.scheduler, ear, targetValidationErrors);
                        if (targetValidationErrors.size() == 0) {
                            serviceIndexPassed = false;
                            taskImpl.listWebServices(ear, this.scheduler);
                            serviceIndexPassed = true;
                            verifyEJBTaskImpl.verifyPartialUpdate(this.scheduler, contentType, operationType, locale, ear, deployContext, this.appTaskName);
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ServiceIndexServerTask was unable to obtain EARFile for update of application, " + this.scheduler.getAppName() + ", perhaps due to using zeroEarCopy or zeroBinaryCopy options during the install");
                    }
                }
                CommonUtils.closeEar(ear, this.scheduler);
            }
            AppNotification appNotify = this.createNotification("Completed", "ADMA5005I", new String[]{this.scheduler.getAppName()});
            this.scheduler.propagateTaskEvent(appNotify);
            bl = true;
            Object var16_20 = null;
        }
        catch (Throwable th) {
            try {
                FFDCFilter.processException(th, "com.ibm.ws.webservices.admin.deploy.ServiceIndexServerTask.performTask", "172", (Object)this);
                if (!serviceIndexPassed) {
                    this.scheduler.propagateTaskEvent(this.createNotification("Failed", "ADMA5006E", new String[]{this.scheduler.getAppName(), th.toString()}));
                } else {
                    Object[] arg = new Object[]{this.scheduler.getAppName(), th.toString()};
                    String msg = newBundle.getString("CWSAD0041E");
                    String error = MessageFormat.format(msg, arg);
                    this.scheduler.propagateTaskEvent(verifyEJBTaskImpl.createNotification(this.getShortName(), "Failed", error));
                }
                if (this.scheduler instanceof UpdateScheduler && ear != null) {
                    ear.close();
                }
                if (th instanceof AdminException) {
                    throw (AdminException)th;
                }
                throw new AdminException(th, AppUtils.getMessage((ResourceBundle)this.getResourceBundle(), (String)"ADMA0066E"));
            }
            catch (Throwable throwable) {
                block46: {
                    int i2;
                    Exception e22;
                    Object var16_21 = null;
                    if (tempDirToBeRemoved[0] != null && tempDirToBeRemoved[0].length() > 0) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Remove temporary serviceIndexServer directory " + tempDirToBeRemoved[0]);
                        }
                        try {
                            AppUtils.deleteDirTree((String)tempDirToBeRemoved[0]);
                        }
                        catch (Exception e22) {
                            FFDCFilter.processException((Throwable)e22, "com.ibm.ws.webservices.admin.deploy.ServiceIndexServerTask.performTask", "186", (Object)this);
                            this.scheduler.propagateTaskEvent(this.createNotification("Failed", "ADMA5006E", new String[]{this.scheduler.getAppName(), e22.toString()}));
                        }
                    }
                    if (updateDirToBeRemoved[0] != null && updateDirToBeRemoved[0].length() > 0) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Remove update serviceIndexServer directory " + updateDirToBeRemoved[0]);
                        }
                        try {
                            AppUtils.deleteDirTree((String)updateDirToBeRemoved[0]);
                        }
                        catch (Exception e22) {
                            FFDCFilter.processException((Throwable)e22, "com.ibm.ws.webservices.admin.deploy.ServiceIndexServerTask.performTask", "200", (Object)this);
                            this.scheduler.propagateTaskEvent(this.createNotification("Failed", "ADMA5006E", new String[]{this.scheduler.getAppName(), e22.toString()}));
                        }
                    }
                    for (i2 = 0; i2 < targetValidationErrors.size(); ++i2) {
                        this.scheduler.propagateTaskEvent(this.createNotification("Failed", "ADMA5055E", new String[]{this.scheduler.getAppName(), (String)targetValidationErrors.get(i2)}));
                    }
                    i2 = 0;
                    if (i2 < targetValidationErrors.size()) {
                        throw new AdminException(AppUtils.getMessage((ResourceBundle)this.getResourceBundle(), (String)"ADMA5055E", (Object[])new String[]{this.scheduler.getAppName(), (String)targetValidationErrors.get(i2)}));
                    }
                    if (!tc.isEntryEnabled()) break block46;
                    Tr.exit(tc, "ServiceIndexServerTask.performTask()");
                }
                throw throwable;
            }
        }
        if (tempDirToBeRemoved[0] != null && tempDirToBeRemoved[0].length() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Remove temporary serviceIndexServer directory " + tempDirToBeRemoved[0]);
            }
            try {
                AppUtils.deleteDirTree((String)tempDirToBeRemoved[0]);
            }
            catch (Exception e22) {
                FFDCFilter.processException((Throwable)e22, "com.ibm.ws.webservices.admin.deploy.ServiceIndexServerTask.performTask", "186", (Object)this);
                this.scheduler.propagateTaskEvent(this.createNotification("Failed", "ADMA5006E", new String[]{this.scheduler.getAppName(), e22.toString()}));
            }
        }
        if (updateDirToBeRemoved[0] != null && updateDirToBeRemoved[0].length() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Remove update serviceIndexServer directory " + updateDirToBeRemoved[0]);
            }
            try {
                AppUtils.deleteDirTree((String)updateDirToBeRemoved[0]);
            }
            catch (Exception e22) {
                FFDCFilter.processException((Throwable)e22, "com.ibm.ws.webservices.admin.deploy.ServiceIndexServerTask.performTask", "200", (Object)this);
                this.scheduler.propagateTaskEvent(this.createNotification("Failed", "ADMA5006E", new String[]{this.scheduler.getAppName(), e22.toString()}));
            }
        }
        for (i2 = 0; i2 < targetValidationErrors.size(); ++i2) {
            this.scheduler.propagateTaskEvent(this.createNotification("Failed", "ADMA5055E", new String[]{this.scheduler.getAppName(), (String)targetValidationErrors.get(i2)}));
        }
        i2 = 0;
        if (i2 < targetValidationErrors.size()) {
            throw new AdminException(AppUtils.getMessage((ResourceBundle)this.getResourceBundle(), (String)"ADMA5055E", (Object[])new String[]{this.scheduler.getAppName(), (String)targetValidationErrors.get(i2)}));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ServiceIndexServerTask.performTask()");
        }
        return bl;
    }
}

