/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.admin.deploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.Scheduler;
import com.ibm.ws.webservices.admin.serviceindex.impl.EndpointBean;
import com.ibm.ws.webservices.admin.serviceindex.impl.WebServiceBean;
import com.ibm.ws.webservices.admin.utils.CommonUtils;
import com.ibm.ws.webservices.admin.utils.ServiceContainmentHelper;
import com.ibm.wsspi.websvcs.desc.WSClientEndpointDescriptor;
import com.ibm.wsspi.websvcs.desc.WSClientOperationDescriptor;
import com.ibm.wsspi.websvcs.desc.WSClientServiceDescriptor;
import com.ibm.wsspi.websvcs.desc.WSClientType;
import com.ibm.wsspi.websvcs.desc.WSEndpointDescriptor;
import com.ibm.wsspi.websvcs.desc.WSModuleDescriptor;
import com.ibm.wsspi.websvcs.desc.WSOperationDescriptor;
import com.ibm.wsspi.websvcs.desc.WSServiceDescriptor;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;

public class ServiceIndexDataBuilder {
    private static TraceComponent tc = Tr.register(ServiceIndexDataBuilder.class, "webservices.admin", "com.ibm.ws.webservices.admin.resources.websvcsAdmin");

    public static void getWSData(ModuleFile mf, Scheduler scheduler, Map serviceMap, Map clientServiceMap) {
        boolean containsWSClient;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWSData");
        }
        ServiceContainmentHelper sContainmentHelper = CommonUtils.getServiceContianmentHelper(scheduler, mf);
        WSModuleDescriptor moduleDesc = sContainmentHelper.getModuleDescriptor();
        if (sContainmentHelper.containsJAXWSWebServices()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getWSData, WSDescriptionBuilder.getModuleDescriptor returns services or clients");
            }
            Iterator services = moduleDesc.getJAXWSServices();
            while (services.hasNext()) {
                WebServiceBean wsBean = ServiceIndexDataBuilder.getWSBean((WSServiceDescriptor)services.next());
                if (wsBean == null) continue;
                serviceMap.put(wsBean.getServiceName(), wsBean);
            }
        }
        if (containsWSClient = moduleDesc.containsWebServiceClients()) {
            Iterator services = moduleDesc.getServiceRefs();
            while (services.hasNext()) {
                WebServiceBean wsBean;
                WSClientServiceDescriptor client = (WSClientServiceDescriptor)services.next();
                WSClientType clientType = client.getClientType();
                if (!clientType.equals((Object)WSClientType.JAX_WS) || (wsBean = ServiceIndexDataBuilder.getWSBean(client)) == null) continue;
                clientServiceMap.put(wsBean.getServiceName(), wsBean);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWSData", new Object[]{serviceMap, clientServiceMap});
        }
    }

    private static WebServiceBean getWSBean(WSServiceDescriptor serviceDesc) {
        WebServiceBean wsBean = null;
        if (serviceDesc.isJAXWSService()) {
            wsBean = new WebServiceBean();
            wsBean.setServiceName(serviceDesc.getQName().toString());
            wsBean.setType("JAX-WS");
            Iterator endpoints = serviceDesc.getEndpoints();
            while (endpoints.hasNext()) {
                EndpointBean endpointBean = ServiceIndexDataBuilder.getEndpointBean((WSEndpointDescriptor)endpoints.next());
                wsBean.addEndpoint(endpointBean);
            }
        }
        return wsBean;
    }

    private static WebServiceBean getWSBean(WSClientServiceDescriptor serviceDesc) {
        WebServiceBean wsBean = new WebServiceBean();
        wsBean.setClient(true);
        wsBean.setServiceName(serviceDesc.getQName().toString());
        wsBean.setType("JAX-WS");
        Iterator endpoints = serviceDesc.getEndpoints();
        while (endpoints.hasNext()) {
            EndpointBean endpointBean = ServiceIndexDataBuilder.getEndpointBean((WSClientEndpointDescriptor)endpoints.next());
            wsBean.addEndpoint(endpointBean);
        }
        return wsBean;
    }

    private static EndpointBean getEndpointBean(WSEndpointDescriptor endpointDesc) {
        EndpointBean endpointBean = new EndpointBean();
        endpointBean.setName(endpointDesc.getName());
        Iterator operations = endpointDesc.getOperations();
        while (operations.hasNext()) {
            WSOperationDescriptor opDesc = (WSOperationDescriptor)operations.next();
            endpointBean.addOperation(opDesc.getName());
        }
        return endpointBean;
    }

    private static EndpointBean getEndpointBean(WSClientEndpointDescriptor endpointDesc) {
        EndpointBean endpointBean = new EndpointBean();
        endpointBean.setName(endpointDesc.getName());
        Iterator operations = endpointDesc.getOperations();
        while (operations.hasNext()) {
            WSClientOperationDescriptor opDesc = (WSClientOperationDescriptor)operations.next();
            endpointBean.addOperation(opDesc.getName());
        }
        return endpointBean;
    }
}

