/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.admin.commands;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandProvider;
import com.ibm.ws.webservices.admin.commands.GetWebService;
import com.ibm.ws.webservices.admin.commands.ListServices;
import com.ibm.ws.webservices.admin.commands.ListWebServiceEndpoints;
import com.ibm.ws.webservices.admin.commands.ListWebServiceOperations;
import com.ibm.ws.webservices.admin.commands.ListWebServices;

public class WebServiceCommandProvider
extends CommandProvider {
    private static TraceComponent tc = Tr.register(WebServiceCommandProvider.class, "WebServiceCommandProvider", "com.ibm.ws.webservices.admin.commands");

    public AbstractAdminCommand createCommand(CommandMetadata metadata) throws CommandNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createCommand");
        }
        String cmdName = metadata.getName();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, metadata.toString());
            Tr.debug(tc, "Trying to create new " + cmdName + " command.");
        }
        AbstractAdminCommand command = null;
        if (cmdName.equals("listServices")) {
            command = new ListServices(metadata);
        } else if (cmdName.equals("listWebServices")) {
            command = new ListWebServices((TaskCommandMetadata)metadata);
        } else if (cmdName.equals("getWebService")) {
            command = new GetWebService((TaskCommandMetadata)metadata);
        } else if (cmdName.equals("listWebServiceEndpoints")) {
            command = new ListWebServiceEndpoints((TaskCommandMetadata)metadata);
        } else if (cmdName.equals("listWebServiceOperations")) {
            command = new ListWebServiceOperations((TaskCommandMetadata)metadata);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cannot find command " + cmdName + " to create.");
            }
            throw new CommandNotFoundException(cmdName);
        }
        return command;
    }

    public AbstractAdminCommand loadCommand(CommandData cmdData) throws CommandNotFoundException, CommandLoadException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadCommand");
        }
        String cmdName = cmdData.getName();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, cmdData.toString());
            Tr.debug(tc, "Trying to load new " + cmdName + " command.");
        }
        AbstractAdminCommand command = null;
        if (cmdName.equals("listServices")) {
            command = new ListServices(cmdData);
        } else if (cmdName.equals("listWebServices")) {
            command = new ListWebServices(cmdData);
        } else if (cmdName.equals("getWebService")) {
            command = new GetWebService(cmdData);
        } else if (cmdName.equals("listWebServiceEndpoints")) {
            command = new ListWebServiceEndpoints(cmdData);
        } else if (cmdName.equals("listWebServiceOperations")) {
            command = new ListWebServiceOperations(cmdData);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cannot find task command " + cmdName + " to load.");
            }
            throw new CommandNotFoundException(cmdName);
        }
        return command;
    }
}

