/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.client.Call;
import com.ibm.ws.webservices.engine.resources.Messages;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;

public class Version {
    private static final TraceComponent _tc = Tr.register(Version.class, "WebServices", "com.ibm.ws.webservices.resources.webservicesMessages");
    private static String binaryCopyright = "5724-I63, 5724-H88, 5655-N01, 5733-W60 (C) COPYRIGHT International Business Machines Corp., 2002, 2005 All Rights Reserved * Licensed Materials - Property of IBM US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static String versionInfo = "SERV1/ws/code/webservices/src/com/ibm/ws/webservices/Version.java, WAS.webservices, WAS70.SERV1, cf070937.21";
    private static String wsBuiltOn = "9/18/09 22:10:15";
    private static String release = "?";
    private static String buildNum = "?";
    private static String rawData = "?";
    private static boolean initialized = false;

    public static String getBinaryCopyright() {
        return binaryCopyright;
    }

    public static String getRawData() {
        Version.init();
        return rawData;
    }

    public static String getVersion() {
        Version.init();
        return "\n" + Version.getBuildNum() + "\n" + Version.getRelease() + "\n" + Version.getDateBuilt() + "\n";
    }

    public static String getBuildNum() {
        Version.init();
        return Messages.getMessage("webServicesBuildNum") + " " + buildNum;
    }

    public static String getRawBuildNum() {
        Version.init();
        return buildNum;
    }

    public static String getRelease() {
        Version.init();
        return Messages.getMessage("webServicesRelease") + " " + release;
    }

    public static String getDateBuilt() {
        Version.init();
        return Messages.getMessage("builtOn") + " " + wsBuiltOn;
    }

    private static synchronized void init() {
        if (!initialized) {
            initialized = true;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "versionInfo is '" + versionInfo + "'.");
            }
            StringTokenizer tokenizer = new StringTokenizer(versionInfo, ",");
            String filePathname = tokenizer.nextToken();
            if (tokenizer.hasMoreTokens()) {
                String componentName = tokenizer.nextToken();
                if (tokenizer.hasMoreTokens()) {
                    StringTokenizer relTokenizer;
                    String cmvcRelease = tokenizer.nextToken().trim();
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "CMVC release is: " + cmvcRelease);
                    }
                    if (tokenizer.hasMoreTokens()) {
                        buildNum = tokenizer.nextToken().trim();
                    }
                    if ((relTokenizer = new StringTokenizer(cmvcRelease, "WAS, .SERV")).hasMoreTokens()) {
                        String releaseNum = relTokenizer.nextToken().trim();
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "ReleaseNum is :" + releaseNum);
                        }
                        StringBuffer buf = new StringBuffer();
                        for (int x = 0; x < releaseNum.length(); ++x) {
                            if (x > 0) {
                                buf.append('.');
                            }
                            buf.append(releaseNum.charAt(x));
                        }
                        release = buf.toString();
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "WAS Version is: " + release);
                        }
                    }
                }
            }
            tokenizer = new StringTokenizer(wsBuiltOn, "/ :");
            StringBuffer buf = new StringBuffer();
            while (tokenizer.hasMoreTokens()) {
                buf.append(tokenizer.nextToken());
            }
            rawData = buildNum + " v" + buf.toString().trim();
        }
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println(Version.getVersion());
        } else {
            try {
                Call call = new Call(args[0]);
                String result = (String)call.invoke(new QName("Version", "getVersion"), null);
                System.out.println(result);
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.webservices.Version.main", "155");
                e.printStackTrace();
            }
        }
    }
}

