/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.util;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.util.FileSystem;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.servlet.ServletContext;

public class ExtendedDocumentRootUtils {
    protected static Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.ws.webcontainer.util");
    private static final String CLASS_NAME = "com.ibm.ws.webcontainer.util.ExtendedDocumentRootUtils";
    private static boolean isWindows = System.getProperty("os.name").toLowerCase().startsWith("windows");
    private Vector searchPath = new Vector();
    private boolean useContentLength = false;
    private ZipFile matchedZipFile;
    private ZipEntry matchedEntry;
    private ExtDocRootFile extDocRootFile;

    public ExtendedDocumentRootUtils(ServletContext ctxt, String extendedDocumentRoot) {
        if (extendedDocumentRoot != null) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "ExtendedDocumentRootUtils", "extendedDocumentRoot --> " + extendedDocumentRoot);
            }
            this.createSearchPath(ctxt, extendedDocumentRoot);
        }
    }

    public ExtendedDocumentRootUtils(String baseDir, String extendedDocumentRoot) {
        if (extendedDocumentRoot != null) {
            if (baseDir != null && !(baseDir = baseDir.replace('\\', '/')).endsWith("/")) {
                baseDir = baseDir + "/";
            }
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "ExtendedDocumentRootUtils", "baseDir --> ", baseDir);
                logger.logp(Level.FINE, CLASS_NAME, "ExtendedDocumentRootUtils", "extendedDocumentRoot --> " + extendedDocumentRoot);
            }
            this.createSearchPath(baseDir, extendedDocumentRoot);
        }
    }

    public boolean searchPathExists() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            String result = !this.searchPath.isEmpty() ? "true" : "false";
            logger.logp(Level.FINE, CLASS_NAME, "searchPathExists", " ", result);
        }
        return !this.searchPath.isEmpty();
    }

    private void createSearchPath(ServletContext ctx, String extendedDocumentRoot) {
        String baseDir = ctx.getRealPath("/../");
        this.createSearchPath(baseDir, extendedDocumentRoot);
    }

    private void createSearchPath(String baseDir, String extendedDocumentRoot) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "createSearchPath", "baseDir --> " + baseDir);
            logger.logp(Level.FINE, CLASS_NAME, "createSearchPath", "extendedDocumentRoot --> " + extendedDocumentRoot);
        }
        StringTokenizer st = new StringTokenizer(extendedDocumentRoot, ",");
        while (st.hasMoreTokens()) {
            try {
                String currentSearchLocation = st.nextToken().trim();
                if (currentSearchLocation == null) continue;
                if (isWindows && currentSearchLocation.indexOf(":") == 1 || currentSearchLocation.startsWith("/")) {
                    File f = new File(currentSearchLocation);
                    this.searchPath.addElement(f.toString());
                    if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) continue;
                    logger.logp(Level.FINE, CLASS_NAME, "createSearchPath", "add to searchPath --> " + f.toString());
                    continue;
                }
                File realPath = new File(baseDir + currentSearchLocation);
                String canonicalPath = realPath.getCanonicalPath();
                this.searchPath.addElement(canonicalPath);
                if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) continue;
                logger.logp(Level.FINE, CLASS_NAME, "createSearchPath", "add to searchPath --> " + canonicalPath);
            }
            catch (IOException io) {
                io.printStackTrace(System.out);
            }
        }
    }

    public void handleExtendedDocumentRoots(String filename) throws FileNotFoundException, IOException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "handleExtendedDocumentRoots", "filename --> " + filename);
        }
        boolean foundMatch = false;
        Enumeration altDocumentRoots = this.searchPath.elements();
        while (altDocumentRoots.hasMoreElements()) {
            String currDocumentRoot = altDocumentRoots.nextElement().toString();
            File currFile = new File(currDocumentRoot);
            if (currFile.isDirectory()) {
                File tmpFile = new File(currFile, filename);
                if (!tmpFile.exists()) continue;
                foundMatch = true;
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "handleExtendedDocumentRoots", "found match in directory --> " + tmpFile.toString());
                }
                this.handleCaseSensitivityCheck(tmpFile.toString(), filename);
                this.extDocRootFile = new FileResource(tmpFile);
                this.useContentLength = true;
                if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) break;
                logger.logp(Level.FINE, CLASS_NAME, "handleExtendedDocumentRoots", "useContentLength --> " + this.useContentLength);
                break;
            }
            if (!currFile.exists()) continue;
            ZipFile zip = new ZipFile(currFile);
            ZipEntry zEntry = zip.getEntry(filename.substring(1).replace('\\', '/'));
            if (zEntry != null) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "handleExtendedDocumentRoots", "found match in zip or jar file --> " + currFile.toString());
                }
                foundMatch = true;
                this.extDocRootFile = new ZipFileResource(currFile, zEntry.getName());
                zip.close();
                break;
            }
            zip.close();
        }
        if (!foundMatch) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "handleExtendedDocumentRoots", "unable to locate resource --> " + filename);
            }
            throw new FileNotFoundException(filename);
        }
    }

    public InputStream getInputStream() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getInputStream", "getInputStream for ExtendedDocumentRoot this -->" + this);
        }
        try {
            return this.extDocRootFile.getIS();
        }
        catch (Exception e) {
            return null;
        }
    }

    public File getMatchedFile() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getMatchedFile", "file --> [" + this.extDocRootFile.getMatch() + "]");
        }
        return this.extDocRootFile.getMatch();
    }

    public long getLastModifiedMatchedFile() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getLastModifiedMatchedFile", "file --> [" + (this.extDocRootFile.getMatch() == null ? 0L : this.extDocRootFile.getMatch().lastModified()) + "]");
        }
        return this.extDocRootFile.getMatch() == null ? 0L : this.extDocRootFile.getMatch().lastModified();
    }

    public boolean useContentLength() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "useContentLength", "length --> [" + this.useContentLength + "]");
        }
        return this.useContentLength;
    }

    public ZipFile getMatchedZipFile() {
        if (this.extDocRootFile instanceof ZipFileResource) {
            return ((ZipFileResource)this.extDocRootFile).getZipFile();
        }
        return null;
    }

    public ZipEntry getMatchedEntry() {
        if (this.extDocRootFile instanceof ZipFileResource) {
            return ((ZipFileResource)this.extDocRootFile).getZipEntry();
        }
        return null;
    }

    private void handleCaseSensitivityCheck(String path, String strippedPathInfo) throws FileNotFoundException, IOException {
        if (FileSystem.isCaseInsensitive) {
            File caseFile;
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "handleCaseSensitivityCheck", "file system is case insensitive");
            }
            if (!FileSystem.uriCaseCheck(caseFile = new File(path), strippedPathInfo)) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "handleCaseSensitivityCheck", "failed for --> [" + path + "]");
                }
                throw new FileNotFoundException(path);
            }
        }
    }

    protected class FileResource
    implements ExtDocRootFile {
        private File file;

        protected FileResource(File file) {
            this.file = file;
        }

        public InputStream getIS() throws IOException {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, ExtendedDocumentRootUtils.CLASS_NAME, "getIS", "return FileResource inputstream file -->" + this.file);
            }
            return new FileInputStream(this.file);
        }

        public File getMatch() {
            return this.file;
        }
    }

    protected class ZipFileResource
    implements ExtDocRootFile {
        private String entry;
        private File jarFile;

        protected ZipFileResource(File jarFile, String entry) {
            this.entry = entry;
            this.jarFile = jarFile;
        }

        public InputStream getIS() throws IOException {
            ZipFile zip = new ZipFile(this.jarFile);
            ZipEntry zEntry = zip.getEntry(this.entry);
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, ExtendedDocumentRootUtils.CLASS_NAME, "getIS", "return ZipFileResource inputstream zip -->" + this.jarFile + " entry -->" + this.entry);
            }
            return zip.getInputStream(zEntry);
        }

        public File getMatch() {
            return this.jarFile;
        }

        public ZipFile getZipFile() {
            try {
                return new ZipFile(this.jarFile);
            }
            catch (Exception e) {
                return null;
            }
        }

        public ZipEntry getZipEntry() {
            try {
                return new ZipFile(this.jarFile).getEntry(this.entry);
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    protected static interface ExtDocRootFile {
        public InputStream getIS() throws IOException;

        public File getMatch();
    }
}

