/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.srt;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.websphere.servlet.response.IResponse;
import com.ibm.ws.webcontainer.WebContainer;
import com.ibm.ws.webcontainer.core.Response;
import com.ibm.ws.webcontainer.srt.SRTConnectionContext;
import com.ibm.ws.webcontainer.srt.SRTOutputStream;
import com.ibm.ws.webcontainer.srt.http.HttpDate;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.ws.webcontainer.webapp.WebAppDispatcherContext;
import com.ibm.wsspi.webcontainer.WCCustomProperties;
import com.ibm.wsspi.webcontainer.WebContainerRequestState;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import com.ibm.wsspi.webcontainer.servlet.IExtendedRequest;
import com.ibm.wsspi.webcontainer.servlet.IExtendedResponse;
import com.ibm.wsspi.webcontainer.servlet.IOutputMethodListener;
import com.ibm.wsspi.webcontainer.servlet.IServletResponse;
import com.ibm.wsspi.webcontainer.util.BufferedServletOutputStream;
import com.ibm.wsspi.webcontainer.util.BufferedWriter;
import com.ibm.wsspi.webcontainer.util.EncodingUtils;
import com.ibm.wsspi.webcontainer.util.IOutputStreamObserver;
import com.ibm.wsspi.webcontainer.util.IResponseOutput;
import com.ibm.wsspi.webcontainer.util.ResponseBuffer;
import com.ibm.wsspi.webcontainer.util.WSServletOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SRTServletResponse
implements HttpServletResponse,
IResponseOutput,
IExtendedResponse,
IServletResponse,
Response,
IOutputStreamObserver {
    private static boolean skipInputStreamRead = false;
    private boolean isCharEncodingExplicit;
    private static final byte[] REASON_OK = "OK".getBytes();
    private static final String CONTENT_LANGUAGE_HEADER = "Content-Language";
    private static final byte[] CONTENT_LANGUAGE_HEADER_BYTES = "Content-Language".getBytes();
    private static final byte[] HEADER_CONTENT_TYPE_BYTES = "Content-Type".getBytes();
    private static final String HEADER_CONTENT_LENGTH = "Content-Length";
    private static final byte[] HEADER_CONTENT_LENGTH_BYTES = "Content-Length".getBytes();
    private static final String HEADER_CONTENT_ENCODING = "Content-Encoding";
    private static final byte[] HEADER_CONTENT_ENCODING_BYTES = "Content-Encoding".getBytes();
    private static final boolean keepContentLength = Boolean.valueOf(WebContainer.getWebContainerProperties().getProperty("keepcontentlength"));
    private static final boolean skipHeaderFlush = Boolean.valueOf(WebContainer.getWebContainerProperties().getProperty("com.ibm.ws.webcontainer.skipheaderflush"));
    private static final String contentTypeCompatibility = WCCustomProperties.CONTENT_TYPE_COMPATIBILITY;
    private static final boolean getSessionCompatibility = Boolean.valueOf(WebContainer.getWebContainerProperties().getProperty("com.ibm.ws.webcontainer.getsession2_4compatibility"));
    protected static Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.ws.webcontainer.srt");
    private static final String CLASS_NAME = "com.ibm.ws.webcontainer.srt.SRTServletResponse";
    protected static final NLS nls = new NLS("com.ibm.ws.webcontainer.resources.Messages");
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    public static final Locale _defaultLocale = Locale.getDefault();
    public static final String _defaultEncoding = "ISO-8859-1";
    protected IResponse _response = null;
    protected boolean writerClosed = false;
    protected SRTOutputStream _rawOut = new SRTOutputStream();
    protected ResponseBuffer _responseBuffer = null;
    protected WSServletOutputStream _bufferedOut;
    protected BufferedWriter _bufferedWriter = new BufferedWriter(4096);
    protected PrintWriter _pwriter;
    protected boolean _firstWrite = false;
    protected boolean _firstWriteToCurrentBuffer = false;
    protected int _bufferSize = 4096;
    protected boolean _gotWriter = false;
    protected boolean _firstWriterRetrieval = true;
    protected boolean _gotOutputStream = false;
    protected boolean _firstOutputStreamRetrieval = true;
    protected OutputStreamWriter _outWriter = null;
    protected String _outWriterEncoding;
    protected boolean writerException = false;
    protected boolean _ignoreStateErrors;
    protected boolean _headersWritten = false;
    protected Locale _locale;
    protected String _encoding;
    protected int _contentLength = -1;
    protected int _statusCode = 200;
    private SRTConnectionContext _connContext;
    private IOutputMethodListener outputMethodListener = null;
    private String _contentType;
    private static final boolean oldDateFormatter = Boolean.valueOf(WebContainer.getWebContainerProperties().getProperty("com.ibm.ws.webcontainer.olddateformatter"));
    private static ThreadLocal<SimpleDateFormat> dateFormat = new ThreadLocal();
    private static String formatStr = "EEE, dd MMM yyyy HH:mm:ss z";
    private static TimeZone gmtTimeZone = TimeZone.getTimeZone("GMT");

    public SRTServletResponse() {
        this._bufferedOut = this.createOutputStream(4096);
        this._bufferedWriter.setObserver(this);
        this._bufferedOut.setObserver(this);
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "SRTServletResponse", "outputstream is of type --> " + this._bufferedOut);
        }
    }

    public SRTServletResponse(SRTConnectionContext context) {
        this();
        this._connContext = context;
    }

    public void alertClose() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "alertClose", " _outWriter: --> " + this._outWriter, "[" + this + "]");
        }
        this.writerClosed = true;
    }

    public void alertFirstWrite() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "alertFirstWrite", " _outWriter: --> " + this._outWriter, "[" + this + "]");
        }
        this._firstWrite = true;
        this._firstWriteToCurrentBuffer = true;
    }

    public void alertFirstFlush() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "alertFirstFlush", "_outWriter: --> " + this._outWriter, "[" + this + "]");
        }
        if (!this.isCommitted()) {
            this.commit();
        }
    }

    public void alertException() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "alertException", "_outWriter: --> " + this._outWriter, "[" + this + "]");
        }
        this.writerException = true;
    }

    public boolean writerObtained() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "writerObtained", " " + String.valueOf(this._gotWriter), "[" + this + "]");
        }
        return this._gotWriter;
    }

    public boolean outputStreamObtained() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "outputStreamObtained", " " + String.valueOf(this._gotOutputStream), "[" + this + "]");
        }
        return this._gotOutputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "finish", "[" + this + "]");
        }
        if (!this.isCommitted()) {
            this.commit();
        }
        try {
            try {
                this.flushBuffer(false);
                this._rawOut.close();
            }
            catch (IOException e) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "finish", "Servlet.Exception:.Error.while.finishing.response", e);
                }
                Object var3_2 = null;
                this._rawOut.reset();
                this._response = null;
                this._bufferSize = 4096;
                this._encoding = null;
                this._bufferedOut.reset();
                this._bufferedWriter.reset();
                this._responseBuffer = null;
                this._gotOutputStream = false;
                this._gotWriter = false;
                this._pwriter = null;
                this._responseBuffer = null;
            }
            Object var3_1 = null;
            this._rawOut.reset();
            this._response = null;
            this._bufferSize = 4096;
            this._encoding = null;
            this._bufferedOut.reset();
            this._bufferedWriter.reset();
            this._responseBuffer = null;
            this._gotOutputStream = false;
            this._gotWriter = false;
            this._pwriter = null;
            this._responseBuffer = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this._rawOut.reset();
            this._response = null;
            this._bufferSize = 4096;
            this._encoding = null;
            this._bufferedOut.reset();
            this._bufferedWriter.reset();
            this._responseBuffer = null;
            this._gotOutputStream = false;
            this._gotWriter = false;
            this._pwriter = null;
            this._responseBuffer = null;
            throw throwable;
        }
        this.resetState();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "finish");
        }
    }

    protected void resetState() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "resetState", "[" + this + "]");
        }
        this._headersWritten = false;
        this._firstWrite = false;
        this._firstWriteToCurrentBuffer = false;
        this._ignoreStateErrors = false;
        this._contentLength = -1;
        this._contentType = null;
        this._locale = _defaultLocale;
        this.writerClosed = false;
        this._firstWriterRetrieval = true;
        this._firstOutputStreamRetrieval = true;
        this.isCharEncodingExplicit = false;
    }

    public void addField(String key, String value) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "addField", "key --> " + key + " value --> " + value, "[" + this + "]");
        }
        this._response.addHeader(key, value);
    }

    public void addDateField(String key, long value) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "addDateField", "key --> " + key + " value --> " + value, "[" + this + "]");
        }
        this._response.addDateHeader(key, value);
    }

    public void addIntField(String key, int value) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "addIntField", "key --> " + key + " value --> " + value, "[" + this + "]");
        }
        this._response.addIntHeader(key, value);
    }

    protected String getHeader(String key) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getHeader", " name --> " + key + " response --> " + this._response.getHeader(key), "[" + this + "]");
        }
        return this._response.getHeader(key);
    }

    public IResponse getIResponse() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getIResponse", " response --> " + this._response, "[" + this + "]");
        }
        return this._response;
    }

    protected String getHeader(byte[] key) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getHeader", " name --> " + (key != null ? new String(key) : "") + " response --> " + this._response.getHeader(key), "[" + this + "]");
        }
        return this._response.getHeader(key);
    }

    public boolean containsHeader(String name) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "containsHeader", " name --> " + name + " response --> " + String.valueOf(this._response.containsHeader(name)), "[" + this + "]");
        }
        return this._response.containsHeader(name);
    }

    public boolean containsHeader(byte[] name) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "containsHeader", " name --> " + (name != null ? new String(name) : "") + " response --> " + String.valueOf(this._response.containsHeader(name)), "[" + this + "]");
        }
        return this._response.containsHeader(name);
    }

    protected void removeHeader(String key) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "removeHeader", " name --> " + key, "[" + this + "]");
        }
        this._response.removeHeader(key);
    }

    protected void removeHeader(byte[] key) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "removeHeader", " name --> " + (key != null ? new String(key) : ""), "[" + this + "]");
        }
        this._response.removeHeader(key);
    }

    public void resetBuffer() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "resetBuffer", "[" + this + "]");
        }
        if (this._responseBuffer != null) {
            this._responseBuffer.clearBuffer();
        }
        if (this._bufferedWriter != null) {
            this._bufferedWriter.clearBuffer();
        }
        this._firstWriteToCurrentBuffer = false;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "resetBuffer");
        }
    }

    public void closeResponseOutput() {
        this.closeResponseOutput(false);
    }

    public void closeResponseOutput(boolean releaseChannel) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "closeResponseOutput", "[" + this + "]");
            logger.logp(Level.FINE, CLASS_NAME, "closeResponseOutput", "releaseChannel->" + releaseChannel + ", writerClosed->" + this.writerClosed);
        }
        if (!this.writerClosed) {
            boolean isArdEnabled = false;
            if (com.ibm.wsspi.webcontainer.WebContainer.getWebContainer().getWebContainerConfig().isArdEnabled() && ((WebAppDispatcherContext)this._connContext.getRequest().getWebAppDispatcherContext()).getWebApp().getWebAppConfig().isArdEnabled()) {
                isArdEnabled = true;
                WebContainerRequestState reqState = WebContainerRequestState.getInstance(true);
                reqState.setAttribute("com.ibm.ws.webcontainer.appIsArdEnabled", true);
            }
            if (!isArdEnabled) {
                block22: {
                    this._response.setFlushMode(false);
                    try {
                        if (this._gotOutputStream) {
                            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                logger.logp(Level.FINE, CLASS_NAME, "closeResponseOutput", "flush output stream");
                            }
                            this._bufferedOut.flush();
                        } else if (this._gotWriter) {
                            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                logger.logp(Level.FINE, CLASS_NAME, "closeResponseOutput", "flush writer");
                            }
                            this._pwriter.flush();
                        }
                    }
                    catch (Throwable th) {
                        if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.SEVERE)) break block22;
                        logger.logp(Level.SEVERE, CLASS_NAME, "closeResponseOutput", "Error while flushing last response");
                    }
                }
                this._response.setFlushMode(true);
            }
            try {
                if (this._gotOutputStream) {
                    if (!isArdEnabled && !WCCustomProperties.FINISH_RESPONSE_ON_CLOSE) {
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "closeResponseOutput", "setLastBuffer to true ");
                        }
                        this._response.setLastBuffer(true);
                    }
                    this._bufferedOut.close();
                    this._rawOut.close();
                } else if (this._gotWriter) {
                    if (!isArdEnabled && !WCCustomProperties.FINISH_RESPONSE_ON_CLOSE) {
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "closeResponseOutput", "setLastBuffer to true ");
                        }
                        this._response.setLastBuffer(true);
                    }
                    this._pwriter.close();
                    this._rawOut.close();
                }
                if (releaseChannel) {
                    this._response.releaseChannel();
                    WebContainerRequestState.getInstance(true).setCompleted(true);
                }
            }
            catch (Throwable th) {
                logger.logp(Level.SEVERE, CLASS_NAME, "closeResponseOutput", "Error while closing response output.", th);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "closeResponseOutput");
        }
    }

    public void setIgnoreStateErrors(boolean b) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setIgnoreStateErrors", " " + String.valueOf(b), "[" + this + "]");
        }
        this._ignoreStateErrors = b;
    }

    public void setBufferSize(int size) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "setBufferSize ", String.valueOf(size) + " [" + this + "]");
        }
        this._bufferSize = size;
        if (this._responseBuffer != null) {
            if (!this._firstWrite) {
                this._responseBuffer.setBufferSize(size);
            } else {
                logger.logp(Level.SEVERE, CLASS_NAME, "setBufferSize", "setbuffer.size.called.after.write");
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.exiting(CLASS_NAME, "setBufferSize", "throw IllegalStateException");
                }
                throw new IllegalStateException("setBufferSize() called after first write to Output Stream/Writer");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "setBufferSize");
        }
    }

    public int getBufferSize() {
        if (this._responseBuffer == null) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "getBufferSize", "size --> " + this._bufferSize, "[" + this + "]");
            }
            return this._bufferSize;
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getBufferSize", "getBufferSize --> " + this._responseBuffer.getBufferSize(), "[" + this + "]");
        }
        return this._responseBuffer.getBufferSize();
    }

    public void flushBuffer() throws IOException {
        this.flushBuffer(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushBuffer(boolean flushToWire) throws IOException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "flushBuffer", "flushToWire=" + String.valueOf(flushToWire) + " [" + this + "]");
        }
        boolean commited = false;
        if (!flushToWire) {
            this._response.setFlushMode(false);
        }
        try {
            if (isTraceOn && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "flushBuffer", "_firstWriteToCurrentBuffer->" + this._firstWriteToCurrentBuffer + ", skipHeaderFlush->" + skipHeaderFlush);
            }
            if (this._firstWriteToCurrentBuffer || skipHeaderFlush) {
                if (isTraceOn && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "flushBuffer", "we've written output so flush");
                }
                if (this._pwriter != null && !this.writerClosed) {
                    this._pwriter.flush();
                    commited = true;
                }
                if (this._gotOutputStream) {
                    this._responseBuffer.flushBuffer();
                    commited = true;
                }
            }
            if (!this.isCommitted() && !commited) {
                if (isTraceOn && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "flushBuffer", "Not committed, so write headers");
                }
                this.commit();
                this._response.writeHeaders();
            }
        }
        finally {
            if (!flushToWire) {
                this._response.setFlushMode(true);
            }
            if (isTraceOn && logger.isLoggable(Level.FINE)) {
                logger.exiting(CLASS_NAME, "flushBuffer");
            }
        }
    }

    public boolean isCommitted() {
        if (this._headersWritten) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "isCommitted", "headersWritten=true", "[" + this + "]");
            }
            return true;
        }
        if (this._gotWriter || this._gotOutputStream) {
            if (this._responseBuffer == null) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "isCommitted", "responseBuffer=null", "[" + this + "]");
                }
                return false;
            }
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "isCommitted", "responseBuffer isCommitted=" + this._responseBuffer.isCommitted(), "[" + this + "]");
            }
            return this._responseBuffer.isCommitted();
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "isCommitted", "false", "[" + this + "]");
        }
        return false;
    }

    public IExtendedRequest getRequest() {
        if (this._connContext == null) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "getRequest", "null", "[" + this + "]");
            }
            return null;
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getRequest", "request=" + this._connContext.getRequest(), "[" + this + "]");
        }
        return this._connContext.getRequest();
    }

    public ServletOutputStream getOutputStream() {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "getOutputStream", "gotWriter=" + String.valueOf(this._gotWriter) + " [" + this + "]");
        }
        if (!this._ignoreStateErrors && this._gotWriter) {
            if (isTraceOn && logger.isLoggable(Level.FINE)) {
                logger.exiting(CLASS_NAME, "getOutputStream", "throw IllegalStateException");
            }
            throw new IllegalStateException(nls.getString("Writer.already.obtained", "Writer already obtained"));
        }
        if (!WCCustomProperties.FINISH_RESPONSE_ON_CLOSE || !this._gotOutputStream) {
            this._gotOutputStream = true;
            this._bufferedOut.init(this._rawOut, this.getBufferSize());
            this._bufferedOut.setLimit(this._contentLength);
            this._bufferedOut.setResponse(this._response);
            this._responseBuffer = this._bufferedOut;
        }
        this.fireOutputStreamRetrievedEvent(this._bufferedOut);
        if (isTraceOn && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "getOutputStream");
        }
        return this._bufferedOut;
    }

    public PrintWriter getWriter() throws IOException, UnsupportedEncodingException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "getWriter", "gotOutputStream=" + String.valueOf(this._gotOutputStream) + " [" + this + "]");
        }
        if (!this._ignoreStateErrors && this._gotOutputStream) {
            if (isTraceOn && logger.isLoggable(Level.FINE)) {
                logger.exiting(CLASS_NAME, "getWriter", "throw IllegalStateException");
            }
            throw new IllegalStateException(nls.getString("OutputStream.already.obtained", "OutputStream already obtained"));
        }
        if (!this._gotWriter) {
            String contentType;
            String charEncoding = this.getCharacterEncoding();
            if ((contentTypeCompatibility == null || !contentTypeCompatibility.equalsIgnoreCase("V4") && !contentTypeCompatibility.equalsIgnoreCase("V5")) && (contentType = this.getContentType()) != null && contentType.indexOf("charset") == -1 && contentType.startsWith("text")) {
                if (contentType.endsWith(";")) {
                    this.setContentType(contentType + "charset=" + charEncoding);
                } else {
                    this.setContentType(contentType + ";charset=" + charEncoding);
                }
            }
            if (this._outWriter == null || this.writerException || !charEncoding.equals(this._outWriterEncoding)) {
                if (isTraceOn && logger.isLoggable(Level.FINE) && this.writerException) {
                    logger.logp(Level.FINE, CLASS_NAME, "getWriter", "writerException --> " + this.writerException + "--> creating new OutputStreamWriter");
                }
                this._outWriter = new OutputStreamWriter((OutputStream)this._rawOut, EncodingUtils.getJvmConverter(charEncoding));
                this._outWriterEncoding = charEncoding;
                this.writerException = false;
            } else if (isTraceOn && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "getWriter", "reusing _outWriter: --> " + this._outWriter);
            }
            if (isTraceOn && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "getWriter", "created writer with encoding: " + this._outWriter.getEncoding());
            }
            this._bufferedWriter.init(this._outWriter, this.getBufferSize());
            this._bufferedWriter.setLimit(this._contentLength);
            this._bufferedWriter.setResponse(this._response);
            this._pwriter = new PrintWriter((Writer)this._bufferedWriter, false);
            this._responseBuffer = this._bufferedWriter;
            this._gotWriter = true;
            this.writerClosed = false;
        }
        this.fireWriterRetrievedEvent(this._pwriter);
        if (isTraceOn && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "getWriter");
        }
        return this._pwriter;
    }

    public void start() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "start", "[" + this + "]");
        }
        this.setDefaultResponseEncoding();
    }

    protected SRTConnectionContext getConnectionContext() {
        return this._connContext;
    }

    public Object clone() throws CloneNotSupportedException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "clone", "[" + this + "]");
        }
        return super.clone();
    }

    public void addCookie(Cookie cookie) {
        WebAppDispatcherContext dispatchContext;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "addCookie", "Adding cookie --> " + cookie.getName(), "[" + this + "]");
        }
        if ((dispatchContext = (WebAppDispatcherContext)this.getRequest().getWebAppDispatcherContext()).isInclude()) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "addCookie", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "addCookie cookie --> " + cookie.getName());
            }
        } else if (!this._ignoreStateErrors && this.isCommitted()) {
            logger.logp(Level.WARNING, CLASS_NAME, "addCookie", "WARNING: Cannot set header. Response already committed.");
        } else {
            this._response.addCookie(cookie);
        }
    }

    protected void commit() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "commit", "[" + this + "]");
        }
        if (!this._headersWritten && !this.isCommitted()) {
            this.addLocaleHeader();
            if (this.getHeader(HEADER_CONTENT_ENCODING_BYTES) != null && this.getHeader(HEADER_CONTENT_LENGTH_BYTES) != null) {
                if (keepContentLength) {
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "commit", "WebContainer custom property set to keep Content-Length header w/presence of Content-Encoding header");
                    }
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "commit", "Content-Length header disallowed w/presence of Content-Encoding header");
                    }
                    this.removeHeader(HEADER_CONTENT_LENGTH_BYTES);
                }
            }
            WebContainer.notifyHttpServletResponseListenersPreHeaderCommit((HttpServletRequest)((Object)this._connContext.getRequest()), this);
            this._response.prepareHeadersForWrite();
            this._headersWritten = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "commit");
        }
    }

    private void addLocaleHeader() {
        this._response.setContentLanguage(this._locale.toString().replace('_', '-'));
    }

    public String encodeRedirectUrl(String URL2) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "encodeRedirectUrl", "[" + this + "]");
        }
        return this.encodeURL(URL2);
    }

    public String encodeRedirectURL(String url) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "encodeRedirectURL", "[" + this + "]");
        }
        return this.encodeURL(url);
    }

    public String encodeUrl(String URL2) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "encodeUrl", "[" + this + "]");
        }
        return this.encodeURL(URL2);
    }

    public String encodeURL(String url) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "encodeURL", " url --> " + url, "[" + this + "]");
        }
        WebAppDispatcherContext dispatchContext = (WebAppDispatcherContext)this.getRequest().getWebAppDispatcherContext();
        return dispatchContext.encodeURL(url);
    }

    protected void setDefaultResponseEncoding() {
        WebAppDispatcherContext dispatchContext;
        WebApp webApp;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "setDefaultResponseEncoding", "[" + this + "]");
        }
        IExtendedRequest extReq = this.getRequest();
        boolean useAuto = false;
        if (extReq != null && (webApp = (dispatchContext = (WebAppDispatcherContext)extReq.getWebAppDispatcherContext()).getWebApp()) != null && webApp.getConfiguration().isAutoResponseEncoding()) {
            useAuto = true;
            this._locale = this.getRequest().getLocale();
            if (this._locale == null) {
                this._locale = _defaultLocale;
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "setDefaultResponseEncoding", "_locale is null: default to " + this._locale.toString());
                }
            }
            this._encoding = this.getRequest().getCharacterEncoding();
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "setDefaultResponseEncoding", "Encoding from request: " + this._encoding);
            }
            if (this._encoding != null && !EncodingUtils.isCharsetSupported(this._encoding)) {
                this._encoding = null;
            }
            if (this._encoding == null) {
                this._encoding = dispatchContext.getWebApp().getConfiguration().getLocaleEncoding(this._locale);
                if (this._encoding == null) {
                    this._encoding = EncodingUtils.getEncodingFromLocale(this._locale);
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "setDefaultResponseEncoding", "Encoding from locale: " + this._encoding);
                    }
                    if (this._encoding == null) {
                        this._encoding = _defaultEncoding;
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "setDefaultResponseEncoding", "_encoding is null: default to " + this._encoding);
                        }
                    }
                }
            }
            if (EncodingUtils.setContentTypeBySetHeader) {
                this.setHeader("Content-Type", "text/html; charset=" + this._encoding);
            } else {
                this.setContentType("text/html; charset=" + this._encoding);
            }
        }
        if (!useAuto) {
            this._locale = _defaultLocale;
            this._encoding = _defaultEncoding;
            if (contentTypeCompatibility != null) {
                if (contentTypeCompatibility.equalsIgnoreCase("V4")) {
                    this.setHeader("Content-Type", "text/html");
                    if (EncodingUtils.setContentTypeBySetHeader) {
                        this.setHeader("Content-Type", "text/html");
                    } else {
                        this.setContentType("text/html");
                    }
                } else if (contentTypeCompatibility.equalsIgnoreCase("V5")) {
                    if (EncodingUtils.setContentTypeBySetHeader) {
                        this.setHeader("Content-Type", "text/html; charset=" + this._encoding);
                    } else {
                        this.setContentType("text/html; charset=" + this._encoding);
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "setDefaultResponseEncoding", "_locale: " + this._locale.toString() + ", _encoding: " + this._encoding);
        }
    }

    public void reset() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "reset", "[" + this + "]");
        }
        this._response.setReason(REASON_OK);
        this._response.setStatusCode(200);
        if (this._responseBuffer != null) {
            this._responseBuffer.clearBuffer();
        }
        if (this._bufferedWriter != null) {
            this._bufferedWriter.clearBuffer();
        }
        this._response.clearHeaders();
        this.resetState();
        this.setDefaultResponseEncoding();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "reset");
        }
    }

    public String getCharacterEncoding() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "getCharacterEncoding", "[" + this + "]");
        }
        if (this._encoding == null) {
            this.setDefaultResponseEncoding();
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "getCharacterEncoding", " encoding --> " + this._encoding);
        }
        return this._encoding;
    }

    public String getContentType() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getContentType", "[" + this + "]");
        }
        return this.getHeader(HEADER_CONTENT_TYPE_BYTES);
    }

    public void setCharacterEncoding(String encoding) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "setCharacterEncoding", " encoding --> " + encoding + " [" + this + "]");
        }
        WebAppDispatcherContext dispatchContext = (WebAppDispatcherContext)this.getRequest().getWebAppDispatcherContext();
        if (this.getRequest() != null && dispatchContext.isInclude()) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.exiting(CLASS_NAME, "setCharacterEncoding", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"));
            }
            return;
        }
        if (this._gotWriter || this._headersWritten) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.exiting(CLASS_NAME, "setCharacterEncoding", "_gotWriter=" + String.valueOf(this._gotWriter) + ", _headersWritten=" + String.valueOf(this._headersWritten));
            }
            return;
        }
        if (encoding != null) {
            String apos = "'";
            String qoute = "\"";
            if (encoding.startsWith(apos) || encoding.startsWith(qoute)) {
                encoding = encoding.substring(1);
            }
            if (encoding.endsWith(apos) || encoding.endsWith(qoute)) {
                encoding = encoding.substring(0, encoding.length() - 1);
            }
            this._encoding = encoding;
            this.isCharEncodingExplicit = true;
        }
        if (this._contentType != null) {
            int index = this._contentType.indexOf("charset=");
            this._contentType = index != -1 ? this._contentType.substring(0, index) + "charset=" + this._encoding : this._contentType + "; charset=" + this._encoding;
            if (this._response != null) {
                this._response.setContentType(this._contentType);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "setCharacterEncoding", "encoding: " + this._encoding + " ,contentType: " + this._contentType);
        }
    }

    public Cookie[] getCookies() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getCookies", "[" + this + "]");
        }
        return this._response.getCookies();
    }

    public void sendError(int status) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "sendError", "error --> " + String.valueOf(status), "[" + this + "]");
        }
        Object[] args = new Object[]{new Integer(status)};
        this.sendError(status, MessageFormat.format(nls.getString("Error.reported.{0}", "Error reported: {0}"), args));
    }

    public void sendError(int status, String msg) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "sendError", "status --> " + status + " " + msg + " [" + this + "]");
        }
        WebAppDispatcherContext dispatchContext = (WebAppDispatcherContext)this.getRequest().getWebAppDispatcherContext();
        dispatchContext.sendError(status, msg);
        this.closeResponseOutput();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "sendError");
        }
    }

    public void setReason(String msg) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setReason", " message --> " + msg, "[" + this + "]");
        }
        this._response.setReason(msg);
    }

    public void sendRedirect(String location) throws IOException {
        WebAppDispatcherContext dispatchContext;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "sendRedirect", "location --> " + location + " [" + this + "]");
        }
        if ((dispatchContext = (WebAppDispatcherContext)this.getRequest().getWebAppDispatcherContext()).isInclude()) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "sendRedirect", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "sendRedirect location --> " + location);
            }
        } else {
            dispatchContext.sendRedirect(location);
        }
        this.closeResponseOutput();
        if (!this.isCommitted()) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "sendRedirect", " : Not committed, so write headers");
            }
            this.commit();
            this._response.setLastBuffer(true);
            this._response.writeHeaders();
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "sendRedirect");
        }
    }

    public void sendRedirect303(String location) throws IOException {
        WebAppDispatcherContext dispatchContext;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "sendRedirect303", "location --> " + location + " [" + this + "]");
        }
        if ((dispatchContext = (WebAppDispatcherContext)this.getRequest().getWebAppDispatcherContext()).isInclude()) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "sendRedirect303", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "sendRedirect303 location -->" + location);
            }
        } else {
            dispatchContext.sendRedirect303(location);
        }
        this.closeResponseOutput();
        if (!this.isCommitted()) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "sendRedirect", " : Not committed, so write headers");
            }
            this.commit();
            this._response.setLastBuffer(true);
            this._response.writeHeaders();
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "sendRedirect303");
        }
    }

    public void setContentLength(int len) {
        WebAppDispatcherContext dispatchContext;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "setContentLength", "length --> " + String.valueOf(len) + " [" + this + "]");
        }
        if ((dispatchContext = (WebAppDispatcherContext)this.getRequest().getWebAppDispatcherContext()).isInclude()) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "setContentLength", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "setContentLength length --> " + String.valueOf(len));
            }
        } else {
            this._contentLength = len;
            this._bufferedOut.setLimit(this._contentLength);
            this._bufferedWriter.setLimit(this._contentLength);
            this.setIntHeader(HEADER_CONTENT_LENGTH, len);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "setContentLength");
        }
    }

    public void setContentType(String type) {
        WebAppDispatcherContext dispatchContext;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "setContentType", " type --> " + type + " [" + this + "]");
        }
        if ((dispatchContext = (WebAppDispatcherContext)this.getRequest().getWebAppDispatcherContext()).isInclude()) {
            if (isTraceOn && logger.isLoggable(Level.FINE)) {
                logger.exiting(CLASS_NAME, "setContentType", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"));
            }
            return;
        }
        if (this.isCommitted()) {
            if (isTraceOn && logger.isLoggable(Level.FINE)) {
                logger.exiting(CLASS_NAME, "setContentType", "not set - response isCommitted");
            }
            return;
        }
        int equalsIndex = type.indexOf(61);
        boolean containsCharset = false;
        int beginCharsetStrIndex = equalsIndex - 7;
        int startCharsetValIndex = equalsIndex + 1;
        boolean isPreV7 = false;
        if (contentTypeCompatibility != null && (contentTypeCompatibility.equalsIgnoreCase("V4") || contentTypeCompatibility.equalsIgnoreCase("V5") || contentTypeCompatibility.equalsIgnoreCase("V6"))) {
            isPreV7 = true;
        }
        boolean addEncoding = false;
        if (beginCharsetStrIndex > -1) {
            containsCharset = type.substring(beginCharsetStrIndex, equalsIndex).equalsIgnoreCase("charset");
        }
        if (containsCharset) {
            if (isTraceOn && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "setContentType", " isPreV7 --> " + isPreV7);
            }
            if (!this._gotWriter) {
                int endIndex = type.length() - 1;
                if (startCharsetValIndex <= endIndex) {
                    boolean endsWithQoute;
                    this.isCharEncodingExplicit = true;
                    boolean startsWithQoute = type.charAt(startCharsetValIndex) == '\"' || type.charAt(startCharsetValIndex) == '\'';
                    boolean bl = endsWithQoute = type.charAt(endIndex) == '\"' || type.charAt(endIndex) == '\'';
                    if (startsWithQoute && endsWithQoute) {
                        this._encoding = type.substring(startCharsetValIndex + 1, endIndex);
                        addEncoding = true;
                    } else {
                        this._encoding = type.substring(startCharsetValIndex);
                    }
                }
            } else if (isPreV7) {
                if (isTraceOn && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "setContentType", " isPreV7, strip charset ");
                }
                type = type.substring(0, beginCharsetStrIndex).trim();
                type = type.substring(0, type.length() - 1);
            }
        }
        if (!isPreV7) {
            if (this._gotWriter) {
                if (isTraceOn && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "setContentType", " add encoding because we retrieved a writer");
                }
                addEncoding = true;
            } else {
                if (isTraceOn && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "setContentType", " did not get writer, check to see if charset already exists");
                }
                if (this.isCharEncodingExplicit && type.startsWith("text")) {
                    if (isTraceOn && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "setContentType", " add encoding because the content type already had a charset");
                    }
                    addEncoding = true;
                }
            }
        }
        if (addEncoding) {
            type = containsCharset ? type.substring(0, startCharsetValIndex) + this._encoding : type + ";" + "charset=" + this._encoding;
        }
        this._contentType = type;
        if (this._response != null) {
            this._response.setContentType(type);
        }
        if (isTraceOn && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "setContentType", "type=" + this._contentType);
        }
    }

    public void setDateHeader(String name) {
        WebAppDispatcherContext dispatchContext;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "setDateHeader", "name --> " + name + " [" + this + "]");
        }
        if ((dispatchContext = (WebAppDispatcherContext)this.getRequest().getWebAppDispatcherContext()).isInclude()) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "setDateHeader", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"));
            }
        } else {
            if (!this._ignoreStateErrors && this.isCommitted()) {
                logger.logp(Level.WARNING, CLASS_NAME, "setDateHeader", "WARNING: Cannot set header. Response already committed.");
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.exiting(CLASS_NAME, "setDateHeader", "Response already committed");
                }
                return;
            }
            this.setHeader(name, this.createCompliantHttpDateString(System.currentTimeMillis()));
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "setDateHeader");
        }
    }

    public void setDateHeader(String name, long t) {
        WebAppDispatcherContext dispatchContext;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "setDateHeader", " name --> " + name + " value --> " + String.valueOf(t) + " [" + this + "]");
        }
        if ((dispatchContext = (WebAppDispatcherContext)this.getRequest().getWebAppDispatcherContext()).isInclude()) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "setDateHeader", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"));
            }
        } else {
            if (!this._ignoreStateErrors && this.isCommitted()) {
                logger.logp(Level.WARNING, CLASS_NAME, "setDateHeader", "WARNING: Cannot set header. Response already committed.");
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.exiting(CLASS_NAME, "setDateHeader", "Response already committed");
                }
                return;
            }
            this._response.setDateHeader(name, t);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "setDateHeader");
        }
    }

    public void setHeader(String name, String s) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setHeader", " name --> " + name + " value --> " + s, "[" + this + "]");
        }
        this.setHeader(name, s, true);
    }

    public void setHeader(String name, String s, boolean checkInclude) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "setHeader", " name --> " + name + " value --> " + s + " checkInclude --> " + checkInclude + " [" + this + "]");
        }
        WebAppDispatcherContext dispatchContext = (WebAppDispatcherContext)this.getRequest().getWebAppDispatcherContext();
        if (checkInclude && dispatchContext.isInclude()) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "setHeader", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "setHeader name --> " + name + " value --> " + s + " checkInclude --> " + checkInclude);
            }
        } else {
            if (name == null) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.exiting(CLASS_NAME, "setHeader", "name is null");
                }
                return;
            }
            if (!this._ignoreStateErrors && this.isCommitted()) {
                logger.logp(Level.WARNING, CLASS_NAME, "setHeader", "WARNING: Cannot set header. Response already committed.");
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.exiting(CLASS_NAME, "setHeader", "Response already committed");
                }
                return;
            }
            if (s == null) {
                this.removeHeader(name);
            } else {
                if (name.equalsIgnoreCase("Content-Type")) {
                    String value = s.toLowerCase();
                    int index = value.indexOf("charset=");
                    if (index != -1) {
                        this._encoding = s.substring(index + 8);
                        s = s.substring(0, index) + "charset=" + this._encoding;
                    } else if (dispatchContext.isAutoRequestEncoding()) {
                        s = s.endsWith(";") ? s + "charset=" + this.getCharacterEncoding() : s + ";charset=" + this.getCharacterEncoding();
                    }
                    this._contentType = s;
                }
                this._response.setHeader(name, s);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "setHeader", " name --> " + name + " value --> " + s);
        }
    }

    public void setInternalHeader(String name, String s) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setInternalHeader", " name --> " + name + " value --> " + s, "[" + this + "]");
        }
        this.setHeader(name, s, false);
    }

    protected void setHeader(byte[] name, String s) {
        WebAppDispatcherContext dispatchContext;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "setHeader", " name --> " + name + " value --> " + s + " [" + this + "]");
        }
        if ((dispatchContext = (WebAppDispatcherContext)this.getRequest().getWebAppDispatcherContext()).isInclude()) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "setHeader", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "setHeader name --> " + name + " value --> " + s);
            }
        } else {
            if (name == null) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.exiting(CLASS_NAME, "setHeader", "name is null");
                }
                return;
            }
            if (!this._ignoreStateErrors && this.isCommitted()) {
                logger.logp(Level.WARNING, CLASS_NAME, "setHeader", "WARNING: Cannot set header. Response already committed.");
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.exiting(CLASS_NAME, "setHeader", "Response already committed");
                }
                return;
            }
            if (s == null) {
                this.removeHeader(name);
            } else {
                if (Arrays.equals(name, HEADER_CONTENT_TYPE_BYTES)) {
                    String value = s.toLowerCase();
                    int index = value.indexOf("charset=");
                    if (index != -1) {
                        this._encoding = s.substring(index + 8);
                        s = s.substring(0, index) + "charset=" + this._encoding;
                    } else if (dispatchContext.isAutoRequestEncoding()) {
                        s = value.endsWith(";") ? s + "charset=" + this.getCharacterEncoding() : s + ";charset=" + this.getCharacterEncoding();
                    }
                    this._contentType = s;
                }
                this._response.setHeader(name, s.getBytes());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "setHeader");
        }
    }

    public void setIntHeader(String name, int i) {
        WebAppDispatcherContext dispatchContext;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "setIntHeader", " name --> " + name + " value --> " + String.valueOf(i) + " [" + this + "]");
        }
        if ((dispatchContext = (WebAppDispatcherContext)this.getRequest().getWebAppDispatcherContext()).isInclude()) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "setIntHeader", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "setIntHeader name --> " + name + " value --> " + String.valueOf(i));
            }
        } else {
            if (!this._ignoreStateErrors && this.isCommitted()) {
                logger.logp(Level.WARNING, CLASS_NAME, "setIntHeader", "WARNING: Cannot set header. Response already committed.");
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.exiting(CLASS_NAME, "setIntHeader : Response already committed.");
                }
                return;
            }
            this._response.setIntHeader(name, i);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "setIntHeader");
        }
    }

    public void setStatus(int status) {
        WebAppDispatcherContext dispatchContext;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "setStatus", " status --> " + String.valueOf(status) + " [" + this + "]");
        }
        if ((dispatchContext = (WebAppDispatcherContext)this.getRequest().getWebAppDispatcherContext()).isInclude()) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "setStatus", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "setStatus status --> " + String.valueOf(status));
            }
        } else if (!this._ignoreStateErrors && this.isCommitted()) {
            logger.logp(Level.WARNING, CLASS_NAME, "setStatus", "WARNING: Cannot set status. Response already committed.");
        } else {
            this.resetBuffer();
            this._response.setStatusCode(status);
            this._statusCode = status;
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "setStatus");
        }
    }

    public void setStatus(int status, String reason) {
        WebAppDispatcherContext dispatchContext;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "setStatus", " status --> " + String.valueOf(status) + " reason --> " + reason + " [" + this + "]");
        }
        if ((dispatchContext = (WebAppDispatcherContext)this.getRequest().getWebAppDispatcherContext()).isInclude()) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "setStatus", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "setStatus status --> " + String.valueOf(status) + " reason --> " + reason);
            }
        } else if (!this._ignoreStateErrors && this.isCommitted()) {
            logger.logp(Level.WARNING, CLASS_NAME, "setStatus", "WARNING: Cannot set status. Response already committed.");
        } else {
            this.resetBuffer();
            this._response.setStatusCode(status);
            this._response.setReason(reason);
            this._statusCode = status;
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "setStatus");
        }
    }

    public int getStatusCode() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getStatusCode", "statusCode = " + this._statusCode, "[" + this + "]");
        }
        return this._statusCode;
    }

    public void setLocale(Locale loc) {
        String contentType;
        WebAppDispatcherContext dispatchContext;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "setLocale", " locale --> " + (loc != null ? loc.toString() : "") + " [" + this + "]");
        }
        if ((dispatchContext = (WebAppDispatcherContext)this.getRequest().getWebAppDispatcherContext()).isInclude()) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.exiting(CLASS_NAME, "setLocale", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"));
            }
            return;
        }
        this._locale = loc;
        if (this.isCharEncodingSet() || this._gotWriter || this._headersWritten) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.exiting(CLASS_NAME, "setLocale", "_gotWriter=" + String.valueOf(this._gotWriter) + ", _headersWritten=" + String.valueOf(this._headersWritten));
            }
            return;
        }
        this.isCharEncodingExplicit = false;
        this._encoding = dispatchContext.getWebApp().getConfiguration().getLocaleEncoding(this._locale);
        if (this._encoding == null) {
            this._encoding = EncodingUtils.getEncodingFromLocale(this._locale);
            if (this._encoding == null) {
                this._encoding = _defaultEncoding;
            }
        }
        if ((contentType = this.getHeader(HEADER_CONTENT_TYPE_BYTES)) != null) {
            int index = contentType.indexOf("charset=");
            contentType = index != -1 ? contentType.substring(0, index) + "charset=" + this._encoding : contentType + "; charset=" + this._encoding;
            this._response.setContentType(contentType);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "setLocale", "contentType = " + contentType);
        }
    }

    private boolean isCharEncodingSet() {
        int index;
        String contentType = this.getHeader(HEADER_CONTENT_TYPE_BYTES);
        if (contentType != null && (index = contentType.indexOf("charset=")) != -1) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "isCharEncodingSet", String.valueOf(this.isCharEncodingExplicit));
            }
            return this.isCharEncodingExplicit;
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "isCharEncodingSet", "false");
        }
        return false;
    }

    public Locale getLocale() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getLocale", "_locale = " + this._locale + " [" + this + "]");
        }
        if (this._locale == null) {
            this.setDefaultResponseEncoding();
        }
        return this._locale;
    }

    public void addDateHeader(String name, long date) {
        WebAppDispatcherContext dispatchContext;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "addDateHeader", "name --> " + name + " date --> " + date + " [" + this + "]");
        }
        if ((dispatchContext = (WebAppDispatcherContext)this.getRequest().getWebAppDispatcherContext()).isInclude()) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "addDateHeader", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "addDateHeader name --> " + name + " value --> " + String.valueOf(date));
            }
        } else {
            if (!this._ignoreStateErrors && this.isCommitted()) {
                logger.logp(Level.WARNING, CLASS_NAME, "addDateHeader", "WARNING: Cannot set header. Response already committed.");
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.exiting(CLASS_NAME, "addDateHeader", "Response already committed");
                }
                return;
            }
            if (name.equalsIgnoreCase("Content-Type")) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.exiting(CLASS_NAME, "addDateHeader", "throw IllegalArgumentException");
                }
                throw new IllegalArgumentException("Cannot Set Content-Type to a Date value");
            }
            this.setHeader(name, this.createCompliantHttpDateString(date));
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "addDateHeader");
        }
    }

    public void addHeader(String name, String value) {
        WebAppDispatcherContext dispatchContext;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "addHeader", "name --> " + name + " with value --> " + value + " [" + this + "]");
        }
        if ((dispatchContext = (WebAppDispatcherContext)this.getRequest().getWebAppDispatcherContext()).isInclude()) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "addHeader", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "addHeader --> " + name + " with value --> " + value);
            }
        } else {
            if (!this._ignoreStateErrors && this.isCommitted()) {
                logger.logp(Level.WARNING, CLASS_NAME, "addHeader", "WARNING: Cannot set header. Response already committed.");
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.exiting(CLASS_NAME, "addHeader", "Response already committed");
                }
                return;
            }
            if (name.equalsIgnoreCase("Content-Type")) {
                this._response.setContentType(value);
            } else {
                this.addField(name, value);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "addHeader");
        }
    }

    public void addHeader(byte[] name, byte[] value) {
        WebAppDispatcherContext dispatchContext;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "addHeader", "name(byte) --> " + (name != null ? new String(name) : "") + " with value --> " + (value != null ? new String(value) : "") + " [" + this + "]");
        }
        if ((dispatchContext = (WebAppDispatcherContext)this.getRequest().getWebAppDispatcherContext()).isInclude()) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "addHeader", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "addHeader(byte) --> " + (name != null ? new String(name) : "") + " with value --> " + (value != null ? new String(value) : ""));
            }
        } else {
            if (!this._ignoreStateErrors && this.isCommitted()) {
                logger.logp(Level.WARNING, CLASS_NAME, "addHeader", "WARNING: Cannot set header. Response already committed.");
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.exiting(CLASS_NAME, "addHeader", "Response already committed");
                }
                return;
            }
            this._response.addHeader(name, value);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "addHeader");
        }
    }

    public void addIntHeader(String name, int value) {
        WebAppDispatcherContext dispatchContext;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "addIntHeader", " name --> " + name + " value --> " + String.valueOf(value) + " [" + this + "]");
        }
        if ((dispatchContext = (WebAppDispatcherContext)this.getRequest().getWebAppDispatcherContext()).isInclude()) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "addIntHeader", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "addIntHeader name --> " + name + " value --> " + String.valueOf(value));
            }
        } else {
            if (!this._ignoreStateErrors && this.isCommitted()) {
                logger.logp(Level.WARNING, CLASS_NAME, "addIntHeader", "WARNING: Cannot set header. Response already committed.");
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.exiting(CLASS_NAME, "addIntHeader", "Response already committed");
                }
                return;
            }
            if (name.equalsIgnoreCase("Content-Type")) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.exiting(CLASS_NAME, "addIntHeader", "throw IllegalArgumentException");
                }
                throw new IllegalArgumentException("Cannot Set Content-Type to an Int value");
            }
            this.addIntField(name, value);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "addIntHeader");
        }
    }

    public void addSessionCookie(Cookie cookie) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "addSessionCookie", "cookie --> " + cookie.getName() + " [" + this + "]");
        }
        if (this.isCommitted()) {
            WebAppDispatcherContext dispatchContext = (WebAppDispatcherContext)this.getRequest().getWebAppDispatcherContext();
            if (!getSessionCompatibility && dispatchContext.isInclude() && dispatchContext.getWebApp().getVersionID() >= 25) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.exiting(CLASS_NAME, "addSessionCookie", "throw IllegalArgumentException");
                }
                throw new IllegalStateException();
            }
            logger.logp(Level.WARNING, CLASS_NAME, "addSessionCookie", "WARNING: Cannot set session cookie. Response already committed.");
        } else {
            this._response.addCookie(cookie);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "addSessionCookie");
        }
    }

    public void initForNextResponse(IResponse resp) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "initForNextResponse", "resp = " + resp + " [" + this + "]");
        }
        if (resp == null) {
            this._rawOut.init(null);
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.exiting(CLASS_NAME, "initForNextResponse");
            }
            return;
        }
        resp.setStatusCode(200);
        resp.setReason(REASON_OK);
        this._statusCode = 200;
        this._response = resp;
        try {
            this._rawOut.init(this._response.getOutputStream());
        }
        catch (IOException e) {
            logger.logp(Level.SEVERE, CLASS_NAME, "initForNextResponse", "error initializing rawOut ", e);
        }
        this._bufferedOut.reset();
        this._bufferedWriter.reset();
        this._responseBuffer = null;
        this._bufferSize = 4096;
        this._encoding = null;
        this._gotOutputStream = false;
        this._gotWriter = false;
        this._pwriter = null;
        this.resetState();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "initForNextResponse");
        }
    }

    public Vector[] getHeaderTable() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getHeaderTable", "[" + this + "]");
        }
        return this._response.getHeaderTable();
    }

    public void destroy() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "destroy", "[" + this + "]");
        }
        this._connContext = null;
        this._rawOut = null;
        this._bufferedOut = null;
        this._bufferedWriter = null;
    }

    protected WSServletOutputStream createOutputStream(int size) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "createOutputStream", "size : " + size + " [" + this + "]");
        }
        return new BufferedServletOutputStream(size);
    }

    protected String createCompliantHttpDateString(long timestamp) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "createCompliantHttpDateString", "createCompliantHttpDateString entry, use old data formatter->" + String.valueOf(oldDateFormatter), "[" + this + "]");
        }
        if (oldDateFormatter) {
            return new HttpDate(timestamp).toString();
        }
        SimpleDateFormat tmpDateFmt = dateFormat.get();
        if (tmpDateFmt == null) {
            tmpDateFmt = new SimpleDateFormat(formatStr);
            tmpDateFmt.setTimeZone(gmtTimeZone);
            dateFormat.set(tmpDateFmt);
        }
        Date myDate = new Date(timestamp);
        return tmpDateFmt.format(myDate);
    }

    public static void main(String[] args) {
        SRTServletResponse srtRes = new SRTServletResponse();
        srtRes.setContentType("text/html;charset='ISO-8859-1'");
        srtRes._gotWriter = true;
        srtRes._headersWritten = true;
        srtRes.setContentType("text/xml;charset=ISO-8859-7");
        System.out.println(srtRes.getContentType());
        srtRes = new SRTServletResponse();
        srtRes.setCharacterEncoding(_defaultEncoding);
        System.out.println(srtRes.getContentType());
        srtRes = new SRTServletResponse();
        srtRes.setCharacterEncoding("UTF-8");
        srtRes.setContentType("text/html");
        try {
            srtRes.getWriter();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        srtRes._gotWriter = true;
        srtRes._headersWritten = true;
        srtRes.setContentType("text/xml");
        System.out.println(srtRes.getContentType());
        srtRes = new SRTServletResponse();
        try {
            srtRes.getWriter();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        srtRes._gotWriter = true;
        srtRes._headersWritten = true;
        srtRes.setContentType("text/xml;charset=UTF-8");
        System.out.println(srtRes.getContentType());
        srtRes = new SRTServletResponse();
        srtRes.setContentType("text/html");
        srtRes.setCharacterEncoding("UTF-8");
        System.out.println(srtRes.getContentType());
        srtRes = new SRTServletResponse();
        try {
            srtRes.getWriter();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println(srtRes.getContentType());
    }

    public void fireOutputStreamRetrievedEvent(ServletOutputStream sos) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "fireOutputStreamRetrievedEvent", "_firstOutputStreamRetrieval:" + String.valueOf(this._firstOutputStreamRetrieval) + " ,outputMethodListener:" + this.outputMethodListener, "[" + this + "]");
        }
        if (this.outputMethodListener != null && this._firstOutputStreamRetrieval) {
            this._firstOutputStreamRetrieval = false;
            this.outputMethodListener.notifyOutputStreamRetrieved(sos);
        }
    }

    public void fireWriterRetrievedEvent(PrintWriter pw) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "fireWriterRetrievedEvent", "__firstWriterRetrieval:" + String.valueOf(this._firstWriterRetrieval) + " ,outputMethodListener:" + this.outputMethodListener, "[" + this + "]");
        }
        if (this.outputMethodListener != null && this._firstWriterRetrieval) {
            this._firstWriterRetrieval = false;
            this.outputMethodListener.notifyWriterRetrieved(pw);
        }
    }

    public void registerOutputMethodListener(IOutputMethodListener listener) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "registerOutputMethodListener", "listener = " + listener, "[" + this + "]");
        }
        this.outputMethodListener = listener;
    }

    public static void setSkipInputStreamRead(boolean b) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setSkipInputStreamRead", "b = " + String.valueOf(b));
        }
        skipInputStreamRead = b;
    }

    public static boolean isSkipInputStreamRead() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "isSkipInputStreamRead", "skipInputStreamRead = " + String.valueOf(skipInputStreamRead));
        }
        return skipInputStreamRead;
    }

    public boolean isOutputWritten() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "isOutputWritten", "_firstWrite = " + String.valueOf(this._firstWrite), "[" + this + "]");
        }
        return this._firstWrite;
    }
}

